/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.swing;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.NumberSpinnerModelAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpinnerWithDefaultHandler {
    private ValueModel defaultValueHolder;
    private boolean installingFormatter;
    private boolean showEmptyString;
    private JSpinner spinner;
    private JFormattedTextField textField;
    private boolean valueBeingChanged;
    static final Number DEFAULT_VALUE = -1;

    public SpinnerWithDefaultHandler(ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, Comparable<? extends Number> minimumValue, Comparable<? extends Number> maximumValue, Number stepSize) {
        this.initialize(subjectHolder, valueHolder, defaultValueHolder, minimumValue, maximumValue, stepSize);
    }

    private PropertyChangeListener buildDefaultValuePropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                SpinnerWithDefaultHandler.this.spinnerModel().setDefaultValue((Number)e.getNewValue());
            }
        };
    }

    private FocusListener buildFocusListener() {
        return new FocusListener(){

            public void focusGained(FocusEvent e) {
                SpinnerWithDefaultHandler.this.updateTextFieldOnFocusGained();
            }

            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    SpinnerWithDefaultHandler.this.updateTextFieldOnFocusLost();
                }
            }
        };
    }

    private NumberFormatter buildFormatter(JSpinner.NumberEditor editor) {
        NumberFormatter oldformatter = (NumberFormatter)this.textField.getFormatter();
        NumberFormatter newFormatter = this.buildNumberFormatter(editor);
        newFormatter.setMaximum(oldformatter.getMaximum());
        newFormatter.setMinimum(oldformatter.getMinimum());
        newFormatter.setValueClass(oldformatter.getValueClass());
        newFormatter.setOverwriteMode(oldformatter.getOverwriteMode());
        newFormatter.setAllowsInvalid(oldformatter.getAllowsInvalid());
        newFormatter.setCommitsOnValidEdit(true);
        return newFormatter;
    }

    private ChangeListener buildModelChangeListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SpinnerWithDefaultHandler.this.updateTextFieldForegroundColor();
            }
        };
    }

    private NumberFormatter buildNumberFormatter(JSpinner.NumberEditor editor) {
        return new NumberFormatter(editor.getFormat()){

            public Object stringToValue(String text) throws ParseException {
                if (SpinnerWithDefaultHandler.this.defaultValue().equals(text)) {
                    return DEFAULT_VALUE;
                }
                if (text.length() == 0) {
                    return null;
                }
                return super.stringToValue(text);
            }

            public String valueToString(Object value) throws ParseException {
                if (SpinnerWithDefaultHandler.this.installingFormatter) {
                    value = SpinnerWithDefaultHandler.this.spinnerModel().getActualNumber();
                    if (value == null) {
                        value = DEFAULT_VALUE;
                    }
                } else {
                    if (SpinnerWithDefaultHandler.this.showEmptyString) {
                        return "";
                    }
                    if (SpinnerWithDefaultHandler.this.textField.hasFocus() && !SpinnerWithDefaultHandler.this.valueBeingChanged) {
                        return SpinnerWithDefaultHandler.this.textField.getText();
                    }
                }
                if (value == DEFAULT_VALUE) {
                    return SpinnerWithDefaultHandler.this.defaultValue();
                }
                return super.valueToString(value);
            }
        };
    }

    private PropertyChangeListener buildPropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                SpinnerWithDefaultHandler.this.subjectChanged(e.getNewValue() == null);
            }
        };
    }

    protected JSpinner buildSpinner(SpinnerNumberModel model) {
        return new JSpinner(model);
    }

    private String defaultValue() {
        Number defaultValue = (Number)this.defaultValueHolder.getValue();
        if (defaultValue == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        sb.append(defaultValue);
        sb.append(')');
        return sb.toString();
    }

    public final JSpinner getSpinner() {
        return this.spinner;
    }

    private void initialize(ValueModel subjectHolder, PropertyValueModel valueHolder, ValueModel defaultValueHolder, Comparable minimumValue, Comparable maximumValue, Number stepSize) {
        this.defaultValueHolder = defaultValueHolder;
        subjectHolder.addPropertyChangeListener("value", this.buildPropertyChangeListener());
        defaultValueHolder.addPropertyChangeListener("value", this.buildDefaultValuePropertyChangeListener());
        SpinnerModel model = new SpinnerModel(valueHolder, defaultValueHolder, minimumValue, maximumValue, stepSize);
        this.spinner = this.buildSpinner(model);
        model.addChangeListener(this.buildModelChangeListener());
        JSpinner.NumberEditor editor = (JSpinner.NumberEditor)this.spinner.getEditor();
        this.textField = editor.getTextField();
        this.textField.setFocusLostBehavior(3);
        this.textField.addFocusListener(this.buildFocusListener());
        this.installNumberFormatter(valueHolder, editor);
        this.updateTextFieldForegroundColor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installNumberFormatter(ValueModel numberHolder, JSpinner.NumberEditor editor) {
        try {
            this.installingFormatter = true;
            NumberFormatter newFormatter = this.buildFormatter(editor);
            if (numberHolder.getValue() != null) {
                this.textField.setValue(numberHolder.getValue());
            }
            this.textField.setFormatterFactory(new DefaultFormatterFactory(newFormatter));
        }
        finally {
            this.installingFormatter = false;
        }
    }

    private SpinnerModel spinnerModel() {
        return (SpinnerModel)this.spinner.getModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void subjectChanged(boolean nullSubject) {
        if (nullSubject) {
            try {
                this.showEmptyString = true;
                this.textField.setValue(DEFAULT_VALUE);
            }
            finally {
                this.showEmptyString = false;
            }
        } else {
            this.spinnerModel().synchronize(this.spinnerModel().getActualNumber());
        }
    }

    private void updateTextFieldForegroundColor() {
        if (this.spinnerModel().getActualNumber() == null) {
            this.textField.setForeground(Color.GRAY);
        } else {
            this.textField.setForeground(UIManager.getColor("TextField.foreground"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTextFieldOnFocusGained() {
        if (this.spinnerModel().getActualNumber() == null) {
            try {
                this.showEmptyString = true;
                this.textField.setValue(DEFAULT_VALUE);
                this.textField.setForeground(UIManager.getColor("TextField.foreground"));
            }
            finally {
                this.showEmptyString = false;
            }
        }
    }

    private void updateTextFieldOnFocusLost() {
        String text = this.textField.getText();
        if (text.length() == 0 || text.equals(DEFAULT_VALUE.toString())) {
            this.textField.setValue(DEFAULT_VALUE);
            this.textField.setForeground(Color.GRAY);
        }
    }

    private class SpinnerModel
    extends NumberSpinnerModelAdapter {
        private Number value;

        SpinnerModel(PropertyValueModel valueHolder, ValueModel defaultValueHolde, Comparable minimumValue, Comparable maximumValue, Number stepSize) {
            super(valueHolder, minimumValue, maximumValue, stepSize, SpinnerWithDefaultHandler.this.defaultValueHolder.getValue() != null ? (Number)((Number)SpinnerWithDefaultHandler.this.defaultValueHolder.getValue()) : (Number)0);
            this.synchronizeValue();
        }

        Object getActualNumber() {
            return this.numberHolder.getValue();
        }

        public Number getNumber() {
            return this.value;
        }

        public Number getValue() {
            return this.value;
        }

        protected void setDefaultValue(Number defaultValue) {
            super.setDefaultValue(defaultValue);
            if (this.value == DEFAULT_VALUE) {
                this.fireStateChanged();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Object value) {
            if (value != DEFAULT_VALUE && !SpinnerWithDefaultHandler.this.installingFormatter) {
                try {
                    SpinnerWithDefaultHandler.this.valueBeingChanged = value != null;
                    SpinnerWithDefaultHandler.this.showEmptyString = value == null;
                    this.value = value == null ? (Number)DEFAULT_VALUE : (Number)((Number)value);
                    super.setValue(value);
                }
                finally {
                    SpinnerWithDefaultHandler.this.valueBeingChanged = false;
                    SpinnerWithDefaultHandler.this.showEmptyString = false;
                }
            }
        }

        protected void synchronize(Object value) {
            this.value = value == null ? (Number)DEFAULT_VALUE : (Number)((Number)value);
            super.synchronize(this.value);
            if (value == null && this.getSuperValue() == DEFAULT_VALUE) {
                this.fireStateChanged();
            }
        }

        private void synchronizeValue() {
            this.value = (Number)this.numberHolder.getValue();
            if (this.value == null) {
                this.value = DEFAULT_VALUE;
            }
        }
    }
}

