/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;

public class MetadataHelper {
    public static final String JPA_ORM_FILE = "META-INF/orm.xml";
    public static final String ECLIPSELINK_ORM_FILE = "META-INF/eclipselink-orm.xml";

    public static Class getClassForName(String classname, ClassLoader loader) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return (Class)AccessController.doPrivileged(new PrivilegedClassForName(classname, true, loader));
                }
                catch (PrivilegedActionException exception) {
                    throw ValidationException.unableToLoadClass(classname, exception.getException());
                }
            }
            return PrivilegedAccessHelper.getClassForName(classname, true, loader);
        }
        catch (ClassNotFoundException exception) {
            if (classname.indexOf(36) != -1) {
                String outer = classname.substring(0, classname.indexOf(36));
                Class outerClass = MetadataHelper.getClassForName(outer, loader);
                for (int index = 0; index < outerClass.getClasses().length; ++index) {
                    if (!outerClass.getClasses()[index].getName().equals(classname)) continue;
                    return outerClass.getClasses()[index];
                }
            }
            throw ValidationException.unableToLoadClass(classname, exception);
        }
    }

    static Object getClassInstance(Class cls) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(cls));
                }
                catch (PrivilegedActionException exception) {
                    throw ValidationException.errorInstantiatingClass(cls, exception.getException());
                }
            }
            return PrivilegedAccessHelper.newInstanceFromClass(cls);
        }
        catch (IllegalAccessException exception) {
            throw ValidationException.errorInstantiatingClass(cls, exception);
        }
        catch (InstantiationException exception) {
            throw ValidationException.errorInstantiatingClass(cls, exception);
        }
    }

    static Object getClassInstance(String className, ClassLoader loader) {
        return MetadataHelper.getClassInstance(MetadataHelper.getClassForName(className, loader));
    }

    public static String getName(String name, String defaultName, String context, MetadataLogger logger, Object location) {
        if (name != null && !name.equals("")) {
            return name;
        }
        if (defaultName == null || defaultName.equals("")) {
            return "";
        }
        logger.logConfigMessage(context, location, (Object)defaultName);
        return defaultName;
    }

    public static Integer getValue(Integer value, Integer defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static String getValue(String value, String defaultValue) {
        if (value != null && !value.equals("")) {
            return value;
        }
        return defaultValue;
    }
}

