/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.util.List;
import java.util.Map;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.CollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.AssociationOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.mappings.EmbeddableMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.UnidirectionalOneToManyMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneToManyAccessor
extends CollectionAccessor {
    public OneToManyAccessor() {
        super("<one-to-many>");
    }

    public OneToManyAccessor(MetadataAnnotation oneToMany, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(oneToMany, accessibleObject, classAccessor);
        if (oneToMany != null) {
            this.setOrphanRemoval((Boolean)oneToMany.getAttribute("orphanRemoval"));
        }
    }

    @Override
    protected String getLoggingContext() {
        return "metadata_default_one_to_many_reference_class";
    }

    @Override
    public boolean isOneToMany() {
        return true;
    }

    @Override
    public void process() {
        super.process();
        if (this.getMappedBy() == null || this.getMappedBy().equals("")) {
            if (this.getJoinColumns().isEmpty()) {
                this.processManyToManyMapping();
            } else {
                this.processUnidirectionalOneToManyMapping();
            }
        } else {
            this.processOneToManyMapping();
        }
    }

    @Override
    protected void processAssociationOverride(AssociationOverrideMetadata associationOverride, EmbeddableMapping embeddableMapping, MetadataDescriptor owningDescriptor) {
        if (this.getMapping().isUnidirectionalOneToManyMapping()) {
            UnidirectionalOneToManyMapping overrideMapping = new UnidirectionalOneToManyMapping();
            overrideMapping.setAttributeName(this.getAttributeName());
            this.processUnidirectionalOneToManyTargetForeignKeyRelationship(overrideMapping, associationOverride.getJoinColumns(), owningDescriptor);
            embeddableMapping.addOverrideUnidirectionalOneToManyMapping(overrideMapping);
        } else {
            super.processAssociationOverride(associationOverride, embeddableMapping, owningDescriptor);
        }
    }

    protected void processManyToManyMapping() {
        ManyToManyMapping mapping = new ManyToManyMapping();
        this.process(mapping);
        this.processJoinTable(mapping, this.getJoinTableMetadata());
    }

    protected void processOneToManyMapping() {
        OneToManyMapping mapping = new OneToManyMapping();
        this.process(mapping);
        OneToOneMapping ownerMapping = null;
        if (!this.getOwningMapping(this.getMappedBy()).isOneToOneMapping()) {
            throw ValidationException.invalidMapping(this.getJavaClass(), this.getReferenceClass());
        }
        ownerMapping = (OneToOneMapping)this.getOwningMapping(this.getMappedBy());
        Map<DatabaseField, DatabaseField> keys = ownerMapping.getSourceToTargetKeyFields();
        for (DatabaseField fkField : keys.keySet()) {
            DatabaseField pkField = keys.get(fkField);
            if (this.getDescriptor().usesTablePerClassInheritanceStrategy() && !pkField.getTable().equals(this.getDescriptor().getPrimaryTable())) {
                pkField = (DatabaseField)pkField.clone();
                pkField.setTable(this.getDescriptor().getPrimaryTable());
            }
            mapping.addTargetForeignKeyField(fkField, pkField);
        }
    }

    protected void processUnidirectionalOneToManyMapping() {
        UnidirectionalOneToManyMapping mapping = new UnidirectionalOneToManyMapping();
        this.process(mapping);
        this.processUnidirectionalOneToManyTargetForeignKeyRelationship(mapping, this.getJoinColumns(this.getJoinColumns(), this.getReferenceDescriptor()), this.getOwningDescriptor());
    }

    protected void processUnidirectionalOneToManyTargetForeignKeyRelationship(UnidirectionalOneToManyMapping mapping, List<JoinColumnMetadata> joinColumns, MetadataDescriptor owningDescriptor) {
        String defaultPKFieldName = owningDescriptor.getPrimaryKeyFieldName();
        String defaultFKFieldName = this.getUpperCaseAttributeName() + "_" + defaultPKFieldName;
        for (JoinColumnMetadata joinColumn : joinColumns) {
            MappingAccessor mappingAccessor;
            DatabaseField pkField = joinColumn.getPrimaryKeyField();
            pkField.setName(this.getName(pkField, defaultPKFieldName, "metadata_default_pk_column"));
            pkField.setTable(owningDescriptor.getPrimaryKeyTable());
            DatabaseField fkField = joinColumn.getForeignKeyField();
            fkField.setName(this.getName(fkField, defaultFKFieldName, "metadata_default_fk_column"));
            if (fkField.getTableName().equals("")) {
                fkField.setTable(this.getReferenceDescriptor().getPrimaryTable());
            }
            if ((mappingAccessor = owningDescriptor.getPrimaryKeyAccessorForField(pkField)) != null) {
                Class fieldClassification = mappingAccessor.getMapping().getFieldClassification(mappingAccessor.getMapping().getField());
                String typeName = fieldClassification == null ? mappingAccessor.getRawClass().getName() : fieldClassification.getName();
                fkField.setTypeName(typeName);
            }
            mapping.addTargetForeignKeyField(fkField, pkField);
            if (!fkField.isReadOnly()) continue;
            mapping.setIsReadOnly(true);
        }
    }
}

