/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.objects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ClassReader;
import org.eclipse.persistence.internal.libraries.asm.ClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.CodeVisitor;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.libraries.asm.attrs.Annotation;
import org.eclipse.persistence.internal.libraries.asm.attrs.RuntimeVisibleAnnotations;
import org.eclipse.persistence.internal.libraries.asm.attrs.RuntimeVisibleParameterAnnotations;
import org.eclipse.persistence.internal.libraries.asm.attrs.SignatureAttribute;

public class MetadataFactory {
    public static final String PRIMITIVES = "VJIBZCSFD";
    public static final String TOKENS = "()<>;";
    public static boolean ALLOW_JDK = false;
    protected Map<String, MetadataClass> metadata;
    public MetadataLogger logger;
    public ClassLoader loader;

    public MetadataFactory(MetadataLogger logger, ClassLoader loader) {
        this.logger = logger;
        this.loader = loader;
        this.metadata = new HashMap<String, MetadataClass>();
        this.metadata.put("void", new MetadataClass(this, Void.TYPE));
        this.metadata.put("", new MetadataClass(this, Void.TYPE));
        this.metadata.put(null, new MetadataClass(this, Void.TYPE));
        this.metadata.put("int", new MetadataClass(this, Integer.TYPE));
        this.metadata.put("long", new MetadataClass(this, Long.TYPE));
        this.metadata.put("short", new MetadataClass(this, Short.TYPE));
        this.metadata.put("boolean", new MetadataClass(this, Boolean.TYPE));
        this.metadata.put("float", new MetadataClass(this, Float.TYPE));
        this.metadata.put("double", new MetadataClass(this, Double.TYPE));
        this.metadata.put("char", new MetadataClass(this, Character.TYPE));
        this.metadata.put("byte", new MetadataClass(this, Byte.TYPE));
        this.metadata.put("V", new MetadataClass(this, Void.TYPE));
        this.metadata.put("I", new MetadataClass(this, Integer.TYPE));
        this.metadata.put("J", new MetadataClass(this, Long.TYPE));
        this.metadata.put("S", new MetadataClass(this, Short.TYPE));
        this.metadata.put("Z", new MetadataClass(this, Boolean.TYPE));
        this.metadata.put("F", new MetadataClass(this, Float.TYPE));
        this.metadata.put("D", new MetadataClass(this, Double.TYPE));
        this.metadata.put("C", new MetadataClass(this, Character.TYPE));
        this.metadata.put("B", new MetadataClass(this, Byte.TYPE));
    }

    public String toClassName(String classDescription) {
        if (classDescription == null) {
            return "void";
        }
        return classDescription.replace('/', '.');
    }

    public MetadataClass getClassMetadata(String className) {
        if (className == null) {
            return null;
        }
        MetadataClass metadataClass = this.metadata.get(className);
        if (metadataClass == null) {
            this.buildClassMetadata(className);
            metadataClass = this.metadata.get(className);
        }
        return metadataClass;
    }

    public void buildClassMetadata(String className) {
        ClassMetadataVisitor visitor = new ClassMetadataVisitor();
        try {
            ClassReader reader = new ClassReader(this.loader.getResourceAsStream(className.replace('.', '/') + ".class"));
            Attribute[] attributes = new Attribute[]{new RuntimeVisibleAnnotations(), new RuntimeVisibleParameterAnnotations(), new SignatureAttribute()};
            reader.accept(visitor, attributes, false);
        }
        catch (Exception exception) {
            this.metadata.put(className, new MetadataClass(this, className));
        }
    }

    public MetadataLogger getLogger() {
        return this.logger;
    }

    public void setLogger(MetadataLogger logger) {
        this.logger = logger;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public void setLoader(ClassLoader loader) {
        this.loader = loader;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ClassMetadataVisitor
    implements ClassVisitor {
        MetadataClass classMetadata;

        ClassMetadataVisitor() {
        }

        @Override
        public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
            String className = MetadataFactory.this.toClassName(name);
            this.classMetadata = new MetadataClass(MetadataFactory.this, className);
            MetadataFactory.this.metadata.put(className, this.classMetadata);
            this.classMetadata.setName(className);
            this.classMetadata.setSuperclassName(MetadataFactory.this.toClassName(superName));
            this.classMetadata.setModifiers(access);
            if (!ALLOW_JDK && (className.startsWith("java") || className.startsWith("javax"))) {
                this.classMetadata.setIsJDK(true);
            }
            ArrayList<String> interfacesNames = new ArrayList<String>();
            for (String interfaceName : interfaces) {
                interfacesNames.add(MetadataFactory.this.toClassName(interfaceName));
            }
            this.classMetadata.setInterfaces(interfacesNames);
        }

        @Override
        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        @Override
        public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
            if (this.classMetadata.isJDK()) {
                return;
            }
            MetadataField field = new MetadataField(MetadataFactory.this, MetadataFactory.this.logger);
            field.setName(name);
            field.setAttributeName(name);
            field.setGenericType(this.getGenericType(attrs));
            field.setType(this.processDescription(desc, false).get(0));
            field.setModifiers(access);
            this.addAnnotations(attrs, field.getAnnotations());
            this.classMetadata.getFields().put(name, field);
        }

        public List<String> getGenericType(Attribute attrs) {
            if (attrs == null) {
                return null;
            }
            if (attrs instanceof SignatureAttribute) {
                return this.processDescription(((SignatureAttribute)attrs).signature, true);
            }
            return this.getGenericType(attrs.next);
        }

        public String getPrimitiveName(char primitive) {
            if (primitive == 'V') {
                return "void";
            }
            if (primitive == 'I') {
                return "int";
            }
            if (primitive == 'Z') {
                return "boolean";
            }
            if (primitive == 'J') {
                return "long";
            }
            if (primitive == 'F') {
                return "float";
            }
            if (primitive == 'D') {
                return "double";
            }
            if (primitive == 'B') {
                return "byte";
            }
            if (primitive == 'C') {
                return "char";
            }
            if (primitive == 'S') {
                return "short";
            }
            return new String(new char[]{primitive});
        }

        public List<String> processDescription(String desc, boolean isGeneric) {
            ArrayList<String> arguments = new ArrayList<String>();
            for (int index = 0; index < desc.length(); ++index) {
                int start;
                char next = desc.charAt(index);
                if (MetadataFactory.TOKENS.indexOf(next) != -1) continue;
                if (next == 'L') {
                    start = ++index;
                    next = desc.charAt(index);
                    while (MetadataFactory.TOKENS.indexOf(next) == -1) {
                        next = desc.charAt(++index);
                    }
                    arguments.add(MetadataFactory.this.toClassName(desc.substring(start, index)));
                    continue;
                }
                if (!isGeneric && MetadataFactory.PRIMITIVES.indexOf(next) != -1) {
                    arguments.add(this.getPrimitiveName(next));
                    continue;
                }
                if (next == '[') {
                    start = index++;
                    next = desc.charAt(index);
                    while (next == '[') {
                        next = desc.charAt(++index);
                    }
                    if (MetadataFactory.PRIMITIVES.indexOf(next) == -1) {
                        while (next != ';') {
                            next = desc.charAt(++index);
                        }
                        arguments.add(MetadataFactory.this.toClassName(desc.substring(start, index + 1)));
                        continue;
                    }
                    arguments.add(desc.substring(start, index + 1));
                    continue;
                }
                arguments.add(new String(new char[]{next}));
            }
            return arguments;
        }

        @Override
        public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
            if (this.classMetadata.isJDK()) {
                return null;
            }
            MetadataMethod method = null;
            if (name.indexOf("init>") != -1) {
                return null;
            }
            List<String> argumentNames = this.processDescription(desc, false);
            method = new MetadataMethod(MetadataFactory.this, this.classMetadata, MetadataFactory.this.logger);
            method.setName(name);
            method.setAttributeName(Helper.getAttributeNameFromMethodName(name));
            method.setModifiers(access);
            method.setGenericType(this.getGenericType(attrs));
            method.setReturnType(argumentNames.get(argumentNames.size() - 1));
            argumentNames.remove(argumentNames.size() - 1);
            method.setParameters(argumentNames);
            this.addAnnotations(attrs, method.getAnnotations());
            MetadataMethod existing = this.classMetadata.getMethods().get(name);
            if (existing == null) {
                this.classMetadata.getMethods().put(name, method);
            } else {
                while (existing.getNext() != null) {
                    existing = existing.getNext();
                }
                existing.setNext(method);
            }
            return null;
        }

        @Override
        public void visitAttribute(Attribute attr) {
            if (this.classMetadata.isJDK()) {
                return;
            }
            if (attr instanceof SignatureAttribute) {
                this.classMetadata.setGenericType(this.getGenericType(attr));
            } else {
                this.addAnnotations(attr, this.classMetadata.getAnnotations());
            }
        }

        public void addAnnotations(Attribute attr, Map<String, MetadataAnnotation> annotations) {
            if (!(attr instanceof RuntimeVisibleAnnotations)) {
                return;
            }
            RuntimeVisibleAnnotations visibleAnnotations = (RuntimeVisibleAnnotations)attr;
            for (Annotation visibleAnnotation : visibleAnnotations.annotations) {
                if (visibleAnnotation.type.indexOf("javax/persistence") == -1 && visibleAnnotation.type.indexOf("org/eclipse/persistence") == -1) continue;
                MetadataAnnotation annotation = this.buildAnnotation(visibleAnnotation);
                annotations.put(annotation.getName(), annotation);
            }
        }

        public MetadataAnnotation buildAnnotation(Annotation visibleAnnotation) {
            MetadataAnnotation annotation = new MetadataAnnotation();
            annotation.setName(this.processDescription(visibleAnnotation.type, false).get(0));
            for (Object[] attribute : visibleAnnotation.elementValues) {
                String attributeName = (String)attribute[0];
                Object attributeValue = this.buildAnnotationValue(attribute[1]);
                annotation.getAttributes().put(attributeName, attributeValue);
            }
            return annotation;
        }

        public Object buildAnnotationValue(Object value) {
            if (value instanceof Annotation) {
                return this.buildAnnotation((Annotation)value);
            }
            if (value instanceof Object[]) {
                Object[] values = (Object[])value;
                for (int index = 0; index < values.length; ++index) {
                    values[index] = this.buildAnnotationValue(values[index]);
                }
                return values;
            }
            if (value instanceof Type) {
                return ((Type)value).getClassName();
            }
            if (value instanceof Annotation.EnumConstValue) {
                return ((Annotation.EnumConstValue)value).constName;
            }
            return value;
        }

        @Override
        public void visitEnd() {
        }
    }
}

