/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metamodel;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.PersistenceException;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.indirection.IndirectSet;
import org.eclipse.persistence.internal.jpa.metamodel.AttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.CollectionAttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.EmbeddableTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.EntityTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.ListAttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.MapAttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl;
import org.eclipse.persistence.internal.jpa.metamodel.SetAttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.SingularAttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.TypeImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ManagedTypeImpl<X>
extends TypeImpl<X>
implements ManagedType<X> {
    private RelationalDescriptor descriptor;
    protected Map<String, Attribute<X, ?>> members;
    protected MetamodelImpl metamodel;

    protected ManagedTypeImpl(MetamodelImpl metamodel, RelationalDescriptor descriptor) {
        super(descriptor.getJavaClass());
        this.descriptor = descriptor;
        this.metamodel = metamodel;
        descriptor.setProperty(this.getClass().getName(), this);
    }

    @Override
    public Attribute<X, ?> getAttribute(String name) {
        if (!this.members.containsKey(name)) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_not_present", new Object[]{name, this}));
        }
        return this.members.get(name);
    }

    @Override
    public Set<Attribute<? super X, ?>> getAttributes() {
        return new HashSet(this.members.values());
    }

    @Override
    public CollectionAttribute<? super X, ?> getCollection(String name) {
        CollectionAttribute anAttribute = (CollectionAttribute)this.members.get(name);
        if (null == anAttribute) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_not_present", new Object[]{name, this}));
        }
        return anAttribute;
    }

    @Override
    public <E> CollectionAttribute<? super X, E> getCollection(String name, Class<E> elementType) {
        CollectionAttribute<X, ?> anAttribute = this.getCollection(name);
        Class aClass = anAttribute.getElementType().getJavaType();
        if (elementType != aClass) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_type_incorrect", new Object[]{name, this, elementType, aClass}));
        }
        return anAttribute;
    }

    @Override
    public Set<PluralAttribute<? super X, ?, ?>> getCollections() {
        Set<Attribute<X, ?>> allAttributes = this.getAttributes();
        HashSet pluralAttributes = new HashSet();
        for (Attribute<X, ?> anAttribute : allAttributes) {
            if (!anAttribute.isCollection()) continue;
            pluralAttributes.add((PluralAttribute)anAttribute);
        }
        return pluralAttributes;
    }

    @Override
    public Attribute<X, ?> getDeclaredAttribute(String name) {
        throw new PersistenceException("Not Yet Implemented");
    }

    @Override
    public Set<Attribute<X, ?>> getDeclaredAttributes() {
        return new HashSet(this.members.values());
    }

    @Override
    public CollectionAttribute<X, ?> getDeclaredCollection(String name) {
        throw new PersistenceException("Not Yet Implemented");
    }

    @Override
    public <E> CollectionAttribute<X, E> getDeclaredCollection(String name, Class<E> elementType) {
        throw new PersistenceException("Not Yet Implemented");
    }

    @Override
    public Set<PluralAttribute<X, ?, ?>> getDeclaredCollections() {
        throw new PersistenceException("Not Yet Implemented");
    }

    public static ManagedTypeImpl<?> create(MetamodelImpl metamodel, RelationalDescriptor descriptor) {
        ManagedTypeImpl managedType = (EmbeddableTypeImpl)descriptor.getProperty(ManagedTypeImpl.class.getName());
        if (managedType == null) {
            managedType = descriptor.isAggregateDescriptor() ? new EmbeddableTypeImpl(metamodel, descriptor) : new EntityTypeImpl(metamodel, descriptor);
        }
        return managedType;
    }

    @Override
    public <E> ListAttribute<X, E> getDeclaredList(String name, Class<E> elementType) {
        throw new PersistenceException("Not Yet Implemented");
    }

    @Override
    public ListAttribute<X, ?> getDeclaredList(String name) {
        throw new PersistenceException("Not Yet Implemented");
    }

    @Override
    public MapAttribute<X, ?, ?> getDeclaredMap(String name) {
        throw new PersistenceException("Not Yet Implemented");
    }

    @Override
    public <K, V> MapAttribute<X, K, V> getDeclaredMap(String name, Class<K> keyType, Class<V> valueType) {
        throw new PersistenceException("Not Yet Implemented");
    }

    @Override
    public SetAttribute<X, ?> getDeclaredSet(String name) {
        throw new PersistenceException("Not Yet Implemented");
    }

    @Override
    public <E> SetAttribute<X, E> getDeclaredSet(String name, Class<E> elementType) {
        throw new PersistenceException("Not Yet Implemented");
    }

    @Override
    public SingularAttribute<X, ?> getDeclaredSingularAttribute(String name) {
        throw new PersistenceException("Not Yet Implemented");
    }

    @Override
    public <Y> SingularAttribute<X, Y> getDeclaredSingularAttribute(String name, Class<Y> type) {
        throw new PersistenceException("Not Yet Implemented");
    }

    @Override
    public Set<SingularAttribute<X, ?>> getDeclaredSingularAttributes() {
        throw new PersistenceException("Not Yet Implemented");
    }

    public RelationalDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public ListAttribute<? super X, ?> getList(String name) {
        return this.getList(name, true);
    }

    protected ListAttribute<? super X, ?> getList(String name, boolean performNullCheck) {
        ListAttribute anAttribute = (ListAttribute)this.members.get(name);
        if (performNullCheck && null == anAttribute) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_not_present", new Object[]{name, this}));
        }
        return anAttribute;
    }

    @Override
    public <E> ListAttribute<? super X, E> getList(String name, Class<E> elementType) {
        ListAttribute<X, ?> anAttribute = this.getList(name);
        Class aClass = anAttribute.getElementType().getJavaType();
        if (elementType != aClass) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_type_incorrect", new Object[]{name, this, elementType, aClass}));
        }
        return anAttribute;
    }

    @Override
    public MapAttribute<? super X, ?, ?> getMap(String name) {
        MapAttribute anAttribute = (MapAttribute)this.members.get(name);
        if (null == anAttribute) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_not_present", new Object[]{name, this}));
        }
        return anAttribute;
    }

    @Override
    public <K, V> MapAttribute<? super X, K, V> getMap(String name, Class<K> keyType, Class<V> valueType) {
        MapAttribute<X, ?, ?> anAttribute = this.getMap(name);
        Class aClass = anAttribute.getElementType().getJavaType();
        if (valueType != aClass) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_type_incorrect", new Object[]{name, this, valueType, aClass}));
        }
        return anAttribute;
    }

    public Map<String, Attribute<X, ?>> getMembers() {
        return this.members;
    }

    public MetamodelImpl getMetamodel() {
        return this.metamodel;
    }

    @Override
    public SetAttribute<? super X, ?> getSet(String name) {
        SetAttribute anAttribute = (SetAttribute)this.members.get(name);
        if (null == anAttribute) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_not_present", new Object[]{name, this}));
        }
        return anAttribute;
    }

    @Override
    public <E> SetAttribute<? super X, E> getSet(String name, Class<E> elementType) {
        SetAttribute<X, ?> anAttribute = this.getSet(name);
        Class aClass = anAttribute.getElementType().getJavaType();
        if (elementType != aClass) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_type_incorrect", new Object[]{name, this, elementType, aClass.getName()}));
        }
        return anAttribute;
    }

    @Override
    public SingularAttribute<? super X, ?> getSingularAttribute(String name) {
        Attribute<X, ?> anAttribute = this.getMembers().get(name);
        if (null == anAttribute) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_not_present", new Object[]{name, this}));
        }
        return (SingularAttribute)anAttribute;
    }

    @Override
    public <Y> SingularAttribute<? super X, Y> getSingularAttribute(String name, Class<Y> type) {
        SingularAttribute<X, ?> anAttribute = this.getSingularAttribute(name);
        Class<?> aClass = anAttribute.getType().getJavaType();
        if (type != aClass) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_type_incorrect", new Object[]{name, this, type, aClass}));
        }
        return anAttribute;
    }

    @Override
    public Set<SingularAttribute<? super X, ?>> getSingularAttributes() {
        HashSet singularAttributeSet = new HashSet();
        for (AttributeImpl attributeImpl : this.members.values()) {
            if (attributeImpl.isPlural()) continue;
            singularAttributeSet.add((SingularAttribute<X, ?>)((Object)attributeImpl));
        }
        return singularAttributeSet;
    }

    protected void initialize() {
        this.members = new HashMap();
        for (DatabaseMapping mapping : this.getDescriptor().getMappings()) {
            CollectionMapping colMapping;
            AttributeImpl member = null;
            member = mapping.isCollectionMapping() ? ((colMapping = (CollectionMapping)mapping).getContainerPolicy().isMapPolicy() ? new MapAttributeImpl(this, colMapping) : (colMapping.getContainerPolicy().isListPolicy() ? new ListAttributeImpl(this, colMapping) : (colMapping.getContainerPolicy().getContainerClass().isAssignableFrom(Set.class) || colMapping.getContainerPolicy().getContainerClass().isAssignableFrom(IndirectSet.class) ? new SetAttributeImpl(this, colMapping) : new CollectionAttributeImpl(this, colMapping)))) : new SingularAttributeImpl(this, mapping);
            this.members.put(mapping.getAttributeName(), member);
        }
    }

    @Override
    public boolean isIdentifiableType() {
        return false;
    }

    @Override
    public boolean isManagedType() {
        return true;
    }

    public String toString() {
        return "ManagedTypeImpl[" + this.getDescriptor() + "]";
    }
}

