/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metamodel;

import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.Type;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.metamodel.AttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.ManagedTypeImpl;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.mappings.CollectionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PluralAttributeImpl<X, C, V>
extends AttributeImpl<X, C>
implements PluralAttribute<X, C, V> {
    protected Type<V> elementType;

    protected PluralAttributeImpl(ManagedTypeImpl<X> managedType, CollectionMapping mapping) {
        super(managedType, mapping);
        ClassDescriptor elementDesc = mapping.getContainerPolicy().getElementDescriptor();
        if (elementDesc != null) {
            this.elementType = managedType.getMetamodel().getType(elementDesc.getJavaClass());
        } else {
            if (mapping.isDirectCollectionMapping() || mapping.isAbstractCompositeDirectCollectionMapping()) {
                // empty if block
            }
            if (mapping.isMapKeyMapping()) {
                MapContainerPolicy policy = (MapContainerPolicy)mapping.getContainerPolicy();
                this.elementType = managedType.getMetamodel().getType(policy.getElementClass());
            }
        }
    }

    @Override
    public Class<V> getBindableJavaType() {
        return this.elementType.getJavaType();
    }

    @Override
    public Bindable.BindableType getBindableType() {
        return Bindable.BindableType.PLURAL_ATTRIBUTE;
    }

    public CollectionMapping getCollectionMapping() {
        return (CollectionMapping)this.getMapping();
    }

    @Override
    public abstract PluralAttribute.CollectionType getCollectionType();

    @Override
    public Type<V> getElementType() {
        return this.elementType;
    }

    @Override
    public Class<C> getJavaType() {
        return this.elementType.getJavaType();
    }

    @Override
    public boolean isPlural() {
        return true;
    }
}

