/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.querydef;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.jpa.querydef.AbstractQueryImpl;
import org.eclipse.persistence.internal.jpa.querydef.ConstructorSelectionImpl;
import org.eclipse.persistence.internal.jpa.querydef.ExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.QueryBuilderImpl;
import org.eclipse.persistence.internal.jpa.querydef.RootImpl;
import org.eclipse.persistence.internal.jpa.querydef.SelectionImpl;
import org.eclipse.persistence.internal.jpa.querydef.TupleQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CriteriaQueryImpl<T>
extends AbstractQueryImpl<T>
implements CriteriaQuery<T> {
    protected List<Selection<?>> selections = new ArrayList();
    protected Selection selection;
    protected Class<T> queryType;
    protected boolean distinct;

    public CriteriaQueryImpl(Metamodel metamodel, AbstractQueryImpl.ResultType queryResult, Selection<T> initSelection, QueryBuilderImpl queryBuilder) {
        super(metamodel, queryResult, queryBuilder);
        this.selection = initSelection;
    }

    @Override
    public CriteriaQuery<T> select(Selection<? extends T> selection) {
        this.selection = selection;
        return this;
    }

    @Override
    public CriteriaQuery<T> multiselect(Selection<?> ... selections) {
        this.selections.clear();
        for (Selection<?> selection : selections) {
            this.selections.add(selection);
        }
        return this;
    }

    @Override
    public CriteriaQuery<T> multiselect(List<Selection<?>> selectionList) {
        this.selections.clear();
        for (Selection<?> selection : this.selections) {
            this.selections.add(selection);
        }
        return this;
    }

    @Override
    public CriteriaQuery<T> where(Expression<Boolean> restriction) {
        return (CriteriaQuery)super.where(restriction);
    }

    @Override
    public CriteriaQuery<T> where(Predicate ... restrictions) {
        return (CriteriaQuery)super.where(restrictions);
    }

    @Override
    public CriteriaQuery<T> groupBy(Expression<?> ... grouping) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CriteriaQuery<T> having(Expression<Boolean> restriction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CriteriaQuery<T> having(Predicate ... restrictions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CriteriaQuery<T> orderBy(Order ... o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CriteriaQuery<T> distinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    @Override
    public <X> Root<X> from(EntityType<X> entity) {
        RootImpl root = new RootImpl(entity, this.metamodel, entity.getBindableJavaType(), (org.eclipse.persistence.expressions.Expression)new ExpressionBuilder(entity.getBindableJavaType()), entity);
        this.roots.add(root);
        return root;
    }

    @Override
    public <X> Root<X> from(Class<X> entityClass) {
        EntityType<X> entity = this.metamodel.entity(entityClass);
        RootImpl root = new RootImpl(entity, this.metamodel, entity.getBindableJavaType(), (org.eclipse.persistence.expressions.Expression)new ExpressionBuilder(entity.getBindableJavaType()), entity);
        this.roots.add(root);
        return root;
    }

    @Override
    public List<Order> getOrderList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<ParameterExpression<?>> getParameters() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Selection<T> getSelection() {
        return this.selection;
    }

    @Override
    public Class<?> getResultType() {
        return this.queryType;
    }

    public DatabaseQuery translate() {
        ReadAllQuery query = null;
        if (this.queryResult.equals((Object)AbstractQueryImpl.ResultType.CONSTRUCTOR)) {
            ReportQuery rq = new ReportQuery();
            rq.addConstructorReportItem(((ConstructorSelectionImpl)this.selection).translate());
            rq.setShouldReturnSingleAttribute(true);
            query = rq;
        } else if (this.queryResult.equals((Object)AbstractQueryImpl.ResultType.ENTITY)) {
            query = new ReadAllQuery(this.getSelection().getJavaType());
        } else if (this.queryResult.equals((Object)AbstractQueryImpl.ResultType.PARTIAL)) {
            ReadAllQuery raq = new ReadAllQuery(this.getSelection().getJavaType());
            for (Selection<?> selection : this.selections) {
                raq.addPartialAttribute(((SelectionImpl)selection).currentNode);
            }
            query = raq;
        } else {
            ReportQuery reportQuery = null;
            if (this.queryResult.equals((Object)AbstractQueryImpl.ResultType.TUPLE)) {
                reportQuery = new TupleQuery(this.selections);
            } else {
                reportQuery = new ReportQuery();
                reportQuery.setShouldReturnWithoutReportQueryResult(true);
            }
            for (Selection<?> selection : this.selections) {
                if (((SelectionImpl)selection).isConstructor()) {
                    reportQuery.addConstructorReportItem(((ConstructorSelectionImpl)selection).translate());
                    continue;
                }
                reportQuery.addItem(selection.getAlias(), ((SelectionImpl)selection).getCurrentNode());
            }
            query = reportQuery;
        }
        query.setExpressionBuilder(((ExpressionImpl)this.where).getCurrentNode().getBuilder());
        query.setSelectionCriteria(((ExpressionImpl)this.where).getCurrentNode().getBuilder());
        if (this.distinct) {
            query.setDistinctState((short)1);
        }
        return query;
    }
}

