/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAbstractClassIndicatorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorFieldPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorValue;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWTypeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.DescriptorCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.TypeDeclarationCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.IndicatorDictionaryListener;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.IndicatorFieldListener;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.RootListener;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.CheckBoxTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.TableCellEditorAdapter;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.utility.Model;

public abstract class ClassIndicatorDictionarySubPanel
extends AbstractPanel
implements RootListener,
IndicatorFieldListener,
IndicatorDictionaryListener {
    private JButton editButton;
    private ObjectListSelectionModel rowSelectionModel;
    private TableModel classIndicatorTableModel;
    private ValueModel classIndicatorFieldPolicyHolder;
    protected ListChooser indicatorTypeListChooser;
    protected JLabel typeLabel;
    protected JScrollPane tableScrollPane;
    private boolean isRoot;
    private boolean isIndicatorField;
    private boolean isIndicatorDictionary;

    protected ClassIndicatorDictionarySubPanel(PropertyValueModel classIndicatorPolicyHolder, WorkbenchContextHolder contextHolder) {
        super(contextHolder);
        this.initialize(classIndicatorPolicyHolder);
    }

    protected void initialize(PropertyValueModel classIndicatorPolicyHolder) {
        this.classIndicatorFieldPolicyHolder = this.buildClassIndicatorFieldPolicyHolder(classIndicatorPolicyHolder);
        this.rowSelectionModel = this.buildRowSelectionModel();
        this.editButton = this.buildEditButton();
    }

    protected PropertyValueModel buildClassIndicatorFieldPolicyHolder(PropertyValueModel classIndicatorPolicyHolder) {
        return new FilteringPropertyValueModel(classIndicatorPolicyHolder){

            protected boolean accept(Object value) {
                return value instanceof MWClassIndicatorFieldPolicy;
            }
        };
    }

    protected ValueModel buildUseClassIndicatorDictionaryBooleanHolder() {
        return new PropertyAspectAdapter(this.classIndicatorFieldPolicyHolder, "classNameIsIndicator"){

            protected Object getValueFromSubject() {
                return !((MWClassIndicatorFieldPolicy)this.subject).classNameIsIndicator();
            }
        };
    }

    private JButton buildEditButton() {
        JButton editButton = this.buildButton("EDIT");
        editButton.addActionListener(this.buildEditAction());
        editButton.setEnabled(false);
        return editButton;
    }

    protected ListChooser buildIndicatorTypeChooser() {
        DefaultListChooser indicatorTypeChooser = new DefaultListChooser((ComboBoxModel)new ComboBoxModelAdapter(this.buildIndicatorTypeChooserValueModel(), this.buildIndicatorTypeChooserPropertyAdapter()), this.getWorkbenchContextHolder());
        indicatorTypeChooser.setRenderer(this.buildIndicatorTypeChooserRenderer());
        indicatorTypeChooser.setLongListSize(30);
        return indicatorTypeChooser;
    }

    private ListCellRenderer buildIndicatorTypeChooserRenderer() {
        return new AdaptableListCellRenderer(new TypeDeclarationCellRendererAdapter(this.resourceRepository()));
    }

    private TableCellRenderer buildClassColumnRenderer() {
        return new AdaptableTableCellRenderer(new DescriptorCellRendererAdapter(this.resourceRepository()));
    }

    private CollectionValueModel buildIndicatorTypeChooserValueModel() {
        return new CollectionAspectAdapter(this.classIndicatorFieldPolicyHolder){

            protected Iterator getValueFromSubject() {
                MWAbstractClassIndicatorPolicy policy = (MWAbstractClassIndicatorPolicy)this.subject;
                return policy.buildBasicTypes().iterator();
            }
        };
    }

    private PropertyValueModel buildIndicatorTypeChooserPropertyAdapter() {
        return new PropertyAspectAdapter(this.classIndicatorFieldPolicyHolder, "indicatorType"){

            protected Object getValueFromSubject() {
                return ((MWClassIndicatorFieldPolicy)this.subject).getIndicatorType();
            }

            protected void setValueOnSubject(Object value) {
                ((MWClassIndicatorFieldPolicy)this.subject).setIndicatorType((MWTypeDeclaration)value);
            }
        };
    }

    protected MWClassIndicatorFieldPolicy getClassIndicatorPolicy() {
        return (MWClassIndicatorFieldPolicy)this.classIndicatorFieldPolicyHolder.getValue();
    }

    protected String helpTopicId() {
        return "descriptor.inheritance.classIndicator.classIndicatorDictionary";
    }

    protected JTable buildClassIndicatorValuesTable() {
        this.classIndicatorTableModel = this.buildClassIndicatorValuesTableModel();
        JTable classIndicatorValuesTable = SwingComponentFactory.buildTable(this.classIndicatorTableModel, this.rowSelectionModel);
        classIndicatorValuesTable.setPreferredScrollableViewportSize(new Dimension(400, 75));
        TableColumn column = classIndicatorValuesTable.getColumnModel().getColumn(0);
        column.setPreferredWidth(25);
        CheckBoxTableCellRenderer includeRenderer = new CheckBoxTableCellRenderer();
        column.setCellRenderer(includeRenderer);
        column.setCellEditor(new TableCellEditorAdapter(new CheckBoxTableCellRenderer()));
        column = classIndicatorValuesTable.getColumnModel().getColumn(1);
        column.setPreferredWidth(100);
        TableCellRenderer classRenderer = this.buildClassColumnRenderer();
        column.setCellRenderer(classRenderer);
        column = classIndicatorValuesTable.getColumnModel().getColumn(2);
        column.setPreferredWidth(100);
        return classIndicatorValuesTable;
    }

    private TableModel buildClassIndicatorValuesTableModel() {
        return new TableModelAdapter(this.buildClassIndicatorValueAdapter(), this.buildClassIndicatorValueTableColumnAdapter());
    }

    private ColumnAdapter buildClassIndicatorValueTableColumnAdapter() {
        return new ClassIndicatorValueColumnAdapter(this.resourceRepository(), this);
    }

    private ObjectListSelectionModel buildRowSelectionModel() {
        ObjectListSelectionModel rowSelectionModel = new ObjectListSelectionModel(new ListModelAdapter(this.buildClassIndicatorValuesHolder()));
        rowSelectionModel.addListSelectionListener(this.buildRowSelectionListener(rowSelectionModel));
        rowSelectionModel.setSelectionMode(0);
        return rowSelectionModel;
    }

    private ListValueModel buildClassIndicatorValueAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildClassIndicatorValuesHolder(), "indicatorValue");
    }

    private CollectionValueModel buildClassIndicatorValuesHolder() {
        return new CollectionAspectAdapter(this.classIndicatorFieldPolicyHolder, "classIndicatorValues"){

            protected Iterator getValueFromSubject() {
                return ((MWClassIndicatorFieldPolicy)this.subject).classIndicatorValues();
            }
        };
    }

    private Action buildEditAction() {
        return new AbstractFrameworkAction(this.getApplicationContext()){

            public void actionPerformed(ActionEvent e) {
                ClassIndicatorDictionarySubPanel.this.editIndicator();
            }
        };
    }

    private void editIndicator() {
        Object indicatorValue = null;
        MWMappingDescriptor descriptor = null;
        for (int row = this.classIndicatorTableModel.getRowCount() - 1; row >= 0; --row) {
            if (!this.rowSelectionModel.isSelectedIndex(row)) continue;
            indicatorValue = this.classIndicatorTableModel.getValueAt(row, 2);
            descriptor = (MWMappingDescriptor)this.classIndicatorTableModel.getValueAt(row, 1);
        }
        MWClassIndicatorValueDialog dlg = new MWClassIndicatorValueDialog(this.getWorkbenchContext(), this.classIndicatorFieldPolicyHolder, descriptor, indicatorValue);
        dlg.show();
    }

    private ListSelectionListener buildRowSelectionListener(final ListSelectionModel selectionModel) {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ClassIndicatorDictionarySubPanel.this.editButton.getModel().setEnabled(ClassIndicatorDictionarySubPanel.this.editButtonShouldBeEnabled() && (!selectionModel.isSelectionEmpty() || selectionModel.getMinSelectionIndex() != selectionModel.getMaxSelectionIndex()));
                }
            }
        };
    }

    private PropertyChangeListener buildIncludePropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ClassIndicatorDictionarySubPanel.this.updateEditButton();
            }
        };
    }

    private void updateEditButton() {
        this.editButton.setEnabled(this.editButtonShouldBeEnabled());
    }

    private boolean editButtonShouldBeEnabled() {
        return this.getRowSelectionModel().getSelectedValue() != null && ((MWClassIndicatorValue)this.rowSelectionModel.getSelectedValue()).isInclude();
    }

    protected ObjectListSelectionModel getRowSelectionModel() {
        return this.rowSelectionModel;
    }

    protected JButton getEditButton() {
        return this.editButton;
    }

    public void updateRootStatus(boolean newValue) {
        this.isRoot = newValue;
        this.updateEnablementStatus();
    }

    public void updateIndicatorFieldStatus(boolean newValue) {
        this.isIndicatorField = newValue;
        this.updateEnablementStatus();
    }

    public void updateIndicatorDictionaryStatus(boolean newValue) {
        this.isIndicatorDictionary = newValue;
        this.updateEnablementStatus();
    }

    protected void updateEnablementStatus() {
        this.indicatorTypeListChooser.setEnabled(this.isRoot() && this.isIndicatorField() && this.isIndicatorDictionary());
        this.typeLabel.setEnabled(this.isRoot() && this.isIndicatorField() && this.isIndicatorDictionary());
        this.tableScrollPane.setEnabled(this.isRoot() && this.isIndicatorField() && this.isIndicatorDictionary());
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public boolean isIndicatorField() {
        return this.isIndicatorField;
    }

    public boolean isIndicatorDictionary() {
        return this.isIndicatorDictionary;
    }

    private static class MWClassIndicatorValueDialog
    extends AbstractDialog {
        private Object originalIndicatorValue;
        private JTextField indicatorValueTextField;
        private MWClassIndicatorFieldPolicy policy;
        private MWMappingDescriptor descriptor;

        private MWClassIndicatorValueDialog(WorkbenchContext context, ValueModel model, MWMappingDescriptor descriptor, Object indicatorValue) {
            super(context);
            this.originalIndicatorValue = indicatorValue;
            this.descriptor = descriptor;
            this.policy = (MWClassIndicatorFieldPolicy)model.getValue();
        }

        private String getStringValue(Object object) {
            if (object == null) {
                return "";
            }
            return object.toString();
        }

        protected String helpTopicId() {
            return "descriptor.inheritance.indicator.editDialog";
        }

        protected Component buildMainPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            this.setTitle(this.resourceRepository().getString("ENTER_INDICATOR_VALUE"));
            GridBagConstraints constraints = new GridBagConstraints();
            JLabel indicatorTypeLabel = new JLabel(this.resourceRepository().getString("INDICATOR_TYPE"));
            indicatorTypeLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("INDICATOR_TYPE"));
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            constraints.anchor = 18;
            constraints.insets = new Insets(5, 5, 5, 5);
            panel.add((Component)indicatorTypeLabel, constraints);
            JLabel indicatorType = new JLabel(this.policy.getIndicatorType().displayStringWithPackage(), this.resourceRepository().getIcon("class.public"), 0);
            JPanel indicatorTypePanel = new JPanel(new BorderLayout());
            indicatorTypePanel.setMinimumSize(new Dimension(0, 20));
            indicatorTypePanel.setBorder(BorderFactory.createEtchedBorder());
            indicatorTypePanel.add((Component)indicatorType, "West");
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 1;
            constraints.anchor = 18;
            constraints.insets = new Insets(5, 5, 5, 5);
            panel.add((Component)indicatorTypePanel, constraints);
            JLabel indicatorValueLabel = new JLabel(this.resourceRepository().getString("INDICATOR_VALUE"));
            indicatorValueLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("INDICATOR_VALUE"));
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            constraints.anchor = 18;
            constraints.insets = new Insets(5, 5, 5, 5);
            panel.add((Component)indicatorValueLabel, constraints);
            this.indicatorValueTextField = new JTextField(this.getStringValue(this.originalIndicatorValue));
            this.helpManager().addTopicID(this.indicatorValueTextField, this.helpTopicId() + ".indicatorValue");
            this.indicatorValueTextField.setColumns(20);
            this.indicatorValueTextField.getDocument().addDocumentListener(new CVDocumentListener());
            indicatorValueLabel.setLabelFor(this.indicatorValueTextField);
            constraints.gridx = 1;
            constraints.gridy = 1;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            constraints.anchor = 18;
            constraints.insets = new Insets(5, 5, 5, 5);
            panel.add((Component)this.indicatorValueTextField, constraints);
            this.updateOKButton();
            return panel;
        }

        public boolean preConfirm() {
            String indicatorValueText = this.indicatorValueTextField.getText();
            Object indicatorValue = null;
            try {
                indicatorValue = this.policy.buildIndicatorValueFromString(indicatorValueText);
            }
            catch (ConversionException ce) {
                this.showInvalidConversionDialog(ce);
                return false;
            }
            if (indicatorValue.equals(this.originalIndicatorValue)) {
                return true;
            }
            if (this.policy.isRepeatedIndicatorValue(indicatorValue)) {
                this.showRepeatedIndicatorValueDialog(indicatorValueText);
                return false;
            }
            this.policy.getClassIndicatorValueForDescriptor(this.descriptor).setIndicatorValue(indicatorValue);
            return true;
        }

        protected String getInvalidInputMessage(Class javaClass) {
            String javaClassName = javaClass.getName();
            if (javaClassName.equals("java.lang.Boolean")) {
                return this.resourceRepository().getString("BE_EITHER_TRUE_OR_FALSE", javaClassName);
            }
            if (javaClassName.equals("java.lang.Byte")) {
                return this.resourceRepository().getString("BE_BETWEEN_0_AND_127", javaClassName);
            }
            if (javaClassName.equals("java.lang.Character")) {
                return this.resourceRepository().getString("BE_SINGLE_CHARACTER", javaClassName);
            }
            if (javaClassName.equals("java.lang.Double")) {
                return this.resourceRepository().getString("BE_BETWEEN_DOUBLE", new Object[]{javaClassName, NumberFormat.getInstance().format(Double.MIN_VALUE), NumberFormat.getInstance().format(Double.MAX_VALUE)});
            }
            if (javaClassName.equals("java.lang.Float")) {
                return this.resourceRepository().getString("BE_BETWEEN_FLOAT", new Object[]{javaClassName, NumberFormat.getInstance().format(1.4E-45f), NumberFormat.getInstance().format(3.4028234663852886E38)});
            }
            if (javaClassName.equals("java.lang.Integer")) {
                return this.resourceRepository().getString("BE_BETWEEN_INT", new Object[]{javaClassName, NumberFormat.getInstance().format(Integer.MIN_VALUE), NumberFormat.getInstance().format(Integer.MAX_VALUE)});
            }
            if (javaClassName.equals("java.lang.Long")) {
                return this.resourceRepository().getString("BE_BETWEEN_LONG", new Object[]{javaClassName, NumberFormat.getInstance().format(Long.MIN_VALUE), NumberFormat.getInstance().format(Long.MAX_VALUE)});
            }
            if (javaClassName.equals("java.lang.Short")) {
                return this.resourceRepository().getString("BE_BETWEEN_SHORT", new Object[]{javaClassName, NumberFormat.getInstance().format(-32768L), NumberFormat.getInstance().format(32767L)});
            }
            if (javaClassName.equals("java.lang.String")) {
                return this.resourceRepository().getString("BE_A_STRING", javaClassName);
            }
            if (javaClassName.equals("java.math.BigDecimal")) {
                return this.resourceRepository().getString("CONTAINS_ONLY_DIGITS", javaClassName);
            }
            if (javaClassName.equals("java.math.BigInteger")) {
                return this.resourceRepository().getString("CONTAINS_ONLY_DIGITS_AND", javaClassName);
            }
            if (javaClassName.equals("java.sql.Date")) {
                return this.resourceRepository().getString("BE_IN_FORMAT1", javaClassName);
            }
            if (javaClassName.equals("java.sql.Time")) {
                return this.resourceRepository().getString("BE_IN_FORMAT2", javaClassName);
            }
            if (javaClassName.equals("java.sql.Timestamp")) {
                return this.resourceRepository().getString("BE_IN_FORMAT3", javaClassName);
            }
            if (javaClassName.equals("java.util.Date")) {
                return this.resourceRepository().getString("BE_IN_FORMAT4", javaClassName);
            }
            if (javaClassName.equals("java.util.Calendar")) {
                return this.resourceRepository().getString("BE_IN_FORMAT5", javaClassName);
            }
            if (javaClass == byte[].class || javaClass == Byte[].class) {
                return this.resourceRepository().getString("BE_IN_FORMAT_BYTE_ARRAY", javaClassName);
            }
            if (javaClass == char[].class || javaClass == Character[].class) {
                return this.resourceRepository().getString("BE_A_STRING", javaClassName);
            }
            return this.resourceRepository().getString("ILLEGAL_FORMAT");
        }

        private void showInvalidConversionDialog(ConversionException ce) {
            JOptionPane.showMessageDialog(this.getWorkbenchContext().getCurrentWindow(), this.getInvalidInputMessage(ce.getClassToConvertTo()), this.resourceRepository().getString("ILLEGAL_FORMAT"), 2);
        }

        private void showRepeatedIndicatorValueDialog(String valueString) {
            JOptionPane.showMessageDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString("INDICATOR_VALUE_ALLREADY_EXISTS", valueString), this.resourceRepository().getString("REPEATED_INDICATOR_VALUE"), 2);
        }

        private void updateOKButton() {
            boolean enableOKButton = this.indicatorValueTextField.getText() != null && !this.indicatorValueTextField.getText().equals("");
            this.getOKAction().setEnabled(enableOKButton);
        }

        private class CVDocumentListener
        implements DocumentListener {
            private CVDocumentListener() {
            }

            public void changedUpdate(DocumentEvent de) {
                MWClassIndicatorValueDialog.this.updateOKButton();
            }

            public void insertUpdate(DocumentEvent de) {
                MWClassIndicatorValueDialog.this.updateOKButton();
            }

            public void removeUpdate(DocumentEvent de) {
                MWClassIndicatorValueDialog.this.updateOKButton();
            }
        }
    }

    private static class ClassIndicatorValueColumnAdapter
    implements ColumnAdapter {
        private ResourceRepository resourceRepository;
        private ClassIndicatorDictionarySubPanel parentPanel;
        public static final int COLUMN_COUNT = 3;
        public static final int INCLUDE_COLUMN = 0;
        public static final int CLASS_COLUMN = 1;
        public static final int VALUE_COLUMN = 2;
        private static final String[] COLUMN_NAME_KEYS = new String[]{"INCLUDE_COLUMN_HEADER", "CLASS_COLUMN_HEADER", "VALUE_COLUMN_HEADER"};

        protected ClassIndicatorValueColumnAdapter(ResourceRepository repository, ClassIndicatorDictionarySubPanel parentPanel) {
            this.parentPanel = parentPanel;
            this.resourceRepository = repository;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int index) {
            return this.resourceRepository.getString(COLUMN_NAME_KEYS[index]);
        }

        public Class getColumnClass(int index) {
            switch (index) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return Object.class;
                }
                case 2: {
                    return Object.class;
                }
            }
            return Object.class;
        }

        public boolean isColumnEditable(int index) {
            return index == 0;
        }

        public PropertyValueModel[] cellModels(Object subject) {
            MWClassIndicatorValue indicatorValue = (MWClassIndicatorValue)subject;
            PropertyValueModel[] result = new PropertyValueModel[3];
            PropertyValueModel includeAdapter = this.buildIncludeAdapter(indicatorValue);
            includeAdapter.addPropertyChangeListener(this.parentPanel.buildIncludePropertyChangeListener());
            result[0] = includeAdapter;
            result[1] = this.buildClassAdapter(indicatorValue);
            result[2] = this.buildValueAdapter(indicatorValue);
            return result;
        }

        private PropertyValueModel buildIncludeAdapter(MWClassIndicatorValue indicatorValue) {
            return new PropertyAspectAdapter("include", (Model)indicatorValue){

                protected Object getValueFromSubject() {
                    return ((MWClassIndicatorValue)this.subject).isInclude();
                }

                protected void setValueOnSubject(Object value) {
                    ((MWClassIndicatorValue)this.subject).setInclude(((Boolean)value).booleanValue());
                }
            };
        }

        private PropertyValueModel buildClassAdapter(MWClassIndicatorValue indicatorValue) {
            PropertyAspectAdapter adapter = new PropertyAspectAdapter("descriptorValue", (Model)indicatorValue){

                protected Object getValueFromSubject() {
                    return ((MWClassIndicatorValue)this.subject).getDescriptorValue();
                }
            };
            return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)adapter, "name");
        }

        private PropertyValueModel buildValueAdapter(MWClassIndicatorValue indicatorValue) {
            return new PropertyAspectAdapter("indicatorValue", (Model)indicatorValue){

                protected Object getValueFromSubject() {
                    return ((MWClassIndicatorValue)this.subject).getIndicatorValueAsString();
                }
            };
        }
    }
}

