/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JTabbedPane;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWJoinedItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryItem;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.QueryGeneralPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.QueryQuickViewItem;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.QuickViewPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.JoinedAttributesPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QuerySelectionCriteriaPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.RelationalQueryOptionsPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;

final class RelationalReadObjectQueryPanel
extends AbstractPanel {
    private PropertyValueModel queryHolder;
    private JTabbedPane queryPropertiesPane;
    private JoinedAttributesPanel joinedAttributesPanel;
    private QueryGeneralPanel queryGeneralPanel;

    RelationalReadObjectQueryPanel(PropertyValueModel queryHolder, ObjectListSelectionModel querySelectionModel, WorkbenchContextHolder contextHolder) {
        super(contextHolder);
        this.queryHolder = queryHolder;
        this.initializeLayout(querySelectionModel);
    }

    private void initializeLayout(ObjectListSelectionModel querySelectionModel) {
        GridBagConstraints constraints = new GridBagConstraints();
        this.queryPropertiesPane = new JTabbedPane();
        this.queryGeneralPanel = new QueryGeneralPanel(this.queryHolder, querySelectionModel, this.getWorkbenchContextHolder());
        QuerySelectionCriteriaPanel queryFormatPanel = new QuerySelectionCriteriaPanel(this.queryHolder, this.getWorkbenchContextHolder());
        this.joinedAttributesPanel = new JoinedAttributesPanel(this.queryHolder, this.getWorkbenchContextHolder());
        RelationalQueryOptionsPanel queryOptionsPanel = new RelationalQueryOptionsPanel(this.queryHolder, this.getWorkbenchContextHolder());
        this.queryPropertiesPane.addTab(this.resourceRepository().getString("GENERAL_TAB"), this.queryGeneralPanel);
        this.queryPropertiesPane.addTab(this.resourceRepository().getString("FORMAT_TAB"), queryFormatPanel);
        this.queryPropertiesPane.addTab(this.resourceRepository().getString("OPTIMIZATION_TAB"), this.joinedAttributesPanel);
        this.queryPropertiesPane.addTab(this.resourceRepository().getString("OPTIONS_TAB"), queryOptionsPanel);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.queryPropertiesPane, constraints);
    }

    protected void selectQueryOptimizationTab() {
        this.queryPropertiesPane.setSelectedComponent(this.joinedAttributesPanel);
    }

    protected QueryGeneralPanel getQueryGeneralPanel() {
        return this.queryGeneralPanel;
    }

    protected JTabbedPane getQueryTabbedPane() {
        return this.queryPropertiesPane;
    }

    protected QuickViewPanel.QuickViewItem buildJoinedAttributeQuickViewItem(MWJoinedItem queryItem) {
        return new QueryQuickViewItem((MWQueryItem)queryItem){

            public void select() {
                RelationalReadObjectQueryPanel.this.queryPropertiesPane.setSelectedComponent(RelationalReadObjectQueryPanel.this.joinedAttributesPanel);
                RelationalReadObjectQueryPanel.this.joinedAttributesPanel.select((MWQueryItem)this.getValue());
            }
        };
    }
}

