/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWOrderableQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportOrderingItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.Ordering;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.OrderingAttributeDialog;
import org.eclipse.persistence.tools.workbench.uitools.SwitcherPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.Transformer;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;

final class ReportQueryOrderingAttributeDialog
extends OrderingAttributeDialog {
    private ObjectListSelectionModel attributesListSelectionModel;
    private Component existingAttributePanel;
    private Component newAttributePanel;
    private PropertyValueModel attributeTypeHolder;

    ReportQueryOrderingAttributeDialog(MWReportQuery query, MWReportOrderingItem item, Filter traversableFilter, Filter chooseableFilter, WorkbenchContext context) {
        super((MWOrderableQuery)query, (Ordering)item, traversableFilter, chooseableFilter, context);
    }

    protected String helpTopicId() {
        return "descriptor.queryManager.reportQuery.orderingAttributes";
    }

    protected Component buildMainPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.attributeTypeHolder = new SimplePropertyValueModel();
        RadioButtonModelAdapter selectedButtonModel = new RadioButtonModelAdapter(this.attributeTypeHolder, "Selected Attribute");
        JRadioButton selectedRadioButton = SwingComponentFactory.buildRadioButton("ORDERING_ATTRIBUTES_DIALOG_SELECTED_ATTRIBUTE_BUTTON", selectedButtonModel, this.resourceRepository());
        selectedRadioButton.setSelected(true);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)selectedRadioButton, constraints);
        RadioButtonModelAdapter newButtonModel = new RadioButtonModelAdapter(this.attributeTypeHolder, "New Attribute");
        JRadioButton newRadioButton = SwingComponentFactory.buildRadioButton("ORDERING_ATTRIBUTES_DIALOG_NEW_ATTRIBUTE_BUTTON", newButtonModel, this.resourceRepository());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)newRadioButton, constraints);
        this.existingAttributePanel = this.buildExistingAttributePanel();
        this.newAttributePanel = this.buildNewAttributePanel();
        SwitcherPanel switcherPanel = new SwitcherPanel(this.attributeTypeHolder, this.buildSwitchPanelTransformer());
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)switcherPanel, constraints);
        JPanel orderPanel = new JPanel(new GridBagLayout());
        JLabel orderLabel = new JLabel(this.resourceRepository().getString("ORDERING_ATTRIBUTES_DIALOG_ORDER_LABEL"));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(10, 0, 0, 0);
        orderPanel.add((Component)orderLabel, constraints);
        JComboBox orderComboBox = this.buildOrderComboBox();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(10, 5, 0, 0);
        orderPanel.add((Component)orderComboBox, constraints);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)orderPanel, constraints);
        return panel;
    }

    private ListModel buildReportAttributesListModel() {
        DefaultListModel listModel = new DefaultListModel();
        ListIterator i = ((MWReportQuery)this.getQuery()).attributeItems();
        while (i.hasNext()) {
            listModel.addElement(i.next());
        }
        return listModel;
    }

    private Transformer buildSwitchPanelTransformer() {
        return new Transformer(){

            public Object transform(Object o) {
                if (o == "Selected Attribute") {
                    return ReportQueryOrderingAttributeDialog.this.getExistingAttributePanel();
                }
                ReportQueryOrderingAttributeDialog.this.attributesListSelectionModel.setSelectedValue(null);
                return ReportQueryOrderingAttributeDialog.this.getNewAttributePanel();
            }
        };
    }

    private Component getExistingAttributePanel() {
        return this.existingAttributePanel;
    }

    private Component buildExistingAttributePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        ListModel listModel = this.buildReportAttributesListModel();
        JList<Object> reportAttributesList = new JList<Object>(listModel);
        this.attributesListSelectionModel = new ObjectListSelectionModel(listModel);
        reportAttributesList.setSelectionModel(this.attributesListSelectionModel);
        reportAttributesList.setSelectionMode(0);
        reportAttributesList.setCellRenderer(new SimpleListCellRenderer(){

            protected String buildText(Object value) {
                return ((MWReportAttributeItem)value).getName();
            }
        });
        reportAttributesList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ReportQueryOrderingAttributeDialog.this.updateOKButton();
            }
        });
        JScrollPane listScrollPane = new JScrollPane(reportAttributesList);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)listScrollPane, constraints);
        return panel;
    }

    private Component getNewAttributePanel() {
        return this.newAttributePanel;
    }

    private Component buildNewAttributePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JScrollPane scrollPane = new JScrollPane(this.buildQueryableTree());
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)scrollPane, constraints);
        return panel;
    }

    protected void initializeEditMode(MWAttributeItem attributeItem) {
        if (((MWReportOrderingItem)attributeItem).getItemName() == null) {
            super.initializeEditMode(attributeItem);
            this.attributeTypeHolder.setValue("New Attribute");
        } else {
            for (int i = 0; i < this.attributesListSelectionModel.getListModel().getSize(); ++i) {
                MWReportAttributeItem item = (MWReportAttributeItem)this.attributesListSelectionModel.getListModel().getElementAt(i);
                if (item.getQueryableArgument() != attributeItem.getQueryableArgument()) continue;
                this.attributesListSelectionModel.setSelectedValue(item);
                break;
            }
            this.initializeOrderComboBox(attributeItem);
        }
    }

    protected void updateOKButton() {
        if (this.attributesListSelectionModel.getSelectedValue() != null) {
            this.getOKAction().setEnabled(true);
        } else {
            super.updateOKButton();
        }
    }

    protected boolean preConfirm() {
        MWReportAttributeItem attributeItem = (MWReportAttributeItem)this.attributesListSelectionModel.getSelectedValue();
        if (attributeItem == null) {
            return super.preConfirm();
        }
        int index = this.attributeItemsSize();
        if (this.getAttributeItem() != null) {
            index = this.indexOfAttributeItem(this.getAttributeItem());
            this.removeAttributeItem(index);
        }
        MWReportOrderingItem item = ((MWReportQuery)this.getQuery()).addOrderingItem(attributeItem);
        item.setAscending(this.isAscending());
        return true;
    }
}

