/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.persistence.platform.database.oracle.publisher.MethodFilter;
import org.eclipse.persistence.platform.database.oracle.publisher.PublisherException;
import org.eclipse.persistence.platform.database.oracle.publisher.Util;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.AttributeField;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.DefaultArgsHolderName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.DefaultArgsHolderType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.JavaBaseType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.JavaName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.JavaType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.LangName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Name;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.PlsqlIndexTableType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.PlsqlRecordName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.PlsqlRecordType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.PlsqlTableName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.PlsqlTableType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.ProcedureMethod;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.PublisherModifier;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlArrayType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlObjectType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlPackageType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlRefType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlSqljType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlStmtType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlTableType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlToplevelType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.TypeClass;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.WrapperMethodMetadata;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.WrapperPackageMetadata;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllCollTypes;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllTypes;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ElemInfo;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.FieldInfo;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.RowtypeInfo;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.SingleColumnViewRow;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.UserArguments;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ViewCache;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ViewCacheManager;

public class SqlReflector {
    public static final String CHAR_CS = "CHAR_CS";
    public static final String NCHAR_CS = "NCHAR_CS";
    public static final String ROWTYPE = "ROWTYPE";
    public static final String ROWTYPE_PL = "ROWTYPE_PL";
    public static final String ROWTYPE_SQL = "ROWTYPE_SQL";
    private ViewCacheManager m_viewCacheManager;
    private ViewCache m_viewCache;
    private Connection m_conn;
    private Boolean m_isPre920 = null;
    private boolean m_geq9i;
    private boolean m_transitive = true;
    private String m_user;
    private Hashtable m_allTypes;
    private Hashtable m_predefTypes;
    private Vector m_userTypes;
    private HashSet m_allTypeNames;
    private HashSet m_allGeneratedTypeNames;
    private int m_allGeneratedTypeNamesMagicNumber;
    private static final int MAGIC_NUMBER = 0;
    private Hashtable m_allDefaultArgsHolderTypeNames;
    private HashSet m_isReused;
    private boolean m_getTypeCodeWarning = false;
    private SqlStmtType m_sqlStmtType;
    private int m_rowtypeDistinguisher = 0;
    private WrapperPackageMetadata m_wrapperPackageMetadata;
    public static final SqlType BFILE_TYPE = new SqlType("BFILE", -13);
    public static final SqlType BINARY_INTEGER_TYPE = new SqlType(new SqlName("BINARY_INTEGER", "INTEGER"), 4);
    public static final SqlType BLOB_TYPE = new SqlType("BLOB", 2004);
    public static final SqlType CHAR_TYPE = new SqlType("CHAR", 1);
    public static final SqlType CLOB_TYPE = new SqlType("CLOB", 2005);
    public static final SqlType DATE_TYPE = new SqlType("DATE", 91);
    public static final SqlType NCHAR_TYPE = new SqlType("NCHAR", -72054);
    public static final SqlType NCLOB_TYPE = new SqlType("NCLOB", -72055);
    public static final SqlType TIMESTAMP_TYPE = new SqlType("TIMESTAMP", 93);
    public static final SqlType TIMESTAMP_WTZ_TYPE = new SqlType("TIMESTAMP WITH TZ", -101);
    public static final SqlType TIMESTAMPTZ_TYPE = new SqlType("TIMESTAMP WITH TIME ZONE", -101);
    public static final SqlType TIMESTAMPTZ_TYPE0 = new SqlType("TIMESTAMPTZ", -101);
    public static final SqlType TIMESTAMP_WLTZ_TYPE = new SqlType("TIMESTAMP WITH LOCAL TZ", -102);
    public static final SqlType TIMESTAMPLTZ_TYPE = new SqlType("TIMESTAMP WITH LOCAL TIME ZONE", -102);
    public static final SqlType TIMESTAMPLTZ_TYPE0 = new SqlType("TIMESTAMPLTZ", -102);
    public static final SqlType DECIMAL_TYPE = new SqlType("DECIMAL", 3);
    public static final SqlType DOUBLE_PRECISION_TYPE = new SqlType("DOUBLE PRECISION", 8);
    public static final SqlType FLOAT_TYPE = new SqlType("FLOAT", 6);
    public static final SqlType FLOAT38TYPE = new SqlType("FLOAT38", 2);
    public static final SqlType BINARY_DOUBLE_TYPE = new SqlType("BINARY_DOUBLE", 101);
    public static final SqlType BINARY_FLOAT_TYPE = new SqlType("BINARY_FLOAT", 100);
    public static final SqlType INTEGER_TYPE = new SqlType("INTEGER", 4);
    public static final SqlType INT_TYPE = new SqlType("INT", 4);
    public static final SqlType LONG_TYPE = new SqlType(new SqlName("LONG", "VARCHAR2"), 12);
    public static final SqlType LONG_RAW_TYPE = new SqlType(new SqlName("LONG RAW", "RAW"), -2);
    public static final SqlType NUMBER_TYPE = new SqlType("NUMBER", 2);
    public static final SqlType NUMERIC_TYPE = new SqlType("NUMERIC", 2);
    public static final SqlType NVARCHAR2_TYPE = new SqlType("NVARCHAR2", -72054);
    public static final SqlType PLS_INTEGER_TYPE = new SqlType(new SqlName("PLS_INTEGER", "INTEGER"), 4);
    public static final SqlType RAW_TYPE = new SqlType("RAW", -2);
    public static final SqlType REAL_TYPE = new SqlType("REAL", 7);
    public static final SqlType REF_CURSOR_TYPE = new SqlType("REF CURSOR", -10);
    public static final SqlType PLSQL_REF_CURSOR_TYPE = new SqlType("PL/SQL REF CURSOR", -10);
    public static final SqlType ROWID_TYPE = new SqlType(new SqlName("ROWID", "VARCHAR2"), 12);
    public static final SqlType SMALLINT_TYPE = new SqlType("SMALLINT", 5);
    public static final SqlType STRING_TYPE = new SqlType("STRING", 12);
    public static final SqlType UROWID_TYPE = new SqlType(new SqlName("UROWID", "VARCHAR2"), 12);
    public static final SqlType VARCHAR_TYPE = new SqlType("VARCHAR", 12);
    public static final SqlType VARCHAR2_TYPE = new SqlType("VARCHAR2", 12);
    public static SqlType plsqlTableDouble = null;
    public static SqlType plsqlTableFloat = null;
    public static SqlType plsqlTableInt = null;
    public static SqlType plsqlTableShort = null;
    public static SqlType plsqlTableJldouble = null;
    public static SqlType plsqlTableJlfloat = null;
    public static SqlType plsqlTableJlinteger = null;
    public static SqlType plsqlTableJlshort = null;
    public static SqlType plsqlTableJmbigdecimal = null;
    public static SqlType plsqlTableString = null;
    public static final SqlType UNKNOWN_TYPE = new SqlType("<unknown type or type not found>", 1997);
    private Hashtable m_typeMap;

    public SqlReflector(Connection conn, String user) {
        this.m_viewCacheManager = new ViewCacheManager(conn);
        this.m_user = user;
        this.reset(conn);
    }

    public void reset(Connection conn) {
        if (this.m_conn != null) {
            try {
                this.m_conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.m_conn = conn;
        this.m_viewCache = this.m_viewCacheManager.get(this.m_user);
        if (this.m_viewCache == null) {
            this.m_viewCache = new ViewCache(this.m_conn, this.m_user);
            this.m_viewCacheManager.add(this.m_viewCache);
        } else {
            this.m_viewCache.reset(this.m_conn);
        }
        this.m_allTypes = new Hashtable();
        this.m_predefTypes = new Hashtable();
        this.m_userTypes = new Vector();
        this.sqlTypeInit();
        this.m_allTypeNames = new HashSet();
        this.m_allGeneratedTypeNames = new HashSet();
        this.m_allGeneratedTypeNamesMagicNumber = 0;
        this.m_allDefaultArgsHolderTypeNames = new Hashtable();
        this.m_sqlStmtType = null;
        this.m_isReused = new HashSet();
        this.m_wrapperPackageMetadata = null;
        if (conn != null) {
            this.m_geq9i = SqlReflector.geqOracle9(conn);
        }
    }

    public void loadAllTypeNames() {
        try {
            Iterator iter = this.m_viewCache.getRows("ALL_TYPES", new String[]{"TYPE_NAME"}, new String[0], new Object[0], new String[0]);
            while (iter.hasNext()) {
                SingleColumnViewRow row = (SingleColumnViewRow)iter.next();
                this.m_allTypeNames.add(row.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String determineSqlName(String packageName, String[] sourceName, TypeClass parentType, boolean[] isRowType, AttributeField[] fields, SqlType elemType, SqlType valueType) throws SQLException {
        SqlName parentSqlName;
        String parentName = null;
        if (parentType != null && (parentSqlName = (SqlName)parentType.getNameObject()) != null) {
            parentName = parentSqlName.getTypeName().toUpperCase();
        }
        String name = sourceName[0];
        this.m_allGeneratedTypeNames.add(name);
        if (name.indexOf(46) >= 0 && parentName != null) {
            name = parentName + "_" + name.substring(name.indexOf(46) + 1);
            this.m_allGeneratedTypeNames.add(parentName);
        }
        name = name.replace('.', '_').replace(' ', '_');
        boolean toBeDistinguished = false;
        if (sourceName[0].equals("PL/SQL RECORD")) {
            isRowType[0] = true;
            sourceName[0] = ROWTYPE_PL + this.m_rowtypeDistinguisher++;
            name = ROWTYPE_SQL;
            if (packageName != null && !packageName.equals("")) {
                name = parentName != null ? parentName + "_" + name : packageName + "_" + name;
            }
            toBeDistinguished = true;
        }
        return this.determineSqlName(name, toBeDistinguished, fields, elemType, valueType);
    }

    private String determineSqlName(String name, boolean toBeDistinguished, AttributeField[] fields, SqlType elemType, SqlType valueType) throws SQLException {
        String uniqueName;
        String origName = name;
        if (valueType != null && (uniqueName = (String)this.m_allDefaultArgsHolderTypeNames.get(origName)) != null) {
            return uniqueName;
        }
        if (this.m_allTypeNames.contains(name)) {
            Iterator iter;
            boolean match = true;
            if (fields != null) {
                HashSet<String> hs = new HashSet<String>();
                for (int i = 0; i < fields.length; ++i) {
                    String fieldType = ((SqlName)fields[i].getType().getNameObject()).getTargetTypeName();
                    hs.add(fieldType + fields[i].getName());
                }
                iter = this.m_viewCache.getRows("ALL_TYPE_ATTRS", new String[]{"CONCAT(ATTR_TYPE_NAME,ATTR_NAME)"}, new String[]{"TYPE_NAME"}, new Object[]{name}, new String[0]);
                int count = 0;
                while (iter.hasNext()) {
                    String attr = ((SingleColumnViewRow)iter.next()).getValue();
                    if (!hs.contains(attr)) {
                        match = false;
                    }
                    ++count;
                }
                match = match && count == hs.size();
            } else if (elemType != null) {
                iter = this.m_viewCache.getRows("ALL_COLL_TYPES", new String[]{"ELEM_TYPE_NAME"}, new String[]{"TYPE_NAME"}, new Object[]{name}, new String[0]);
                if (iter.hasNext()) {
                    String elemTypeNameInDb = ((SingleColumnViewRow)iter.next()).getValue();
                    String elemTypeName = elemType.getSqlName().getTargetTypeName();
                    match = elemTypeNameInDb.equalsIgnoreCase(elemTypeName);
                } else {
                    match = false;
                }
            } else if (valueType != null) {
                iter = this.m_viewCache.getRows("ALL_TYPE_ATTRS", new String[]{"ATTR_TYPE_NAME"}, new String[]{"TYPE_NAME"}, new Object[]{name}, new String[0]);
                if (iter.hasNext()) {
                    String valueTypeNameInDb = ((SingleColumnViewRow)iter.next()).getValue();
                    String valueTypeName = valueType.getSqlName().getTargetTypeName();
                    match = valueTypeNameInDb.equalsIgnoreCase(valueTypeName);
                } else {
                    match = false;
                }
            }
            if (match) {
                this.m_isReused.add(name);
                return name;
            }
        }
        if (this.m_allTypeNames.contains(uniqueName = name.toUpperCase()) || toBeDistinguished && this.m_allGeneratedTypeNames.contains(uniqueName)) {
            do {
                int len2;
                int len1;
                if ((len1 = name.length()) + (len2 = Integer.toString(this.m_allGeneratedTypeNamesMagicNumber++).length()) <= 29) continue;
                name = name.substring(0, 29 - len2);
            } while (this.m_allTypeNames.contains(uniqueName = name.toUpperCase() + this.m_allGeneratedTypeNamesMagicNumber) || toBeDistinguished && this.m_allGeneratedTypeNames.contains(uniqueName));
        }
        this.m_allGeneratedTypeNames.add(uniqueName);
        if (valueType != null) {
            this.m_allDefaultArgsHolderTypeNames.put(origName, uniqueName);
        }
        return uniqueName;
    }

    void addAllGeneratedTypeNames(String name) {
        this.m_allGeneratedTypeNames.add(name.toUpperCase());
    }

    public boolean isReused(String name) {
        return this.m_isReused.contains(name);
    }

    public void setViewCachePoolCapacity(int size) {
        this.m_viewCacheManager.setViewCachePoolCapacity(size);
    }

    private void sqlTypeInit() {
        if (!this.m_allTypes.isEmpty()) {
            this.m_allTypes = new Hashtable();
        }
        this.m_allTypes.put(SqlReflector.BFILE_TYPE.m_name, BFILE_TYPE);
        this.m_allTypes.put(SqlReflector.BINARY_INTEGER_TYPE.m_name, BINARY_INTEGER_TYPE);
        this.m_allTypes.put(SqlReflector.BLOB_TYPE.m_name, BLOB_TYPE);
        this.m_allTypes.put(SqlReflector.CHAR_TYPE.m_name, CHAR_TYPE);
        this.m_allTypes.put(SqlReflector.CLOB_TYPE.m_name, CLOB_TYPE);
        this.m_allTypes.put(SqlReflector.DATE_TYPE.m_name, DATE_TYPE);
        this.m_allTypes.put(SqlReflector.NCHAR_TYPE.m_name, NCHAR_TYPE);
        this.m_allTypes.put(SqlReflector.NCLOB_TYPE.m_name, NCLOB_TYPE);
        this.m_allTypes.put(SqlReflector.TIMESTAMP_TYPE.m_name, TIMESTAMP_TYPE);
        this.m_allTypes.put(SqlReflector.TIMESTAMP_WTZ_TYPE.m_name, TIMESTAMP_WTZ_TYPE);
        this.m_allTypes.put(SqlReflector.TIMESTAMPTZ_TYPE.m_name, TIMESTAMPTZ_TYPE);
        this.m_allTypes.put(SqlReflector.TIMESTAMPTZ_TYPE0.m_name, TIMESTAMPTZ_TYPE0);
        this.m_allTypes.put(SqlReflector.TIMESTAMP_WLTZ_TYPE.m_name, TIMESTAMP_WLTZ_TYPE);
        this.m_allTypes.put(SqlReflector.TIMESTAMPLTZ_TYPE.m_name, TIMESTAMPLTZ_TYPE);
        this.m_allTypes.put(SqlReflector.TIMESTAMPLTZ_TYPE0.m_name, TIMESTAMPLTZ_TYPE0);
        this.m_allTypes.put(SqlReflector.DECIMAL_TYPE.m_name, DECIMAL_TYPE);
        this.m_allTypes.put(SqlReflector.BINARY_DOUBLE_TYPE.m_name, BINARY_DOUBLE_TYPE);
        this.m_allTypes.put(SqlReflector.DOUBLE_PRECISION_TYPE.m_name, DOUBLE_PRECISION_TYPE);
        this.m_allTypes.put(SqlReflector.FLOAT_TYPE.m_name, FLOAT_TYPE);
        this.m_allTypes.put(SqlReflector.FLOAT38TYPE.m_name, FLOAT38TYPE);
        this.m_allTypes.put(SqlReflector.BINARY_FLOAT_TYPE.m_name, BINARY_FLOAT_TYPE);
        this.m_allTypes.put(SqlReflector.INTEGER_TYPE.m_name, INTEGER_TYPE);
        this.m_allTypes.put(SqlReflector.INT_TYPE.m_name, INT_TYPE);
        this.m_allTypes.put(SqlReflector.LONG_TYPE.m_name, LONG_TYPE);
        this.m_allTypes.put(SqlReflector.LONG_RAW_TYPE.m_name, LONG_RAW_TYPE);
        this.m_allTypes.put(SqlReflector.NUMBER_TYPE.m_name, NUMBER_TYPE);
        this.m_allTypes.put(SqlReflector.NUMERIC_TYPE.m_name, NUMERIC_TYPE);
        this.m_allTypes.put(SqlReflector.NVARCHAR2_TYPE.m_name, NVARCHAR2_TYPE);
        this.m_allTypes.put(SqlReflector.PLS_INTEGER_TYPE.m_name, PLS_INTEGER_TYPE);
        this.m_allTypes.put(SqlReflector.RAW_TYPE.m_name, RAW_TYPE);
        this.m_allTypes.put(SqlReflector.REAL_TYPE.m_name, REAL_TYPE);
        this.m_allTypes.put(SqlReflector.REF_CURSOR_TYPE.m_name, REF_CURSOR_TYPE);
        this.m_allTypes.put(SqlReflector.PLSQL_REF_CURSOR_TYPE.m_name, PLSQL_REF_CURSOR_TYPE);
        this.m_allTypes.put(SqlReflector.ROWID_TYPE.m_name, ROWID_TYPE);
        this.m_allTypes.put(SqlReflector.SMALLINT_TYPE.m_name, SMALLINT_TYPE);
        this.m_allTypes.put(SqlReflector.STRING_TYPE.m_name, STRING_TYPE);
        this.m_allTypes.put(SqlReflector.UROWID_TYPE.m_name, UROWID_TYPE);
        this.m_allTypes.put(SqlReflector.VARCHAR_TYPE.m_name, VARCHAR_TYPE);
        this.m_allTypes.put(SqlReflector.VARCHAR2_TYPE.m_name, VARCHAR2_TYPE);
        String name = "PLSQL_TABLE_DOUBLE";
        SqlName sqlName = new SqlName(name, name);
        sqlName.setAnnotation(new JavaName("", "double[]", null, "double[]", null));
        plsqlTableDouble = new PlsqlIndexTableType(sqlName, true);
        name = "PLSQL_TABLE_FLOAT";
        sqlName = new SqlName(name, name);
        sqlName.setAnnotation(new JavaName("", "float[]", null, "float[]", null));
        plsqlTableFloat = new PlsqlIndexTableType(sqlName, true);
        name = "PLSQL_TABLE_INT";
        sqlName = new SqlName(name, name);
        sqlName.setAnnotation(new JavaName("", "int[]", null, "int[]", null));
        plsqlTableInt = new PlsqlIndexTableType(sqlName, true);
        name = "PLSQL_TABLE_SHORT";
        sqlName = new SqlName(name, name);
        sqlName.setAnnotation(new JavaName("", "short[]", null, "short[]", null));
        plsqlTableShort = new PlsqlIndexTableType(sqlName, true);
        name = "PLSQL_TABLE_JLDOUBLE";
        sqlName = new SqlName(name, name);
        sqlName.setAnnotation(new JavaName("", "Double[]", null, "Double[]", null));
        plsqlTableJldouble = new PlsqlIndexTableType(sqlName, true);
        name = "PLSQL_TABLE_JLFLOAT";
        sqlName = new SqlName(name, name);
        sqlName.setAnnotation(new JavaName("", "Float[]", null, "Float[]", null));
        plsqlTableJlfloat = new PlsqlIndexTableType(sqlName, true);
        name = "PLSQL_TABLE_JLINTEGER";
        sqlName = new SqlName(name, name);
        sqlName.setAnnotation(new JavaName("", "Integer[]", null, "Integer[]", null));
        plsqlTableJlinteger = new PlsqlIndexTableType(sqlName, true);
        name = "PLSQL_TABLE_JLSHORT";
        sqlName = new SqlName(name, name);
        sqlName.setAnnotation(new JavaName("", "Short[]", null, "Short[]", null));
        plsqlTableJlshort = new PlsqlIndexTableType(sqlName, true);
        name = "PLSQL_TABLE_JLINTEGER";
        sqlName = new SqlName(name, name);
        sqlName.setAnnotation(new JavaName("", "Integer[]", null, "Integer[]", null));
        plsqlTableJlinteger = new PlsqlIndexTableType(sqlName, true);
        name = "PLSQL_TABLE_JMBIGDECIMAL";
        sqlName = new SqlName(name, name);
        sqlName.setAnnotation(new JavaName("", "java.math.BigDecimal[]", null, "java.math.BigDecimal[]", null));
        plsqlTableJmbigdecimal = new PlsqlIndexTableType(sqlName, true);
        name = "PLSQL_TABLE_STRING";
        sqlName = new SqlName(name, name);
        sqlName.setAnnotation(new JavaName("", "String[]", null, "String[]", null));
        plsqlTableString = new PlsqlIndexTableType(sqlName, false);
        this.m_allTypes.put(SqlReflector.plsqlTableDouble.m_name, plsqlTableDouble);
        this.m_allTypes.put(SqlReflector.plsqlTableFloat.m_name, plsqlTableFloat);
        this.m_allTypes.put(SqlReflector.plsqlTableInt.m_name, plsqlTableInt);
        this.m_allTypes.put(SqlReflector.plsqlTableShort.m_name, plsqlTableShort);
        this.m_allTypes.put(SqlReflector.plsqlTableJldouble.m_name, plsqlTableJldouble);
        this.m_allTypes.put(SqlReflector.plsqlTableJlfloat.m_name, plsqlTableJlfloat);
        this.m_allTypes.put(SqlReflector.plsqlTableJlshort.m_name, plsqlTableJlshort);
        this.m_allTypes.put(SqlReflector.plsqlTableJlinteger.m_name, plsqlTableJlinteger);
        this.m_allTypes.put(SqlReflector.plsqlTableJmbigdecimal.m_name, plsqlTableJmbigdecimal);
        this.m_allTypes.put(SqlReflector.plsqlTableString.m_name, plsqlTableString);
        String hint = "/*[32767]*/";
        plsqlTableDouble.setHint(hint);
        plsqlTableFloat.setHint(hint);
        plsqlTableInt.setHint(hint);
        plsqlTableShort.setHint(hint);
        plsqlTableJldouble.setHint(hint);
        plsqlTableJlfloat.setHint(hint);
        plsqlTableJlinteger.setHint(hint);
        plsqlTableJlshort.setHint(hint);
        plsqlTableString.setHint(hint);
        plsqlTableJmbigdecimal.setHint(hint);
        this.m_allTypes.put(SqlReflector.UNKNOWN_TYPE.m_name, UNKNOWN_TYPE);
    }

    public Connection getConnection() {
        return this.m_conn;
    }

    public SqlType addSqlType(SqlName sqlName, int whatIsIt, boolean mustBeNew, boolean generateMe, SqlType parentType, String modifier) throws SQLException, PublisherException {
        return this.addSqlType(sqlName, whatIsIt, mustBeNew, generateMe, parentType, modifier, false, null);
    }

    public SqlType addSqlType(SqlName sqlName, int whatIsIt, boolean mustBeNew, boolean generateMe, SqlType parentType, String modifier, boolean ncharFormOfUse, MethodFilter signatureFilter) throws SQLException, PublisherException {
        SqlType result = null;
        try {
            Iterator iter;
            if (ncharFormOfUse) {
                if (sqlName.getTypeName().equals("CHAR")) {
                    sqlName = NCHAR_TYPE.getSqlName();
                } else if (sqlName.getTypeName().equals("VARCHAR2")) {
                    sqlName = NVARCHAR2_TYPE.getSqlName();
                } else if (sqlName.getTypeName().equals("CLOB")) {
                    sqlName = NCLOB_TYPE.getSqlName();
                }
            }
            SqlType t = this.findType(sqlName);
            boolean predefined = false;
            if (t == null) {
                t = this.findPredefType(sqlName);
                predefined = true;
            }
            if (t != null) {
                result = t;
                if (mustBeNew && predefined) {
                    throw new PublisherException("duplicate type " + result.toString());
                }
                if (mustBeNew) {
                    t.setNameObject(sqlName);
                }
                return result;
            }
            String schema = sqlName.getSchemaName();
            String type = sqlName.getTypeName();
            if (whatIsIt == 12) {
                return new SqlToplevelType(sqlName, parentType, signatureFilter, this);
            }
            if ((whatIsIt & 4) != 0) {
                Iterator rowIter = this.m_viewCache.getRows("ALL_OBJECTS", new String[]{"'PACKAGE' AS TYPECODE"}, new String[]{"OWNER", "OBJECT_NAME", "OBJECT_TYPE", "STATUS"}, new Object[]{schema, type, "PACKAGE", "VALID"}, new String[0]);
                if (rowIter.hasNext()) {
                    this.m_viewCache.fetch(type, signatureFilter);
                    result = new SqlPackageType(sqlName, parentType, signatureFilter, this);
                }
                if (result != null) {
                    return result;
                }
                if (whatIsIt == 4) {
                    throw new PublisherException("package not found " + sqlName.toString());
                }
            }
            if ((iter = this.m_viewCache.getRows("ALL_TYPES", new String[0], new String[]{"OWNER", "TYPE_NAME", "PREDEFINED"}, new Object[]{schema, type, "NO"}, new String[0])).hasNext()) {
                int kind;
                int dbTypeCode;
                String typeCode;
                block42: {
                    AllTypes allTypes = (AllTypes)iter.next();
                    typeCode = allTypes.typeCode;
                    byte[] typeOID = allTypes.typeOid;
                    dbTypeCode = 0;
                    kind = 0;
                    if (!this.m_getTypeCodeWarning) {
                        try {
                            Object[] outParams = this.m_viewCache.getOutParameters("BEGIN sys.sqljutl.get_typecode(:1, :2, :3, :4); END;", new Object[]{typeOID}, new int[]{4, 12, 4});
                            if (outParams == null) {
                                throw new SQLException("no data from sqljutl.get_typecode call");
                            }
                            dbTypeCode = (Integer)outParams[0];
                            String name = (String)outParams[1];
                            kind = (Integer)outParams[2];
                        }
                        catch (SQLException exn) {
                            String msg = exn.getMessage();
                            if (this.isPre920()) {
                                msg = null;
                                this.m_getTypeCodeWarning = true;
                            } else if (msg.indexOf("PLS-00201") > 0) {
                                msg = "cannot determine type " + type;
                                this.m_getTypeCodeWarning = true;
                            } else {
                                msg = "error determining type " + type;
                            }
                            if (msg == null) break block42;
                            throw new PublisherException(msg);
                        }
                    }
                }
                if (dbTypeCode == 58) {
                    result = new SqlObjectType(sqlName, 2007, generateMe, parentType, this);
                } else if (dbTypeCode == 108 && kind != 0) {
                    result = new SqlSqljType(sqlName, kind, parentType, this);
                } else if (typeCode.equals("OBJECT")) {
                    result = new SqlObjectType(sqlName, generateMe, parentType, this);
                    if (SqlName.langIsOtt()) {
                        new SqlRefType(sqlName, result, parentType, generateMe, this);
                    }
                    if (PublisherModifier.isIncomplete(result.getModifiers())) {
                        int line = sqlName.getLine();
                        int column = sqlName.getColumn();
                        String mesg = "incomplete type " + sqlName.toString();
                        if (line > 0 || column > 0) {
                            mesg = "" + line + "." + column + ": " + mesg;
                        }
                        System.err.println(mesg);
                    }
                } else if (typeCode.equals("COLLECTION")) {
                    if ((whatIsIt & 2) == 0) {
                        throw new PublisherException("collection found " + sqlName.toString());
                    }
                    Iterator iter3 = this.m_viewCache.getRows("ALL_COLL_TYPES", new String[0], new String[]{"OWNER", "TYPE_NAME"}, new Object[]{schema, type}, new String[0]);
                    if (iter3.hasNext()) {
                        AllCollTypes act = (AllCollTypes)iter3.next();
                        String collTypeCode = act.collType;
                        result = collTypeCode.equals("TABLE") ? new SqlTableType(sqlName, generateMe, parentType, this) : new SqlArrayType(sqlName, generateMe, parentType, this);
                    }
                }
            }
            if (result != null) {
                return result;
            }
            if (result != null) {
                return result;
            }
            result = this.addPredefType(sqlName, 1997);
            if ((whatIsIt & 4) != 0) {
                throw new PublisherException("type not found " + sqlName.toString());
            }
        }
        catch (SQLException e) {
            System.err.println(e.getMessage());
        }
        catch (PublisherException ex) {
            System.err.println(ex.getMessage());
        }
        return result;
    }

    public SqlType addSqlUserType(String schema, String type, int whatIsIt, boolean mustBeNew, int line, int col, MethodFilter signatureFilter) throws SQLException, PublisherException {
        SqlName sn = new SqlName(schema, type, false, line, col, this);
        return this.addSqlType(sn, whatIsIt, mustBeNew, true, null, null, false, signatureFilter);
    }

    private SqlType addSqlDBType(SqlName sqlName, String modifier, boolean ncharFormOfUse, SqlType parentType) throws SQLException, PublisherException {
        if (modifier != null && modifier.equals("REF")) {
            SqlType t = this.addSqlType(sqlName, 3, false, this.m_transitive, parentType, modifier);
            SqlRefType rt = new SqlRefType(sqlName, t, parentType, this.m_transitive, this);
            return rt;
        }
        return this.addSqlType(sqlName, 3, false, this.m_transitive, parentType, modifier, ncharFormOfUse, null);
    }

    public SqlType addSqlDBType(String schema, String type, String subtype, String modifier, boolean ncharFormOfUse, SqlType parentType) throws SQLException, PublisherException {
        int line = 0;
        int col = 0;
        if (parentType != null) {
            SqlName psqlname = (SqlName)parentType.getNameObject();
            line = psqlname.getLine();
            col = psqlname.getColumn();
        }
        if (subtype != null) {
            type = type != null ? type + "." + subtype : subtype;
            if (schema != null) {
                type = schema + "." + type;
                schema = null;
            }
        }
        SqlName sn = new SqlName(schema, type, true, line, col, this);
        sn.setAnnotation(this.genPattern((LangName)sn.getAnnotation(), sn.getSimpleName(), true));
        return this.addSqlDBType(sn, modifier, ncharFormOfUse, parentType);
    }

    public SqlType addPlsqlDBType(String schema, String type, String subtype, String modifier, boolean ncharFormOfUse, String packageName, String methodName, String methodNo, int sequence, SqlType parentType) throws SQLException, PublisherException {
        return this.addPlsqlDBType(schema, type, subtype, modifier, ncharFormOfUse, packageName, methodName, methodNo, sequence, parentType, false);
    }

    public SqlType addPlsqlDBType(String schema, String type, String subtype, String modifier, boolean ncharFormOfUse, String packageName, String methodName, String methodNo, int sequence, SqlType parentType, boolean isGrandparent) throws SQLException, PublisherException {
        SqlType result;
        boolean predefined;
        int line = 0;
        int col = 0;
        if (parentType != null) {
            SqlName psqlname = (SqlName)parentType.getNameObject();
            line = psqlname.getLine();
            col = psqlname.getColumn();
        }
        if (subtype != null) {
            type = type != null ? type + "." + subtype : subtype;
            if (schema != null) {
                type = schema + "." + type;
                schema = null;
            }
        }
        if (modifier == null || !modifier.equals("PL/SQL RECORD") && !modifier.equals("PL/SQL TABLE") && (!modifier.equals("TABLE") || subtype == null && type.indexOf(".") == -1) && (!modifier.equals("VARRAY") || subtype == null && type.indexOf(".") == -1)) {
            SqlName sn = new SqlName(schema, type, true, line, col, this);
            sn.setAnnotation(this.genPattern((LangName)sn.getAnnotation(), sn.getSimpleName(), true));
            return this.addSqlDBType(sn, modifier, ncharFormOfUse, parentType);
        }
        RowtypeInfo[] rowtypeInfoA = null;
        if (modifier != null && type != null && modifier.equals("PL/SQL RECORD") && type.equals("PL/SQL RECORD")) {
            rowtypeInfoA = this.reflectRowtypeInfo(packageName, methodName, methodNo, sequence);
            for (int i = 0; i < this.m_userTypes.size(); ++i) {
                boolean found = true;
                TypeClass p = (TypeClass)this.m_userTypes.elementAt(i);
                if (!(p instanceof PlsqlRecordType)) continue;
                RowtypeInfo[] rowtypeInfoB = ((PlsqlRecordType)p).getRowtypeInfo();
                if (rowtypeInfoB == null || rowtypeInfoA == null || rowtypeInfoA.length != rowtypeInfoB.length) {
                    found = false;
                    continue;
                }
                for (int ja = 0; ja < rowtypeInfoA.length; ++ja) {
                    boolean microFound = false;
                    for (int jb = 0; jb < rowtypeInfoB.length; ++jb) {
                        if (!rowtypeInfoA[ja].equals(rowtypeInfoB[jb])) continue;
                        microFound = true;
                        break;
                    }
                    if (microFound) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                return (SqlType)p;
            }
        }
        boolean bl = predefined = (result = this.findPredefType(schema, type)) != null;
        if (!predefined) {
            result = this.findType(schema, type);
        }
        if (result != null) {
            if (result.getTypecode() != -72057) {
                return result;
            }
            if (!predefined) {
                if (modifier != null && modifier.equals("PL/SQL RECORD")) {
                    result.setTypecode(1992);
                } else if (modifier != null && modifier.equals("PL/SQL TABLE")) {
                    result.setTypecode(-14);
                } else if (modifier != null && modifier.equals("TABLE")) {
                    result.setTypecode(1991);
                } else if (modifier != null && modifier.equals("VARRAY")) {
                    result.setTypecode(1990);
                }
                return result;
            }
        }
        if (modifier != null && modifier.equals("PL/SQL RECORD")) {
            FieldInfo[] fieldInfo = PlsqlRecordType.getFieldInfo(packageName, methodName, methodNo, sequence, this);
            AttributeField[] fields = PlsqlRecordType.reflectFields(false, fieldInfo, this, parentType, true);
            if (predefined) {
                String hint = result.getHint();
                result = new PlsqlRecordType(result.getSqlName(), fieldInfo, fields, rowtypeInfoA, false, parentType, this);
                result.setHint(hint);
            } else {
                PlsqlRecordName sqlName = new PlsqlRecordName(schema, type, true, line, col, packageName, parentType, fields, this);
                sqlName.setAnnotation(this.genPattern((LangName)sqlName.getAnnotation(), sqlName.getSimpleName(), true));
                result = new PlsqlRecordType(sqlName, fieldInfo, fields, rowtypeInfoA, true, parentType, this);
            }
        } else {
            int oracleType = 1997;
            if (modifier != null && modifier.equals("PL/SQL TABLE")) {
                oracleType = -14;
            } else if (modifier != null && modifier.equals("TABLE") && type.indexOf(".") > -1) {
                oracleType = 1991;
            } else if (modifier != null && modifier.equals("VARRAY") && type.indexOf(".") > -1) {
                oracleType = 1990;
            }
            if (oracleType != 1997) {
                ElemInfo elemInfo = PlsqlTableType.getElemInfo(schema, type, packageName, methodName, methodNo, this.m_viewCache);
                int[] details = new int[3];
                SqlType elemType = (SqlType)PlsqlTableType.getComponentType(elemInfo, this, parentType, details);
                if (predefined) {
                    String hint = result.getHint();
                    result = PlsqlTableType.newInstance(result.getSqlName(), oracleType, elemInfo, elemType, details, false, parentType, isGrandparent, this);
                    result.setHint(hint);
                } else {
                    PlsqlTableName sqlName = new PlsqlTableName(schema, type, true, line, col, packageName, parentType, elemType, this);
                    sqlName.setAnnotation(this.genPattern((LangName)sqlName.getAnnotation(), sqlName.getSimpleName(), true));
                    result = PlsqlTableType.newInstance(sqlName, oracleType, elemInfo, elemType, details, true, parentType, isGrandparent, this);
                }
            }
        }
        if (result != null) {
            return result;
        }
        throw new PublisherException("unsupported Type " + schema + "." + type);
    }

    RowtypeInfo[] reflectRowtypeInfo(String packageName, String methodName, String methodNo, int sequence) throws SQLException {
        int i;
        Iterator iter = this.m_viewCache.getRows("ALL_ARGUMENTS", new String[0], new String[]{"PACKAGE_NAME", "OBJECT_NAME", "OVERLOAD"}, new Object[]{packageName, methodName, methodNo}, new String[0]);
        Vector<UserArguments> viewRows = new Vector<UserArguments>();
        while (iter.hasNext()) {
            UserArguments item = (UserArguments)iter.next();
            viewRows.addElement(item);
        }
        RowtypeInfo[] rowtypeInfoA = RowtypeInfo.getRowtypeInfo(viewRows);
        int data_level = 0;
        for (int i2 = 0; i2 < rowtypeInfoA.length; ++i2) {
            RowtypeInfo rti = rowtypeInfoA[i2];
            if (sequence != -1 && sequence != rti.sequence()) continue;
            data_level = rti.data_level();
            break;
        }
        int next_rec_sequence = -1;
        for (int i3 = 0; i3 < rowtypeInfoA.length; ++i3) {
            RowtypeInfo rti = rowtypeInfoA[i3];
            if (data_level != rti.data_level() || sequence != -1 && sequence >= rti.sequence()) continue;
            next_rec_sequence = rti.sequence();
            break;
        }
        ++data_level;
        Vector<RowtypeInfo> rowtypeInfoW = new Vector<RowtypeInfo>();
        for (i = 0; i < rowtypeInfoA.length; ++i) {
            RowtypeInfo rti = rowtypeInfoA[i];
            if (sequence != -1 && sequence >= rti.sequence() || data_level != rti.data_level() || next_rec_sequence != -1 && next_rec_sequence <= rti.sequence()) continue;
            rowtypeInfoW.addElement(rti);
        }
        rowtypeInfoA = new RowtypeInfo[rowtypeInfoW.size()];
        for (i = 0; i < rowtypeInfoW.size(); ++i) {
            rowtypeInfoA[i] = (RowtypeInfo)rowtypeInfoW.elementAt(i);
            rowtypeInfoA[i].data_level(rowtypeInfoA[i].data_level() - data_level + 1);
        }
        return rowtypeInfoA;
    }

    public SqlType addPredefType(String schema, String type, int typecode, String javaName, String convertInto, String convertOutOf, String conversionTarget) throws PublisherException {
        String annotation;
        SqlName sn = new SqlName(schema, type, false, false, true, convertInto, convertOutOf, conversionTarget, this);
        boolean isPlsqlIndexTable = false;
        int maxLen = Integer.valueOf("4000");
        int maxElemLen = -1;
        boolean isNumeric = true;
        int pos = javaName.indexOf("[");
        if (pos >= 0) {
            annotation = "/*" + javaName.substring(pos).trim() + "*/";
            isPlsqlIndexTable = true;
            int pos1 = pos;
            int pos2 = javaName.indexOf("]");
            if (pos2 > -1) {
                try {
                    maxLen = Integer.parseInt(javaName.substring(pos1 + 1, pos2));
                }
                catch (NumberFormatException e) {
                    System.err.println("ERROR: number format error: " + javaName);
                }
            }
            pos1 = javaName.indexOf("(");
            pos2 = javaName.indexOf(")");
            if (pos1 > -1 && pos2 > -1) {
                try {
                    maxElemLen = Integer.parseInt(javaName.substring(pos1 + 1, pos2));
                }
                catch (NumberFormatException e) {
                    System.err.println("ERROR: number format error: " + javaName);
                }
            }
            if ("String".equals(javaName = javaName.substring(0, pos)) || "java.lang.String".equals(javaName)) {
                isNumeric = false;
            }
            javaName = javaName + "[]";
            if (maxElemLen == -1) {
                maxElemLen = Integer.valueOf(Util.getDefaultTypeLen("VARCHAR2"));
            }
        } else {
            annotation = "";
        }
        sn.setLangName(null, javaName, null, null, null, null, null, null, true);
        SqlType st = null;
        if (isPlsqlIndexTable) {
            st = new PlsqlIndexTableType(sn, isNumeric, maxLen, maxElemLen);
            this.m_predefTypes.put(sn, st);
        } else {
            st = this.addPredefType(sn, typecode);
        }
        st.setHint(annotation);
        return st;
    }

    public SqlType addPredefType(SqlName name, int typecode) throws PublisherException {
        boolean isPrimitive = true;
        String declClassName = (name.getDeclPackage() != null && name.getDeclPackage().length() > 0 ? name.getDeclPackage() + "." : "") + name.getDeclClass();
        Class<?> declClass = null;
        try {
            declClass = Class.forName(declClassName);
        }
        catch (Throwable t) {
            try {
                declClass = Class.forName("java.lang." + declClassName);
            }
            catch (Throwable t2) {
                // empty catch block
            }
        }
        if (declClass == null) {
            isPrimitive = false;
        } else if (declClass != null) {
            try {
                Field f = declClass.getField("_SQL_TYPENAME");
                isPrimitive = false;
            }
            catch (Throwable t) {
                try {
                    Field f = declClass.getField("_SQL_NAME");
                    isPrimitive = false;
                }
                catch (Throwable t2) {
                    // empty catch block
                }
            }
        }
        if (declClassName.equals("boolean") || declClassName.equals("int") || declClassName.equals("short") || declClassName.equals("double") || declClassName.equals("float") || declClassName.equals("long") || declClassName.equals("byte") || declClassName.equals("char") || declClassName.endsWith("[]")) {
            isPrimitive = true;
        }
        if (typecode == 1997 || typecode == -72057) {
            if ("INTEGER".equals(name.getTargetTypeName())) {
                typecode = 4;
            }
            if ("CHAR".equals(name.getTargetTypeName())) {
                typecode = 1;
            }
        }
        SqlType st = null;
        if (!isPrimitive) {
            try {
                st = new SqlObjectType(name, typecode, false, null, this);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        } else {
            st = new SqlType(name, typecode, false, isPrimitive, null, this);
        }
        if (st == null) {
            throw new PublisherException("Cannot find Type " + name);
        }
        this.m_predefTypes.put(name, st);
        return st;
    }

    public void addType(Name name, TypeClass type, boolean generateMe) {
        this.m_allTypes.put(name, type);
        if (generateMe) {
            this.m_userTypes.addElement(type);
        }
    }

    public SqlType addDefaultArgsHolderType(SqlType valueType, String packageName, SqlType parentType, boolean ncharFormOfUse) throws SQLException, PublisherException {
        String typeName = "";
        typeName = valueType.getSqlName().getTypeName().indexOf(".") > -1 ? typeName + valueType.getSqlName().getSimpleName() : typeName + valueType.getSqlName().getTypeName();
        DefaultArgsHolderName sqlName = new DefaultArgsHolderName(null, typeName, true, 0, 0, packageName, parentType, valueType, this);
        SqlType result = this.findType(sqlName);
        if (result == null) {
            sqlName.setAnnotation(this.genPattern((LangName)sqlName.getAnnotation(), sqlName.getSimpleName(), true));
            result = new DefaultArgsHolderType(sqlName, valueType, ncharFormOfUse, this);
        }
        return result;
    }

    public Enumeration getPlsqlUserTypes() {
        int j;
        boolean inserted;
        Vector<SqlType> sortedPlsqlTypes = new Vector<SqlType>();
        for (int i = 0; i < this.m_userTypes.size(); ++i) {
            if (!(this.m_userTypes.elementAt(i) instanceof SqlType)) continue;
            SqlType t = (SqlType)this.m_userTypes.elementAt(i);
            String name = t.getName();
            if (!t.isPlsqlRecord() && !t.isPlsqlTable() && !(t instanceof DefaultArgsHolderType)) continue;
            inserted = false;
            for (j = 0; j < sortedPlsqlTypes.size(); ++j) {
                String name2 = ((SqlType)sortedPlsqlTypes.elementAt(j)).getName();
                if (name.compareTo(name2) >= 0) continue;
                sortedPlsqlTypes.insertElementAt(t, j);
                inserted = true;
                break;
            }
            if (inserted) continue;
            sortedPlsqlTypes.addElement(t);
        }
        Vector<SqlType> plsqlUserTypes = new Vector<SqlType>();
        for (int i = 0; i < sortedPlsqlTypes.size(); ++i) {
            SqlType t = (SqlType)sortedPlsqlTypes.elementAt(i);
            inserted = false;
            for (j = 0; j < plsqlUserTypes.size(); ++j) {
                if (!((SqlType)plsqlUserTypes.elementAt(j)).dependsOn(t)) continue;
                plsqlUserTypes.insertElementAt(t, j);
                inserted = true;
                break;
            }
            if (inserted) continue;
            plsqlUserTypes.addElement(t);
        }
        return plsqlUserTypes.elements();
    }

    public boolean isUserType(TypeClass t) {
        if (t instanceof SqlType) {
            for (int i = 0; i < this.m_userTypes.size(); ++i) {
                if (!this.m_userTypes.elementAt(i).equals(t)) continue;
                return true;
            }
        }
        return false;
    }

    private SqlType findType(SqlName sqlName) {
        return this._findType(this.m_allTypes, sqlName);
    }

    private SqlType findType(String schema, String type) {
        SqlName sqlName = new SqlName(Util.getSchema(schema, type), Util.getType(schema, type), false, this);
        return this._findType(this.m_allTypes, sqlName);
    }

    private SqlType findPredefType(SqlName sqlName) {
        return this._findType(this.m_predefTypes, sqlName);
    }

    private SqlType findPredefType(String schema, String type) {
        SqlName sqlName = new SqlName(schema, type, false, this);
        return this._findType(this.m_predefTypes, sqlName);
    }

    private SqlType _findType(Hashtable ht, SqlName sqlName) {
        return (SqlType)ht.get(sqlName);
    }

    public SqlType findType(String name) {
        String schema = Util.getSchema(null, name);
        SqlName sqlName = new SqlName(schema, name = Util.getType(null, name), false, this);
        SqlType sqlType = this.findType(sqlName);
        if (sqlType == null) {
            sqlType = this.findPredefType(sqlName);
        }
        return sqlType;
    }

    public void addAllTypes(String schema) throws SQLException, PublisherException {
        if (this.m_conn != null) {
            Iterator iter = this.m_viewCache.getRows("ALL_TYPES", new String[0], new String[]{"OWNER", "PREDEFINED"}, new Object[]{schema, "NO"}, new String[]{"TYPE_NAME"});
            while (iter.hasNext()) {
                AllTypes allTypes = (AllTypes)iter.next();
                this.addSqlDBType(schema, allTypes.typeName, null, "", false, null);
            }
        }
    }

    public void addAllPackages(String schema) throws SQLException, PublisherException {
        if (this.m_conn != null) {
            int count;
            PreparedStatement stmt = this.m_conn.prepareStatement("SELECT OBJECT_NAME AS TYPE_NAME FROM ALL_OBJECTS WHERE OWNER = :1 AND OBJECT_TYPE = 'PACKAGE' AND STATUS='VALID'");
            stmt.setString(1, schema);
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                SqlName sn = new SqlName(schema, rs.getString(1), true, this);
                sn.setAnnotation(this.genPattern((LangName)sn.getAnnotation(), sn.getSimpleName(), true));
                this.addSqlType(sn, 4, false, true, null, null);
            }
            rs.close();
            stmt.close();
            stmt = this.m_conn.prepareStatement("SELECT COUNT(OBJECT_NAME) AS ARG_COUNT FROM ALL_ARGUMENTS WHERE OWNER = :1 AND PACKAGE_NAME IS NULL AND DATA_LEVEL = 0");
            stmt.setString(1, schema);
            rs = stmt.executeQuery();
            if (rs.next() && (count = rs.getInt(1)) > 0) {
                SqlType t = this.addSqlUserType(schema, "", 12, true, 0, 0, null);
                String userName = SqlName.sqlIdToJavaId("TOPLEVEL", true);
                t.getSqlName().setLangName("", userName, null, null, null, null, null, null, true);
            }
            rs.close();
            stmt.close();
        }
    }

    public JavaType addJavaType(String typeName, AttributeField[] fields, ProcedureMethod[] methods, boolean genPattern, TypeClass sqlType) throws SQLException {
        if (typeName == null) {
            return null;
        }
        JavaType jt = null;
        for (int i = 0; i < this.m_userTypes.size(); ++i) {
            if (!(this.m_userTypes.elementAt(i) instanceof JavaType)) continue;
            JavaType jTypeTmp = (JavaType)this.m_userTypes.elementAt(i);
            JavaName jNameTmp = new JavaName(null, typeName, null, null, null);
            if (!jTypeTmp.getJavaName().equals(jNameTmp)) continue;
            jt = jTypeTmp;
        }
        if (jt != null) {
            return jt;
        }
        JavaName javaName = new JavaName(null, typeName, null, null, null);
        if (genPattern) {
            javaName = (JavaName)this.genPattern(javaName, typeName, false);
        }
        jt = new JavaBaseType(javaName, fields, methods, sqlType);
        this.m_userTypes.addElement(jt);
        return jt;
    }

    public boolean hasMethodsInSubclasses(TypeClass who) throws SQLException, PublisherException {
        Enumeration v = this.m_userTypes.elements();
        block0: while (v.hasMoreElements()) {
            Object t = v.nextElement();
            if (!(t instanceof SqlType)) continue;
            SqlType st = (SqlType)t;
            boolean stHasMethods = st.hasMethods();
            while ((st = (SqlType)st.getSupertype()) != null) {
                if (who.getName() == null || !who.getName().equals(st.getName())) continue;
                if (!stHasMethods) continue block0;
                return true;
            }
        }
        return false;
    }

    public void createSqlStmtType(SqlName sqlName) throws SQLException {
        if (this.m_sqlStmtType == null) {
            this.m_sqlStmtType = new SqlStmtType(sqlName, this);
        }
    }

    public boolean isPre920() {
        if (this.m_isPre920 == null) {
            try {
                String vp;
                String v = this.m_conn.getMetaData().getDatabaseProductVersion().toUpperCase();
                if (v.startsWith("ORACLE DATABASE 10G") || v.startsWith("ORACLE DATABASE 11G")) {
                    this.m_isPre920 = new Boolean(false);
                    return false;
                }
                int pos = v.indexOf("ORACLE");
                if (0 < pos) {
                    v = v.substring(pos);
                }
                if ((vp = v.substring(0, "ORACLExx".length()).toUpperCase()).equals("ORACLE12") || vp.equals("ORACLE11") || vp.equals("ORACLE10") || vp.equals("ORACLE9I") && (v.indexOf("9.2.") > 0 || v.indexOf("9.3.") > 0 || v.indexOf("9.4.") > 0)) {
                    this.m_isPre920 = new Boolean(false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.m_isPre920 == null) {
                this.m_isPre920 = new Boolean(true);
            }
        }
        return this.m_isPre920;
    }

    public boolean geqOracle9() {
        return this.m_geq9i;
    }

    public static boolean geqOracle9(Connection conn) {
        boolean geq9i = false;
        try {
            String dv = conn.getMetaData().getDatabaseProductVersion().toUpperCase();
            int pos = dv.indexOf("ORACLE");
            if (0 < pos) {
                dv = dv.substring(pos);
            }
            geq9i = dv.startsWith("ORACLE9") || dv.startsWith("ORACLE DATABASE 10G") || dv.startsWith("ORACLE DATABASE 11G") || dv.startsWith("ORACLE1") || dv.startsWith("ORACLE2") || dv.startsWith("ORACLE3");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return geq9i;
    }

    public void setTransitive(boolean transitive) {
        this.m_transitive = transitive;
    }

    public static boolean isNull(String col) {
        return col == null || col.length() == 0;
    }

    public boolean noUserTypes() {
        return this.m_userTypes.isEmpty();
    }

    public Hashtable getTypeMap() {
        return this.m_typeMap;
    }

    private LangName genPattern(LangName langName, String simpleName, boolean sql2Java) {
        String genPattern = null;
        if (genPattern == null) {
            return langName;
        }
        String useName = simpleName;
        if (sql2Java) {
            useName = SqlName.sqlIdToJavaId(simpleName, true);
        }
        String sql = genPattern;
        for (int i = genPattern.length() - 1; i >= 0; --i) {
            if (genPattern.charAt(i) != '%' || i == genPattern.length() - 1) continue;
            int j = genPattern.charAt(i + 1) - 48;
            sql = sql.substring(0, i) + (j == 1 ? simpleName : useName) + sql.substring(i + 2);
        }
        String useItf = null;
        String generatedName = null;
        String generatedItf = null;
        StringTokenizer st = new StringTokenizer(sql, "#");
        String[] tokens = new String[st.countTokens()];
        int i = 0;
        while (0 < st.countTokens()) {
            tokens[i] = st.nextToken();
            if (i == 1) {
                generatedItf = tokens[1];
                useItf = tokens[1];
            }
            ++i;
        }
        st = new StringTokenizer(tokens[0], ":");
        tokens = new String[st.countTokens()];
        i = 0;
        while (0 < st.countTokens()) {
            tokens[i] = st.nextToken();
            if (i == 0) {
                useName = tokens[0];
            } else if (i == 1) {
                useName = tokens[1];
                generatedName = tokens[0];
            }
            ++i;
        }
        if (useName == null) {
            useItf = null;
        }
        if (generatedName == null) {
            generatedItf = null;
        }
        if (useItf != null) {
            generatedItf = null;
        }
        JavaName retJavaName = new JavaName("", useName, useItf, generatedName, generatedItf);
        return retJavaName;
    }

    public String determineSqlName(String name, boolean toBeDistinguished) {
        String uniqueName;
        if (name.length() > 29) {
            name = name.substring(0, 29);
            toBeDistinguished = true;
        }
        if (this.m_allTypeNames.contains(uniqueName = name.toUpperCase()) || toBeDistinguished && this.m_allGeneratedTypeNames.contains(uniqueName)) {
            do {
                int len2;
                int len1;
                if ((len1 = name.length()) + (len2 = Integer.toString(this.m_allGeneratedTypeNamesMagicNumber++).length()) <= 29) continue;
                name = name.substring(0, 29 - len2);
            } while (this.m_allTypeNames.contains(uniqueName = name.toUpperCase() + this.m_allGeneratedTypeNamesMagicNumber) || toBeDistinguished && this.m_allGeneratedTypeNames.contains(uniqueName));
        }
        this.m_allGeneratedTypeNames.add(uniqueName);
        return uniqueName;
    }

    public ViewCache getViewCache() {
        return this.m_viewCache;
    }

    public void getViewCache(ViewCache vc) {
        this.m_viewCache = vc;
    }

    public void close() {
        try {
            if (this.m_conn != null) {
                this.m_conn.close();
            }
            if (this.m_viewCache != null) {
                this.m_viewCache.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Enumeration getUserTypes() {
        return this.m_userTypes.elements();
    }

    public WrapperPackageMetadata getWrapperPackageMetadata() {
        return this.m_wrapperPackageMetadata;
    }

    public void addWrapperMethodMetadata(String name, String[] paramTypes, String[] paramNames, String returnType) {
        if (this.m_wrapperPackageMetadata == null) {
            this.m_wrapperPackageMetadata = new WrapperPackageMetadata("");
        }
        this.m_wrapperPackageMetadata.addMethod(new WrapperMethodMetadata(name, paramTypes, paramNames, returnType));
    }
}

