/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import java.util.List;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.xr.Attachment;
import org.eclipse.persistence.internal.xr.CollectionResult;
import org.eclipse.persistence.internal.xr.NamedQueryHandler;
import org.eclipse.persistence.internal.xr.Parameter;
import org.eclipse.persistence.internal.xr.ProcedureArgument;
import org.eclipse.persistence.internal.xr.ProcedureOutputArgument;
import org.eclipse.persistence.internal.xr.QNameTransformer;
import org.eclipse.persistence.internal.xr.QueryHandler;
import org.eclipse.persistence.internal.xr.QueryOperation;
import org.eclipse.persistence.internal.xr.Result;
import org.eclipse.persistence.internal.xr.StoredFunctionQueryHandler;
import org.eclipse.persistence.internal.xr.StoredProcedureQueryHandler;
import org.eclipse.persistence.internal.xr.sxf.SimpleXMLFormat;
import org.eclipse.persistence.internal.xr.sxf.SimpleXMLFormatProject;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlTypeWithMethods;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.tools.dbws.DBWSBuilder;
import org.eclipse.persistence.tools.dbws.OperationModel;
import org.eclipse.persistence.tools.dbws.Util;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredArgument;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredFunction;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredProcedure;
import org.eclipse.persistence.tools.dbws.oracle.OracleHelper;
import org.eclipse.persistence.tools.dbws.oracle.PLSQLStoredArgument;

public class ProcedureOperationModel
extends OperationModel {
    protected String catalogPattern;
    protected String schemaPattern;
    protected String procedurePattern;
    protected int overload;
    protected SqlTypeWithMethods typ;

    public String getCatalogPattern() {
        return this.catalogPattern;
    }

    public void setCatalogPattern(String catalogPattern) {
        this.catalogPattern = "null".equalsIgnoreCase(catalogPattern) ? null : catalogPattern;
    }

    public String getSchemaPattern() {
        return this.schemaPattern;
    }

    public void setSchemaPattern(String schemaPattern) {
        this.schemaPattern = "null".equalsIgnoreCase(schemaPattern) ? null : schemaPattern;
    }

    public String getProcedurePattern() {
        return this.procedurePattern;
    }

    public void setProcedurePattern(String procedurePattern) {
        this.procedurePattern = procedurePattern;
    }

    public int getOverload() {
        return this.overload;
    }

    public void setOverload(int overload) {
        this.overload = overload;
    }

    @Override
    public boolean isProcedureOperation() {
        return true;
    }

    public boolean isPLSQLProcedureOperation() {
        return false;
    }

    public SqlTypeWithMethods getJPubType() {
        return this.typ;
    }

    public void setJPubType(SqlTypeWithMethods typ) {
        this.typ = typ;
    }

    @Override
    public void buildOperation(DBWSBuilder builder) {
        super.buildOperation(builder);
        boolean isOracle = builder.databasePlatform.getClass().getName().contains("Oracle");
        List<DbStoredProcedure> procs = builder.loadProcedures(this, isOracle);
        for (DbStoredProcedure storedProcedure : procs) {
            StringBuilder sb = new StringBuilder();
            if (this.name == null || this.name.length() == 0) {
                if (storedProcedure.getOverload() > 0) {
                    sb.append(storedProcedure.getOverload());
                    sb.append('_');
                }
                if (storedProcedure.getCatalog() != null && storedProcedure.getCatalog().length() > 0) {
                    sb.append(storedProcedure.getCatalog());
                    sb.append('_');
                }
                if (storedProcedure.getSchema() != null && storedProcedure.getSchema().length() > 0) {
                    sb.append(storedProcedure.getSchema());
                    sb.append('_');
                }
                sb.append(storedProcedure.getName());
            } else {
                sb.append(this.name);
            }
            QueryOperation qo = new QueryOperation();
            qo.setName(sb.toString());
            Object qh = storedProcedure.isFunction() ? new StoredFunctionQueryHandler() : new StoredProcedureQueryHandler();
            sb = new StringBuilder();
            if (isOracle) {
                if (storedProcedure.getSchema() != null && storedProcedure.getSchema().length() > 0) {
                    sb.append(storedProcedure.getSchema());
                    sb.append('.');
                }
                if (storedProcedure.getCatalog() != null && storedProcedure.getCatalog().length() > 0) {
                    sb.append(storedProcedure.getCatalog());
                    sb.append('.');
                }
            } else {
                if (storedProcedure.getCatalog() != null && storedProcedure.getCatalog().length() > 0) {
                    sb.append(storedProcedure.getCatalog());
                    sb.append('.');
                }
                if (storedProcedure.getSchema() != null && storedProcedure.getSchema().length() > 0) {
                    sb.append(storedProcedure.getSchema());
                    sb.append('.');
                }
            }
            sb.append(storedProcedure.getName());
            ((StoredProcedureQueryHandler)qh).setName(sb.toString());
            builder.logMessage(Level.FINEST, "Building QueryOperation for " + sb.toString());
            List queries = builder.getOrProject().getQueries();
            if (queries.size() > 0) {
                for (DatabaseQuery q : queries) {
                    if (!q.getName().equals(qo.getName())) continue;
                    qh = new NamedQueryHandler();
                    ((NamedQueryHandler)qh).setName(qo.getName());
                }
            }
            qo.setQueryHandler((QueryHandler)qh);
            SimpleXMLFormat sxf = null;
            if (this.isSimpleXMLFormat() || this.getReturnType() == null) {
                sxf = new SimpleXMLFormat();
            }
            if (this.simpleXMLFormatTag != null && this.simpleXMLFormatTag.length() > 0) {
                sxf.setSimpleXMLFormatTag(this.simpleXMLFormatTag);
            }
            if (this.xmlTag != null && this.xmlTag.length() > 0) {
                if (sxf == null) {
                    sxf = new SimpleXMLFormat();
                }
                sxf.setXMLTag(this.xmlTag);
            }
            Object result = null;
            if (!storedProcedure.isFunction() && isOracle && Util.noOutArguments(storedProcedure)) {
                result = new Result();
                result.setType(new QName("http://www.w3.org/2001/XMLSchema", "int", "xsd"));
            } else if (storedProcedure.isFunction()) {
                DbStoredFunction storedFunction = (DbStoredFunction)storedProcedure;
                DbStoredArgument rarg = storedFunction.getReturnArg();
                if (rarg.getJdbcTypeName().contains("CURSOR")) {
                    result = new CollectionResult();
                    result.setType(Util.SXF_QNAME_CURSOR);
                } else {
                    result = new Result();
                    int rargJdbcType = rarg.getJdbcType();
                    switch (rargJdbcType) {
                        case 1111: 
                        case 2002: 
                        case 2003: {
                            if (this.returnType != null) {
                                result.setType(this.buildCustomQName(this.returnType, builder));
                                break;
                            }
                            result.setType(XMLConstants.ANY_QNAME);
                            break;
                        }
                        default: {
                            if (isOracle) {
                                result.setType(OracleHelper.getXMLTypeFromJDBCType(rarg, builder.getTargetNamespace()));
                                break;
                            }
                            result.setType(Util.getXMLTypeFromJDBCType(rargJdbcType));
                        }
                    }
                }
            } else if (!isOracle) {
                if (this.returnType != null) {
                    result = new Result();
                    result.setType(this.buildCustomQName(this.returnType, builder));
                } else if (this.isCollection) {
                    result = new CollectionResult();
                    if (this.isSimpleXMLFormat()) {
                        result.setType(Util.SXF_QNAME_CURSOR);
                    }
                } else {
                    result = new Result();
                    result.setType(org.eclipse.persistence.internal.xr.Util.SXF_QNAME);
                }
            }
            if (this.binaryAttachment) {
                Attachment attachment = new Attachment();
                attachment.setMimeType("application/octet-stream");
                result.setAttachment(attachment);
            }
            for (DbStoredArgument arg : storedProcedure.getArguments()) {
                String argName = arg.getName();
                if (argName == null) continue;
                ProcedureOutputArgument pa = null;
                Parameter parm = null;
                Util.InOut direction = arg.getInOut();
                QName xmlType = null;
                switch (arg.getJdbcType()) {
                    case 1111: 
                    case 2002: 
                    case 2003: {
                        String typeString = builder.topTransformer.generateSchemaAlias(arg.getJdbcTypeName());
                        xmlType = this.buildCustomQName(typeString, builder);
                        break;
                    }
                    default: {
                        xmlType = isOracle ? OracleHelper.getXMLTypeFromJDBCType(arg, builder.getTargetNamespace()) : Util.getXMLTypeFromJDBCType(arg.getJdbcType());
                    }
                }
                if (direction == Util.InOut.IN) {
                    parm = new Parameter();
                    parm.setName(argName);
                    parm.setType(xmlType);
                    pa = new ProcedureArgument();
                    pa.setName(argName);
                    pa.setParameterName(argName);
                    if (qh instanceof StoredProcedureQueryHandler) {
                        ((StoredProcedureQueryHandler)qh).getInArguments().add(pa);
                    }
                } else {
                    ProcedureOutputArgument pao = pa = new ProcedureOutputArgument();
                    pao.setName(argName);
                    pao.setParameterName(argName);
                    if (arg.getJdbcTypeName().contains("CURSOR") && this.returnType == null) {
                        pao.setResultType(Util.SXF_QNAME_CURSOR);
                        if (result == null) {
                            result = new CollectionResult();
                            result.setType(Util.SXF_QNAME_CURSOR);
                        }
                    } else {
                        if (this.returnType != null && sxf == null) {
                            xmlType = Util.qNameFromString("{" + builder.getTargetNamespace() + "}" + this.returnType, builder.schema);
                        }
                        pao.setResultType(xmlType);
                        if (result == null) {
                            result = this.isCollection ? new CollectionResult() : new Result();
                            result.setType(xmlType);
                        }
                    }
                    if (direction == Util.InOut.INOUT) {
                        if (qh instanceof StoredProcedureQueryHandler) {
                            ((StoredProcedureQueryHandler)qh).getInOutArguments().add(pao);
                        }
                    } else if (qh instanceof StoredProcedureQueryHandler) {
                        ((StoredProcedureQueryHandler)qh).getOutArguments().add(pao);
                    }
                }
                if (arg instanceof PLSQLStoredArgument) {
                    pa.setComplexTypeName(((PLSQLStoredArgument)arg).getPlSqlTypeName());
                }
                if (parm == null) continue;
                qo.getParameters().add(parm);
            }
            if (sxf != null) {
                result.setSimpleXMLFormat(sxf);
                if (builder.oxProject.getDescriptorForAlias("simple-xml-format") == null) {
                    SimpleXMLFormatProject sxfProject = new SimpleXMLFormatProject();
                    builder.oxProject.addDescriptor(sxfProject.buildXRRowSetModelDescriptor());
                }
            }
            qo.setResult(result);
            builder.xrServiceModel.getOperations().put(qo.getName(), qo);
        }
        if (ProcedureOperationModel.requiresSimpleXMLFormat(builder.xrServiceModel) && builder.schema.getTopLevelElements().get("simple-xml-format") == null) {
            Util.addSimpleXMLFormat(builder.schema);
        }
    }

    protected QName buildCustomQName(String typeString, DBWSBuilder builder) {
        QName qName = null;
        String nsURI = null;
        String prefix = null;
        String localPart = null;
        int colonIdx = typeString.indexOf(58);
        if (colonIdx > 0) {
            prefix = typeString.substring(0, colonIdx);
            nsURI = builder.schema.getNamespaceResolver().resolveNamespacePrefix(prefix);
            if (nsURI == null) {
                nsURI = "";
            }
            localPart = typeString.substring(colonIdx + 1);
            if ("http://www.w3.org/2001/XMLSchema".equals(nsURI)) {
                qName = (QName)QNameTransformer.SCHEMA_QNAMES.get(localPart);
                if (qName == null) {
                    qName = new QName("http://www.w3.org/2001/XMLSchema", localPart, prefix == null ? "" : prefix);
                }
            } else {
                qName = new QName(nsURI == null ? "" : nsURI, localPart, prefix == null ? "" : prefix);
            }
        } else {
            qName = Util.qNameFromString("{" + builder.getTargetNamespace() + "}" + typeString, builder.schema);
        }
        return qName;
    }
}

