/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.SessionLoaderException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.jaxb.JaxbClassLoader;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.compiler.Generator;
import org.eclipse.persistence.jaxb.javamodel.JavaModel;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaModelImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaModelInputImpl;
import org.eclipse.persistence.jaxb.xmlmodel.JavaType;
import org.eclipse.persistence.jaxb.xmlmodel.XmlBindings;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.SessionEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBContextFactory {
    public static final String ECLIPSELINK_OXM_XML_KEY = "eclipselink-oxm-xml";
    private static final String METADATA_MODEL_PACKAGE = "org.eclipse.persistence.jaxb.xmlmodel";

    public static javax.xml.bind.JAXBContext createContext(Class[] classesToBeBound, Map properties) throws JAXBException {
        ClassLoader loader = null;
        if (classesToBeBound.length > 0 && null == (loader = classesToBeBound[0].getClassLoader())) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        return JAXBContextFactory.createContext(classesToBeBound, properties, loader);
    }

    public static javax.xml.bind.JAXBContext createContext(Class[] classesToBeBound, Map properties, ClassLoader classLoader) throws JAXBException {
        Map<String, XmlBindings> xmlBindings = JAXBContextFactory.getXmlBindingsFromProperties(properties, classLoader);
        if (xmlBindings == null) {
            xmlBindings = JAXBContextFactory.getXmlBindingsFromPackages(classesToBeBound, classLoader);
        }
        if (xmlBindings != null) {
            for (String key : xmlBindings.keySet()) {
                classesToBeBound = JAXBContextFactory.getXmlBindingsClasses(xmlBindings.get(key), classLoader, classesToBeBound);
            }
        }
        JaxbClassLoader loader = new JaxbClassLoader(classLoader);
        classesToBeBound = JAXBContextFactory.updateClassesWithObjectFactory(classesToBeBound, loader);
        try {
            Generator generator = new Generator(new JavaModelInputImpl(classesToBeBound, (JavaModel)new JavaModelImpl(loader)), xmlBindings, classLoader);
            return JAXBContextFactory.createContext(generator, properties, classLoader, loader, classesToBeBound);
        }
        catch (Exception ex) {
            throw new JAXBException(ex.getMessage(), (Throwable)ex);
        }
    }

    public static javax.xml.bind.JAXBContext createContext(String contextPath, ClassLoader classLoader) throws JAXBException {
        return JAXBContextFactory.createContext(contextPath, classLoader, null);
    }

    public static javax.xml.bind.JAXBContext createContext(String contextPath, ClassLoader classLoader, Map properties) throws JAXBException {
        Throwable sessionLoadingException = null;
        try {
            XMLContext xmlContext = new XMLContext(contextPath, classLoader);
            return new JAXBContext(xmlContext);
        }
        catch (ValidationException vex) {
            if (vex.getErrorCode() != 7095) {
                sessionLoadingException = vex;
            }
        }
        catch (SessionLoaderException ex) {
            sessionLoadingException = ex;
        }
        catch (Exception ex) {
            throw new JAXBException((Throwable)ex);
        }
        ArrayList<Class> classes = new ArrayList<Class>();
        boolean shouldSearchContextPath = false;
        Map<String, XmlBindings> xmlBindingMap = JAXBContextFactory.getXmlBindingsFromProperties(properties, classLoader);
        if (xmlBindingMap == null) {
            shouldSearchContextPath = true;
            xmlBindingMap = new HashMap<String, XmlBindings>();
        } else {
            classes = JAXBContextFactory.getXmlBindingsClassesFromMap(xmlBindingMap, classLoader, classes);
        }
        StringTokenizer tokenizer = new StringTokenizer(contextPath, ":");
        XmlBindings xmlBindings = null;
        while (tokenizer.hasMoreElements()) {
            InputStream iStream;
            String path = tokenizer.nextToken();
            try {
                Class<?> objectFactory = classLoader.loadClass(path + ".ObjectFactory");
                if (JAXBContextFactory.isJAXB2ObjectFactory(objectFactory)) {
                    classes.add(objectFactory);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                classLoader.loadClass(path + ".package-info");
            }
            catch (Exception ex) {
                // empty catch block
            }
            InputStream jaxbIndex = classLoader.getResourceAsStream(path.replace('.', '/') + "/jaxb.index");
            if (jaxbIndex != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(jaxbIndex));
                try {
                    String line = reader.readLine();
                    while (line != null) {
                        String className = path + "." + line.trim();
                        try {
                            classes.add(classLoader.loadClass(className));
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        line = reader.readLine();
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (!shouldSearchContextPath || (iStream = classLoader.getResourceAsStream(path.replace('.', '/') + "/eclipselink-oxm.xml")) == null) continue;
            xmlBindings = JAXBContextFactory.getXmlBindings(new StreamSource(iStream), classLoader);
            classes = JAXBContextFactory.getXmlBindingsClasses(xmlBindings, classLoader, classes);
            xmlBindingMap.put(path, xmlBindings);
        }
        if (classes.size() == 0) {
            org.eclipse.persistence.exceptions.JAXBException jaxbException = org.eclipse.persistence.exceptions.JAXBException.noObjectFactoryOrJaxbIndexInPath((String)contextPath);
            if (sessionLoadingException != null) {
                jaxbException.setInternalException(sessionLoadingException);
            }
            throw new JAXBException((Throwable)jaxbException);
        }
        Class[] classArray = new Class[classes.size()];
        for (int i = 0; i < classes.size(); ++i) {
            classArray[i] = classes.get(i);
        }
        return JAXBContextFactory.createContext(classArray, properties, classLoader, xmlBindingMap);
    }

    public static javax.xml.bind.JAXBContext createContext(Type[] typesToBeBound, Map properties, ClassLoader classLoader) throws JAXBException {
        Map<String, XmlBindings> xmlBindings = JAXBContextFactory.getXmlBindingsFromProperties(properties, classLoader);
        if (xmlBindings == null) {
            xmlBindings = JAXBContextFactory.getXmlBindingsFromPackages(typesToBeBound, classLoader);
        }
        if (xmlBindings != null) {
            for (String key : xmlBindings.keySet()) {
                typesToBeBound = JAXBContextFactory.getXmlBindingsClasses(xmlBindings.get(key), classLoader, typesToBeBound);
            }
        }
        JaxbClassLoader loader = new JaxbClassLoader(classLoader);
        JavaModelInputImpl inputImpl = new JavaModelInputImpl(typesToBeBound, (JavaModel)new JavaModelImpl(loader));
        typesToBeBound = JAXBContextFactory.updateTypesWithObjectFactory(typesToBeBound, loader);
        try {
            Generator generator = new Generator(inputImpl, inputImpl.getJavaClassToType(), xmlBindings, classLoader);
            return JAXBContextFactory.createContext(generator, properties, classLoader, loader, typesToBeBound);
        }
        catch (Exception ex) {
            throw new JAXBException(ex.getMessage(), (Throwable)ex);
        }
    }

    private static javax.xml.bind.JAXBContext createContext(Class[] classesToBeBound, Map properties, ClassLoader classLoader, Map<String, XmlBindings> xmlBindings) throws JAXBException {
        JaxbClassLoader loader = new JaxbClassLoader(classLoader);
        try {
            Generator generator = new Generator(new JavaModelInputImpl(classesToBeBound, (JavaModel)new JavaModelImpl(loader)), xmlBindings, loader);
            return JAXBContextFactory.createContext(generator, properties, classLoader, loader, classesToBeBound);
        }
        catch (Exception ex) {
            throw new JAXBException(ex.getMessage(), (Throwable)ex);
        }
    }

    private static javax.xml.bind.JAXBContext createContext(Generator generator, Map properties, ClassLoader classLoader, JaxbClassLoader loader, Type[] typesToBeBound) throws Exception {
        JAXBContext jaxbContext = null;
        XMLContext xmlContext = null;
        Project proj = generator.generateProject();
        ConversionManager conversionManager = null;
        if (classLoader != null) {
            conversionManager = new ConversionManager();
            conversionManager.setLoader((ClassLoader)loader);
        } else {
            conversionManager = ConversionManager.getDefaultManager();
        }
        proj.convertClassNamesToClasses(conversionManager.getLoader());
        for (ClassDescriptor descriptor : proj.getOrderedDescriptors()) {
            if (descriptor.getJavaClass() != null) continue;
            descriptor.setJavaClass(conversionManager.convertClassNameToClass(descriptor.getJavaClassName()));
        }
        org.eclipse.persistence.internal.jaxb.SessionEventListener eventListener = new org.eclipse.persistence.internal.jaxb.SessionEventListener();
        eventListener.setShouldValidateInstantiationPolicy(false);
        xmlContext = new XMLContext(proj, (ClassLoader)loader, (SessionEventListener)eventListener);
        jaxbContext = new JAXBContext(xmlContext, generator, typesToBeBound);
        return jaxbContext;
    }

    private static boolean isJAXB2ObjectFactory(Class objectFactoryClass) {
        try {
            Class xmlRegistry = PrivilegedAccessHelper.getClassForName((String)"javax.xml.bind.annotation.XmlRegistry");
            return objectFactoryClass.isAnnotationPresent(xmlRegistry);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static Map<String, XmlBindings> getXmlBindingsFromProperties(Map properties, ClassLoader classLoader) {
        if (properties != null) {
            HashMap<String, XmlBindings> bindings = new HashMap<String, XmlBindings>();
            Map metadataFiles = null;
            try {
                metadataFiles = (Map)properties.get(ECLIPSELINK_OXM_XML_KEY);
            }
            catch (ClassCastException x) {
                // empty catch block
            }
            if (metadataFiles != null) {
                for (String key : metadataFiles.keySet()) {
                    Source metadataSource = (Source)metadataFiles.get(key);
                    XmlBindings binding = JAXBContextFactory.getXmlBindings(metadataSource, classLoader);
                    if (binding == null) continue;
                    bindings.put(key, binding);
                }
            }
            if (bindings.size() > 0) {
                return bindings;
            }
        }
        return null;
    }

    private static Map<String, XmlBindings> getXmlBindingsFromPackages(Class[] classes, ClassLoader classLoader) {
        if (classes != null) {
            HashMap<String, XmlBindings> bindings = new HashMap<String, XmlBindings>();
            for (Class cls : classes) {
                String packageName = "";
                if (cls.getPackage() != null) {
                    packageName = cls.getPackage().getName();
                } else {
                    String className = cls.getName();
                    int idx = className.lastIndexOf(46);
                    if (idx > 0) {
                        packageName = className.substring(0, idx);
                    }
                }
                if (bindings.containsKey(packageName)) continue;
                try {
                    StreamSource metadataSource;
                    XmlBindings binding;
                    InputStream iStream = classLoader.getResourceAsStream(packageName.replace('.', '/') + "/eclipselink-oxm.xml");
                    if (iStream == null || (binding = JAXBContextFactory.getXmlBindings(metadataSource = new StreamSource(iStream), classLoader)) == null) continue;
                    bindings.put(packageName, binding);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (bindings.size() > 0) {
                return bindings;
            }
        }
        return null;
    }

    private static Map<String, XmlBindings> getXmlBindingsFromPackages(Type[] types, ClassLoader classLoader) {
        if (types != null) {
            HashMap<String, XmlBindings> bindings = new HashMap<String, XmlBindings>();
            for (Type type : types) {
                String packageName = "";
                if (type.getClass().getPackage() != null) {
                    packageName = type.getClass().getPackage().getName();
                } else {
                    String className = type.getClass().getName();
                    int idx = className.lastIndexOf(46);
                    if (idx > 0) {
                        packageName = className.substring(0, idx);
                    }
                }
                if (bindings.containsKey(packageName)) continue;
                try {
                    StreamSource metadataSource;
                    XmlBindings binding;
                    InputStream iStream = classLoader.getResourceAsStream(packageName.replace('.', '/') + "/eclipselink-oxm.xml");
                    if (iStream == null || (binding = JAXBContextFactory.getXmlBindings(metadataSource = new StreamSource(iStream), classLoader)) == null) continue;
                    bindings.put(packageName, binding);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (bindings.size() > 0) {
                return bindings;
            }
        }
        return null;
    }

    private static XmlBindings getXmlBindings(Source metadataSource, ClassLoader classLoader) {
        XmlBindings xmlBindings = null;
        if (metadataSource != null) {
            try {
                JAXBContext jaxbContext = (JAXBContext)JAXBContextFactory.createContext(METADATA_MODEL_PACKAGE, classLoader);
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                xmlBindings = (XmlBindings)unmarshaller.unmarshal(metadataSource);
            }
            catch (JAXBException jaxbEx) {
                // empty catch block
            }
        }
        return xmlBindings;
    }

    private static Type[] getXmlBindingsClasses(XmlBindings xmlBindings, ClassLoader classLoader, Type[] existingTypes) {
        Type[] additionalTypes = existingTypes;
        ArrayList<Class> javaTypeClasses = new ArrayList<Class>();
        for (JavaType javaType : xmlBindings.getJavaTypes().getJavaType()) {
            try {
                javaTypeClasses.add(classLoader.loadClass(javaType.getName()));
            }
            catch (ClassNotFoundException e) {}
        }
        if (javaTypeClasses.size() > 0) {
            for (Type type : existingTypes) {
                Class cls;
                if (!(type instanceof Class) || javaTypeClasses.contains(cls = (Class)type)) continue;
                javaTypeClasses.add(cls);
            }
            additionalTypes = javaTypeClasses.toArray(new Type[javaTypeClasses.size()]);
        }
        return additionalTypes;
    }

    private static Class[] getXmlBindingsClasses(XmlBindings xmlBindings, ClassLoader classLoader, Class[] existingClasses) {
        Class[] additionalClasses = existingClasses;
        ArrayList<Class> javaTypeClasses = new ArrayList<Class>();
        for (JavaType javaType : xmlBindings.getJavaTypes().getJavaType()) {
            try {
                javaTypeClasses.add(classLoader.loadClass(javaType.getName()));
            }
            catch (ClassNotFoundException e) {}
        }
        if (javaTypeClasses.size() > 0) {
            for (Class cls : existingClasses) {
                if (javaTypeClasses.contains(cls)) continue;
                javaTypeClasses.add(cls);
            }
            additionalClasses = javaTypeClasses.toArray(new Class[javaTypeClasses.size()]);
        }
        return additionalClasses;
    }

    private static ArrayList<Class> getXmlBindingsClasses(XmlBindings xmlBindings, ClassLoader classLoader, ArrayList<Class> existingClasses) {
        ArrayList<Class> additionalClasses = existingClasses;
        for (JavaType javaType : xmlBindings.getJavaTypes().getJavaType()) {
            try {
                Class<?> jClass = classLoader.loadClass(javaType.getName());
                if (additionalClasses.contains(jClass)) continue;
                additionalClasses.add(jClass);
            }
            catch (ClassNotFoundException e) {}
        }
        return additionalClasses;
    }

    private static ArrayList<Class> getXmlBindingsClassesFromMap(Map<String, XmlBindings> xmlBindingMap, ClassLoader classLoader, ArrayList<Class> existingClasses) {
        ArrayList<Class> additionalClasses = existingClasses;
        for (String packageName : xmlBindingMap.keySet()) {
            additionalClasses = JAXBContextFactory.getXmlBindingsClasses(xmlBindingMap.get(packageName), classLoader, additionalClasses);
        }
        return additionalClasses;
    }

    private static Class[] updateClassesWithObjectFactory(Class[] classes, ClassLoader loader) {
        ArrayList updatedClasses = new ArrayList();
        for (Class next : classes) {
            if (!updatedClasses.contains(next)) {
                updatedClasses.add(next);
            }
            if (next.getPackage() == null) continue;
            String packageName = next.getPackage().getName();
            try {
                Class<?> objectFactoryClass = loader.loadClass(packageName + ".ObjectFactory");
                if (updatedClasses.contains(objectFactoryClass)) continue;
                updatedClasses.add(objectFactoryClass);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return updatedClasses.toArray(new Class[updatedClasses.size()]);
    }

    private static Type[] updateTypesWithObjectFactory(Type[] types, ClassLoader loader) {
        ArrayList<Type> updatedTypes = new ArrayList<Type>();
        for (Type next : types) {
            if (!updatedTypes.contains(next)) {
                updatedTypes.add(next);
            }
            if (!(next instanceof Class) || ((Class)next).getPackage() == null) continue;
            String packageName = ((Class)next).getPackage().getName();
            try {
                Class<?> objectFactoryClass = loader.loadClass(packageName + ".ObjectFactory");
                if (updatedTypes.contains(objectFactoryClass)) continue;
                updatedTypes.add(objectFactoryClass);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return updatedTypes.toArray(new Type[updatedTypes.size()]);
    }
}

