/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.util.Map;
import javax.xml.bind.JAXBElement;
import org.eclipse.persistence.jaxb.compiler.AnnotationsProcessor;
import org.eclipse.persistence.jaxb.compiler.NamespaceInfo;
import org.eclipse.persistence.jaxb.compiler.Property;
import org.eclipse.persistence.jaxb.compiler.TypeInfo;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaModelInput;
import org.eclipse.persistence.jaxb.xmlmodel.JavaAttribute;
import org.eclipse.persistence.jaxb.xmlmodel.JavaType;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAnyAttribute;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAnyElement;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAttribute;
import org.eclipse.persistence.jaxb.xmlmodel.XmlBindings;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElement;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElementRef;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElementRefs;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElements;
import org.eclipse.persistence.jaxb.xmlmodel.XmlNsForm;
import org.eclipse.persistence.jaxb.xmlmodel.XmlSchema;
import org.eclipse.persistence.jaxb.xmlmodel.XmlTransient;
import org.eclipse.persistence.jaxb.xmlmodel.XmlValue;
import org.eclipse.persistence.oxm.NamespaceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLProcessor {
    private Map<String, XmlBindings> xmlBindingMap;

    public XMLProcessor(Map<String, XmlBindings> bindings) {
        this.xmlBindingMap = bindings;
    }

    public void processXML(AnnotationsProcessor annotationsProcessor, JavaModelInput jModelInput) {
        for (String packageName : this.xmlBindingMap.keySet()) {
            XmlBindings xmlBindings = this.xmlBindingMap.get(packageName);
            NamespaceInfo nsInfo = this.processXmlSchema(xmlBindings, packageName);
            if (nsInfo != null) {
                annotationsProcessor.addPackageToNamespaceMapping(packageName, nsInfo);
            }
            int idx = 0;
            JavaClass[] javaClasses = new JavaClass[xmlBindings.getJavaTypes().getJavaType().size()];
            for (JavaType javaType : xmlBindings.getJavaTypes().getJavaType()) {
                javaClasses[idx++] = jModelInput.getJavaModel().getClass(javaType.getName());
            }
            annotationsProcessor.init();
            Map<String, TypeInfo> typeInfoMap = annotationsProcessor.preBuildTypeInfo(javaClasses);
            for (JavaType javaType : xmlBindings.getJavaTypes().getJavaType()) {
                TypeInfo info = typeInfoMap.get(javaType.getName());
                nsInfo = annotationsProcessor.getPackageToNamespaceMappings().get(packageName);
                if (javaType.isSetXmlAccessorOrder()) {
                    info.setXmlAccessOrder(javaType.getXmlAccessorOrder());
                } else if (!info.isSetXmlAccessOrder()) {
                    if (xmlBindings.isSetXmlAccessorOrder()) {
                        info.setXmlAccessOrder(xmlBindings.getXmlAccessorOrder());
                    } else {
                        info.setXmlAccessOrder(nsInfo.getAccessOrder());
                    }
                }
                if (javaType.isSetXmlAccessorType()) {
                    info.setXmlAccessType(javaType.getXmlAccessorType());
                } else if (!info.isSetXmlAccessType()) {
                    if (xmlBindings.isSetXmlAccessorType()) {
                        info.setXmlAccessType(xmlBindings.getXmlAccessorType());
                    } else {
                        info.setXmlAccessType(nsInfo.getAccessType());
                    }
                }
                if (javaType.isSetXmlTransient()) {
                    info.setXmlTransient(javaType.isXmlTransient());
                }
                if (javaType.getXmlRootElement() != null) {
                    info.setXmlRootElement(javaType.getXmlRootElement());
                }
                if (javaType.getXmlSeeAlso() != null && javaType.getXmlSeeAlso().size() > 0) {
                    info.setXmlSeeAlso(javaType.getXmlSeeAlso());
                }
                if (javaType.getXmlType() == null) continue;
                info.setXmlType(javaType.getXmlType());
            }
            javaClasses = annotationsProcessor.postBuildTypeInfo(javaClasses);
            annotationsProcessor.processJavaClasses(javaClasses);
            Map<String, TypeInfo> typeInfosForPackage = annotationsProcessor.getTypeInfosForPackage(packageName);
            for (JavaType javaType : xmlBindings.getJavaTypes().getJavaType()) {
                TypeInfo typeInfo = typeInfosForPackage.get(javaType.getName());
                if (javaType == null) continue;
                this.processJavaType(javaType, typeInfo);
            }
        }
    }

    private void processJavaType(JavaType javaType, TypeInfo typeInfo) {
        if (null != javaType.getJavaAttributes()) {
            for (JAXBElement<? extends JavaAttribute> jaxbElement : javaType.getJavaAttributes().getJavaAttribute()) {
                JavaAttribute javaAttribute = (JavaAttribute)jaxbElement.getValue();
                Property oldProperty = typeInfo.getProperties().get(javaAttribute.getJavaAttribute());
                Property newProperty = this.processJavaAttribute(javaAttribute, oldProperty);
                typeInfo.getProperties().put(javaAttribute.getJavaAttribute(), newProperty);
            }
        }
    }

    private Property processJavaAttribute(JavaAttribute javaAttribute, Property oldProperty) {
        if (javaAttribute instanceof XmlAnyAttribute) {
            return this.processXmlAnyAttribute((XmlAnyAttribute)javaAttribute, oldProperty);
        }
        if (javaAttribute instanceof XmlAnyElement) {
            return this.processXmlAnyElement((XmlAnyElement)javaAttribute, oldProperty);
        }
        if (javaAttribute instanceof XmlAttribute) {
            return this.processXmlAttribute((XmlAttribute)javaAttribute, oldProperty);
        }
        if (javaAttribute instanceof XmlElement) {
            return this.processXmlElement((XmlElement)javaAttribute, oldProperty);
        }
        if (javaAttribute instanceof XmlElements) {
            return this.processXmlElements((XmlElements)javaAttribute, oldProperty);
        }
        if (javaAttribute instanceof XmlElementRef) {
            return this.processXmlElementRef((XmlElementRef)javaAttribute, oldProperty);
        }
        if (javaAttribute instanceof XmlElementRefs) {
            return this.processXmlElementRefs((XmlElementRefs)javaAttribute, oldProperty);
        }
        if (javaAttribute instanceof XmlTransient) {
            return this.processXmlTransient((XmlTransient)javaAttribute, oldProperty);
        }
        if (javaAttribute instanceof XmlValue) {
            return this.processXmlValue((XmlValue)javaAttribute, oldProperty);
        }
        return null;
    }

    private Property processXmlAnyAttribute(XmlAnyAttribute xmlAnyAttribute, Property oldProperty) {
        return oldProperty;
    }

    private Property processXmlAnyElement(XmlAnyElement xmlAnyElement, Property oldProperty) {
        return oldProperty;
    }

    private Property processXmlAttribute(XmlAttribute xmlAttribute, Property oldProperty) {
        return oldProperty;
    }

    private Property processXmlElement(XmlElement xmlElement, Property oldProperty) {
        return oldProperty;
    }

    private Property processXmlElements(XmlElements xmlElements, Property oldProperty) {
        return oldProperty;
    }

    private Property processXmlElementRef(XmlElementRef xmlElementRef, Property oldProperty) {
        return oldProperty;
    }

    private Property processXmlElementRefs(XmlElementRefs xmlElementRefs, Property oldProperty) {
        return oldProperty;
    }

    private Property processXmlTransient(XmlTransient xmlTransient, Property oldProperty) {
        oldProperty.setTransient(true);
        return oldProperty;
    }

    private Property processXmlValue(XmlValue xmlValue, Property oldProperty) {
        return oldProperty;
    }

    private NamespaceInfo processXmlSchema(XmlBindings xmlBindings, String packageName) {
        XmlSchema schema = xmlBindings.getXmlSchema();
        if (schema == null) {
            return null;
        }
        NamespaceInfo nsInfo = new NamespaceInfo();
        XmlNsForm form = schema.getAttributeFormDefault();
        nsInfo.setAttributeFormQualified(form.equals((Object)XmlNsForm.QUALIFIED));
        form = schema.getElementFormDefault();
        nsInfo.setElementFormQualified(form.equals((Object)XmlNsForm.QUALIFIED));
        nsInfo.setLocation(schema.getLocation() == null ? "##generate" : schema.getLocation());
        nsInfo.setNamespace(schema.getNamespace() == null ? "" : schema.getNamespace());
        NamespaceResolver nsr = new NamespaceResolver();
        for (XmlSchema.XmlNs xmlns : schema.getXmlNs()) {
            nsr.put(xmlns.getPrefix(), xmlns.getNamespaceUri());
        }
        nsInfo.setNamespaceResolver(nsr);
        return nsInfo;
    }
}

