/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.string;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.eclipse.persistence.tools.workbench.utility.string.StringMatcher;

public class RegExStringMatcherAdapter
implements StringMatcher,
Serializable {
    private Pattern pattern;
    private static final long serialVersionUID = 1L;

    public RegExStringMatcherAdapter(String regularExpression) {
        this(regularExpression, 0);
    }

    public RegExStringMatcherAdapter(String regularExpression, int flags) {
        this.setPatternString(regularExpression, flags);
    }

    public RegExStringMatcherAdapter(Pattern pattern) {
        this.setPattern(pattern);
    }

    public void setPatternString(String patternString) {
        this.setPatternString(patternString, 0);
    }

    public synchronized boolean matches(String string) {
        return this.pattern.matcher(string).matches();
    }

    public synchronized Pattern getPattern() {
        return this.pattern;
    }

    public synchronized void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public void setPatternString(String patternString, int flags) {
        this.setPattern(this.buildPattern(patternString, flags));
    }

    protected Pattern buildPattern(String regularExpression, int flags) {
        return Pattern.compile(regularExpression, flags);
    }
}

