/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.oxm.XMLRoot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBElementAttributeAccessor
extends AttributeAccessor {
    private AttributeAccessor nestedAccessor;
    private ContainerPolicy containerPolicy;
    private boolean isContainer;
    private Map<QName, Class> qNamesToScopes;
    private Class declaredType;

    public JAXBElementAttributeAccessor(AttributeAccessor nestedAccessor) {
        this.nestedAccessor = nestedAccessor;
        this.isContainer = false;
        this.qNamesToScopes = new HashMap<QName, Class>();
    }

    public JAXBElementAttributeAccessor(AttributeAccessor nestedAccessor, ContainerPolicy containerPolicy) {
        this.nestedAccessor = nestedAccessor;
        this.containerPolicy = containerPolicy;
        this.isContainer = true;
        this.qNamesToScopes = new HashMap<QName, Class>();
    }

    @Override
    public Object getAttributeValueFromObject(Object object) {
        Object value = this.nestedAccessor.getAttributeValueFromObject(object);
        if (this.isContainer) {
            Object results = this.containerPolicy.containerInstance(this.containerPolicy.sizeFor(value));
            Object iterator = this.containerPolicy.iteratorFor(value);
            while (this.containerPolicy.hasNext(iterator)) {
                Object next = this.containerPolicy.next(iterator, null);
                if (next instanceof JAXBElement) {
                    JAXBElement element = (JAXBElement)next;
                    XMLRoot root = new XMLRoot();
                    root.setLocalName(element.getName().getLocalPart());
                    root.setNamespaceURI(element.getName().getNamespaceURI());
                    root.setObject(element.getValue());
                    this.containerPolicy.addInto((Object)root, results, null);
                    continue;
                }
                this.containerPolicy.addInto(next, results, null);
            }
            value = results;
        } else if (value instanceof JAXBElement) {
            JAXBElement element = (JAXBElement)value;
            XMLRoot root = new XMLRoot();
            root.setLocalName(element.getName().getLocalPart());
            root.setNamespaceURI(element.getName().getNamespaceURI());
            root.setObject(element.getValue());
            value = root;
        }
        return value;
    }

    @Override
    public void setAttributeValueInObject(Object object, Object value) {
        Object attributeValue = value;
        if (this.isContainer) {
            Object results = this.containerPolicy.containerInstance(this.containerPolicy.sizeFor(attributeValue));
            Object iterator = this.containerPolicy.iteratorFor(attributeValue);
            while (this.containerPolicy.hasNext(iterator)) {
                Object next = this.containerPolicy.next(iterator, null);
                Object objectToAdd = this.unwrapObject(next);
                this.containerPolicy.addInto(objectToAdd, results, null);
            }
            attributeValue = results;
        } else {
            attributeValue = this.unwrapObject(attributeValue);
        }
        this.nestedAccessor.setAttributeValueInObject(object, attributeValue);
    }

    @Override
    public void initializeAttributes(Class theJavaClass) throws DescriptorException {
        this.nestedAccessor.initializeAttributes(theJavaClass);
    }

    private Object unwrapObject(Object originalObject) {
        if (originalObject instanceof XMLRoot) {
            XMLRoot root = (XMLRoot)originalObject;
            QName name = new QName(root.getNamespaceURI(), root.getLocalName());
            Object value = root.getObject();
            if (value == null) {
                return this.createJAXBElement(name, Object.class, value);
            }
            return this.createJAXBElement(name, this.getDeclaredType(), value);
        }
        return originalObject;
    }

    private JAXBElement createJAXBElement(QName qname, Class theClass, Object value) {
        if (value != null && value instanceof JAXBElement) {
            return (JAXBElement)value;
        }
        if (ClassConstants.XML_GREGORIAN_CALENDAR.isAssignableFrom(theClass)) {
            theClass = ClassConstants.XML_GREGORIAN_CALENDAR;
        } else if (ClassConstants.DURATION.isAssignableFrom(theClass)) {
            theClass = ClassConstants.DURATION;
        }
        Class<JAXBElement.GlobalScope> scopeClass = this.qNamesToScopes.get(qname);
        if (scopeClass == XmlElementDecl.GLOBAL.class) {
            scopeClass = JAXBElement.GlobalScope.class;
        }
        return new JAXBElement(qname, theClass, scopeClass, value);
    }

    public Map<QName, Class> getQNamesToScopes() {
        return this.qNamesToScopes;
    }

    public void setQNamesToScopes(Map<QName, Class> namesToScopes) {
        this.qNamesToScopes = namesToScopes;
    }

    public void setDeclaredType(Class declaredType) {
        this.declaredType = declaredType;
    }

    public Class getDeclaredType() {
        return this.declaredType;
    }
}

