/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.FetchType;
import javax.persistence.MapKey;
import javax.persistence.MapKeyClass;
import javax.persistence.MapKeyColumn;
import javax.persistence.MapKeyEnumerated;
import javax.persistence.MapKeyJoinColumn;
import javax.persistence.MapKeyJoinColumns;
import javax.persistence.MapKeyTemporal;
import javax.persistence.OrderBy;
import javax.persistence.OrderColumn;
import org.eclipse.persistence.annotations.MapKeyConvert;
import org.eclipse.persistence.annotations.OrderCorrection;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappedKeyMapAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.RelationshipAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.columns.AssociationOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.AttributeOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.OrderColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.EnumeratedMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.TemporalMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.JoinTableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.EmbeddableMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionAccessor
extends RelationshipAccessor
implements MappedKeyMapAccessor {
    private static final String ASCENDING = "ASC";
    private static final String DESCENDING = "DESC";
    private ColumnMetadata m_mapKeyColumn;
    private EnumeratedMetadata m_mapKeyEnumerated;
    private List<AssociationOverrideMetadata> m_mapKeyAssociationOverrides;
    private List<AttributeOverrideMetadata> m_mapKeyAttributeOverrides;
    private List<JoinColumnMetadata> m_mapKeyJoinColumns;
    private MetadataClass m_mapKeyClass;
    private OrderColumnMetadata m_orderColumn;
    private String m_mapKey;
    private String m_mapKeyConvert;
    private String m_mapKeyClassName;
    private String m_mappedBy;
    private String m_orderBy;
    private TemporalMetadata m_mapKeyTemporal;

    protected CollectionAccessor(String xmlElement) {
        super(xmlElement);
    }

    protected CollectionAccessor(MetadataAnnotation annotation, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(annotation, accessibleObject, classAccessor);
        String string = this.m_mappedBy = annotation == null ? "" : (String)annotation.getAttribute("mappedBy");
        if (this.isAnnotationPresent(OrderBy.class)) {
            this.m_orderBy = (String)this.getAnnotation(OrderBy.class).getAttribute("value");
            if (this.m_orderBy == null) {
                this.m_orderBy = "";
            }
        }
        if (this.isAnnotationPresent(MapKey.class)) {
            this.m_mapKey = (String)this.getAnnotation(MapKey.class).getAttributeString("name");
        }
        if (this.isAnnotationPresent(MapKeyClass.class)) {
            this.m_mapKeyClass = this.getMetadataClass((String)this.getAnnotation(MapKeyClass.class).getAttribute("value"));
        }
        if (this.isAnnotationPresent(MapKeyColumn.class)) {
            this.m_mapKeyColumn = new ColumnMetadata(this.getAnnotation(MapKeyColumn.class), accessibleObject, this.getAttributeName());
        }
        this.m_mapKeyJoinColumns = new ArrayList<JoinColumnMetadata>();
        if (this.isAnnotationPresent(MapKeyJoinColumns.class)) {
            for (Object jColumn : (Object[])this.getAnnotation(MapKeyJoinColumns.class).getAttributeArray("value")) {
                this.m_mapKeyJoinColumns.add(new JoinColumnMetadata((MetadataAnnotation)jColumn, accessibleObject));
            }
        }
        if (this.isAnnotationPresent(MapKeyJoinColumn.class)) {
            this.m_mapKeyJoinColumns.add(new JoinColumnMetadata(this.getAnnotation(MapKeyJoinColumn.class), accessibleObject));
        }
        this.m_mapKeyAttributeOverrides = new ArrayList<AttributeOverrideMetadata>();
        if (this.isAnnotationPresent(AttributeOverrides.class)) {
            for (Object attributeOverride : (Object[])this.getAnnotation(AttributeOverrides.class).getAttributeArray("value")) {
                this.m_mapKeyAttributeOverrides.add(new AttributeOverrideMetadata((MetadataAnnotation)attributeOverride, accessibleObject));
            }
        }
        if (this.isAnnotationPresent(AttributeOverride.class)) {
            this.m_mapKeyAttributeOverrides.add(new AttributeOverrideMetadata(this.getAnnotation(AttributeOverride.class), accessibleObject));
        }
        this.m_mapKeyAssociationOverrides = new ArrayList<AssociationOverrideMetadata>();
        if (this.isAnnotationPresent(AssociationOverrides.class)) {
            for (Object associationOverride : (Object[])this.getAnnotation(AssociationOverrides.class).getAttributeArray("value")) {
                this.m_mapKeyAssociationOverrides.add(new AssociationOverrideMetadata((MetadataAnnotation)associationOverride, accessibleObject));
            }
        }
        if (this.isAnnotationPresent(AssociationOverride.class)) {
            this.m_mapKeyAssociationOverrides.add(new AssociationOverrideMetadata(this.getAnnotation(AssociationOverride.class), accessibleObject));
        }
        if (this.isAnnotationPresent(OrderColumn.class)) {
            String correctionType = null;
            if (this.isAnnotationPresent(OrderCorrection.class)) {
                correctionType = this.getAnnotation(OrderCorrection.class).getAttribute("value").toString();
            }
            this.m_orderColumn = new OrderColumnMetadata(this.getAnnotation(OrderColumn.class), accessibleObject, correctionType);
        }
        if (this.isAnnotationPresent(MapKeyEnumerated.class)) {
            this.m_mapKeyEnumerated = new EnumeratedMetadata(this.getAnnotation(MapKeyEnumerated.class), accessibleObject);
        }
        if (this.isAnnotationPresent(MapKeyTemporal.class)) {
            this.m_mapKeyTemporal = new TemporalMetadata(this.getAnnotation(MapKeyTemporal.class), accessibleObject);
        }
        if (this.isAnnotationPresent(MapKeyConvert.class)) {
            this.m_mapKeyConvert = (String)this.getAnnotation(MapKeyConvert.class).getAttribute("value");
        }
    }

    @Override
    protected ColumnMetadata getColumn(String loggingCtx) {
        if (loggingCtx.equals("metadata_default_key_column")) {
            if (this.m_mapKeyColumn == null) {
                return new ColumnMetadata(this.getAnnotation(MapKeyColumn.class), this.getAccessibleObject(), this.getAttributeName());
            }
            return this.m_mapKeyColumn;
        }
        return super.getColumn(loggingCtx);
    }

    @Override
    public String getDefaultFetchType() {
        return FetchType.LAZY.name();
    }

    @Override
    public EnumeratedMetadata getEnumerated(boolean isForMapKey) {
        return this.getMapKeyEnumerated();
    }

    @Override
    public String getMapKey() {
        return this.m_mapKey;
    }

    @Override
    public List<AssociationOverrideMetadata> getMapKeyAssociationOverrides() {
        return this.m_mapKeyAssociationOverrides;
    }

    @Override
    public List<AttributeOverrideMetadata> getMapKeyAttributeOverrides() {
        return this.m_mapKeyAttributeOverrides;
    }

    @Override
    public MetadataClass getMapKeyClass() {
        return this.m_mapKeyClass;
    }

    public String getMapKeyClassName() {
        return this.m_mapKeyClassName;
    }

    @Override
    public ColumnMetadata getMapKeyColumn() {
        return this.m_mapKeyColumn;
    }

    @Override
    public String getMapKeyConvert() {
        return this.m_mapKeyConvert;
    }

    public EnumeratedMetadata getMapKeyEnumerated() {
        return this.m_mapKeyEnumerated;
    }

    @Override
    public List<JoinColumnMetadata> getMapKeyJoinColumns() {
        return this.m_mapKeyJoinColumns;
    }

    public TemporalMetadata getMapKeyTemporal() {
        return this.m_mapKeyTemporal;
    }

    public String getMappedBy() {
        return this.m_mappedBy;
    }

    public String getOrderBy() {
        return this.m_orderBy;
    }

    protected OrderColumnMetadata getOrderColumn() {
        return this.m_orderColumn;
    }

    @Override
    public MetadataClass getReferenceClass() {
        if (this.m_referenceClass == null) {
            this.m_referenceClass = this.getTargetEntity();
            if (this.m_referenceClass.isVoid()) {
                this.m_referenceClass = this.getReferenceClassFromGeneric();
                if (this.m_referenceClass == null) {
                    throw ValidationException.unableToDetermineTargetEntity(this.getAttributeName(), this.getJavaClass());
                }
                this.getLogger().logConfigMessage(this.getLoggingContext(), this.getAnnotatedElement(), (Object)this.m_referenceClass);
            }
        }
        return this.m_referenceClass;
    }

    @Override
    protected DatabaseTable getReferenceDatabaseTable() {
        if (this.getMapping().isManyToManyMapping()) {
            return ((ManyToManyMapping)this.getMapping()).getRelationTable();
        }
        return super.getReferenceDatabaseTable();
    }

    @Override
    public TemporalMetadata getTemporal(boolean isForMapKey) {
        return this.getMapKeyTemporal();
    }

    @Override
    protected boolean hasConvert(boolean isForMapKey) {
        return isForMapKey ? this.m_mapKeyConvert != null : super.hasConvert(isForMapKey);
    }

    @Override
    public boolean hasEnumerated(boolean isForMapKey) {
        return isForMapKey ? this.m_mapKeyEnumerated != null : super.hasEnumerated(isForMapKey);
    }

    @Override
    public boolean hasTemporal(boolean isForMapKey) {
        return isForMapKey ? this.m_mapKeyTemporal != null : super.hasTemporal(isForMapKey);
    }

    @Override
    public boolean isCollectionAccessor() {
        return true;
    }

    @Override
    public boolean isMappedKeyMapAccessor() {
        return this.isMapAccessor();
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObjects(this.m_mapKeyJoinColumns, accessibleObject);
        this.initXMLObjects(this.m_mapKeyAssociationOverrides, accessibleObject);
        this.initXMLObjects(this.m_mapKeyAttributeOverrides, accessibleObject);
        this.initXMLObject(this.m_mapKeyColumn, accessibleObject);
        this.initXMLObject(this.m_orderColumn, accessibleObject);
        this.m_mapKeyClass = this.initXMLClassName(this.m_mapKeyClassName);
    }

    @Override
    public void process() {
        if (!this.getAccessibleObject().isSupportedToManyCollectionClass(this.getDescriptor())) {
            throw ValidationException.invalidCollectionTypeForRelationship(this.getJavaClass(), this.getRawClass(), this.getAttributeName());
        }
    }

    protected void process(CollectionMapping mapping) {
        this.setMapping(mapping);
        mapping.setIsReadOnly(false);
        mapping.setIsLazy(this.isLazy());
        mapping.setJoinFetch(this.getMappingJoinFetchType(this.getJoinFetch()));
        mapping.setAttributeName(this.getAttributeName());
        mapping.setReferenceClassName(this.getReferenceClassName());
        this.processOrphanRemoval(mapping);
        this.setAccessorMethods(mapping);
        this.processCascadeTypes(mapping);
        this.processOrderBy(mapping);
        this.processContainerPolicyAndIndirection(mapping, this.getMapKey());
        this.processReturnInsertAndUpdate();
        if (this.m_orderColumn != null) {
            this.m_orderColumn.process(mapping, this.getDescriptor());
        }
    }

    @Override
    protected void processAssociationOverride(AssociationOverrideMetadata associationOverride, EmbeddableMapping embeddableMapping, MetadataDescriptor owningDescriptor) {
        if (this.getMapping().isManyToManyMapping()) {
            JoinTableMetadata joinTable = associationOverride.getJoinTable();
            String defaultName = owningDescriptor.getPrimaryTableName() + "_" + this.getReferenceDescriptor().getPrimaryTableName();
            this.processTable(joinTable, defaultName);
            ManyToManyMapping overrideMapping = new ManyToManyMapping();
            overrideMapping.setAttributeName(this.getAttributeName());
            this.processJoinTable(overrideMapping, joinTable);
            embeddableMapping.addOverrideManyToManyMapping(overrideMapping);
        } else {
            super.processAssociationOverride(associationOverride, embeddableMapping, owningDescriptor);
        }
    }

    protected void processJoinTable(ManyToManyMapping mapping, JoinTableMetadata joinTable) {
        String defaultName = this.getOwningDescriptor().getPrimaryTableName() + "_" + this.getReferenceDescriptor().getPrimaryTableName();
        this.processTable(joinTable, defaultName);
        mapping.setRelationTable(joinTable.getDatabaseTable());
        String defaultSourceFieldName = this.getReferenceDescriptor().hasBiDirectionalManyToManyAccessorFor(this.getJavaClassName(), this.getAttributeName()) ? this.getReferenceDescriptor().getBiDirectionalManyToManyAccessor(this.getJavaClassName(), this.getAttributeName()).getAttributeName() : this.getOwningDescriptor().getAlias();
        this.addManyToManyRelationKeyFields(this.getJoinColumnsAndValidate(joinTable.getJoinColumns(), this.getOwningDescriptor()), mapping, defaultSourceFieldName, this.getOwningDescriptor(), true);
        String defaultTargetFieldName = this.getAttributeName();
        this.addManyToManyRelationKeyFields(this.getJoinColumnsAndValidate(joinTable.getInverseJoinColumns(), this.getReferenceDescriptor()), mapping, defaultTargetFieldName, this.getReferenceDescriptor(), false);
    }

    protected void processOrderBy(CollectionMapping mapping) {
        block12: {
            if (this.m_orderBy == null) break block12;
            MetadataDescriptor referenceDescriptor = this.getReferenceDescriptor();
            if (this.m_orderBy.equals("")) {
                List<String> orderByAttributes = referenceDescriptor.getIdOrderByAttributeNames();
                if (referenceDescriptor.hasEmbeddedId()) {
                    String embeddedIdAttributeName = referenceDescriptor.getEmbeddedIdAttributeName();
                    for (String orderByAttribute : orderByAttributes) {
                        mapping.addAggregateOrderBy(embeddedIdAttributeName, orderByAttribute, false);
                    }
                } else {
                    for (String orderByAttribute : orderByAttributes) {
                        mapping.addOrderBy(orderByAttribute, false);
                    }
                }
            } else {
                StringTokenizer commaTokenizer = new StringTokenizer(this.m_orderBy, ",");
                while (commaTokenizer.hasMoreTokens()) {
                    String ordering;
                    StringTokenizer spaceTokenizer = new StringTokenizer(commaTokenizer.nextToken());
                    String propertyOrFieldName = spaceTokenizer.nextToken();
                    MappingAccessor referenceAccessor = referenceDescriptor.getAccessorFor(propertyOrFieldName);
                    if (referenceAccessor == null) {
                        throw ValidationException.invalidOrderByValue(propertyOrFieldName, referenceDescriptor.getJavaClass(), this.getAccessibleObjectName(), this.getJavaClass());
                    }
                    String attributeName = referenceAccessor.getAttributeName();
                    String string = ordering = spaceTokenizer.hasMoreTokens() ? spaceTokenizer.nextToken() : ASCENDING;
                    if (referenceAccessor.isEmbedded()) {
                        for (String orderByAttributeName : referenceDescriptor.getOrderByAttributeNames()) {
                            mapping.addAggregateOrderBy(this.m_orderBy, orderByAttributeName, ordering.equals(DESCENDING));
                        }
                        continue;
                    }
                    if (referenceAccessor.getClassAccessor().isEmbeddableAccessor()) {
                        String embeddableChain = this.m_orderBy;
                        if (embeddableChain.contains(".")) {
                            embeddableChain = embeddableChain.substring(0, embeddableChain.lastIndexOf("."));
                        }
                        mapping.addAggregateOrderBy(embeddableChain, attributeName, ordering.equals(DESCENDING));
                        continue;
                    }
                    mapping.addOrderBy(attributeName, ordering.equals(DESCENDING));
                }
            }
        }
    }

    public void setMapKey(String mapKey) {
        this.m_mapKey = mapKey;
    }

    public void setMapKeyAssociationOverrides(List<AssociationOverrideMetadata> mapKeyAssociationOverrides) {
        this.m_mapKeyAssociationOverrides = mapKeyAssociationOverrides;
    }

    public void setMapKeyAttributeOverrides(List<AttributeOverrideMetadata> mapKeyAttributeOverrides) {
        this.m_mapKeyAttributeOverrides = mapKeyAttributeOverrides;
    }

    @Override
    public void setMapKeyClass(MetadataClass mapKeyClass) {
        this.m_mapKeyClass = mapKeyClass;
    }

    public void setMapKeyClassName(String mapKeyClassName) {
        this.m_mapKeyClassName = mapKeyClassName;
    }

    public void setMapKeyColumn(ColumnMetadata mapKeyColumn) {
        this.m_mapKeyColumn = mapKeyColumn;
    }

    public void setMapKeyConvert(String mapKeyConvert) {
        this.m_mapKeyConvert = mapKeyConvert;
    }

    public void setMapKeyEnumerated(EnumeratedMetadata mapKeyEnumerated) {
        this.m_mapKeyEnumerated = mapKeyEnumerated;
    }

    public void setMapKeyJoinColumns(List<JoinColumnMetadata> mapKeyJoinColumns) {
        this.m_mapKeyJoinColumns = mapKeyJoinColumns;
    }

    public void setMapKeyTemporal(TemporalMetadata mapKeyTemporal) {
        this.m_mapKeyTemporal = mapKeyTemporal;
    }

    public void setMappedBy(String mappedBy) {
        this.m_mappedBy = mappedBy;
    }

    public void setOrderBy(String orderBy) {
        this.m_orderBy = orderBy;
    }

    public void setOrderColumn(OrderColumnMetadata orderColumn) {
        this.m_orderColumn = orderColumn;
    }
}

