/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metamodel;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.indirection.IndirectSet;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jpa.metamodel.AttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.CollectionAttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.EmbeddableTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.EntityTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.ListAttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.MapAttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl;
import org.eclipse.persistence.internal.jpa.metamodel.SetAttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.SingularAttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.TypeImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ManagedTypeImpl<X>
extends TypeImpl<X>
implements ManagedType<X> {
    private RelationalDescriptor descriptor;
    protected Map<String, Attribute<X, ?>> members;
    protected MetamodelImpl metamodel;

    protected ManagedTypeImpl(MetamodelImpl metamodel, RelationalDescriptor descriptor) {
        super(descriptor.getJavaClass());
        this.descriptor = descriptor;
        this.metamodel = metamodel;
        descriptor.setProperty(this.getClass().getName(), this);
    }

    @Override
    public Attribute<X, ?> getAttribute(String name) {
        if (!this.members.containsKey(name)) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_not_present", new Object[]{name, this}));
        }
        return this.members.get(name);
    }

    @Override
    public Set<Attribute<? super X, ?>> getAttributes() {
        return new HashSet(this.members.values());
    }

    @Override
    public CollectionAttribute<? super X, ?> getCollection(String name) {
        CollectionAttribute anAttribute = (CollectionAttribute)this.members.get(name);
        if (null == anAttribute) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_not_present", new Object[]{name, this}));
        }
        return anAttribute;
    }

    @Override
    public <E> CollectionAttribute<? super X, E> getCollection(String name, Class<E> elementType) {
        Attribute<X, ?> anAttribute = this.members.get(name);
        if (null == anAttribute) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_not_present", new Object[]{name, this}));
        }
        this.verifyAttributeTypeAndReturnType(anAttribute, elementType, PluralAttribute.CollectionType.COLLECTION);
        return (CollectionAttribute)anAttribute;
    }

    @Override
    public Set<PluralAttribute<? super X, ?, ?>> getCollections() {
        Set<Attribute<X, ?>> allAttributes = this.getAttributes();
        HashSet pluralAttributes = new HashSet();
        for (Attribute<X, ?> anAttribute : allAttributes) {
            if (!anAttribute.isCollection()) continue;
            pluralAttributes.add((PluralAttribute)anAttribute);
        }
        return pluralAttributes;
    }

    @Override
    public Attribute<X, ?> getDeclaredAttribute(String name) {
        Attribute<X, ?> anAttribute = this.getAttribute(name);
        ManagedTypeImpl aManagedSuperType = this.getManagedSuperType();
        if (null == aManagedSuperType) {
            return anAttribute;
        }
        if (aManagedSuperType.hasDeclaredAttribute(name)) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_declared_attribute_not_present_but_is_on_superclass", new Object[]{name, this}));
        }
        return anAttribute;
    }

    @Override
    public Set<Attribute<X, ?>> getDeclaredAttributes() {
        HashSet allAttributes = new HashSet(this.members.values());
        HashSet declaredAttributes = new HashSet();
        for (Attribute attribute : allAttributes) {
            if (!this.hasDeclaredAttribute(attribute.getName())) continue;
            declaredAttributes.add(attribute);
        }
        return declaredAttributes;
    }

    @Override
    public CollectionAttribute<X, ?> getDeclaredCollection(String name) {
        CollectionAttribute<X, ?> anAttribute = this.getCollection(name);
        this.getDeclaredAttribute(name);
        return anAttribute;
    }

    @Override
    public <E> CollectionAttribute<X, E> getDeclaredCollection(String name, Class<E> elementType) {
        CollectionAttribute<X, E> anAttribute = this.getCollection(name, elementType);
        this.getDeclaredAttribute(name);
        return anAttribute;
    }

    @Override
    public Set<PluralAttribute<X, ?, ?>> getDeclaredCollections() {
        Set<PluralAttribute<X, ?, ?>> pluralAttributes = this.getCollections();
        HashSet declaredAttributes = new HashSet();
        for (PluralAttribute<X, ?, ?> anAttribute : pluralAttributes) {
            if (!((TypeImpl)anAttribute.getElementType()).isManagedType()) continue;
            ManagedTypeImpl potentialSuperType = this.getManagedSuperType();
            if (null == potentialSuperType) {
                declaredAttributes.add(anAttribute);
                continue;
            }
            if (potentialSuperType.hasDeclaredAttribute(anAttribute.getName())) continue;
            declaredAttributes.add(anAttribute);
        }
        return declaredAttributes;
    }

    public static ManagedTypeImpl<?> create(MetamodelImpl metamodel, RelationalDescriptor descriptor) {
        ManagedTypeImpl managedType = (EmbeddableTypeImpl)descriptor.getProperty(ManagedTypeImpl.class.getName());
        if (null == managedType) {
            managedType = descriptor.isAggregateDescriptor() ? new EmbeddableTypeImpl(metamodel, descriptor) : new EntityTypeImpl(metamodel, descriptor);
        }
        return managedType;
    }

    @Override
    public <E> ListAttribute<X, E> getDeclaredList(String name, Class<E> elementType) {
        ListAttribute<X, E> anAttribute = this.getList(name, elementType);
        this.getDeclaredAttribute(name);
        return anAttribute;
    }

    @Override
    public ListAttribute<X, ?> getDeclaredList(String name) {
        ListAttribute<X, ?> anAttribute = this.getList(name);
        this.getDeclaredAttribute(name);
        return anAttribute;
    }

    @Override
    public MapAttribute<X, ?, ?> getDeclaredMap(String name) {
        MapAttribute<X, ?, ?> anAttribute = this.getMap(name);
        this.getDeclaredAttribute(name);
        return anAttribute;
    }

    @Override
    public <K, V> MapAttribute<X, K, V> getDeclaredMap(String name, Class<K> keyType, Class<V> valueType) {
        MapAttribute<X, K, V> anAttribute = this.getMap(name, keyType, valueType);
        this.getDeclaredAttribute(name);
        return anAttribute;
    }

    @Override
    public SetAttribute<X, ?> getDeclaredSet(String name) {
        SetAttribute<X, ?> anAttribute = this.getSet(name);
        this.getDeclaredAttribute(name);
        return anAttribute;
    }

    @Override
    public <E> SetAttribute<X, E> getDeclaredSet(String name, Class<E> elementType) {
        SetAttribute<X, E> anAttribute = this.getSet(name, elementType);
        this.getDeclaredAttribute(name);
        return anAttribute;
    }

    @Override
    public SingularAttribute<X, ?> getDeclaredSingularAttribute(String name) {
        SingularAttribute<X, ?> anAttribute = this.getSingularAttribute(name);
        this.getDeclaredAttribute(name);
        return anAttribute;
    }

    @Override
    public <Y> SingularAttribute<X, Y> getDeclaredSingularAttribute(String name, Class<Y> type) {
        SingularAttribute<X, Y> anAttribute = this.getSingularAttribute(name, type);
        this.getDeclaredAttribute(name);
        return anAttribute;
    }

    @Override
    public Set<SingularAttribute<X, ?>> getDeclaredSingularAttributes() {
        HashSet allAttributes = new HashSet(this.members.values());
        HashSet declaredAttributes = new HashSet();
        for (Attribute attribute : allAttributes) {
            if (attribute.isCollection()) continue;
            declaredAttributes.add((SingularAttribute)attribute);
        }
        return declaredAttributes;
    }

    public RelationalDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public ListAttribute<? super X, ?> getList(String name) {
        return this.getList(name, true);
    }

    protected ListAttribute<? super X, ?> getList(String name, boolean performNullCheck) {
        ListAttribute anAttribute = (ListAttribute)this.members.get(name);
        if (performNullCheck && null == anAttribute) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_not_present", new Object[]{name, this}));
        }
        return anAttribute;
    }

    private void verifyAttributeTypeAndReturnType(Attribute anAttribute, Class attributeElementType, PluralAttribute.CollectionType aReturnCollectionType) {
        if (anAttribute.isCollection()) {
            if (((PluralAttribute)anAttribute).getCollectionType().equals((Object)aReturnCollectionType)) {
                Class aBindableJavaClass = ((PluralAttribute)anAttribute).getBindableJavaType();
                if (attributeElementType != aBindableJavaClass) {
                    throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_type_incorrect", new Object[]{anAttribute.getName(), this, attributeElementType, aBindableJavaClass}));
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_return_type_incorrect", new Object[]{anAttribute.getName(), this, aReturnCollectionType, ((PluralAttribute)anAttribute).getCollectionType()}));
            }
        }
    }

    @Override
    public <E> ListAttribute<? super X, E> getList(String name, Class<E> elementType) {
        ListAttribute anAttribute = (ListAttribute)this.members.get(name);
        if (null == anAttribute) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_not_present", new Object[]{name, this}));
        }
        this.verifyAttributeTypeAndReturnType(anAttribute, elementType, PluralAttribute.CollectionType.LIST);
        return anAttribute;
    }

    private ManagedTypeImpl getManagedSuperType() {
        ManagedTypeImpl aSuperType = null;
        Class aSuperClass = this.getJavaType().getSuperclass();
        if (null != aSuperClass && aSuperClass != ClassConstants.OBJECT) {
            aSuperType = (ManagedTypeImpl)this.getMetamodel().type(aSuperClass);
        }
        return aSuperType;
    }

    @Override
    public MapAttribute<? super X, ?, ?> getMap(String name) {
        MapAttribute anAttribute = (MapAttribute)this.members.get(name);
        if (null == anAttribute) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_not_present", new Object[]{name, this}));
        }
        return anAttribute;
    }

    @Override
    public <K, V> MapAttribute<? super X, K, V> getMap(String name, Class<K> keyType, Class<V> valueType) {
        MapAttribute<X, ?, ?> anAttribute = this.getMap(name);
        Class aClass = anAttribute.getElementType().getJavaType();
        if (valueType != aClass) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_type_incorrect", new Object[]{name, this, valueType, aClass}));
        }
        return anAttribute;
    }

    public Map<String, Attribute<X, ?>> getMembers() {
        return this.members;
    }

    public MetamodelImpl getMetamodel() {
        return this.metamodel;
    }

    @Override
    public SetAttribute<? super X, ?> getSet(String name) {
        SetAttribute anAttribute = (SetAttribute)this.members.get(name);
        if (null == anAttribute) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_not_present", new Object[]{name, this}));
        }
        return anAttribute;
    }

    @Override
    public <E> SetAttribute<? super X, E> getSet(String name, Class<E> elementType) {
        SetAttribute<X, ?> anAttribute = this.getSet(name);
        Class aClass = anAttribute.getElementType().getJavaType();
        if (elementType != aClass) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_type_incorrect", new Object[]{name, this, elementType, aClass.getName()}));
        }
        return anAttribute;
    }

    @Override
    public SingularAttribute<? super X, ?> getSingularAttribute(String name) {
        Attribute<X, ?> anAttribute = this.getMembers().get(name);
        if (null == anAttribute) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_not_present", new Object[]{name, this}));
        }
        return (SingularAttribute)anAttribute;
    }

    @Override
    public <Y> SingularAttribute<? super X, Y> getSingularAttribute(String name, Class<Y> type) {
        SingularAttribute<X, ?> anAttribute = this.getSingularAttribute(name);
        Class<?> aClass = anAttribute.getType().getJavaType();
        if (type != aClass) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_type_incorrect", new Object[]{name, this, type, aClass}));
        }
        return anAttribute;
    }

    @Override
    public Set<SingularAttribute<? super X, ?>> getSingularAttributes() {
        HashSet singularAttributeSet = new HashSet();
        for (AttributeImpl attributeImpl : this.members.values()) {
            if (attributeImpl.isPlural()) continue;
            singularAttributeSet.add((SingularAttribute<X, ?>)((Object)attributeImpl));
        }
        return singularAttributeSet;
    }

    private boolean hasDeclaredAttribute(String attributeName) {
        return this.hasDeclaredAttribute(attributeName, this.getMembers().get(attributeName));
    }

    private boolean hasDeclaredAttribute(String attributeName, Attribute firstLevelAttribute) {
        Attribute<X, ?> anAttribute = this.getMembers().get(attributeName);
        ManagedTypeImpl aSuperType = this.getManagedSuperType();
        if (null == aSuperType) {
            return null == anAttribute && null != firstLevelAttribute;
        }
        Attribute<X, ?> aSuperTypeAttribute = aSuperType.getMembers().get(attributeName);
        if (null != aSuperTypeAttribute) {
            return false;
        }
        if (null == aSuperTypeAttribute) {
            return aSuperType.hasDeclaredAttribute(attributeName, firstLevelAttribute);
        }
        return anAttribute == firstLevelAttribute;
    }

    protected void initialize() {
        this.members = new HashMap();
        for (DatabaseMapping mapping : this.getDescriptor().getMappings()) {
            CollectionMapping colMapping;
            AttributeImpl member = null;
            member = mapping.isCollectionMapping() ? ((colMapping = (CollectionMapping)mapping).getContainerPolicy().isMapPolicy() ? new MapAttributeImpl(this, colMapping) : (colMapping.getContainerPolicy().isListPolicy() ? new ListAttributeImpl(this, colMapping) : (colMapping.getContainerPolicy().getContainerClass().isAssignableFrom(Set.class) || colMapping.getContainerPolicy().getContainerClass().isAssignableFrom(IndirectSet.class) ? new SetAttributeImpl(this, colMapping) : new CollectionAttributeImpl(this, colMapping)))) : new SingularAttributeImpl(this, mapping);
            this.members.put(mapping.getAttributeName(), member);
        }
    }

    @Override
    public boolean isIdentifiableType() {
        return false;
    }

    @Override
    public boolean isManagedType() {
        return true;
    }

    public String toString() {
        return "ManagedTypeImpl[" + this.getDescriptor() + "]";
    }
}

