/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.weaving;

import java.io.File;
import java.io.FileOutputStream;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.StringTokenizer;
import javax.persistence.spi.ClassTransformer;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.libraries.asm.ClassReader;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.attrs.Attributes;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.weaving.ClassDetails;
import org.eclipse.persistence.internal.weaving.ClassWeaver;
import org.eclipse.persistence.sessions.Session;

public class PersistenceWeaver
implements ClassTransformer {
    public static final String WEAVING_OUTPUT_PATH = "eclipselink.weaving.output.path";
    public static final String WEAVING_SHOULD_OVERWRITE = "eclipselink.weaving.overwrite.existing";
    public static final String WEAVER_NOT_OVERWRITING = "weaver_not_overwriting";
    public static final String WEAVER_COULD_NOT_WRITE = "weaver_could_not_write";
    public static final String EXCEPTION_WHILE_WEAVING = "exception_while_weaving";
    protected Session session;
    protected Map classDetailsMap;

    public PersistenceWeaver(Session session, Map classDetailsMap) {
        this.session = session;
        this.classDetailsMap = classDetailsMap;
    }

    public void clear() {
        this.session = null;
        this.classDetailsMap = null;
    }

    public Map getClassDetailsMap() {
        return this.classDetailsMap;
    }

    public byte[] transform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        Map classDetailsMap = this.classDetailsMap;
        Session session = this.session;
        if (classDetailsMap == null || session == null) {
            return null;
        }
        try {
            ClassDetails classDetails = (ClassDetails)classDetailsMap.get(Helper.toSlashedClassName(className));
            if (classDetails != null) {
                ((AbstractSession)session).log(1, "weaver", "begin_weaving_class", className);
                ClassReader classReader = new ClassReader(classfileBuffer);
                ClassWriter classWriter = new ClassWriter(true, true);
                ClassWeaver classWeaver = new ClassWeaver(classWriter, classDetails);
                classReader.accept(classWeaver, Attributes.getDefaultAttributes(), false);
                if (classWeaver.alreadyWeaved) {
                    ((AbstractSession)session).log(1, "weaver", "end_weaving_class", className);
                    return null;
                }
                if (classWeaver.weaved) {
                    byte[] bytes = classWriter.toByteArray();
                    String outputPath = System.getProperty(WEAVING_OUTPUT_PATH, "");
                    if (!outputPath.equals("")) {
                        this.outputFile(className, bytes, outputPath);
                    }
                    if (classWeaver.weavedPersistenceEntity) {
                        ((AbstractSession)session).log(1, "weaver", "weaved_persistenceentity", className);
                    }
                    if (classWeaver.weavedChangeTracker) {
                        ((AbstractSession)session).log(1, "weaver", "weaved_changetracker", className);
                    }
                    if (classWeaver.weavedLazy) {
                        ((AbstractSession)session).log(1, "weaver", "weaved_lazy", className);
                    }
                    if (classWeaver.weavedFetchGroups) {
                        ((AbstractSession)session).log(1, "weaver", "weaved_fetchgroups", className);
                    }
                    ((AbstractSession)session).log(1, "weaver", "end_weaving_class", className);
                    return bytes;
                }
                ((AbstractSession)session).log(1, "weaver", "end_weaving_class", className);
            }
        }
        catch (Throwable exception) {
            ((AbstractSession)session).log(6, "weaver", EXCEPTION_WHILE_WEAVING, className, exception);
            ((AbstractSession)session).logThrowable(1, "weaver", exception);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void outputFile(String className, byte[] classBytes, String outputPath) {
        StringBuffer directoryName = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(className, "\n\\/");
        String token = null;
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) continue;
            directoryName.append(token + File.separator);
        }
        FileOutputStream fos = null;
        try {
            String usedOutputPath = outputPath;
            if (!outputPath.endsWith(File.separator)) {
                usedOutputPath = outputPath + File.separator;
            }
            File file = new File(usedOutputPath + directoryName);
            file.mkdirs();
            file = new File(file, token + ".class");
            if (!file.exists()) {
                file.createNewFile();
            } else if (!System.getProperty(WEAVING_SHOULD_OVERWRITE, "false").equalsIgnoreCase("true")) {
                ((AbstractSession)this.session).log(6, "weaver", WEAVER_NOT_OVERWRITING, className);
                Helper.close(fos);
                return;
            }
            fos = new FileOutputStream(file);
            fos.write(classBytes);
            Helper.close(fos);
        }
        catch (Exception e) {
            ((AbstractSession)this.session).log(6, "weaver", WEAVER_COULD_NOT_WRITE, className, e);
            ((AbstractSession)this.session).logThrowable(1, "weaver", e);
        }
        finally {
            Helper.close(fos);
        }
    }

    protected static String getShortName(String name) {
        int pos = name.lastIndexOf(47);
        if (pos >= 0) {
            if ((name = name.substring(pos + 1)).endsWith(";")) {
                name = name.substring(0, name.length() - 1);
            }
            return name;
        }
        return "";
    }
}

