/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.expressions.SQLDeleteStatement;
import org.eclipse.persistence.internal.expressions.SQLInsertStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationTableMechanism
implements Cloneable {
    protected DatabaseTable relationTable;
    protected Vector<DatabaseField> sourceKeyFields;
    protected Vector<DatabaseField> targetKeyFields;
    protected Vector<DatabaseField> sourceRelationKeyFields;
    protected Vector<DatabaseField> targetRelationKeyFields;
    protected DataModifyQuery deleteQuery;
    protected boolean hasCustomDeleteQuery = false;
    protected DataModifyQuery insertQuery = new DataModifyQuery();
    protected boolean hasCustomInsertQuery = false;

    public RelationTableMechanism() {
        this.deleteQuery = new DataModifyQuery();
        this.sourceRelationKeyFields = NonSynchronizedVector.newInstance(1);
        this.targetRelationKeyFields = NonSynchronizedVector.newInstance(1);
        this.sourceKeyFields = NonSynchronizedVector.newInstance(1);
        this.targetKeyFields = NonSynchronizedVector.newInstance(1);
    }

    public void addSourceRelationKeyField(DatabaseField sourceRelationKeyField, DatabaseField sourcePrimaryKeyField) {
        this.getSourceRelationKeyFields().addElement(sourceRelationKeyField);
        this.getSourceKeyFields().addElement(sourcePrimaryKeyField);
    }

    public void addSourceRelationKeyFieldName(String sourceRelationKeyFieldName, String sourcePrimaryKeyFieldName) {
        this.addSourceRelationKeyField(new DatabaseField(sourceRelationKeyFieldName), new DatabaseField(sourcePrimaryKeyFieldName));
    }

    public void addTargetRelationKeyField(DatabaseField targetRelationKeyField, DatabaseField targetPrimaryKeyField) {
        this.getTargetRelationKeyFields().addElement(targetRelationKeyField);
        this.getTargetKeyFields().addElement(targetPrimaryKeyField);
    }

    public void addTargetRelationKeyFieldName(String targetRelationKeyFieldName, String targetPrimaryKeyFieldName) {
        this.addTargetRelationKeyField(new DatabaseField(targetRelationKeyFieldName), new DatabaseField(targetPrimaryKeyFieldName));
    }

    public Object clone() {
        RelationTableMechanism clone;
        try {
            clone = (RelationTableMechanism)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone.setTargetKeyFields(this.cloneFields(this.getTargetKeyFields()));
        clone.setSourceKeyFields(this.cloneFields(this.getSourceKeyFields()));
        clone.setTargetRelationKeyFields(this.cloneFields(this.getTargetRelationKeyFields()));
        clone.setSourceRelationKeyFields(this.cloneFields(this.getSourceRelationKeyFields()));
        clone.setInsertQuery((DataModifyQuery)this.insertQuery.clone());
        clone.setDeleteQuery((DataModifyQuery)this.deleteQuery.clone());
        return clone;
    }

    protected Vector cloneFields(Vector fields) {
        NonSynchronizedVector clonedFields = NonSynchronizedVector.newInstance();
        Enumeration fieldsEnum = fields.elements();
        while (fieldsEnum.hasMoreElements()) {
            ((Vector)clonedFields).addElement(((DatabaseField)fieldsEnum.nextElement()).clone());
        }
        return clonedFields;
    }

    protected DataModifyQuery getDeleteQuery() {
        return this.deleteQuery;
    }

    protected DataModifyQuery getInsertQuery() {
        return this.insertQuery;
    }

    public DatabaseTable getRelationTable() {
        return this.relationTable;
    }

    public String getRelationTableName() {
        if (this.relationTable == null) {
            return null;
        }
        return this.relationTable.getName();
    }

    public String getRelationTableQualifiedName() {
        if (this.relationTable == null) {
            return null;
        }
        return this.relationTable.getQualifiedName();
    }

    public Vector getSourceKeyFieldNames() {
        Vector<String> fieldNames = new Vector<String>(this.getSourceKeyFields().size());
        Enumeration<DatabaseField> fieldsEnum = this.getSourceKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            fieldNames.addElement(fieldsEnum.nextElement().getQualifiedName());
        }
        return fieldNames;
    }

    public Vector<DatabaseField> getSourceKeyFields() {
        return this.sourceKeyFields;
    }

    public Vector getSourceRelationKeyFieldNames() {
        Vector<String> fieldNames = new Vector<String>(this.getSourceRelationKeyFields().size());
        Enumeration<DatabaseField> fieldsEnum = this.getSourceRelationKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            fieldNames.addElement(fieldsEnum.nextElement().getQualifiedName());
        }
        return fieldNames;
    }

    public Vector<DatabaseField> getSourceRelationKeyFields() {
        return this.sourceRelationKeyFields;
    }

    public Vector getTargetKeyFieldNames() {
        Vector<String> fieldNames = new Vector<String>(this.getTargetKeyFields().size());
        Enumeration<DatabaseField> fieldsEnum = this.getTargetKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            fieldNames.addElement(fieldsEnum.nextElement().getQualifiedName());
        }
        return fieldNames;
    }

    public Vector<DatabaseField> getTargetKeyFields() {
        return this.targetKeyFields;
    }

    public Vector getTargetRelationKeyFieldNames() {
        Vector<String> fieldNames = new Vector<String>(this.getTargetRelationKeyFields().size());
        Enumeration<DatabaseField> fieldsEnum = this.getTargetRelationKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            fieldNames.addElement(fieldsEnum.nextElement().getQualifiedName());
        }
        return fieldNames;
    }

    public Vector<DatabaseField> getTargetRelationKeyFields() {
        return this.targetRelationKeyFields;
    }

    protected boolean hasCustomDeleteQuery() {
        return this.hasCustomDeleteQuery;
    }

    protected boolean hasCustomInsertQuery() {
        return this.hasCustomInsertQuery;
    }

    public boolean hasRelationTable() {
        return this.relationTable != null && this.relationTable.getName().length() > 0;
    }

    public void initialize(AbstractSession session, ForeignReferenceMapping mapping) throws DescriptorException {
        this.initializeRelationTable(session, mapping);
        this.initializeSourceRelationKeys(session, mapping);
        this.initializeTargetRelationKeys(session, mapping);
        if (this.isSingleSourceRelationKeySpecified()) {
            this.initializeSourceKeysWithDefaults(session, mapping);
        } else {
            this.initializeSourceKeys(session, mapping);
        }
        if (this.isSingleTargetRelationKeySpecified()) {
            this.initializeTargetKeysWithDefaults(session, mapping);
        } else {
            this.initializeTargetKeys(session, mapping);
        }
        if (this.getRelationTable().getName().indexOf(32) != -1) {
            String quoteChar = ((DatasourcePlatform)session.getDatasourcePlatform()).getIdentifierQuoteCharacter();
            if (this.getRelationTable().getName().indexOf(quoteChar) == -1) {
                this.getRelationTable().setName(quoteChar + this.getRelationTable().getName() + quoteChar);
            }
        }
        if (mapping.isCollectionMapping()) {
            ((CollectionMapping)mapping).getContainerPolicy().initialize(session, this.getRelationTable());
        }
        this.initializeInsertQuery(session, mapping);
        this.initializeDeleteQuery(session, mapping);
    }

    protected void initializeDeleteQuery(AbstractSession session, ForeignReferenceMapping mapping) {
        Expression expression;
        DatabaseField relationKey;
        if (!this.getDeleteQuery().hasSessionName()) {
            this.getDeleteQuery().setSessionName(session.getName());
        }
        if (this.hasCustomDeleteQuery()) {
            return;
        }
        Expression whereClause = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        Enumeration<DatabaseField> relationKeyEnum = this.getSourceRelationKeyFields().elements();
        while (relationKeyEnum.hasMoreElements()) {
            relationKey = relationKeyEnum.nextElement();
            expression = ((Expression)builder).getField(relationKey).equal(builder.getParameter(relationKey));
            whereClause = expression.and(whereClause);
        }
        if (mapping.isCollectionMapping()) {
            relationKeyEnum = this.getTargetRelationKeyFields().elements();
            while (relationKeyEnum.hasMoreElements()) {
                relationKey = relationKeyEnum.nextElement();
                expression = ((Expression)builder).getField(relationKey).equal(builder.getParameter(relationKey));
                whereClause = expression.and(whereClause);
            }
        }
        SQLDeleteStatement statement = new SQLDeleteStatement();
        statement.setTable(this.getRelationTable());
        statement.setWhereClause(whereClause);
        this.getDeleteQuery().setSQLStatement(statement);
    }

    protected void initializeInsertQuery(AbstractSession session, ForeignReferenceMapping mapping) {
        if (!this.getInsertQuery().hasSessionName()) {
            this.getInsertQuery().setSessionName(session.getName());
        }
        if (this.hasCustomInsertQuery()) {
            return;
        }
        SQLInsertStatement statement = new SQLInsertStatement();
        statement.setTable(this.getRelationTable());
        DatabaseRecord joinRow = new DatabaseRecord();
        Enumeration<DatabaseField> targetEnum = this.getTargetRelationKeyFields().elements();
        while (targetEnum.hasMoreElements()) {
            joinRow.put(targetEnum.nextElement(), (Object)null);
        }
        Enumeration<DatabaseField> sourceEnum = this.getSourceRelationKeyFields().elements();
        while (sourceEnum.hasMoreElements()) {
            joinRow.put(sourceEnum.nextElement(), (Object)null);
        }
        if (mapping.isCollectionMapping()) {
            CollectionMapping collectionMapping = (CollectionMapping)mapping;
            if (collectionMapping.getListOrderField() != null) {
                joinRow.put(collectionMapping.getListOrderField(), (Object)null);
            }
            collectionMapping.getContainerPolicy().addFieldsForMapKey(joinRow);
        }
        statement.setModifyRow(joinRow);
        this.getInsertQuery().setSQLStatement(statement);
        this.getInsertQuery().setModifyRow(joinRow);
    }

    protected void initializeRelationTable(AbstractSession session, ForeignReferenceMapping mapping) throws DescriptorException {
        Platform platform = session.getDatasourcePlatform();
        if (!this.hasRelationTable()) {
            throw DescriptorException.noRelationTable(mapping);
        }
        if (platform.getTableQualifier().length() > 0 && this.getRelationTable().getTableQualifier().length() == 0) {
            this.getRelationTable().setTableQualifier(platform.getTableQualifier());
        }
    }

    protected void initializeSourceKeys(AbstractSession session, ForeignReferenceMapping mapping) {
        for (int index = 0; index < this.getSourceKeyFields().size(); ++index) {
            DatabaseField field = mapping.getDescriptor().buildField(this.getSourceKeyFields().get(index));
            this.getSourceKeyFields().set(index, field);
        }
    }

    protected void initializeSourceKeysWithDefaults(AbstractSession session, DatabaseMapping mapping) {
        List<DatabaseField> primaryKeyFields = mapping.getDescriptor().getPrimaryKeyFields();
        for (int index = 0; index < primaryKeyFields.size(); ++index) {
            this.getSourceKeyFields().addElement(primaryKeyFields.get(index));
        }
    }

    protected void initializeSourceRelationKeys(AbstractSession session, ForeignReferenceMapping mapping) throws DescriptorException {
        if (this.getSourceRelationKeyFields().size() == 0) {
            throw DescriptorException.noSourceRelationKeysSpecified(mapping);
        }
        Enumeration<DatabaseField> entry = this.getSourceRelationKeyFields().elements();
        while (entry.hasMoreElements()) {
            DatabaseField field = entry.nextElement();
            if (field.hasTableName() && !field.getTableName().equals(this.getRelationTable().getName())) {
                throw DescriptorException.relationKeyFieldNotProperlySpecified(field, mapping);
            }
            field.setTable(this.getRelationTable());
        }
    }

    protected void initializeTargetKeys(AbstractSession session, ForeignReferenceMapping mapping) {
        for (int index = 0; index < this.getTargetKeyFields().size(); ++index) {
            DatabaseField field = mapping.getReferenceDescriptor().buildField(this.getTargetKeyFields().get(index));
            this.getTargetKeyFields().set(index, field);
        }
    }

    protected void initializeTargetKeysWithDefaults(AbstractSession session, ForeignReferenceMapping mapping) {
        List<DatabaseField> primaryKeyFields = mapping.getReferenceDescriptor().getPrimaryKeyFields();
        for (int index = 0; index < primaryKeyFields.size(); ++index) {
            this.getTargetKeyFields().addElement(primaryKeyFields.get(index));
        }
    }

    protected void initializeTargetRelationKeys(AbstractSession session, ForeignReferenceMapping mapping) {
        if (this.getTargetRelationKeyFields().size() == 0) {
            throw DescriptorException.noTargetRelationKeysSpecified(mapping);
        }
        Enumeration<DatabaseField> targetEnum = this.getTargetRelationKeyFields().elements();
        while (targetEnum.hasMoreElements()) {
            DatabaseField field = targetEnum.nextElement();
            if (field.hasTableName() && !field.getTableName().equals(this.getRelationTable().getName())) {
                throw DescriptorException.relationKeyFieldNotProperlySpecified(field, mapping);
            }
            field.setTable(this.getRelationTable());
        }
    }

    protected boolean isSingleSourceRelationKeySpecified() {
        return this.getSourceKeyFields().isEmpty();
    }

    protected boolean isSingleTargetRelationKeySpecified() {
        return this.getTargetKeyFields().isEmpty();
    }

    public void setCustomDeleteQuery(DataModifyQuery query) {
        this.setDeleteQuery(query);
        this.setHasCustomDeleteQuery(true);
    }

    public void setCustomInsertQuery(DataModifyQuery query) {
        this.setInsertQuery(query);
        this.setHasCustomInsertQuery(true);
    }

    protected void setDeleteQuery(DataModifyQuery deleteQuery) {
        this.deleteQuery = deleteQuery;
    }

    public void setDeleteSQLString(String sqlString) {
        DataModifyQuery query = new DataModifyQuery();
        query.setSQLString(sqlString);
        this.setCustomDeleteQuery(query);
    }

    public void setDeleteCall(Call call) {
        DataModifyQuery query = new DataModifyQuery();
        query.setCall(call);
        this.setCustomDeleteQuery(query);
    }

    protected void setHasCustomDeleteQuery(boolean hasCustomDeleteQuery) {
        this.hasCustomDeleteQuery = hasCustomDeleteQuery;
    }

    protected void setHasCustomInsertQuery(boolean bool) {
        this.hasCustomInsertQuery = bool;
    }

    protected void setInsertQuery(DataModifyQuery insertQuery) {
        this.insertQuery = insertQuery;
    }

    public void setInsertSQLString(String sqlString) {
        DataModifyQuery query = new DataModifyQuery();
        query.setSQLString(sqlString);
        this.setCustomInsertQuery(query);
    }

    public void setInsertCall(Call call) {
        DataModifyQuery query = new DataModifyQuery();
        query.setCall(call);
        this.setCustomInsertQuery(query);
    }

    public void setRelationTable(DatabaseTable relationTable) {
        this.relationTable = relationTable;
    }

    public void setRelationTableName(String tableName) {
        this.relationTable = new DatabaseTable(tableName);
    }

    public void setSessionName(String name) {
        this.getInsertQuery().setSessionName(name);
        this.getDeleteQuery().setSessionName(name);
    }

    public void setSourceKeyFieldNames(Vector fieldNames) {
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(fieldNames.size());
        Enumeration fieldNamesEnum = fieldNames.elements();
        while (fieldNamesEnum.hasMoreElements()) {
            ((Vector)fields).addElement(new DatabaseField((String)fieldNamesEnum.nextElement()));
        }
        this.setSourceKeyFields(fields);
    }

    public void setSourceKeyFields(Vector<DatabaseField> sourceKeyFields) {
        this.sourceKeyFields = sourceKeyFields;
    }

    public void setSourceRelationKeyFieldName(String sourceRelationKeyFieldName) {
        this.getSourceRelationKeyFields().addElement(new DatabaseField(sourceRelationKeyFieldName));
    }

    public void setSourceRelationKeyFieldNames(Vector fieldNames) {
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(fieldNames.size());
        Enumeration fieldNamesEnum = fieldNames.elements();
        while (fieldNamesEnum.hasMoreElements()) {
            ((Vector)fields).addElement(new DatabaseField((String)fieldNamesEnum.nextElement()));
        }
        this.setSourceRelationKeyFields(fields);
    }

    public void setSourceRelationKeyFields(Vector<DatabaseField> sourceRelationKeyFields) {
        this.sourceRelationKeyFields = sourceRelationKeyFields;
    }

    public void setTargetKeyFieldNames(Vector fieldNames) {
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(fieldNames.size());
        Enumeration fieldNamesEnum = fieldNames.elements();
        while (fieldNamesEnum.hasMoreElements()) {
            ((Vector)fields).addElement(new DatabaseField((String)fieldNamesEnum.nextElement()));
        }
        this.setTargetKeyFields(fields);
    }

    public void setTargetKeyFields(Vector<DatabaseField> targetKeyFields) {
        this.targetKeyFields = targetKeyFields;
    }

    public void setTargetRelationKeyFieldName(String targetRelationKeyFieldName) {
        this.getTargetRelationKeyFields().addElement(new DatabaseField(targetRelationKeyFieldName));
    }

    public void setTargetRelationKeyFieldNames(Vector fieldNames) {
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(fieldNames.size());
        Enumeration fieldNamesEnum = fieldNames.elements();
        while (fieldNamesEnum.hasMoreElements()) {
            ((Vector)fields).addElement(new DatabaseField((String)fieldNamesEnum.nextElement()));
        }
        this.setTargetRelationKeyFields(fields);
    }

    public void setTargetRelationKeyFields(Vector<DatabaseField> targetRelationKeyFields) {
        this.targetRelationKeyFields = targetRelationKeyFields;
    }

    public AbstractRecord buildRelationTableSourceRow(Object sourceObject, AbstractSession session, ForeignReferenceMapping mapping) {
        DatabaseRecord databaseRow = new DatabaseRecord();
        return this.addRelationTableSourceRow(sourceObject, session, databaseRow, mapping);
    }

    public AbstractRecord addRelationTableSourceRow(Object sourceObject, AbstractSession session, AbstractRecord databaseRow, ForeignReferenceMapping mapping) {
        ObjectBuilder builder = mapping.getDescriptor().getObjectBuilder();
        int size = this.sourceKeyFields.size();
        for (int i = 0; i < size; ++i) {
            Object sourceValue = builder.extractValueFromObjectForField(sourceObject, this.sourceKeyFields.get(i), session);
            databaseRow.put(this.sourceRelationKeyFields.get(i), sourceValue);
        }
        return databaseRow;
    }

    public AbstractRecord buildRelationTableSourceRow(AbstractRecord sourceRow) {
        DatabaseRecord databaseRow = new DatabaseRecord();
        return this.addRelationTableSourceRow(sourceRow, databaseRow);
    }

    public AbstractRecord addRelationTableSourceRow(AbstractRecord sourceRow, AbstractRecord databaseRow) {
        int size = this.sourceKeyFields.size();
        for (int i = 0; i < size; ++i) {
            Object sourceValue = sourceRow.get(this.sourceKeyFields.get(i));
            databaseRow.put(this.sourceRelationKeyFields.get(i), sourceValue);
        }
        return databaseRow;
    }

    public AbstractRecord addRelationTableTargetRow(Object targetObject, AbstractSession session, AbstractRecord databaseRow, ForeignReferenceMapping mapping) {
        ObjectBuilder builder = mapping.getReferenceDescriptor().getObjectBuilder();
        int size = this.targetKeyFields.size();
        for (int i = 0; i < size; ++i) {
            Object sourceValue = builder.extractValueFromObjectForField(targetObject, this.targetKeyFields.get(i), session);
            databaseRow.put(this.targetRelationKeyFields.get(i), sourceValue);
        }
        return databaseRow;
    }

    public AbstractRecord buildRelationTableSourceAndTargetRow(Object sourceObject, Object targetObject, AbstractSession session, ForeignReferenceMapping mapping) {
        AbstractRecord databaseRow = this.buildRelationTableSourceRow(sourceObject, session, mapping);
        databaseRow = this.addRelationTableTargetRow(targetObject, session, databaseRow, mapping);
        return databaseRow;
    }

    public AbstractRecord buildRelationTableSourceAndTargetRow(AbstractRecord sourceRow, Object targetObject, AbstractSession session, ForeignReferenceMapping mapping) {
        AbstractRecord databaseRow = this.buildRelationTableSourceRow(sourceRow);
        databaseRow = this.addRelationTableTargetRow(targetObject, session, databaseRow, mapping);
        return databaseRow;
    }
}

