/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.descriptors.InstanceVariableAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.MethodAttributeAccessor;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XMLObjectBuilder;
import org.eclipse.persistence.internal.oxm.XPathEngine;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeCollectionMapping;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.XMLNillableMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.NullPolicy;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLCompositeCollectionMapping
extends AbstractCompositeCollectionMapping
implements XMLMapping,
XMLNillableMapping {
    AbstractNullPolicy nullPolicy = new NullPolicy();
    private AttributeAccessor containerAccessor;
    private UnmarshalKeepAsElementPolicy keepAsElementPolicy;
    private boolean isWriteOnly;

    public AttributeAccessor getContainerAccessor() {
        return this.containerAccessor;
    }

    public void setContainerAccessor(AttributeAccessor anAttributeAccessor) {
        this.containerAccessor = anAttributeAccessor;
    }

    public void setContainerAttributeName(String attributeName) {
        if (attributeName != null) {
            if (this.getContainerAccessor() == null) {
                this.containerAccessor = new InstanceVariableAttributeAccessor();
            }
            this.getContainerAccessor().setAttributeName(attributeName);
        }
    }

    public String getContainerAttributeName() {
        if (this.getContainerAccessor() == null) {
            return null;
        }
        return this.getContainerAccessor().getAttributeName();
    }

    public void setContainerGetMethodName(String methodName) {
        if (methodName == null) {
            return;
        }
        if (this.getContainerAccessor() == null) {
            this.containerAccessor = new MethodAttributeAccessor();
        }
        if (!this.getContainerAccessor().isMethodAttributeAccessor()) {
            String attributeName = this.containerAccessor.getAttributeName();
            this.setContainerAccessor(new MethodAttributeAccessor());
            this.getContainerAccessor().setAttributeName(attributeName);
        }
        ((MethodAttributeAccessor)this.getContainerAccessor()).setGetMethodName(methodName);
    }

    public String getContainerGetMethodName() {
        if (this.getContainerAccessor() == null || !this.getContainerAccessor().isMethodAttributeAccessor()) {
            return null;
        }
        return ((MethodAttributeAccessor)this.getContainerAccessor()).getGetMethodName();
    }

    public String getContainerSetMethodName() {
        if (this.getContainerAccessor() == null || !this.getContainerAccessor().isMethodAttributeAccessor()) {
            return null;
        }
        return ((MethodAttributeAccessor)this.getContainerAccessor()).getSetMethodName();
    }

    public void setContainerSetMethodName(String methodName) {
        if (methodName == null) {
            return;
        }
        if (this.getContainerAccessor() == null) {
            this.containerAccessor = new MethodAttributeAccessor();
        }
        if (!this.getContainerAccessor().isMethodAttributeAccessor()) {
            String attributeName = this.containerAccessor.getAttributeName();
            this.setContainerAccessor(new MethodAttributeAccessor());
            this.getContainerAccessor().setAttributeName(attributeName);
        }
        ((MethodAttributeAccessor)this.getContainerAccessor()).setSetMethodName(methodName);
    }

    public boolean isXMLMapping() {
        return true;
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        if (this.getReferenceClass() == null && this.getReferenceClassName() != null) {
            this.setReferenceClass(session.getDatasourcePlatform().getConversionManager().convertClassNameToClass(this.getReferenceClassName()));
        }
        if (this.getReferenceClass() != null) {
            super.initialize(session);
        } else {
            if (this.getField() == null) {
                throw DescriptorException.fieldNameNotSetInMapping(this);
            }
            this.setField(this.getDescriptor().buildField(this.getField()));
            this.setFields(this.collectFields());
            if (this.hasConverter()) {
                this.getConverter().initialize(this, session);
            }
        }
        ContainerPolicy cp = this.getContainerPolicy();
        if (cp != null) {
            if (cp.getContainerClass() == null) {
                Class cls = session.getDatasourcePlatform().getConversionManager().convertClassNameToClass(cp.getContainerClassName());
                cp.setContainerClass(cls);
            }
            if (cp instanceof MapContainerPolicy) {
                ((MapContainerPolicy)cp).setElementClass(this.getReferenceClass());
            }
        }
        if (null != this.containerAccessor) {
            this.containerAccessor.initializeAttributes(this.referenceClass);
        }
    }

    public String getXPath() {
        return this.getField().getName();
    }

    public void setXPath(String xpathString) {
        this.setField(new XMLField(xpathString));
    }

    protected Object buildCompositeObject(ClassDescriptor descriptor, AbstractRecord nestedRow, ObjectBuildingQuery query, JoinedAttributeManager joinManger) {
        return descriptor.getObjectBuilder().buildObject(query, nestedRow, joinManger);
    }

    protected AbstractRecord buildCompositeRow(Object attributeValue, AbstractSession session, AbstractRecord parentRow) {
        ClassDescriptor classDesc = null;
        try {
            classDesc = this.getReferenceDescriptor(attributeValue, session);
        }
        catch (Exception e) {
            // empty catch block
        }
        XMLField xmlFld = (XMLField)this.getField();
        if (xmlFld.hasLastXPathFragment() && xmlFld.getLastXPathFragment().hasLeafElementType()) {
            XMLRecord xmlRec = (XMLRecord)parentRow;
            xmlRec.setLeafElementType(xmlFld.getLastXPathFragment().getLeafElementType());
        }
        XMLRecord parent = (XMLRecord)parentRow;
        if (classDesc != null) {
            XMLObjectBuilder objectBuilder = (XMLObjectBuilder)classDesc.getObjectBuilder();
            boolean addXsiType = this.shouldAddXsiType((XMLRecord)parentRow, classDesc);
            XMLRecord child = (XMLRecord)objectBuilder.createRecordFor(attributeValue, (XMLField)this.getField(), parent, this);
            child.setNamespaceResolver(parent.getNamespaceResolver());
            objectBuilder.buildIntoNestedRow(child, attributeValue, session, addXsiType);
            return child;
        }
        if (attributeValue instanceof Element && this.getKeepAsElementPolicy() == UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT) {
            return new DOMRecord((Element)attributeValue);
        }
        Node newNode = XPathEngine.getInstance().create((XMLField)this.getField(), parent.getDOM(), attributeValue, session);
        DOMRecord newRow = new DOMRecord(newNode);
        return newRow;
    }

    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session) throws DescriptorException {
        if (this.isReadOnly()) {
            return;
        }
        Object attributeValue = this.getAttributeValueFromObject(object);
        if (attributeValue == null) {
            row.put(this.getField(), (Object)null);
            return;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Vector<AbstractRecord> nestedRows = new Vector<AbstractRecord>(cp.sizeFor(attributeValue));
        Object iter = cp.iteratorFor(attributeValue);
        while (cp.hasNext(iter)) {
            Object element = cp.next(iter, session);
            if (this.hasConverter()) {
                element = this.getConverter() instanceof XMLConverter ? ((XMLConverter)this.getConverter()).convertObjectValueToDataValue(element, session, ((XMLRecord)row).getMarshaller()) : this.getConverter().convertObjectValueToDataValue(element, session);
            }
            nestedRows.addElement(this.buildCompositeRow(element, session, row));
        }
        Object fieldValue = null;
        if (!nestedRows.isEmpty()) {
            fieldValue = this.getDescriptor().buildFieldValueFromNestedRows(nestedRows, this.getStructureName(), session);
        }
        row.put(this.getField(), fieldValue);
    }

    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) throws DatabaseException {
        ContainerPolicy cp = this.getContainerPolicy();
        Object fieldValue = row.getValues(this.getField());
        if (fieldValue == null || fieldValue instanceof String) {
            return cp.containerInstance();
        }
        Vector nestedRows = this.getDescriptor().buildNestedRowsFromFieldValue(fieldValue, executionSession);
        if (nestedRows == null) {
            return cp.containerInstance();
        }
        Object result = cp.containerInstance(nestedRows.size());
        Enumeration stream = nestedRows.elements();
        while (stream.hasMoreElements()) {
            AbstractRecord nestedRow = (AbstractRecord)stream.nextElement();
            Object objectToAdd = null;
            ClassDescriptor aDescriptor = this.getReferenceDescriptor((DOMRecord)nestedRow);
            if (aDescriptor == null) {
                if (this.getKeepAsElementPolicy() == UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT || this.getKeepAsElementPolicy() == UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT) {
                    XMLPlatformFactory.getInstance().getXMLPlatform().namespaceQualifyFragment((Element)((DOMRecord)nestedRow).getDOM());
                    objectToAdd = ((DOMRecord)nestedRow).getDOM();
                    if (this.getConverter() != null) {
                        objectToAdd = this.getConverter() instanceof XMLConverter ? ((XMLConverter)this.getConverter()).convertDataValueToObjectValue(objectToAdd, executionSession, ((XMLRecord)nestedRow).getUnmarshaller()) : this.getConverter().convertDataValueToObjectValue(objectToAdd, executionSession);
                    }
                    objectToAdd = this.convertToSimpleTypeIfPresent(objectToAdd, nestedRow, executionSession);
                } else {
                    NodeList children = ((Element)((DOMRecord)nestedRow).getDOM()).getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        Node nextNode = children.item(i);
                        if (nextNode.getNodeType() != 1) continue;
                        throw XMLMarshalException.noDescriptorFound(this);
                    }
                    objectToAdd = this.convertToSimpleTypeIfPresent(objectToAdd, nestedRow, executionSession);
                }
            } else {
                if (aDescriptor.hasInheritance()) {
                    QName leafElementType;
                    Class newElementClass = aDescriptor.getInheritancePolicy().classFromRow(nestedRow, executionSession);
                    if (newElementClass == null && (leafElementType = ((XMLField)this.getField()).getLeafElementType()) != null) {
                        Object indicator = aDescriptor.getInheritancePolicy().getClassIndicatorMapping().get(leafElementType);
                        if (indicator == null) {
                            throw DescriptorException.missingClassForIndicatorFieldValue(leafElementType, aDescriptor.getInheritancePolicy().getDescriptor());
                        }
                        newElementClass = (Class)indicator;
                    }
                    if (newElementClass != null) {
                        aDescriptor = this.getReferenceDescriptor(newElementClass, executionSession);
                    } else if (Modifier.isAbstract(aDescriptor.getJavaClass().getModifiers())) {
                        throw DescriptorException.missingClassIndicatorField(nestedRow, aDescriptor.getInheritancePolicy().getDescriptor());
                    }
                }
                objectToAdd = this.buildCompositeObject(aDescriptor, nestedRow, sourceQuery, joinManager);
                if (this.hasConverter()) {
                    objectToAdd = this.getConverter() instanceof XMLConverter ? ((XMLConverter)this.getConverter()).convertDataValueToObjectValue(objectToAdd, executionSession, ((XMLRecord)nestedRow).getUnmarshaller()) : this.getConverter().convertDataValueToObjectValue(objectToAdd, executionSession);
                }
            }
            cp.addInto(objectToAdd, result, sourceQuery.getSession());
            if (null == this.containerAccessor) continue;
            this.containerAccessor.setAttributeValueInObject(objectToAdd, ((DOMRecord)nestedRow).getOwningObject());
        }
        return result;
    }

    private Object convertToSimpleTypeIfPresent(Object objectToAdd, AbstractRecord nestedRow, AbstractSession executionSession) {
        String stringValue = null;
        Element theElement = (Element)((DOMRecord)nestedRow).getDOM();
        Node textchild = theElement.getFirstChild();
        if (textchild != null && textchild.getNodeType() == 3 && (stringValue = ((Text)textchild).getNodeValue()) != null && this.getKeepAsElementPolicy() != UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT && this.getKeepAsElementPolicy() != UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT) {
            objectToAdd = stringValue;
        }
        if (stringValue == null || stringValue.equals("")) {
            return objectToAdd;
        }
        String type = theElement.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (null != type && !type.equals("")) {
            XPathFragment typeFragment = new XPathFragment(type);
            String namespaceURI = ((DOMRecord)nestedRow).resolveNamespacePrefix(typeFragment.getPrefix());
            typeFragment.setNamespaceURI(namespaceURI);
            QName schemaTypeQName = new QName(namespaceURI, typeFragment.getLocalName());
            Class theClass = (Class)XMLConversionManager.getDefaultXMLTypes().get(schemaTypeQName);
            if (theClass != null) {
                objectToAdd = ((XMLConversionManager)executionSession.getDatasourcePlatform().getConversionManager()).convertObject(stringValue, theClass, schemaTypeQName);
            }
        }
        return objectToAdd;
    }

    public ClassDescriptor getReferenceDescriptor(DOMRecord xmlRecord) {
        ClassDescriptor returnDescriptor = this.referenceDescriptor;
        if (returnDescriptor == null) {
            String type = ((Element)xmlRecord.getDOM()).getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
            if (null != type && !type.equals("")) {
                XPathFragment typeFragment = new XPathFragment(type);
                String namespaceURI = xmlRecord.resolveNamespacePrefix(typeFragment.getPrefix());
                typeFragment.setNamespaceURI(namespaceURI);
                returnDescriptor = xmlRecord.getUnmarshaller().getXMLContext().getDescriptorByGlobalType(typeFragment);
            } else {
                QName leafType = ((XMLField)this.getField()).getLastXPathFragment().getLeafElementType();
                if (leafType != null) {
                    XPathFragment frag = new XPathFragment();
                    String xpath = leafType.getLocalPart();
                    String uri = leafType.getNamespaceURI();
                    if (uri != null && !uri.equals("")) {
                        frag.setNamespaceURI(uri);
                        String prefix = ((XMLDescriptor)this.getDescriptor()).getNonNullNamespaceResolver().resolveNamespaceURI(uri);
                        if (prefix != null && !prefix.equals("")) {
                            xpath = prefix + ":" + xpath;
                        }
                    }
                    frag.setXPath(xpath);
                    returnDescriptor = xmlRecord.getUnmarshaller().getXMLContext().getDescriptorByGlobalType(frag);
                }
            }
        }
        return returnDescriptor;
    }

    protected ClassDescriptor getReferenceDescriptor(Class theClass, AbstractSession session) {
        if (this.getReferenceDescriptor() != null && this.getReferenceDescriptor().getJavaClass().equals(theClass)) {
            return this.getReferenceDescriptor();
        }
        ClassDescriptor subDescriptor = session.getDescriptor(theClass);
        if (subDescriptor == null && this.getKeepAsElementPolicy() != UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT) {
            throw DescriptorException.noSubClassMatch(theClass, this);
        }
        return subDescriptor;
    }

    public boolean shouldAddXsiType(XMLRecord record, ClassDescriptor descriptor) {
        XMLDescriptor xmlDescriptor = (XMLDescriptor)descriptor;
        if (this.getReferenceDescriptor() == null && xmlDescriptor.getSchemaReference() != null) {
            XMLField indicatorField;
            if (descriptor.hasInheritance() && (indicatorField = (XMLField)descriptor.getInheritancePolicy().getClassIndicatorField()).getLastXPathFragment().getNamespaceURI() != null && indicatorField.getLastXPathFragment().getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema-instance") && indicatorField.getLastXPathFragment().getLocalName().equals("type")) {
                return false;
            }
            XMLSchemaReference xmlRef = xmlDescriptor.getSchemaReference();
            if (xmlRef.getType() == 1 && xmlRef.isGlobalDefinition()) {
                QName ctxQName = xmlRef.getSchemaContextAsQName(xmlDescriptor.getNamespaceResolver());
                QName leafType = ((XMLField)this.getField()).getLeafElementType();
                if (leafType == null || !ctxQName.equals(record.getLeafElementType())) {
                    return true;
                }
            }
        }
        return false;
    }

    public void writeSingleValue(Object value, Object parent, XMLRecord record, AbstractSession session) {
        Object element = value;
        if (this.hasConverter()) {
            element = this.getConverter() instanceof XMLConverter ? ((XMLConverter)this.getConverter()).convertObjectValueToDataValue(element, session, record.getMarshaller()) : this.getConverter().convertObjectValueToDataValue(element, session);
        }
        XMLRecord nestedRow = (XMLRecord)this.buildCompositeRow(element, session, record);
        record.add(this.getField(), nestedRow);
    }

    public void setNullPolicy(AbstractNullPolicy aNullPolicy) {
        this.nullPolicy = aNullPolicy;
    }

    public AbstractNullPolicy getNullPolicy() {
        return this.nullPolicy;
    }

    public UnmarshalKeepAsElementPolicy getKeepAsElementPolicy() {
        return this.keepAsElementPolicy;
    }

    public void setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy keepAsElementPolicy) {
        this.keepAsElementPolicy = keepAsElementPolicy;
    }

    protected XMLDescriptor getDescriptor(XMLRecord xmlRecord, AbstractSession session, QName rootQName) throws XMLMarshalException {
        XMLContext xmlContext;
        XMLDescriptor xmlDescriptor;
        if (rootQName == null) {
            rootQName = new QName(xmlRecord.getNamespaceURI(), xmlRecord.getLocalName());
        }
        if (null == (xmlDescriptor = (xmlContext = xmlRecord.getUnmarshaller().getXMLContext()).getDescriptor(rootQName)) && this.getKeepAsElementPolicy() != UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT && this.getKeepAsElementPolicy() != UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT) {
            throw XMLMarshalException.noDescriptorWithMatchingRootElement(xmlRecord.getLocalName());
        }
        return xmlDescriptor;
    }

    public boolean isWriteOnly() {
        return this.isWriteOnly;
    }

    public void setIsWriteOnly(boolean b) {
        this.isWriteOnly = b;
    }

    public void preInitialize(AbstractSession session) throws DescriptorException {
        this.getAttributeAccessor().setIsWriteOnly(this.isWriteOnly());
        this.getAttributeAccessor().setIsReadOnly(this.isReadOnly());
        super.preInitialize(session);
    }

    public void setAttributeValueInObject(Object object, Object value) throws DescriptorException {
        if (this.isWriteOnly()) {
            return;
        }
        super.setAttributeValueInObject(object, value);
    }
}

