/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.platform.database.oracle.publisher.PublisherException;
import org.eclipse.persistence.platform.database.oracle.publisher.Util;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlCollectionType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlPackageType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlReflector;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.TypeClass;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ElemInfo;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.PlsqlElemHelper;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.PlsqlElemInfo;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ViewCache;
import org.eclipse.persistence.platform.database.oracle.publisher.visit.PublisherVisitor;

public class PlsqlTableType
extends SqlCollectionType {
    public static final int NUMBER_OF_DETAILS = 3;
    public static final int DETAILS_TYPE_LENGTH = 0;
    public static final int DETAILS_TYPE_PRECISION = 1;
    public static final int DETAILS_TYPE_SCALE = 2;
    private ElemInfo m_elemInfo;

    public PlsqlTableType(SqlName sqlName, int typeCode, ElemInfo elemInfo, SqlType elemType, int[] details, boolean generateMe, SqlType parentType, SqlReflector reflector) {
        super(sqlName, typeCode, generateMe, parentType, reflector);
        this.m_elemInfo = elemInfo;
        this.m_elementType = elemType;
        this.m_elemTypeLength = details[0];
        this.m_elemTypePrecision = details[1];
        this.m_elemTypeScale = details[2];
    }

    @Override
    protected ElemInfo getElemInfo() {
        return this.m_elemInfo;
    }

    public static ElemInfo getElemInfo(String _schema, String _typeName, String packageName, String methodName, String methodNo, ViewCache viewCache) throws SQLException {
        String schema = Util.getSchema(_schema, _typeName);
        String typeName = Util.getType(_schema, _typeName);
        if (typeName.indexOf(46) >= 0) {
            typeName = typeName.substring(typeName.indexOf(46) + 1);
        }
        Vector rowV = new Vector();
        Iterator iter = packageName != null && packageName.length() > 0 ? viewCache.getRows("ALL_ARGUMENTS", new String[0], new String[]{"PACKAGE_NAME", "OBJECT_NAME", "OVERLOAD"}, new Object[]{packageName, methodName, methodNo}, new String[]{"SEQUENCE"}) : viewCache.getRows("ALL_ARGUMENTS", new String[0], new String[0], new Object[0], new String[0]);
        PlsqlElemHelper[] info = PlsqlElemHelper.getPlsqlElemHelper(iter);
        int i0 = 0;
        int i1 = -1;
        for (i0 = 1; i0 < info.length - 1; ++i0) {
            if (schema == null || !schema.equals(info[i0].typeOwner) || typeName == null || !typeName.equals(info[i0].typeSubname)) continue;
            if (info[i0 - 1].sequence == info[i0].sequence + 1 && info[i0 - 1].dataLevel == info[i0].dataLevel + 1 && info[i0 - 1].objectName.equals(info[i0].objectName) && (info[i0 - 1].overload == info[i0].overload || info[i0 - 1].overload != null && info[i0 - 1].overload.equals(info[i0].overload))) {
                i1 = i0 - 1;
                break;
            }
            if (info[i0 + 1].sequence != info[i0].sequence + 1 || info[i0 + 1].dataLevel != info[i0].dataLevel + 1 || !info[i0 + 1].objectName.equals(info[i0].objectName) || info[i0 - 1].overload != info[i0].overload && (info[i0 - 1].overload == null || !info[i0 - 1].overload.equals(info[i0].overload))) continue;
            i1 = i0 + 1;
            break;
        }
        if (i1 == -1) {
            i0 = 0;
            if (schema != null && schema.equals(info[i0].typeOwner) && typeName != null && typeName.equals(info[i0].typeSubname)) {
                i1 = 1;
            }
            i0 = info.length - 1;
            if (schema != null && schema.equals(info[i0].typeOwner) && typeName != null && typeName.equals(info[i0].typeSubname)) {
                i1 = i0 - 1;
            }
        }
        if (i1 >= info.length || i1 < 0) {
            throw new SQLException("Error reflecting element type for collection type " + typeName);
        }
        PlsqlElemInfo peti = new PlsqlElemInfo(info[i1]);
        return peti;
    }

    @Override
    public TypeClass getComponentType() {
        return this.m_elementType;
    }

    static TypeClass getComponentType(ElemInfo elemInfo, SqlReflector reflector, SqlType parentType, int[] details) throws SQLException, PublisherException {
        SqlType result;
        block2: {
            result = null;
            try {
                PlsqlElemInfo info = null;
                info = (PlsqlElemInfo)elemInfo;
                String elemTypeName = info.elemTypeName;
                String elemSchemaName = info.elemTypeOwner;
                String elemTypeMod = info.elemTypeMod;
                String elemPackageName = info.elemTypePackageName;
                String elemMethodName = info.elemTypeMethodName;
                String elemMethodNo = info.elemTypeMethodNo;
                int elemTypeSequence = info.elemTypeSequence;
                details[0] = info.elemTypeLength;
                details[1] = info.elemTypePrecision;
                details[2] = info.elemTypeScale;
                result = reflector.addPlsqlDBType(elemSchemaName, elemTypeName, null, elemTypeMod, false, elemPackageName, elemMethodName, elemMethodNo, elemTypeSequence, parentType);
            }
            catch (SQLException e) {
                System.err.println(e.getMessage());
                if (result != null) break block2;
                result = SqlReflector.UNKNOWN_TYPE;
            }
        }
        return result;
    }

    private static String getIndexType(SqlName sqlName, ViewCache viewCache) throws SQLException {
        return "NUMBER";
    }

    public static SqlType newInstance(SqlName sqlName, int typeCode, ElemInfo elemInfo, SqlType elemType, int[] details, boolean generateMe, SqlType parentType, boolean isGrandparent, SqlReflector reflector) throws SQLException, PublisherException {
        if (parentType != null && !isGrandparent && parentType != null && parentType instanceof SqlPackageType && typeCode == -14) {
            String indexType = PlsqlTableType.getIndexType(sqlName, reflector.getViewCache());
        }
        return new PlsqlTableType(sqlName, typeCode, elemInfo, elemType, details, generateMe, parentType, reflector);
    }

    @Override
    public void accept(PublisherVisitor v) {
        v.visit(this);
    }
}

