/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.eclipse.persistence.jaxb.javamodel.Helper;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaHasAnnotations;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.xmlmodel.XmlJavaTypeAdapter;

public class Property {
    private String propertyName;
    private QName schemaName;
    private boolean isMethodProperty;
    private QName schemaType;
    private boolean isSwaAttachmentRef;
    private boolean isMtomAttachment;
    private String mimeType;
    private JavaClass type;
    private JavaClass adapterClass;
    private JavaHasAnnotations element;
    private JavaClass genericType;
    private boolean isAttribute = false;
    private Helper helper;
    private String getMethodName;
    private String setMethodName;
    private boolean isRequired = false;
    private boolean isNillable = false;
    private boolean isTransient;
    private String defaultValue;
    private boolean isMixedContent = false;
    private boolean xmlElementType;
    private JavaClass originalType;
    private XmlJavaTypeAdapter xmlJavaTypeAdapter;

    public Property() {
        this.xmlElementType = false;
    }

    public Property(Helper helper) {
        this.helper = helper;
        this.xmlElementType = false;
    }

    public void setHelper(Helper helper) {
        this.helper = helper;
    }

    public void setAdapterClass(Class adapterCls) {
        this.setAdapterClass(this.helper.getJavaClass(adapterCls));
    }

    public void setAdapterClass(JavaClass adapterCls) {
        this.adapterClass = adapterCls;
        JavaClass newType = this.helper.getJavaClass(Object.class);
        for (JavaMethod method : this.adapterClass.getDeclaredMethods()) {
            if (!method.getName().equals("marshal")) continue;
            newType = method.getReturnType();
            break;
        }
        this.setType(newType);
    }

    public JavaHasAnnotations getElement() {
        return this.element;
    }

    public void setElement(JavaHasAnnotations element) {
        this.element = element;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public QName getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(QName schemaName) {
        this.schemaName = schemaName;
    }

    public boolean isMethodProperty() {
        return this.isMethodProperty;
    }

    public void setMethodProperty(boolean isMethod) {
        this.isMethodProperty = isMethod;
    }

    public void setType(JavaClass cls) {
        if (cls == null) {
            return;
        }
        if (this.type != null && this.type == cls) {
            return;
        }
        String clsName = cls.getRawName();
        if (this.type != null && this.isCollectionType(this.type)) {
            this.genericType = cls;
        } else if (this.isCollectionType(cls)) {
            if (cls.hasActualTypeArguments()) {
                ArrayList typeArgs = (ArrayList)cls.getActualTypeArguments();
                this.genericType = (JavaClass)typeArgs.get(0);
            } else {
                this.genericType = this.helper.getJavaClass(Object.class);
            }
            this.type = cls;
        } else if (cls.isArray() && !clsName.equals("byte[]") && !clsName.equals("java.lang.Byte[]")) {
            this.type = cls;
            this.genericType = cls.getComponentType();
        } else {
            this.type = cls;
        }
    }

    public JavaClass getType() {
        return this.type;
    }

    public JavaClass getGenericType() {
        return this.genericType;
    }

    public void setGenericType(JavaClass genericType) {
        this.genericType = genericType;
    }

    public QName getSchemaType() {
        return this.schemaType;
    }

    public void setSchemaType(QName type) {
        this.schemaType = type;
    }

    public boolean isSwaAttachmentRef() {
        return this.isSwaAttachmentRef;
    }

    public void setIsSwaAttachmentRef(boolean b) {
        this.isSwaAttachmentRef = b;
    }

    public boolean isMtomAttachment() {
        return this.isMtomAttachment;
    }

    public void setIsMtomAttachment(boolean b) {
        this.isMtomAttachment = b;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public void setIsRequired(boolean b) {
        this.isRequired = b;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mType) {
        this.mimeType = mType;
    }

    public boolean isAttribute() {
        return this.isAttribute;
    }

    public void setIsAttribute(boolean attribute) {
        this.isAttribute = attribute;
    }

    public String getGetMethodName() {
        return this.getMethodName;
    }

    public void setGetMethodName(String methodName) {
        this.getMethodName = methodName;
    }

    public String getSetMethodName() {
        return this.setMethodName;
    }

    public void setSetMethodName(String methodName) {
        this.setMethodName = methodName;
    }

    public boolean isChoice() {
        return false;
    }

    public boolean isAny() {
        return false;
    }

    public boolean isReference() {
        return false;
    }

    public boolean isNillable() {
        return this.isNillable;
    }

    public void setNillable(boolean isNillable) {
        this.isNillable = isNillable;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isSetDefaultValue() {
        return this.defaultValue != null;
    }

    public boolean isMixedContent() {
        return this.isMixedContent;
    }

    public void setMixedContent(boolean b) {
        this.isMixedContent = b;
    }

    public void setHasXmlElementType(boolean hasXmlElementType) {
        this.xmlElementType = hasXmlElementType;
    }

    public boolean isXmlElementType() {
        return this.xmlElementType;
    }

    public boolean isCollectionType(JavaClass type) {
        return this.helper.getJavaClass(Collection.class).isAssignableFrom(type) || this.helper.getJavaClass(List.class).isAssignableFrom(type) || this.helper.getJavaClass(Set.class).isAssignableFrom(type);
    }

    public JavaClass getActualType() {
        if (this.genericType != null) {
            return this.genericType;
        }
        return this.type;
    }

    public JavaClass getOriginalType() {
        return this.originalType;
    }

    public void setOriginalType(JavaClass type) {
        this.originalType = type;
    }

    public boolean isSetXmlJavaTypeAdapter() {
        return this.getXmlJavaTypeAdapter() != null;
    }

    public XmlJavaTypeAdapter getXmlJavaTypeAdapter() {
        return this.xmlJavaTypeAdapter;
    }

    public void setXmlJavaTypeAdapter(XmlJavaTypeAdapter xmlJavaTypeAdapter) {
        this.xmlJavaTypeAdapter = xmlJavaTypeAdapter;
        this.setAdapterClass(this.helper.getJavaClass(xmlJavaTypeAdapter.getValue()));
    }
}

