/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.helper.HelperContext;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.CodeVisitor;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.eclipse.persistence.sdo.helper.extension.SDOUtil;

public class DynamicClassWriter {
    private static final String START_PROPERTY_INDEX = "START_PROPERTY_INDEX";
    private static final String END_PROPERTY_INDEX = "END_PROPERTY_INDEX";
    private static final String GET = "get";
    private static final String SET = "set";
    private static final String LIST = "List";
    private static final String WRITE_REPLACE = "writeReplace";
    private Class parentClass;
    private String typeImplClassDescriptor;
    private SDOType type;
    private Integer startPropertyIndex;
    private HelperContext aHelperContext;

    public DynamicClassWriter(String className, SDOType type, HelperContext aContext) {
        this.aHelperContext = aContext;
        this.parentClass = SDODataObject.class;
        this.typeImplClassDescriptor = className.replace('.', '/');
        this.type = type;
        this.initializeParentClass();
        if (type.isSubType()) {
            try {
                Field parentEndPropertyIndexField = PrivilegedAccessHelper.getField((Class)this.parentClass, (String)END_PROPERTY_INDEX, (boolean)true);
                Integer parentEndPropertyIndex = (Integer)PrivilegedAccessHelper.getValueFromField((Field)parentEndPropertyIndexField, (Object)this.parentClass);
                this.startPropertyIndex = parentEndPropertyIndex + 1;
            }
            catch (NoSuchFieldException e) {
                this.startPropertyIndex = new Integer(0);
            }
            catch (IllegalAccessException e) {
                this.startPropertyIndex = new Integer(0);
            }
        } else {
            this.startPropertyIndex = new Integer(0);
        }
    }

    private void initializeParentClass() {
        if (this.type.isSubType()) {
            SDOType parentSDOType = (SDOType)this.type.getBaseTypes().get(0);
            String parentClassName = parentSDOType.getInstanceClassName() + "Impl";
            try {
                this.parentClass = ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getLoader().loadClass(parentClassName, parentSDOType);
            }
            catch (Exception e) {
                this.parentClass = null;
            }
            if (this.parentClass == null) {
                this.parentClass = SDODataObject.class;
            }
        } else {
            this.parentClass = SDODataObject.class;
        }
    }

    public Class getParentClass() {
        return this.parentClass;
    }

    public byte[] createClass() {
        ClassWriter cw = new ClassWriter(false);
        if (null == this.type.getInstanceClass()) {
            cw.visit(49, 33, this.typeImplClassDescriptor, Type.getType((Class)this.parentClass).getInternalName(), null, null);
        } else {
            String[] interfaces = new String[]{this.type.getInstanceClassName().replace('.', '/')};
            cw.visit(49, 33, this.typeImplClassDescriptor, Type.getType((Class)this.parentClass).getInternalName(), interfaces, null);
            this.addPropertyIndices(cw);
            for (Object object : this.type.getDeclaredProperties()) {
                SDOProperty sdoProperty = (SDOProperty)object;
                this.addPropertyGetMethod(cw, sdoProperty);
                this.addPropertySetMethod(cw, sdoProperty);
            }
        }
        this.addConstructors(cw);
        this.addWriteReplace(cw);
        cw.visitEnd();
        return cw.toByteArray();
    }

    private void addPropertyIndices(ClassWriter cw) {
        cw.visitField(25, START_PROPERTY_INDEX, "I", (Object)this.startPropertyIndex, null);
        int declaredPropsSize = this.type.getDeclaredProperties().size();
        Integer endPropertyIndex = declaredPropsSize > 0 ? Integer.valueOf(this.startPropertyIndex + declaredPropsSize - 2) : Integer.valueOf(this.startPropertyIndex - 1);
        cw.visitField(25, END_PROPERTY_INDEX, "I", (Object)endPropertyIndex, null);
    }

    private void addConstructors(ClassWriter cw) {
        CodeVisitor mv = cw.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), new String[]{Type.getInternalName(Serializable.class)}, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getType((Class)this.parentClass).getInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]));
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
    }

    private void addPropertyGetMethod(ClassWriter cw, SDOProperty property) {
        String returnType = SDOUtil.getJavaTypeForProperty(property);
        String outerGetMethodName = SDOUtil.getMethodName(property.getName(), returnType);
        String propertyInstanceClassDescriptor = property.isMany() ? Type.getDescriptor(List.class) : (property.getType().isDataType() ? Type.getDescriptor((Class)property.getType().getInstanceClass()) : "L" + returnType.replace('.', '/') + ";");
        CodeVisitor mv = cw.visitMethod(1, outerGetMethodName, "()" + propertyInstanceClassDescriptor, null, null);
        mv.visitVarInsn(25, 0);
        mv.visitIntInsn(16, this.startPropertyIndex + property.getIndexInType());
        String builtIn = SDOUtil.getBuiltInType(returnType);
        if (null != builtIn) {
            if (property.getType().isDataType() && !builtIn.equals(LIST)) {
                mv.visitMethodInsn(182, this.typeImplClassDescriptor, GET + builtIn, "(I)" + propertyInstanceClassDescriptor);
                int iReturnOpcode = Type.getType((Class)property.getType().getInstanceClass()).getOpcode(172);
                mv.visitInsn(iReturnOpcode);
            } else {
                mv.visitMethodInsn(182, this.typeImplClassDescriptor, GET, "(I)Ljava/lang/Object;");
                mv.visitInsn(176);
            }
        } else {
            mv.visitMethodInsn(182, this.typeImplClassDescriptor, GET, "(I)Ljava/lang/Object;");
            mv.visitInsn(176);
        }
        mv.visitMaxs(2, 1);
    }

    private void addPropertySetMethod(ClassWriter cw, SDOProperty property) {
        String returnType = SDOUtil.getJavaTypeForProperty(property);
        String outerSetMethodName = SDOUtil.setMethodName(property.getName());
        String propertyInstanceClassDescriptor = property.isMany() ? Type.getDescriptor(List.class) : (property.getType().isDataType() ? Type.getDescriptor((Class)property.getType().getInstanceClass()) : "L" + returnType.replace('.', '/') + ";");
        CodeVisitor mv = cw.visitMethod(1, outerSetMethodName, "(" + propertyInstanceClassDescriptor + ")V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitIntInsn(16, this.startPropertyIndex + property.getIndexInType());
        String builtIn = SDOUtil.getBuiltInType(returnType);
        int iLoadOpcode = 25;
        if (null != builtIn) {
            if (property.getType().isDataType() && !builtIn.equals(LIST)) {
                iLoadOpcode = Type.getType((Class)property.getType().getInstanceClass()).getOpcode(21);
                mv.visitVarInsn(iLoadOpcode, 1);
                mv.visitMethodInsn(182, this.typeImplClassDescriptor, SET + builtIn, "(I" + propertyInstanceClassDescriptor + ")V");
            } else {
                mv.visitVarInsn(iLoadOpcode, 1);
                mv.visitMethodInsn(182, this.typeImplClassDescriptor, SET, "(ILjava/lang/Object;)V");
            }
        } else {
            mv.visitVarInsn(iLoadOpcode, 1);
            mv.visitMethodInsn(182, this.typeImplClassDescriptor, SET, "(ILjava/lang/Object;)V");
        }
        mv.visitInsn(177);
        if (iLoadOpcode == 24 || iLoadOpcode == 22) {
            mv.visitMaxs(4, 3);
        } else {
            mv.visitMaxs(3, 2);
        }
    }

    private void addWriteReplace(ClassWriter cw) {
        Method method;
        try {
            method = this.parentClass.getDeclaredMethod(WRITE_REPLACE, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return;
        }
        CodeVisitor mv = cw.visitMethod(4, method.getName(), Type.getMethodDescriptor((Method)method), new String[]{Type.getInternalName(ObjectStreamException.class)}, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getInternalName((Class)this.parentClass), method.getName(), Type.getMethodDescriptor((Method)method));
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
    }
}

