/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.eclipse.persistence.jaxb.compiler.AnnotationsProcessor;
import org.eclipse.persistence.jaxb.compiler.NamespaceInfo;
import org.eclipse.persistence.jaxb.compiler.Property;
import org.eclipse.persistence.jaxb.compiler.TypeInfo;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaModelInput;
import org.eclipse.persistence.jaxb.xmlmodel.JavaAttribute;
import org.eclipse.persistence.jaxb.xmlmodel.JavaType;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAnyAttribute;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAnyElement;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAttribute;
import org.eclipse.persistence.jaxb.xmlmodel.XmlBindings;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElement;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElementRef;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElementRefs;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElements;
import org.eclipse.persistence.jaxb.xmlmodel.XmlJavaTypeAdapter;
import org.eclipse.persistence.jaxb.xmlmodel.XmlNsForm;
import org.eclipse.persistence.jaxb.xmlmodel.XmlSchema;
import org.eclipse.persistence.jaxb.xmlmodel.XmlTransient;
import org.eclipse.persistence.jaxb.xmlmodel.XmlValue;
import org.eclipse.persistence.oxm.NamespaceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLProcessor {
    private Map<String, XmlBindings> xmlBindingMap;
    private JavaModelInput jModelInput;
    private AnnotationsProcessor aProcessor;

    public XMLProcessor(Map<String, XmlBindings> bindings) {
        this.xmlBindingMap = bindings;
    }

    public void processXML(AnnotationsProcessor annotationsProcessor, JavaModelInput jModelInput) {
        this.jModelInput = jModelInput;
        this.aProcessor = annotationsProcessor;
        annotationsProcessor.init();
        Map<String, ArrayList<JavaClass>> pkgToClassMap = this.buildPackageToJavaClassMap();
        for (String packageName : this.xmlBindingMap.keySet()) {
            ArrayList<JavaClass> classesToProcess = pkgToClassMap.get(packageName);
            if (classesToProcess == null) continue;
            XmlBindings xmlBindings = this.xmlBindingMap.get(packageName);
            NamespaceInfo nsInfo = this.processXmlSchema(xmlBindings, packageName);
            if (nsInfo != null) {
                annotationsProcessor.addPackageToNamespaceMapping(packageName, nsInfo);
            }
            JavaClass[] javaClasses = classesToProcess.toArray(new JavaClass[classesToProcess.size()]);
            Map<String, TypeInfo> typeInfoMap = annotationsProcessor.preBuildTypeInfo(javaClasses);
            nsInfo = annotationsProcessor.getPackageToNamespaceMappings().get(packageName);
            XmlBindings.JavaTypes jTypes = xmlBindings.getJavaTypes();
            if (jTypes != null) {
                for (JavaType javaType : jTypes.getJavaType()) {
                    TypeInfo info = typeInfoMap.get(javaType.getName());
                    if (javaType.getXmlJavaTypeAdapter() != null) {
                        info.setXmlJavaTypeAdapter(javaType.getXmlJavaTypeAdapter());
                    }
                    if (javaType.isSetXmlAccessorOrder()) {
                        info.setXmlAccessOrder(javaType.getXmlAccessorOrder());
                    } else if (!info.isSetXmlAccessOrder()) {
                        if (xmlBindings.isSetXmlAccessorOrder()) {
                            info.setXmlAccessOrder(xmlBindings.getXmlAccessorOrder());
                        } else {
                            info.setXmlAccessOrder(nsInfo.getAccessOrder());
                        }
                    }
                    if (javaType.isSetXmlAccessorType()) {
                        info.setXmlAccessType(javaType.getXmlAccessorType());
                    } else if (!info.isSetXmlAccessType()) {
                        if (xmlBindings.isSetXmlAccessorType()) {
                            info.setXmlAccessType(xmlBindings.getXmlAccessorType());
                        } else {
                            info.setXmlAccessType(nsInfo.getAccessType());
                        }
                    }
                    if (javaType.isSetXmlTransient()) {
                        info.setXmlTransient(javaType.isXmlTransient());
                    }
                    if (javaType.getXmlRootElement() != null) {
                        info.setXmlRootElement(javaType.getXmlRootElement());
                    }
                    if (javaType.getXmlSeeAlso() != null && javaType.getXmlSeeAlso().size() > 0) {
                        info.setXmlSeeAlso(javaType.getXmlSeeAlso());
                    }
                    if (javaType.getXmlType() != null) {
                        info.setXmlType(javaType.getXmlType());
                    }
                    if (javaType.getXmlCustomizer() == null) continue;
                    info.setXmlCustomizer(javaType.getXmlCustomizer());
                }
            }
            if (xmlBindings.getXmlJavaTypeAdapters() != null) {
                Map<String, TypeInfo> typeInfos = this.aProcessor.getTypeInfosForPackage(packageName);
                for (TypeInfo tInfo : typeInfos.values()) {
                    List<XmlJavaTypeAdapter> adapters = xmlBindings.getXmlJavaTypeAdapters().getXmlJavaTypeAdapter();
                    for (XmlJavaTypeAdapter xja : adapters) {
                        JavaClass adapterClass = jModelInput.getJavaModel().getClass(xja.getValue());
                        JavaClass boundType = jModelInput.getJavaModel().getClass(xja.getType());
                        if (boundType == null) continue;
                        tInfo.addAdapterClass(adapterClass, boundType);
                    }
                }
            }
            javaClasses = annotationsProcessor.postBuildTypeInfo(javaClasses);
            annotationsProcessor.processJavaClasses(javaClasses);
            Map<String, TypeInfo> typeInfosForPackage = annotationsProcessor.getTypeInfosForPackage(packageName);
            jTypes = xmlBindings.getJavaTypes();
            if (jTypes != null) {
                for (JavaType javaType : jTypes.getJavaType()) {
                    TypeInfo typeInfo = typeInfosForPackage.get(javaType.getName());
                    if (javaType == null) continue;
                    this.processJavaType(javaType, typeInfo, nsInfo);
                }
            }
            pkgToClassMap.remove(packageName);
        }
        for (ArrayList<JavaClass> jClassList : pkgToClassMap.values()) {
            JavaClass[] jClassArray = jClassList.toArray(new JavaClass[jClassList.size()]);
            annotationsProcessor.buildNewTypeInfo(jClassArray);
            annotationsProcessor.processJavaClasses(jClassArray);
        }
        Map typeInfos = (Map)this.aProcessor.getTypeInfo().clone();
        for (String key : typeInfos.keySet()) {
            TypeInfo tInfo = (TypeInfo)typeInfos.get(key);
            for (Property prop : tInfo.getPropertyList()) {
                if (!prop.isSetXmlJavaTypeAdapter()) continue;
                JavaClass[] jClassArray = new JavaClass[]{prop.getActualType()};
                this.aProcessor.buildNewTypeInfo(jClassArray);
            }
        }
    }

    private void processJavaType(JavaType javaType, TypeInfo typeInfo, NamespaceInfo nsInfo) {
        if (null != javaType.getJavaAttributes()) {
            for (JAXBElement<? extends JavaAttribute> jaxbElement : javaType.getJavaAttributes().getJavaAttribute()) {
                JavaAttribute javaAttribute = (JavaAttribute)jaxbElement.getValue();
                Property oldProperty = typeInfo.getProperties().get(javaAttribute.getJavaAttribute());
                if (oldProperty == null) continue;
                Property newProperty = this.processJavaAttribute(javaAttribute, oldProperty, nsInfo);
                typeInfo.getProperties().put(javaAttribute.getJavaAttribute(), newProperty);
            }
        }
    }

    private Property processJavaAttribute(JavaAttribute javaAttribute, Property oldProperty, NamespaceInfo nsInfo) {
        if (javaAttribute instanceof XmlAnyAttribute) {
            return this.processXmlAnyAttribute((XmlAnyAttribute)javaAttribute, oldProperty);
        }
        if (javaAttribute instanceof XmlAnyElement) {
            return this.processXmlAnyElement((XmlAnyElement)javaAttribute, oldProperty);
        }
        if (javaAttribute instanceof XmlAttribute) {
            return this.processXmlAttribute((XmlAttribute)javaAttribute, oldProperty, nsInfo);
        }
        if (javaAttribute instanceof XmlElement) {
            return this.processXmlElement((XmlElement)javaAttribute, oldProperty, nsInfo);
        }
        if (javaAttribute instanceof XmlElements) {
            return this.processXmlElements((XmlElements)javaAttribute, oldProperty);
        }
        if (javaAttribute instanceof XmlElementRef) {
            return this.processXmlElementRef((XmlElementRef)javaAttribute, oldProperty);
        }
        if (javaAttribute instanceof XmlElementRefs) {
            return this.processXmlElementRefs((XmlElementRefs)javaAttribute, oldProperty);
        }
        if (javaAttribute instanceof XmlTransient) {
            return this.processXmlTransient((XmlTransient)javaAttribute, oldProperty);
        }
        if (javaAttribute instanceof XmlValue) {
            return this.processXmlValue((XmlValue)javaAttribute, oldProperty);
        }
        if (javaAttribute instanceof XmlJavaTypeAdapter) {
            return this.processXmlJavaTypeAdapter((XmlJavaTypeAdapter)javaAttribute, oldProperty);
        }
        return null;
    }

    private Property processXmlJavaTypeAdapter(XmlJavaTypeAdapter xmlAdapter, Property oldProperty) {
        oldProperty.setXmlJavaTypeAdapter(xmlAdapter);
        return oldProperty;
    }

    private Property processXmlAnyAttribute(XmlAnyAttribute xmlAnyAttribute, Property oldProperty) {
        return oldProperty;
    }

    private Property processXmlAnyElement(XmlAnyElement xmlAnyElement, Property oldProperty) {
        return oldProperty;
    }

    private Property processXmlAttribute(XmlAttribute xmlAttribute, Property oldProperty, NamespaceInfo nsInfo) {
        oldProperty.setIsAttribute(true);
        oldProperty.setIsRequired(xmlAttribute.isRequired());
        String name = xmlAttribute.getName();
        if (name.equals("##default")) {
            name = oldProperty.getPropertyName();
        }
        QName qName = xmlAttribute.getNamespace().equals("##default") ? (nsInfo.isElementFormQualified() ? new QName(nsInfo.getNamespace(), name) : new QName(name)) : new QName(xmlAttribute.getNamespace(), name);
        oldProperty.setSchemaName(qName);
        return oldProperty;
    }

    private Property processXmlElement(XmlElement xmlElement, Property oldProperty, NamespaceInfo nsInfo) {
        oldProperty.setIsRequired(xmlElement.isRequired());
        oldProperty.setNillable(xmlElement.isNillable());
        if (xmlElement.getDefaultValue().equals("\u0000")) {
            oldProperty.setDefaultValue(null);
        } else {
            oldProperty.setDefaultValue(xmlElement.getDefaultValue());
        }
        String name = xmlElement.getName();
        if (name.equals("##default")) {
            name = oldProperty.getPropertyName();
        }
        QName qName = xmlElement.getNamespace().equals("##default") ? (nsInfo.isElementFormQualified() ? new QName(nsInfo.getNamespace(), name) : new QName(name)) : new QName(xmlElement.getNamespace(), name);
        oldProperty.setSchemaName(qName);
        if (xmlElement.getType().equals("javax.xml.bind.annotation.XmlElement.DEFAULT")) {
            if (oldProperty.isXmlElementType()) {
                oldProperty.setType(oldProperty.getOriginalType());
            }
        } else {
            oldProperty.setType(this.jModelInput.getJavaModel().getClass(xmlElement.getType()));
        }
        return oldProperty;
    }

    private Property processXmlElements(XmlElements xmlElements, Property oldProperty) {
        return oldProperty;
    }

    private Property processXmlElementRef(XmlElementRef xmlElementRef, Property oldProperty) {
        return oldProperty;
    }

    private Property processXmlElementRefs(XmlElementRefs xmlElementRefs, Property oldProperty) {
        return oldProperty;
    }

    private Property processXmlTransient(XmlTransient xmlTransient, Property oldProperty) {
        oldProperty.setTransient(true);
        return oldProperty;
    }

    private Property processXmlValue(XmlValue xmlValue, Property oldProperty) {
        return oldProperty;
    }

    private NamespaceInfo processXmlSchema(XmlBindings xmlBindings, String packageName) {
        XmlSchema schema = xmlBindings.getXmlSchema();
        if (schema == null) {
            return null;
        }
        NamespaceInfo nsInfo = new NamespaceInfo();
        XmlNsForm form = schema.getAttributeFormDefault();
        nsInfo.setAttributeFormQualified(form.equals((Object)XmlNsForm.QUALIFIED));
        form = schema.getElementFormDefault();
        nsInfo.setElementFormQualified(form.equals((Object)XmlNsForm.QUALIFIED));
        nsInfo.setLocation(schema.getLocation() == null ? "##generate" : schema.getLocation());
        nsInfo.setNamespace(schema.getNamespace() == null ? "" : schema.getNamespace());
        NamespaceResolver nsr = new NamespaceResolver();
        for (XmlSchema.XmlNs xmlns : schema.getXmlNs()) {
            nsr.put(xmlns.getPrefix(), xmlns.getNamespaceUri());
        }
        nsInfo.setNamespaceResolver(nsr);
        return nsInfo;
    }

    private JavaClass[] getClassesToProcess(XmlBindings xmlBindings) {
        ArrayList<JavaClass> allClasses = new ArrayList<JavaClass>();
        XmlBindings.JavaTypes jTypes = xmlBindings.getJavaTypes();
        if (jTypes != null) {
            for (JavaType javaType : jTypes.getJavaType()) {
                allClasses.add(this.jModelInput.getJavaModel().getClass(javaType.getName()));
            }
        }
        for (JavaClass jClass : this.jModelInput.getJavaClasses()) {
            if (AnnotationsProcessor.classExistsInArray(jClass.getQualifiedName(), allClasses)) continue;
            allClasses.add(jClass);
        }
        return allClasses.toArray(new JavaClass[allClasses.size()]);
    }

    private Map<String, ArrayList<JavaClass>> buildPackageToJavaClassMap() {
        HashMap<String, ArrayList<JavaClass>> theMap = new HashMap<String, ArrayList<JavaClass>>();
        for (String packageName : this.xmlBindingMap.keySet()) {
            XmlBindings xmlBindings = this.xmlBindingMap.get(packageName);
            ArrayList<JavaClass> classes = new ArrayList<JavaClass>();
            XmlBindings.JavaTypes jTypes = xmlBindings.getJavaTypes();
            if (jTypes != null) {
                for (JavaType javaType : jTypes.getJavaType()) {
                    classes.add(this.jModelInput.getJavaModel().getClass(javaType.getName()));
                }
            }
            theMap.put(packageName, classes);
        }
        for (JavaClass jClass : this.jModelInput.getJavaClasses()) {
            String pkg = jClass.getPackageName();
            ArrayList existingClasses = (ArrayList)theMap.get(pkg);
            if (existingClasses != null) {
                if (AnnotationsProcessor.classExistsInArray(jClass.getQualifiedName(), existingClasses)) continue;
                existingClasses.add(jClass);
                continue;
            }
            ArrayList<JavaClass> classes = new ArrayList<JavaClass>();
            classes.add(jClass);
            theMap.put(pkg, classes);
        }
        return theMap;
    }
}

