/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment.osgi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.exceptions.EntityManagerSetupException;
import org.eclipse.persistence.internal.jpa.deployment.JPAInitializer;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceInitializationHelper;
import org.eclipse.persistence.internal.jpa.deployment.osgi.BundleProxyClassLoader;
import org.eclipse.persistence.internal.jpa.deployment.osgi.CompositeClassLoader;
import org.eclipse.persistence.internal.jpa.deployment.osgi.OSGiInitializer;
import org.eclipse.persistence.internal.localization.LoggingLocalization;
import org.eclipse.persistence.jpa.osgi.Activator;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class OSGiPersistenceInitializationHelper
extends PersistenceInitializationHelper {
    private String initializerClassName = null;
    public static final String EQUINOX_INITIALIZER_NAME = "org.eclipse.persistence.internal.jpa.deployment.osgi.equinox.EquinoxInitializer";
    private static final String ORG_ECLIPSE_PERSISTENCE_CORE = "org.eclipse.persistence.core";
    private static Map<String, Bundle> puToBundle = Collections.synchronizedMap(new HashMap());
    private static Map<Bundle, String[]> bundleToPUs = Collections.synchronizedMap(new HashMap());
    private Map<String, ClassLoader> puClassLoaders = new HashMap<String, ClassLoader>();

    public static void addBundle(Bundle bundle, String[] persistenceUnitNames) {
        for (int i = 0; i < persistenceUnitNames.length; ++i) {
            String name = persistenceUnitNames[i];
            puToBundle.put(name, bundle);
        }
        bundleToPUs.put(bundle, persistenceUnitNames);
    }

    public static void removeBundle(Bundle bundle) {
        String[] persistenceUnitNames = bundleToPUs.remove(bundle);
        if (persistenceUnitNames != null) {
            for (int i = 0; i < persistenceUnitNames.length; ++i) {
                String name = persistenceUnitNames[i];
                puToBundle.remove(name);
            }
        }
    }

    public OSGiPersistenceInitializationHelper(String initializerClassName) {
        this.initializerClassName = initializerClassName;
    }

    public ClassLoader getClassLoader(String persistenceUnitName, Map properties) {
        Bundle bundle;
        Object propertyValue;
        ClassLoader previouslyDefinedLoader = this.puClassLoaders.get(persistenceUnitName);
        if (previouslyDefinedLoader != null) {
            return previouslyDefinedLoader;
        }
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>();
        ClassLoader propertyClassLoader = null;
        if (properties != null && (propertyValue = properties.get("eclipselink.classloader")) != null && propertyValue instanceof ClassLoader) {
            propertyClassLoader = (ClassLoader)propertyValue;
            loaders.add(propertyClassLoader);
        }
        if ((bundle = puToBundle.get(persistenceUnitName)) != null) {
            BundleProxyClassLoader bundleClassLoader = new BundleProxyClassLoader(bundle);
            loaders.add(bundleClassLoader);
        }
        if (propertyClassLoader == null && bundle == null) {
            throw EntityManagerSetupException.couldNotFindPersistenceUnitBundle((String)persistenceUnitName);
        }
        BundleContext context = Activator.getContext();
        if (context != null) {
            Bundle[] bundles = context.getBundles();
            Bundle coreBundle = null;
            for (int i = 0; i < bundles.length; ++i) {
                if (!ORG_ECLIPSE_PERSISTENCE_CORE.equals(bundles[i].getSymbolicName())) continue;
                coreBundle = bundles[i];
                loaders.add(new BundleProxyClassLoader(coreBundle));
                break;
            }
            BundleProxyClassLoader eclipseLinkJpaClassLoader = new BundleProxyClassLoader(context.getBundle());
            loaders.add(eclipseLinkJpaClassLoader);
        }
        ClassLoader puClassLoader = null;
        puClassLoader = loaders.size() == 1 && loaders.get(0) == propertyClassLoader ? propertyClassLoader : new CompositeClassLoader(loaders);
        this.puClassLoaders.put(persistenceUnitName, puClassLoader);
        return puClassLoader;
    }

    public JPAInitializer getInitializer(ClassLoader classLoader, Map m) {
        if (this.initializerClassName != null) {
            try {
                Class<?> initializerClass = Class.forName(this.initializerClassName);
                Class[] argTypes = new Class[]{ClassLoader.class, Map.class, PersistenceInitializationHelper.class};
                Object[] args = new Object[]{classLoader, m, this};
                JPAInitializer initializer = (JPAInitializer)initializerClass.getConstructor(argTypes).newInstance(args);
                return initializer;
            }
            catch (Exception e) {
                AbstractSessionLog.getLog().log(1, LoggingLocalization.buildMessage((String)"osgi_initializer_failed", (Object[])new Object[]{this.initializerClassName, e}));
            }
        }
        return new OSGiInitializer(classLoader);
    }

    public static boolean includesBundle(Bundle bundle) {
        return bundleToPUs.containsKey(bundle);
    }
}

