/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.modelgen.objects;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.jpa.modelgen.MetadataMirrorFactory;
import org.eclipse.persistence.internal.jpa.modelgen.objects.PersistenceUnit;
import org.eclipse.persistence.internal.jpa.modelgen.objects.PersistenceXML;
import org.eclipse.persistence.internal.jpa.modelgen.objects.PersistenceXMLMappings;
import org.eclipse.persistence.oxm.XMLContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitReader {
    protected List<PersistenceUnit> m_persistenceUnits = new ArrayList<PersistenceUnit>();

    public PersistenceUnitReader(MetadataMirrorFactory factory, String persistenceXMLPath) throws IOException {
        FileObject fileObject;
        if (persistenceXMLPath == null) {
            factory.getProcessingEnvironment().getMessager().printMessage(Diagnostic.Kind.NOTE, "Reading default META_INF/persistence xml");
            fileObject = PersistenceUnitReader.getFileObject("META-INF/persistence.xml", factory.getProcessingEnvironment());
        } else {
            String persistenceXMLLocation = (persistenceXMLPath = persistenceXMLPath.replace("\\", "/")).endsWith("/") ? persistenceXMLPath + "persistence.xml" : persistenceXMLPath + "/persistence.xml";
            factory.getProcessingEnvironment().getMessager().printMessage(Diagnostic.Kind.NOTE, "Reading specified persistence xml off class path: " + persistenceXMLLocation);
            fileObject = PersistenceUnitReader.getFileObject(persistenceXMLLocation, StandardLocation.CLASS_PATH, factory.getProcessingEnvironment());
            if (fileObject == null) {
                factory.getProcessingEnvironment().getMessager().printMessage(Diagnostic.Kind.NOTE, "Reading specified persistence xml off src path: " + persistenceXMLLocation);
                fileObject = PersistenceUnitReader.getFileObject(persistenceXMLLocation, StandardLocation.SOURCE_PATH, factory.getProcessingEnvironment());
                if (fileObject == null) {
                    factory.getProcessingEnvironment().getMessager().printMessage(Diagnostic.Kind.NOTE, "Reading specified persistence xml off annotation processor path: " + persistenceXMLLocation);
                    fileObject = PersistenceUnitReader.getFileObject(persistenceXMLLocation, StandardLocation.ANNOTATION_PROCESSOR_PATH, factory.getProcessingEnvironment());
                    if (fileObject == null && fileObject == null) {
                        factory.getProcessingEnvironment().getMessager().printMessage(Diagnostic.Kind.NOTE, "Reading specified persistence xml off platform class path: " + persistenceXMLLocation);
                        fileObject = PersistenceUnitReader.getFileObject(persistenceXMLLocation, StandardLocation.PLATFORM_CLASS_PATH, factory.getProcessingEnvironment());
                    }
                }
            }
        }
        if (fileObject != null) {
            InputStream in = fileObject.openInputStream();
            XMLContext context = PersistenceXMLMappings.createXMLContext();
            PersistenceXML persistenceXML = (PersistenceXML)context.createUnmarshaller().unmarshal(in);
            in.close();
            if (!persistenceXML.getVersion().equals("1.0")) {
                for (SEPersistenceUnitInfo puInfo : persistenceXML.getPersistenceUnitInfos()) {
                    this.m_persistenceUnits.add(new PersistenceUnit(puInfo, factory));
                }
            }
        }
    }

    public static FileObject getFileObject(String filename, ProcessingEnvironment processingEnv) {
        return PersistenceUnitReader.getFileObject(filename, StandardLocation.CLASS_OUTPUT, processingEnv);
    }

    public static FileObject getFileObject(String filename, StandardLocation standardLocation, ProcessingEnvironment processingEnv) {
        FileObject fileObject = null;
        try {
            fileObject = processingEnv.getFiler().getResource(standardLocation, "", filename);
        }
        catch (Exception e) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "File was not found: " + filename);
            return null;
        }
        return fileObject;
    }

    public List<PersistenceUnit> getPersistenceUnits() {
        return this.m_persistenceUnits;
    }
}

