/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record.namespaces;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.persistence.internal.oxm.record.namespaces.UnmarshalNamespaceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackUnmarshalNamespaceResolver
implements UnmarshalNamespaceResolver {
    private Map<String, Stack<String>> namespaceMap;
    private Map<String, Stack<String>> uriToPrefixMap;

    @Override
    public String getPrefix(String namespaceURI) {
        Stack<String> prefixStack;
        String prefix = null;
        if (null == prefix && null != this.uriToPrefixMap && (prefixStack = this.uriToPrefixMap.get(namespaceURI)) != null && prefixStack.size() > 0) {
            prefix = prefixStack.peek();
        }
        return prefix;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        Stack<String> uriStack;
        String namespaceURI = null;
        if (prefix == null) {
            prefix = "";
        }
        if (null != this.namespaceMap && (uriStack = this.namespaceMap.get(prefix)) != null && uriStack.size() > 0) {
            namespaceURI = uriStack.peek();
        }
        return namespaceURI;
    }

    @Override
    public void pop(String prefix) {
        Stack<String> prefixStack;
        if (null == this.namespaceMap) {
            return;
        }
        Stack<String> uriStack = this.namespaceMap.get(prefix);
        String uri = null;
        if (uriStack != null && uriStack.size() > 0) {
            uri = uriStack.pop();
        }
        if (uri != null && this.uriToPrefixMap != null && (prefixStack = this.uriToPrefixMap.get(uri)) != null && prefixStack.size() > 0) {
            prefixStack.pop();
        }
    }

    @Override
    public void push(String prefix, String namespaceURI) {
        Stack<String> uriStack;
        if (null == this.namespaceMap) {
            this.namespaceMap = new HashMap<String, Stack<String>>();
        }
        if (this.uriToPrefixMap == null) {
            this.uriToPrefixMap = new HashMap<String, Stack<String>>();
        }
        if ((uriStack = this.namespaceMap.get(prefix)) == null) {
            uriStack = new Stack();
            this.namespaceMap.put(prefix, uriStack);
        }
        uriStack.push(namespaceURI);
        Stack<String> prefixStack = this.uriToPrefixMap.get(namespaceURI);
        if (prefixStack == null) {
            prefixStack = new Stack();
            this.uriToPrefixMap.put(namespaceURI, prefixStack);
        }
        prefixStack.push(prefix);
    }

    @Override
    public Set<String> getPrefixes() {
        if (null == this.namespaceMap) {
            return Collections.EMPTY_SET;
        }
        return this.namespaceMap.keySet();
    }
}

