/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classloader;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassNotFoundException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classloader.CLExternalClassDescription;
import org.eclipse.persistence.tools.workbench.utility.Classpath;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

abstract class AbstractCLExternalClassRepository
implements ExternalClassRepository {
    private Map classDescriptions;
    private ClassLoader classLoader;
    private final Map arrayClassDescriptions = new HashMap();

    AbstractCLExternalClassRepository() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalClassDescription getClassDescription(String className) {
        AbstractCLExternalClassRepository abstractCLExternalClassRepository = this;
        synchronized (abstractCLExternalClassRepository) {
            if (this.classDescriptions == null) {
                this.classDescriptions = this.buildClassDescriptions();
            }
        }
        return (ExternalClassDescription)this.classDescriptions.get(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalClassDescription[] getClassDescriptions() {
        AbstractCLExternalClassRepository abstractCLExternalClassRepository = this;
        synchronized (abstractCLExternalClassRepository) {
            if (this.classDescriptions == null) {
                this.classDescriptions = this.buildClassDescriptions();
            }
        }
        return this.classDescriptions.values().toArray(new ExternalClassDescription[this.classDescriptions.size()]);
    }

    abstract Map buildClassDescriptions();

    ExternalClassDescription getClassDescriptionFor(Class javaClass) {
        if (javaClass.isArray()) {
            return this.getArrayClassDescriptionFor(javaClass);
        }
        ExternalClassDescription classDescription = (ExternalClassDescription)this.classDescriptions.get(javaClass.getName());
        if (classDescription == null) {
            throw new IllegalStateException();
        }
        return classDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExternalClassDescription getArrayClassDescriptionFor(Class javaClass) {
        Map map = this.arrayClassDescriptions;
        synchronized (map) {
            ExternalClassDescription result = (ExternalClassDescription)this.arrayClassDescriptions.get(javaClass);
            if (result == null) {
                result = new CLExternalClassDescription(javaClass.getName(), this);
                this.arrayClassDescriptions.put(javaClass, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class loadClass(String className) throws ExternalClassNotFoundException {
        AbstractCLExternalClassRepository abstractCLExternalClassRepository = this;
        synchronized (abstractCLExternalClassRepository) {
            if (this.classLoader == null) {
                this.classLoader = this.buildClassLoader();
            }
        }
        try {
            return Class.forName(className, false, this.classLoader);
        }
        catch (Throwable t) {
            throw new ExternalClassNotFoundException(className, t);
        }
    }

    abstract ClassLoader buildClassLoader();

    void addClassDescriptionsFromClasspathTo(Classpath classpath, Map map) {
        Classpath.Entry[] entries = classpath.getEntries();
        int len = entries.length;
        for (int i = 0; i < len; ++i) {
            this.addClassDescriptionsFromClasspathEntryTo(entries[i], map);
        }
    }

    private void addClassDescriptionsFromClasspathEntryTo(Classpath.Entry entry, Map map) {
        Iterator stream = entry.classNamesStream();
        while (stream.hasNext()) {
            String name = (String)stream.next();
            if (map.containsKey(name)) continue;
            map.put(name, new CLExternalClassDescription(name, entry.canonicalFileName(), this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addClassDescriptionsTo(Map map) {
        AbstractCLExternalClassRepository abstractCLExternalClassRepository = this;
        synchronized (abstractCLExternalClassRepository) {
            if (this.classDescriptions == null) {
                this.classDescriptions = this.buildClassDescriptions();
            }
        }
        for (Map.Entry entry : this.classDescriptions.entrySet()) {
            if (map.containsKey(entry.getKey())) continue;
            map.put(entry.getKey(), entry.getValue());
        }
    }

    public String toString() {
        String moreInfo = this.classDescriptions == null ? "uninitialized" : String.valueOf(this.classDescriptions.size()) + " types";
        return StringTools.buildToStringFor(this, moreInfo);
    }
}

