/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetField;
import org.eclipse.persistence.internal.security.PrivilegedGetMethod;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Helper
implements Serializable {
    protected static boolean shouldOptimizeDates = false;
    protected static final Object nullWrapper = new Helper();
    protected static Queue<Calendar> calendarCache = Helper.initCalendarCache();
    protected static TimeZone defaultTimeZone = TimeZone.getDefault();
    protected static String CR = null;
    public static String SPACE = " ";
    public static String INDENT = "  ";
    public static String NL = "\n";
    protected static String PATH_SEPARATOR = null;
    protected static String FILE_SEPARATOR = null;
    protected static String CURRENT_WORKING_DIRECTORY = null;
    protected static String TEMP_DIRECTORY = null;
    public static boolean isZeroValidPrimaryKey = false;
    public static final String IS_PROPERTY_METHOD_PREFIX = "is";
    public static final String GET_PROPERTY_METHOD_PREFIX = "get";
    public static final String SET_PROPERTY_METHOD_PREFIX = "set";
    public static final String SET_IS_PROPERTY_METHOD_PREFIX = "setIs";
    public static final int POSITION_AFTER_IS_PREFIX = "is".length();
    public static final int POSITION_AFTER_GET_PREFIX = "get".length();
    public static final String DEFAULT_DATABASE_DELIMITER = "\"";
    private static String defaultStartDatabaseDelimiter = null;
    private static String defaultEndDatabaseDelimiter = null;

    public static boolean shouldOptimizeDates() {
        return shouldOptimizeDates;
    }

    public static void setShouldOptimizeDates(boolean value) {
        shouldOptimizeDates = value;
    }

    public static Queue<Calendar> getCalendarCache() {
        return calendarCache;
    }

    public static Queue initCalendarCache() {
        ConcurrentLinkedQueue<Calendar> calendarCache = new ConcurrentLinkedQueue<Calendar>();
        for (int index = 0; index < 10; ++index) {
            calendarCache.add(Calendar.getInstance());
        }
        return calendarCache;
    }

    public static Calendar allocateCalendar() {
        Calendar calendar = Helper.getCalendarCache().poll();
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        return calendar;
    }

    public static TimeZone getDefaultTimeZone() {
        return defaultTimeZone;
    }

    public static void releaseCalendar(Calendar calendar) {
        Helper.getCalendarCache().offer(calendar);
    }

    public static void addAllToVector(Vector theVector, Vector elementsToAdd) {
        Enumeration stream = elementsToAdd.elements();
        while (stream.hasMoreElements()) {
            theVector.addElement(stream.nextElement());
        }
    }

    public static void addAllToVector(Vector theVector, List elementsToAdd) {
        theVector.addAll(elementsToAdd);
    }

    public static Vector addAllUniqueToVector(Vector theVector, Vector elementsToAdd) {
        Enumeration stream = elementsToAdd.elements();
        while (stream.hasMoreElements()) {
            Object element = stream.nextElement();
            if (theVector.contains(element)) continue;
            theVector.addElement(element);
        }
        return theVector;
    }

    public static Object[] arrayFromVector(Vector vector) {
        Object[] result = new Object[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            result[i] = vector.elementAt(i);
        }
        return result;
    }

    public static byte[] buildBytesFromHexString(String hex) {
        String tmpString = hex;
        if (tmpString.length() % 2 != 0) {
            throw ConversionException.couldNotConvertToByteArray(hex);
        }
        byte[] bytes = new byte[tmpString.length() / 2];
        int byteIndex = bytes.length - 1;
        int strIndex = tmpString.length() - 2;
        while (byteIndex >= 0) {
            byte digit1 = (byte)Character.digit(tmpString.charAt(strIndex), 16);
            byte digit2 = (byte)Character.digit(tmpString.charAt(strIndex + 1), 16);
            if (digit1 == -1 || digit2 == -1) {
                throw ConversionException.couldNotBeConverted(hex, ClassConstants.APBYTE);
            }
            bytes[byteIndex] = (byte)(digit1 * 16 + digit2);
            --byteIndex;
            strIndex -= 2;
        }
        return bytes;
    }

    public static Hashtable buildHashtableFromVector(Vector theVector) {
        Hashtable toReturn = new Hashtable(theVector.size());
        for (Object next : theVector) {
            toReturn.put(next, next);
        }
        return toReturn;
    }

    public static String buildHexStringFromBytes(byte[] bytes) {
        char[] hexArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuffer stringBuffer = new StringBuffer();
        for (int byteIndex = 0; byteIndex < bytes.length; ++byteIndex) {
            int tempByte = bytes[byteIndex];
            if (tempByte < 0) {
                tempByte += 256;
            }
            if ((tempByte = (int)((byte)(tempByte / 16))) > 16) {
                throw ConversionException.couldNotBeConverted(bytes, ClassConstants.STRING);
            }
            stringBuffer.append(hexArray[tempByte]);
            tempByte = bytes[byteIndex];
            if (tempByte < 0) {
                tempByte += 256;
            }
            if ((tempByte = (int)((byte)(tempByte % 16))) > 16) {
                throw ConversionException.couldNotBeConverted(bytes, ClassConstants.STRING);
            }
            stringBuffer.append(hexArray[tempByte]);
        }
        return stringBuffer.toString();
    }

    public static Vector buildVectorFromHashtableElements(Hashtable hashtable) {
        Vector vector = new Vector(hashtable.size());
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public static Vector buildVectorFromMapElements(Map map) {
        Vector vector = new Vector(map.size());
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            vector.addElement(iterator.next());
        }
        return vector;
    }

    public static Vector buildVectorFromHashtableElements(Map hashtable) {
        Vector vector = new Vector(hashtable.size());
        Iterator enumeration = hashtable.values().iterator();
        while (enumeration.hasNext()) {
            vector.addElement(enumeration.next());
        }
        return vector;
    }

    public static Calendar calendarFromUtilDate(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (date instanceof Timestamp) {
            calendar.set(14, ((Timestamp)date).getNanos() / 1000000);
        }
        return calendar;
    }

    public static boolean classImplementsInterface(Class aClass, Class anInterface) {
        int i;
        if (aClass == anInterface) {
            return true;
        }
        Class<?>[] interfaces = aClass.getInterfaces();
        for (i = 0; i < interfaces.length; ++i) {
            if (interfaces[i] != anInterface) continue;
            return true;
        }
        for (i = 0; i < interfaces.length; ++i) {
            if (!Helper.classImplementsInterface(interfaces[i], anInterface)) continue;
            return true;
        }
        Class superClass = aClass.getSuperclass();
        if (superClass == null) {
            return false;
        }
        return Helper.classImplementsInterface(superClass, anInterface);
    }

    public static boolean classIsSubclass(Class subClass, Class superClass) {
        if (superClass == null) {
            return false;
        }
        for (Class temp = subClass; temp != null; temp = temp.getSuperclass()) {
            if (temp != superClass) continue;
            return true;
        }
        return false;
    }

    public static int compareVersions(String version1, String version2) {
        return Helper.compareVersions(Helper.version(version1), Helper.version(version2));
    }

    protected static List<Integer> version(String version) {
        ArrayList<Integer> list = new ArrayList<Integer>(5);
        int iBegin = -1;
        for (int i = 0; i < version.length(); ++i) {
            char ch = version.charAt(i);
            if ('0' <= ch && ch <= '9') {
                if (iBegin != -1) continue;
                iBegin = i;
                continue;
            }
            if (iBegin == -1) break;
            String strNum = version.substring(iBegin, i);
            int num = Integer.parseInt(strNum, 10);
            list.add(num);
            iBegin = -1;
            if (ch != '.') break;
        }
        if (iBegin >= 0) {
            String strNum = version.substring(iBegin, version.length());
            int num = Integer.parseInt(strNum, 10);
            list.add(num);
        }
        return list;
    }

    protected static int compareVersions(List<Integer> list1, List<Integer> list2) {
        int n = Math.max(list1.size(), list2.size());
        int res = 0;
        for (int i = 0; i < n; ++i) {
            int l1 = 0;
            if (i < list1.size()) {
                l1 = list1.get(i);
            }
            int l2 = 0;
            if (i < list2.size()) {
                l2 = list2.get(i);
            }
            if (l1 < l2) {
                res = -1;
                break;
            }
            if (l1 <= l2) continue;
            res = 1;
            break;
        }
        return res;
    }

    public static Class getClassFromClasseName(String className, ClassLoader classLoader) {
        Class convertedClass = null;
        if (className == null) {
            return null;
        }
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    convertedClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(className, true, classLoader));
                }
                catch (PrivilegedActionException exception) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(className, exception.getException());
                }
            } else {
                convertedClass = PrivilegedAccessHelper.getClassForName(className, true, classLoader);
            }
            return convertedClass;
        }
        catch (ClassNotFoundException exc) {
            throw ValidationException.classNotFoundWhileConvertingClassNames(className, exc);
        }
    }

    public static String getComponentTypeNameFromArrayString(String aString) {
        if (aString == null || aString.length() == 0) {
            return null;
        }
        if (aString.length() > 3 && aString.startsWith("[L") & aString.endsWith(";")) {
            return aString.substring(2, aString.length() - 1);
        }
        if (aString.startsWith("[")) {
            Class<?> primitiveClass = null;
            try {
                primitiveClass = Class.forName(aString);
            }
            catch (ClassNotFoundException cnf) {
                primitiveClass = null;
            }
            if (primitiveClass != null) {
                return primitiveClass.getComponentType().getName();
            }
        }
        return null;
    }

    public static boolean compareArrays(Object[] array1, Object[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        for (int index = 0; index < array1.length; ++index) {
            if (array1[index].equals(array2[index])) continue;
            return false;
        }
        return true;
    }

    public static boolean compareBigDecimals(BigDecimal one, BigDecimal two) {
        if (one.scale() != two.scale()) {
            double doubleOne = one.doubleValue();
            double doubleTwo = two.doubleValue();
            if (doubleOne != Double.POSITIVE_INFINITY && doubleOne != Double.NEGATIVE_INFINITY && doubleTwo != Double.POSITIVE_INFINITY && doubleTwo != Double.NEGATIVE_INFINITY) {
                return doubleOne == doubleTwo;
            }
        }
        return one.equals(two);
    }

    public static boolean compareByteArrays(byte[] array1, byte[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        for (int index = 0; index < array1.length; ++index) {
            if (array1[index] == array2[index]) continue;
            return false;
        }
        return true;
    }

    public static boolean compareCharArrays(char[] array1, char[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        for (int index = 0; index < array1.length; ++index) {
            if (array1[index] == array2[index]) continue;
            return false;
        }
        return true;
    }

    public static boolean areTypesAssignable(List types1, List types2) {
        if (types1 == null || types2 == null) {
            return false;
        }
        if (types1.size() == types2.size()) {
            for (int i = 0; i < types1.size(); ++i) {
                Class type1 = (Class)types1.get(i);
                Class type2 = (Class)types2.get(i);
                if (type1 == null || type2 == null || type1.isAssignableFrom(type2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean compareHashtables(Hashtable hashtable1, Hashtable hashtable2) {
        if (hashtable1.size() != hashtable2.size()) {
            return false;
        }
        Hashtable clonedHashtable = (Hashtable)hashtable2.clone();
        Enumeration enumtr = hashtable1.elements();
        while (enumtr.hasMoreElements()) {
            Object element = enumtr.nextElement();
            if (clonedHashtable.remove(element) != null) continue;
            return false;
        }
        return clonedHashtable.isEmpty();
    }

    public static boolean compareOrderedVectors(Vector vector1, Vector vector2) {
        if (vector1 == vector2) {
            return true;
        }
        if (vector1.size() != vector2.size()) {
            return false;
        }
        for (int index = 0; index < vector1.size(); ++index) {
            Object element1 = vector1.elementAt(index);
            Object element2 = vector2.elementAt(index);
            if (!(element1 == null ? element2 != null : !element1.equals(element2))) continue;
            return false;
        }
        return true;
    }

    public static boolean comparePotentialArrays(Object firstValue, Object secondValue) {
        Class<?> firstClass = firstValue.getClass();
        Class<?> secondClass = secondValue.getClass();
        if (firstClass == ClassConstants.APBYTE && secondClass == ClassConstants.APBYTE) {
            return Helper.compareByteArrays((byte[])firstValue, (byte[])secondValue);
        }
        if (firstClass == ClassConstants.APCHAR && secondClass == ClassConstants.APCHAR) {
            return Helper.compareCharArrays((char[])firstValue, (char[])secondValue);
        }
        if (firstClass.isArray() && secondClass.isArray()) {
            return Helper.compareArrays((Object[])firstValue, (Object[])secondValue);
        }
        if (firstValue instanceof BigDecimal && secondValue instanceof BigDecimal) {
            return Helper.compareBigDecimals((BigDecimal)firstValue, (BigDecimal)secondValue);
        }
        return false;
    }

    public static boolean compareUnorderedVectors(Vector v1, Vector v2) {
        if (v1 == v2) {
            return true;
        }
        if (v1.size() != v2.size()) {
            return false;
        }
        Vector v3 = (Vector)v2.clone();
        for (int i = 0; i < v1.size(); ++i) {
            Object e1 = v1.elementAt(i);
            if (!(e1 == null ? !Helper.removeNullElement(v3) : !v3.removeElement(e1))) continue;
            return false;
        }
        return true;
    }

    public static Map concatenateMaps(Map first, Map second) {
        Object value;
        HashMap concatenation = new HashMap(first.size() + second.size() + 4);
        for (Object key : first.keySet()) {
            value = first.get(key);
            concatenation.put(key, value);
        }
        for (Object key : second.keySet()) {
            value = second.get(key);
            concatenation.put(key, value);
        }
        return concatenation;
    }

    public static Vector concatenateUniqueVectors(Vector first, Vector second) {
        NonSynchronizedVector concatenation = NonSynchronizedVector.newInstance();
        Enumeration stream = first.elements();
        while (stream.hasMoreElements()) {
            ((Vector)concatenation).addElement(stream.nextElement());
        }
        stream = second.elements();
        while (stream.hasMoreElements()) {
            Object element = stream.nextElement();
            if (concatenation.contains(element)) continue;
            ((Vector)concatenation).addElement(element);
        }
        return concatenation;
    }

    public static Vector concatenateVectors(Vector first, Vector second) {
        NonSynchronizedVector concatenation = NonSynchronizedVector.newInstance();
        Enumeration stream = first.elements();
        while (stream.hasMoreElements()) {
            ((Vector)concatenation).addElement(stream.nextElement());
        }
        stream = second.elements();
        while (stream.hasMoreElements()) {
            ((Vector)concatenation).addElement(stream.nextElement());
        }
        return concatenation;
    }

    public static Vector copyVector(Vector originalVector, int startIndex, int stopIndex) throws ValidationException {
        if (stopIndex < startIndex) {
            return NonSynchronizedVector.newInstance();
        }
        NonSynchronizedVector newVector = NonSynchronizedVector.newInstance(stopIndex - startIndex);
        for (int index = startIndex; index < stopIndex; ++index) {
            ((Vector)newVector).add(originalVector.get(index));
        }
        return newVector;
    }

    public static String cr() {
        if (CR == null) {
            CR = System.getProperty("line.separator");
        }
        return CR;
    }

    public static String currentWorkingDirectory() {
        if (CURRENT_WORKING_DIRECTORY == null) {
            CURRENT_WORKING_DIRECTORY = System.getProperty("user.dir");
        }
        return CURRENT_WORKING_DIRECTORY;
    }

    public static String tempDirectory() {
        if (TEMP_DIRECTORY == null) {
            TEMP_DIRECTORY = System.getProperty("java.io.tmpdir");
        }
        return TEMP_DIRECTORY;
    }

    public static Date dateFromLong(Long longObject) {
        return new Date(longObject);
    }

    public static Date dateFromYearMonthDate(int year, int month, int day) {
        Calendar localCalendar = Helper.allocateCalendar();
        localCalendar.clear();
        localCalendar.set(year, month, day, 0, 0, 0);
        long millis = localCalendar.getTimeInMillis();
        Date date = new Date(millis);
        Helper.releaseCalendar(localCalendar);
        return date;
    }

    public static Date dateFromString(String dateString) throws ConversionException {
        int day;
        int month;
        int year;
        StringTokenizer dateStringTokenizer;
        if (dateString.indexOf(47) != -1) {
            dateStringTokenizer = new StringTokenizer(dateString, "/");
        } else if (dateString.indexOf(45) != -1) {
            dateStringTokenizer = new StringTokenizer(dateString, "- ");
        } else {
            throw ConversionException.incorrectDateFormat(dateString);
        }
        try {
            year = Integer.parseInt(dateStringTokenizer.nextToken());
            month = Integer.parseInt(dateStringTokenizer.nextToken());
            day = Integer.parseInt(dateStringTokenizer.nextToken());
        }
        catch (NumberFormatException exception) {
            throw ConversionException.incorrectDateFormat(dateString);
        }
        return Helper.dateFromYearMonthDate(year, --month, day);
    }

    public static Date dateFromTimestamp(Timestamp timestamp) {
        return Helper.sqlDateFromUtilDate(timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doesFileExist(String fileName) {
        FileReader reader = null;
        try {
            reader = new FileReader(fileName);
        }
        catch (FileNotFoundException fnfException) {
            boolean bl;
            try {
                bl = false;
            }
            catch (Throwable throwable) {
                Helper.close(reader);
                throw throwable;
            }
            Helper.close(reader);
            return bl;
        }
        Helper.close(reader);
        return true;
    }

    public static String doubleSlashes(String path) {
        StringBuffer buffer = new StringBuffer(path.length() + 5);
        for (int index = 0; index < path.length(); ++index) {
            char charater = path.charAt(index);
            buffer.append(charater);
            if (charater != '\\') continue;
            buffer.append('\\');
        }
        return buffer.toString();
    }

    public static String extractJarNameFromURL(URL url) {
        String tempName = url.getFile();
        int start = tempName.indexOf("file:") + 5;
        int end = tempName.indexOf("!/");
        return tempName.substring(start, end);
    }

    public static String fileSeparator() {
        if (FILE_SEPARATOR == null) {
            FILE_SEPARATOR = System.getProperty("file.separator");
        }
        return FILE_SEPARATOR;
    }

    public static Field getField(Class javaClass, String fieldName) throws NoSuchFieldException {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return (Field)AccessController.doPrivileged(new PrivilegedGetField(javaClass, fieldName, true));
            }
            catch (PrivilegedActionException exception) {
                throw (NoSuchFieldException)exception.getException();
            }
        }
        return PrivilegedAccessHelper.getField(javaClass, fieldName, true);
    }

    public static Method getDeclaredMethod(Class javaClass, String methodName) throws NoSuchMethodException {
        return Helper.getDeclaredMethod(javaClass, methodName, null);
    }

    public static Method getDeclaredMethod(Class javaClass, String methodName, Class[] methodParameterTypes) throws NoSuchMethodException {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return AccessController.doPrivileged(new PrivilegedGetMethod(javaClass, methodName, methodParameterTypes, true));
            }
            catch (PrivilegedActionException pae) {
                if (pae.getCause() instanceof NoSuchMethodException) {
                    throw (NoSuchMethodException)pae.getCause();
                }
                throw (RuntimeException)pae.getCause();
            }
        }
        return PrivilegedAccessHelper.getMethod(javaClass, methodName, methodParameterTypes, true);
    }

    public static Object getInstanceFromClass(Class classFullName) {
        if (classFullName == null) {
            return null;
        }
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(classFullName));
                }
                catch (PrivilegedActionException exception) {
                    Exception throwableException = exception.getException();
                    if (throwableException instanceof InstantiationException) {
                        ValidationException exc = new ValidationException();
                        exc.setInternalException(throwableException);
                        throw exc;
                    }
                    ValidationException exc = new ValidationException();
                    exc.setInternalException(throwableException);
                    throw exc;
                }
            }
            return PrivilegedAccessHelper.newInstanceFromClass(classFullName);
        }
        catch (InstantiationException notInstantiatedException) {
            ValidationException exception = new ValidationException();
            exception.setInternalException(notInstantiatedException);
            throw exception;
        }
        catch (IllegalAccessException notAccessedException) {
            ValidationException exception = new ValidationException();
            exception.setInternalException(notAccessedException);
            throw exception;
        }
    }

    public static Object getNullWrapper() {
        return nullWrapper;
    }

    public static Class getObjectClass(Class javaClass) {
        return ConversionManager.getObjectClass(javaClass);
    }

    public static String getShortClassName(Class javaClass) {
        return Helper.getShortClassName(javaClass.getName());
    }

    public static String getShortClassName(String javaClassName) {
        return javaClassName.substring(javaClassName.lastIndexOf(46) + 1);
    }

    public static String getShortClassName(Object object) {
        return Helper.getShortClassName(object.getClass());
    }

    public static String getPackageName(Class javaClass) {
        String className = Helper.getShortClassName(javaClass);
        return javaClass.getName().substring(0, javaClass.getName().length() - (className.length() + 1));
    }

    public static String getTabs(int noOfTabs) {
        StringWriter writer = new StringWriter();
        for (int index = 0; index < noOfTabs; ++index) {
            writer.write("\t");
        }
        return writer.toString();
    }

    public static int indexOfNullElement(Vector v, int index) {
        int size = v.size();
        for (int i = index; i < size; ++i) {
            if (v.elementAt(i) != null) continue;
            return i;
        }
        return -1;
    }

    public static boolean isPrimitiveWrapper(Class classInQuestion) {
        return classInQuestion.equals(Character.class) || classInQuestion.equals(Boolean.class) || classInQuestion.equals(Byte.class) || classInQuestion.equals(Short.class) || classInQuestion.equals(Integer.class) || classInQuestion.equals(Long.class) || classInQuestion.equals(Float.class) || classInQuestion.equals(Double.class);
    }

    public static boolean isUpperCaseString(String s) {
        char[] c = s.toCharArray();
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isLowerCase(c[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isVowel(char c) {
        return c == 'A' || c == 'a' || c == 'e' || c == 'E' || c == 'i' || c == 'I' || c == 'o' || c == 'O' || c == 'u' || c == 'U';
    }

    public static File[] listFilesIn(File directory) {
        if (directory.isDirectory()) {
            return directory.listFiles();
        }
        return new File[0];
    }

    public static Vector makeVectorFromObject(Object theObject) {
        if (theObject instanceof Vector) {
            return (Vector)theObject;
        }
        if (theObject instanceof Collection) {
            Vector returnVector = new Vector(((Collection)theObject).size());
            Iterator iterator = ((Collection)theObject).iterator();
            while (iterator.hasNext()) {
                returnVector.add(iterator.next());
            }
            return returnVector;
        }
        Vector<Object> returnVector = new Vector<Object>();
        returnVector.addElement(theObject);
        return returnVector;
    }

    public static String pathSeparator() {
        if (PATH_SEPARATOR == null) {
            PATH_SEPARATOR = System.getProperty("path.separator");
        }
        return PATH_SEPARATOR;
    }

    public static String printStackTraceToString(Throwable aThrowable) {
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter((Writer)swriter, true);
        aThrowable.printStackTrace(writer);
        writer.close();
        return swriter.toString();
    }

    public static String printTimeFromMilliseconds(long milliseconds) {
        if (milliseconds > 1000L && milliseconds < 60000L) {
            return milliseconds / 1000L + "s";
        }
        if (milliseconds > 60000L) {
            return milliseconds / 60000L + "min " + Helper.printTimeFromMilliseconds(milliseconds % 60000L);
        }
        return milliseconds + "ms";
    }

    public static String printVector(Vector vector) {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("[");
        Enumeration enumtr = vector.elements();
        stringWriter.write(String.valueOf(enumtr.nextElement()));
        while (enumtr.hasMoreElements()) {
            stringWriter.write(" ");
            stringWriter.write(String.valueOf(enumtr.nextElement()));
        }
        stringWriter.write("]");
        return stringWriter.toString();
    }

    public static Hashtable rehashHashtable(Hashtable table) {
        Hashtable rehashedTable = new Hashtable(table.size() + 2);
        Enumeration values = table.elements();
        Enumeration keys = table.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = values.nextElement();
            rehashedTable.put(key, value);
        }
        return rehashedTable;
    }

    public static Map rehashMap(Map table) {
        HashMap rehashedTable = new HashMap(table.size() + 2);
        Iterator values = table.values().iterator();
        for (Object key : table.keySet()) {
            Object value = values.next();
            rehashedTable.put(key, value);
        }
        return rehashedTable;
    }

    public static String removeAllButAlphaNumericToFit(String s1, int maximumStringLength) {
        int s1Index;
        int s1Size = s1.length();
        if (s1Size <= maximumStringLength) {
            return s1;
        }
        StringBuffer buf = new StringBuffer();
        int numberOfCharsToBeRemoved = s1.length() - maximumStringLength;
        for (s1Index = 0; numberOfCharsToBeRemoved > 0 && s1Index < s1Size; ++s1Index) {
            char currentChar = s1.charAt(s1Index);
            if (Character.isLetterOrDigit(currentChar)) {
                buf.append(currentChar);
                continue;
            }
            --numberOfCharsToBeRemoved;
        }
        while (s1Index < s1Size) {
            buf.append(s1.charAt(s1Index));
            ++s1Index;
        }
        return buf.toString();
    }

    public static String removeCharacterToFit(String s1, char aChar, int maximumStringLength) {
        int s1Index;
        int s1Size = s1.length();
        if (s1Size <= maximumStringLength) {
            return s1;
        }
        StringBuffer buf = new StringBuffer();
        int numberOfCharsToBeRemoved = s1.length() - maximumStringLength;
        for (s1Index = 0; numberOfCharsToBeRemoved > 0 && s1Index < s1Size; ++s1Index) {
            char currentChar = s1.charAt(s1Index);
            if (currentChar == aChar) {
                --numberOfCharsToBeRemoved;
                continue;
            }
            buf.append(currentChar);
        }
        while (s1Index < s1Size) {
            buf.append(s1.charAt(s1Index));
            ++s1Index;
        }
        return buf.toString();
    }

    public static boolean removeNullElement(Vector v) {
        int indexOfNull = Helper.indexOfNullElement(v, 0);
        if (indexOfNull != -1) {
            v.removeElementAt(indexOfNull);
            return true;
        }
        return false;
    }

    public static String removeVowels(String s1) {
        StringBuffer buf = new StringBuffer();
        int s1Size = s1.length();
        for (int s1Index = 0; s1Index < s1Size; ++s1Index) {
            char currentChar = s1.charAt(s1Index);
            if (Helper.isVowel(currentChar)) continue;
            buf.append(currentChar);
        }
        return buf.toString();
    }

    public static String replaceFirstSubString(String source, String subString, String replacement) {
        int index = source.indexOf(subString);
        if (index >= 0) {
            return source.substring(0, index) + replacement + source.substring(index + subString.length());
        }
        return null;
    }

    public static Vector reverseVector(Vector theVector) {
        Vector tempVector = new Vector(theVector.size());
        for (int i = theVector.size() - 1; i > -1; --i) {
            Object currentElement = theVector.elementAt(i);
            tempVector.addElement(currentElement);
        }
        return tempVector;
    }

    public static String rightTrimString(String originalString) {
        int len;
        for (len = originalString.length(); len > 0 && originalString.charAt(len - 1) <= ' '; --len) {
        }
        return originalString.substring(0, len);
    }

    public static String shortenStringsByRemovingVowelsToFit(String s1, String s2, int maximumStringLength) {
        int size = s1.length() + s2.length();
        if (size <= maximumStringLength) {
            return s1 + s2;
        }
        int s1Size = s1.length();
        int s2Size = s2.length();
        StringBuffer buf1 = new StringBuffer();
        StringBuffer buf2 = new StringBuffer();
        int numberOfCharsToBeRemoved = size - maximumStringLength;
        int s1Index = 0;
        int s2Index = 0;
        int modulo2 = 0;
        while (numberOfCharsToBeRemoved > 0 && (s1Index < s1Size || s2Index < s2Size)) {
            if (modulo2 % 2 == 0) {
                if (s1Index < s1Size) {
                    if (Helper.isVowel(s1.charAt(s1Index))) {
                        --numberOfCharsToBeRemoved;
                    } else {
                        buf1.append(s1.charAt(s1Index));
                    }
                    ++s1Index;
                }
            } else if (s2Index < s2Size) {
                if (Helper.isVowel(s2.charAt(s2Index))) {
                    --numberOfCharsToBeRemoved;
                } else {
                    buf2.append(s2.charAt(s2Index));
                }
                ++s2Index;
            }
            ++modulo2;
        }
        while (s1Index < s1Size) {
            buf1.append(s1.charAt(s1Index));
            ++s1Index;
        }
        while (s2Index < s2Size) {
            buf2.append(s2.charAt(s2Index));
            ++s2Index;
        }
        return buf1.toString() + buf2.toString();
    }

    public static Date sqlDateFromUtilDate(java.util.Date utilDate) {
        Calendar calendar = Helper.allocateCalendar();
        calendar.setTime(utilDate);
        Date date = Helper.dateFromCalendar(calendar);
        Helper.releaseCalendar(calendar);
        return date;
    }

    public static String printDate(Date date) {
        Calendar calendar = Helper.allocateCalendar();
        calendar.setTime(date);
        String string = Helper.printDate(calendar);
        Helper.releaseCalendar(calendar);
        return string;
    }

    public static String printDate(Calendar calendar) {
        return Helper.printDate(calendar, true);
    }

    public static String printDate(Calendar calendar, boolean useLocalTime) {
        int day;
        int month;
        int year;
        if (useLocalTime && !defaultTimeZone.equals(calendar.getTimeZone())) {
            Calendar localCalendar = Helper.allocateCalendar();
            localCalendar.setTimeInMillis(calendar.getTimeInMillis());
            year = localCalendar.get(1);
            month = localCalendar.get(2) + 1;
            day = localCalendar.get(5);
            Helper.releaseCalendar(localCalendar);
        } else {
            year = calendar.get(1);
            month = calendar.get(2) + 1;
            day = calendar.get(5);
        }
        char[] buf = "2000-00-00".toCharArray();
        buf[0] = Character.forDigit(year / 1000, 10);
        buf[1] = Character.forDigit(year / 100 % 10, 10);
        buf[2] = Character.forDigit(year / 10 % 10, 10);
        buf[3] = Character.forDigit(year % 10, 10);
        buf[5] = Character.forDigit(month / 10, 10);
        buf[6] = Character.forDigit(month % 10, 10);
        buf[8] = Character.forDigit(day / 10, 10);
        buf[9] = Character.forDigit(day % 10, 10);
        return new String(buf);
    }

    public static String printTime(Time time) {
        Calendar calendar = Helper.allocateCalendar();
        calendar.setTime(time);
        String string = Helper.printTime(calendar);
        Helper.releaseCalendar(calendar);
        return string;
    }

    public static String printTime(Calendar calendar) {
        return Helper.printTime(calendar, true);
    }

    public static String printTime(Calendar calendar, boolean useLocalTime) {
        int second;
        int minute;
        int hour;
        if (useLocalTime && !defaultTimeZone.equals(calendar.getTimeZone())) {
            Calendar localCalendar = Helper.allocateCalendar();
            localCalendar.setTimeInMillis(calendar.getTimeInMillis());
            hour = localCalendar.get(11);
            minute = localCalendar.get(12);
            second = localCalendar.get(13);
            Helper.releaseCalendar(localCalendar);
        } else {
            hour = calendar.get(11);
            minute = calendar.get(12);
            second = calendar.get(13);
        }
        String hourString = hour < 10 ? "0" + hour : Integer.toString(hour);
        String minuteString = minute < 10 ? "0" + minute : Integer.toString(minute);
        String secondString = second < 10 ? "0" + second : Integer.toString(second);
        return hourString + ":" + minuteString + ":" + secondString;
    }

    public static String printCalendar(Calendar calendar) {
        return Helper.printCalendar(calendar, true);
    }

    public static String printCalendar(Calendar calendar, boolean useLocalTime) {
        String millisString = calendar.get(14) == 0 ? "0" : Helper.buildZeroPrefixAndTruncTrailZeros(calendar.get(14), 3);
        StringBuffer timestampBuf = new StringBuffer();
        timestampBuf.append(Helper.printDate(calendar, useLocalTime));
        timestampBuf.append(" ");
        timestampBuf.append(Helper.printTime(calendar, useLocalTime));
        timestampBuf.append(".");
        timestampBuf.append(millisString);
        return timestampBuf.toString();
    }

    public static String printTimestamp(Timestamp timestamp) {
        Calendar calendar = Helper.allocateCalendar();
        calendar.setTime(timestamp);
        String nanosString = timestamp.getNanos() == 0 ? "0" : Helper.buildZeroPrefixAndTruncTrailZeros(timestamp.getNanos(), 9);
        StringBuffer timestampBuf = new StringBuffer();
        timestampBuf.append(Helper.printDate(calendar));
        timestampBuf.append(" ");
        timestampBuf.append(Helper.printTime(calendar));
        timestampBuf.append(".");
        timestampBuf.append(nanosString);
        Helper.releaseCalendar(calendar);
        return timestampBuf.toString();
    }

    public static String buildZeroPrefix(int number, int totalDigits) {
        String numbString = Helper.buildZeroPrefixWithoutSign(number, totalDigits);
        numbString = number < 0 ? "-" + numbString : "+" + numbString;
        return numbString;
    }

    public static String buildZeroPrefixWithoutSign(int number, int totalDigits) {
        String zeros = "000000000";
        int absValue = number < 0 ? -number : number;
        String numbString = Integer.toString(absValue);
        numbString = zeros.substring(0, totalDigits - numbString.length()) + numbString;
        return numbString;
    }

    public static String buildZeroPrefixAndTruncTrailZeros(int number, int totalDigits) {
        String zeros = "000000000";
        String numbString = Integer.toString(number);
        numbString = zeros.substring(0, totalDigits - numbString.length()) + numbString;
        char[] numbChar = new char[numbString.length()];
        numbString.getChars(0, numbString.length(), numbChar, 0);
        int truncIndex = totalDigits - 1;
        while (numbChar[truncIndex] == '0') {
            --truncIndex;
        }
        return new String(numbChar, 0, truncIndex + 1);
    }

    public static String printTimestampWithoutNanos(Timestamp timestamp) {
        Calendar calendar = Helper.allocateCalendar();
        calendar.setTime(timestamp);
        String string = Helper.printCalendarWithoutNanos(calendar);
        Helper.releaseCalendar(calendar);
        return string;
    }

    public static String printCalendarWithoutNanos(Calendar calendar) {
        StringBuffer timestampBuf = new StringBuffer();
        timestampBuf.append(Helper.printDate(calendar));
        timestampBuf.append(" ");
        timestampBuf.append(Helper.printTime(calendar));
        return timestampBuf.toString();
    }

    public static Date dateFromCalendar(Calendar calendar) {
        if (!defaultTimeZone.equals(calendar.getTimeZone())) {
            Calendar localCalendar = Helper.allocateCalendar();
            localCalendar.setTimeInMillis(calendar.getTimeInMillis());
            Date date = Helper.dateFromYearMonthDate(localCalendar.get(1), localCalendar.get(2), localCalendar.get(5));
            Helper.releaseCalendar(localCalendar);
            return date;
        }
        if (calendar.get(11) == 0 && calendar.get(12) == 0 && calendar.get(13) == 0 && calendar.get(14) == 0) {
            return new Date(calendar.getTimeInMillis());
        }
        return Helper.dateFromYearMonthDate(calendar.get(1), calendar.get(2), calendar.get(5));
    }

    public static void systemBug(String description) {
    }

    public static Time timeFromDate(java.util.Date date) {
        Calendar calendar = Helper.allocateCalendar();
        calendar.setTime(date);
        Time time = Helper.timeFromCalendar(calendar);
        Helper.releaseCalendar(calendar);
        return time;
    }

    public static Time timeFromLong(Long longObject) {
        return new Time(longObject);
    }

    public static Time timeFromHourMinuteSecond(int hour, int minute, int second) {
        Calendar localCalendar = Helper.allocateCalendar();
        localCalendar.clear();
        localCalendar.set(1970, 0, 1, hour, minute, second);
        long millis = localCalendar.getTimeInMillis();
        Time time = new Time(millis);
        Helper.releaseCalendar(localCalendar);
        return time;
    }

    public static Time timeFromString(String timeString) throws ConversionException {
        int second;
        int minute;
        int hour;
        String timePortion = timeString;
        if (timeString.length() > 12) {
            timePortion = timeString.substring(11, 19);
        }
        if (timePortion.indexOf(45) == -1 && timePortion.indexOf(47) == -1 && timePortion.indexOf(46) == -1 && timePortion.indexOf(58) == -1) {
            throw ConversionException.incorrectTimeFormat(timePortion);
        }
        StringTokenizer timeStringTokenizer = new StringTokenizer(timePortion, " /:.-");
        try {
            hour = Integer.parseInt(timeStringTokenizer.nextToken());
            minute = Integer.parseInt(timeStringTokenizer.nextToken());
            second = Integer.parseInt(timeStringTokenizer.nextToken());
        }
        catch (NumberFormatException exception) {
            throw ConversionException.incorrectTimeFormat(timeString);
        }
        return Helper.timeFromHourMinuteSecond(hour, minute, second);
    }

    public static Time timeFromTimestamp(Timestamp timestamp) {
        return Helper.timeFromDate(timestamp);
    }

    public static Time timeFromCalendar(Calendar calendar) {
        if (!defaultTimeZone.equals(calendar.getTimeZone())) {
            Calendar localCalendar = Helper.allocateCalendar();
            localCalendar.setTimeInMillis(calendar.getTimeInMillis());
            Time date = Helper.timeFromHourMinuteSecond(localCalendar.get(11), localCalendar.get(12), localCalendar.get(13));
            Helper.releaseCalendar(localCalendar);
            return date;
        }
        return Helper.timeFromHourMinuteSecond(calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public static Timestamp timestampFromCalendar(Calendar calendar) {
        return Helper.timestampFromLong(calendar.getTimeInMillis());
    }

    public static Timestamp timestampFromDate(java.util.Date date) {
        return Helper.timestampFromLong(date.getTime());
    }

    public static Timestamp timestampFromLong(Long millis) {
        return Helper.timestampFromLong((long)millis);
    }

    public static Timestamp timestampFromLong(long millis) {
        Timestamp timestamp = new Timestamp(millis);
        if (millis % 1000L > 0L) {
            timestamp.setNanos((int)(millis % 1000L) * 1000000);
        } else if (millis % 1000L < 0L) {
            timestamp.setNanos((int)(1000000000L - Math.abs(millis % 1000L * 1000000L)));
        }
        return timestamp;
    }

    public static Timestamp timestampFromString(String timestampString) throws ConversionException {
        int nanos;
        int second;
        int minute;
        int hour;
        int day;
        int month;
        if (timestampString.indexOf(45) == -1 && timestampString.indexOf(47) == -1 && timestampString.indexOf(46) == -1 && timestampString.indexOf(58) == -1) {
            throw ConversionException.incorrectTimestampFormat(timestampString);
        }
        StringTokenizer timestampStringTokenizer = new StringTokenizer(timestampString, " /:.-");
        try {
            int year = Integer.parseInt(timestampStringTokenizer.nextToken());
            month = Integer.parseInt(timestampStringTokenizer.nextToken());
            day = Integer.parseInt(timestampStringTokenizer.nextToken());
            try {
                hour = Integer.parseInt(timestampStringTokenizer.nextToken());
                minute = Integer.parseInt(timestampStringTokenizer.nextToken());
                second = Integer.parseInt(timestampStringTokenizer.nextToken());
            }
            catch (NoSuchElementException endOfStringException) {
                hour = 0;
                minute = 0;
                second = 0;
            }
        }
        catch (NumberFormatException exception) {
            throw ConversionException.incorrectTimestampFormat(timestampString);
        }
        try {
            String nanoToken = timestampStringTokenizer.nextToken();
            nanos = Integer.parseInt(nanoToken);
            for (int times = 0; times < 9 - nanoToken.length(); ++times) {
                nanos *= 10;
            }
        }
        catch (NoSuchElementException endOfStringException) {
            nanos = 0;
        }
        catch (NumberFormatException exception) {
            throw ConversionException.incorrectTimestampFormat(timestampString);
        }
        Timestamp timestamp = new Timestamp(year -= 1900, --month, day, hour, minute, second, nanos);
        return timestamp;
    }

    public static Timestamp timestampFromYearMonthDateHourMinuteSecondNanos(int year, int month, int date, int hour, int minute, int second, int nanos) {
        return new Timestamp(year - 1900, month, date, hour, minute, second, nanos);
    }

    public static void toDo(String description) {
    }

    public static String toSlashedClassName(String dottedClassName) {
        if (dottedClassName == null) {
            return null;
        }
        if (dottedClassName.indexOf(46) >= 0) {
            return dottedClassName.replace('.', '/');
        }
        return dottedClassName;
    }

    public static String truncate(String originalString, int size) {
        if (originalString.length() <= size) {
            return originalString;
        }
        String vowels = "AaEeIiOoUu";
        StringBuffer newStringBufferTmp = new StringBuffer(originalString.length());
        int counter = originalString.length() - size;
        for (int index = originalString.length() - 1; index >= 0; --index) {
            if (vowels.indexOf(originalString.charAt(index)) == -1) {
                newStringBufferTmp.append(originalString.charAt(index));
                continue;
            }
            if (--counter != 0) continue;
            StringBuffer newStringBuffer = new StringBuffer(size);
            newStringBuffer.append(originalString.substring(0, index));
            newStringBuffer.append(newStringBufferTmp.reverse().toString());
            return newStringBuffer.toString();
        }
        return newStringBufferTmp.reverse().toString().substring(0, size);
    }

    public static java.util.Date utilDateFromLong(Long longObject) {
        return new java.util.Date(longObject);
    }

    public static java.util.Date utilDateFromSQLDate(Date sqlDate) {
        return new java.util.Date(sqlDate.getTime());
    }

    public static java.util.Date utilDateFromTime(Time time) {
        return new java.util.Date(time.getTime());
    }

    public static java.util.Date utilDateFromTimestamp(Timestamp timestampObject) {
        boolean appendNanos;
        long time = timestampObject.getTime();
        boolean bl = appendNanos = time % 1000L == 0L;
        if (appendNanos) {
            return new java.util.Date(time + (long)(timestampObject.getNanos() / 1000000));
        }
        return new java.util.Date(time);
    }

    public static Vector vectorFromArray(Object[] array) {
        Vector<Object> result = new Vector<Object>(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.addElement(array[i]);
        }
        return result;
    }

    public static void writeHexString(byte[] bytes, Writer writer) throws IOException {
        writer.write(Helper.buildHexStringFromBytes(bytes));
    }

    public static boolean isEquivalentToNull(Object value) {
        return value == null || !isZeroValidPrimaryKey && (value.getClass() == ClassConstants.LONG && (Long)value <= 0L || value.getClass() == ClassConstants.INTEGER && (Integer)value <= 0);
    }

    public static int countOccurrencesOf(Object comparisonObject, List list) {
        boolean comparisonObjectIsNull;
        int instances = 0;
        boolean bl = comparisonObjectIsNull = comparisonObject == null;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Object listObject = list.get(i);
                if (!(comparisonObjectIsNull & listObject == null) && (comparisonObjectIsNull || !comparisonObject.equals(listObject))) continue;
                ++instances;
            }
        }
        return instances;
    }

    public static URI toURI(URL url) throws URISyntaxException {
        try {
            return url.toURI();
        }
        catch (URISyntaxException exception) {
            return new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), null);
        }
    }

    public static String getWeavedValueHolderGetMethodName(String attributeName) {
        return "_persistence_get" + attributeName + "_vh";
    }

    public static String getWeavedValueHolderSetMethodName(String attributeName) {
        return "_persistence_set" + attributeName + "_vh";
    }

    public static void close(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getAttributeNameFromMethodName(String methodName) {
        String leadingChar = "";
        String restOfName = methodName;
        if (methodName.equals(GET_PROPERTY_METHOD_PREFIX) || methodName.equals(IS_PROPERTY_METHOD_PREFIX)) {
            return "";
        }
        if (methodName.startsWith(GET_PROPERTY_METHOD_PREFIX)) {
            leadingChar = methodName.substring(POSITION_AFTER_GET_PREFIX, POSITION_AFTER_GET_PREFIX + 1);
            restOfName = methodName.substring(POSITION_AFTER_GET_PREFIX + 1);
        } else if (methodName.startsWith(IS_PROPERTY_METHOD_PREFIX)) {
            leadingChar = methodName.substring(POSITION_AFTER_IS_PREFIX, POSITION_AFTER_IS_PREFIX + 1);
            restOfName = methodName.substring(POSITION_AFTER_IS_PREFIX + 1);
        }
        return leadingChar.toLowerCase().concat(restOfName);
    }

    public static String getDefaultStartDatabaseDelimiter() {
        if (defaultStartDatabaseDelimiter == null) {
            defaultStartDatabaseDelimiter = DEFAULT_DATABASE_DELIMITER;
        }
        return defaultStartDatabaseDelimiter;
    }

    public static String getDefaultEndDatabaseDelimiter() {
        if (defaultEndDatabaseDelimiter == null) {
            defaultEndDatabaseDelimiter = DEFAULT_DATABASE_DELIMITER;
        }
        return defaultEndDatabaseDelimiter;
    }

    public static void setDefaultStartDatabaseDelimiter(String delimiter) {
        defaultStartDatabaseDelimiter = delimiter;
    }

    public static void setDefaultEndDatabaseDelimiter(String delimiter) {
        defaultEndDatabaseDelimiter = delimiter;
    }
}

