/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.changetracking;

import org.eclipse.persistence.annotations.ChangeTrackingType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.AttributeChangeTrackingPolicy;
import org.eclipse.persistence.descriptors.changetracking.DeferredChangeDetectionPolicy;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangeTrackingPolicy;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;

public class ChangeTrackingMetadata
extends ORMetadata {
    private String m_type;

    public ChangeTrackingMetadata() {
        super("<change-tracking>");
    }

    public ChangeTrackingMetadata(MetadataAnnotation changeTracking, MetadataAccessibleObject accessibleObject) {
        super(changeTracking, accessibleObject);
        this.m_type = (String)changeTracking.getAttribute("value");
    }

    public String getType() {
        return this.m_type;
    }

    public void process(MetadataDescriptor descriptor) {
        descriptor.setHasChangeTracking();
        ClassDescriptor classDescriptor = descriptor.getClassDescriptor();
        DeferredChangeDetectionPolicy policy = null;
        if (this.m_type.equals(ChangeTrackingType.ATTRIBUTE.name())) {
            policy = new AttributeChangeTrackingPolicy();
        } else if (this.m_type.equals(ChangeTrackingType.OBJECT.name())) {
            policy = new ObjectChangeTrackingPolicy();
        } else if (this.m_type.equals(ChangeTrackingType.DEFERRED.name())) {
            policy = new DeferredChangeDetectionPolicy();
        } else if (this.m_type.equals(ChangeTrackingType.AUTO.name())) {
            policy = null;
        }
        classDescriptor.setObjectChangePolicy(policy);
    }

    public void setType(String type) {
        this.m_type = type;
    }
}

