/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.DomToXMLEventWriter;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLEventWriterRecord
extends MarshalRecord {
    private Map<String, String> prefixMapping;
    private XMLEventWriter xmlEventWriter;
    private XMLEventFactory xmlEventFactory;
    private DomToXMLEventWriter domToXMLEventWriter;
    private boolean isStartElementOpen = false;
    private ArrayList attributes;
    private ArrayList namespaceDeclarations;
    private String namespaceURI;
    private XPathFragment xPathFragment;

    public XMLEventWriterRecord(XMLEventWriter xmlEventWriter) {
        this.xmlEventWriter = xmlEventWriter;
        this.prefixMapping = new HashMap<String, String>();
        this.xmlEventFactory = XMLEventFactory.newInstance();
        this.domToXMLEventWriter = new DomToXMLEventWriter(this.xmlEventFactory);
        this.attributes = new ArrayList();
        this.namespaceDeclarations = new ArrayList();
    }

    public XMLEventWriter getXMLEventWriter() {
        return this.xmlEventWriter;
    }

    public void setXMLEventWriter(XMLEventWriter anXMLEventWriter) {
        this.xmlEventWriter = anXMLEventWriter;
    }

    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, String value) {
        Attribute event;
        String namespaceURI = xPathFragment.getNamespaceURI();
        if (namespaceURI == null) {
            event = this.xmlEventFactory.createAttribute(xPathFragment.getLocalName(), value);
        } else {
            String prefix = xPathFragment.getPrefix();
            if (prefix == null) {
                event = this.xmlEventFactory.createAttribute(xPathFragment.getPrefix(), namespaceURI, xPathFragment.getLocalName(), value);
            } else {
                if (this.xmlEventWriter.getNamespaceContext().getNamespaceURI(prefix) == null || !this.xmlEventWriter.getNamespaceContext().getNamespaceURI(prefix).equals(namespaceURI)) {
                    event = this.xmlEventFactory.createNamespace(prefix, namespaceURI);
                }
                event = this.xmlEventFactory.createAttribute(prefix, namespaceURI, xPathFragment.getLocalName(), value);
            }
        }
        if (event.isNamespace()) {
            this.namespaceDeclarations.add(event);
        } else {
            this.attributes.add(event);
        }
    }

    public void attribute(String namespaceURI, String localName, String name, String value) {
        Attribute event;
        if (namespaceURI != null && namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
            event = localName.equals("xmlns") ? this.xmlEventFactory.createNamespace(value) : this.xmlEventFactory.createNamespace(localName, value);
        } else {
            NamespaceContext ctx = this.xmlEventWriter.getNamespaceContext();
            if (namespaceURI == null || namespaceURI.length() == 0) {
                event = this.xmlEventFactory.createAttribute(localName, value);
            } else {
                int index = name.indexOf(58);
                if (index == -1) {
                    event = this.xmlEventFactory.createAttribute("", namespaceURI, localName, value);
                } else {
                    String prefix = name.substring(0, index);
                    event = this.xmlEventFactory.createAttribute(prefix, namespaceURI, localName, value);
                }
            }
        }
        if (event.isNamespace()) {
            this.namespaceDeclarations.add(event);
        } else {
            this.attributes.add(event);
        }
    }

    private void openAndCloseStartElement() {
        try {
            if (this.namespaceURI == null) {
                this.xmlEventWriter.add(this.xmlEventFactory.createStartElement("", "", this.xPathFragment.getLocalName(), this.attributes.iterator(), this.namespaceDeclarations.iterator()));
                String defaultNamespace = this.xmlEventWriter.getNamespaceContext().getNamespaceURI("");
                if (defaultNamespace != null && defaultNamespace.length() > 0) {
                    this.xmlEventWriter.setDefaultNamespace("");
                    this.xmlEventWriter.add(this.xmlEventFactory.createNamespace(""));
                }
            } else {
                String prefix = this.xPathFragment.getPrefix();
                if (prefix == null) {
                    prefix = "";
                }
                StartElement startElement = this.xmlEventFactory.createStartElement(prefix, this.namespaceURI, this.xPathFragment.getLocalName(), this.attributes.iterator(), this.namespaceDeclarations.iterator());
                this.xmlEventWriter.add(startElement);
            }
        }
        catch (XMLStreamException ex) {
            throw XMLMarshalException.marshalException(ex);
        }
    }

    public void cdata(String value) {
        try {
            if (this.isStartElementOpen) {
                this.openAndCloseStartElement();
                this.isStartElementOpen = false;
            }
            Characters cdataEvent = this.xmlEventFactory.createCData(value);
            this.xmlEventWriter.add(cdataEvent);
        }
        catch (Exception e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void characters(String value) {
        try {
            if (this.isStartElementOpen) {
                this.openAndCloseStartElement();
                this.isStartElementOpen = false;
            }
            Characters charactersEvent = this.xmlEventFactory.createCharacters(value);
            this.xmlEventWriter.add(charactersEvent);
        }
        catch (Exception e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void closeStartElement() {
    }

    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        super.openStartElement(xPathFragment, namespaceResolver);
        if (this.isStartElementOpen) {
            this.openAndCloseStartElement();
        }
        this.isStartElementOpen = true;
        this.namespaceURI = xPathFragment.getNamespaceURI();
        this.xPathFragment = xPathFragment;
        this.attributes = new ArrayList();
        this.namespaceDeclarations = new ArrayList();
        this.writePrefixMappings();
    }

    public void element(String namespaceURI, String localName, String Name2) {
        try {
            if (this.isStartElementOpen) {
                this.openAndCloseStartElement();
                this.isStartElementOpen = false;
            }
            String prefix = "";
            if (Name2.indexOf(58) != -1) {
                prefix = Name2.substring(0, Name2.indexOf(58));
            }
            StartElement startElement = this.xmlEventFactory.createStartElement(prefix, namespaceURI, localName);
            this.xmlEventWriter.add(startElement);
            this.xmlEventWriter.add(this.xmlEventFactory.createEndElement(prefix, namespaceURI, localName));
        }
        catch (Exception e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void endDocument() {
        try {
            if (this.isStartElementOpen) {
                this.openAndCloseStartElement();
                this.isStartElementOpen = false;
            }
            EndDocument endDoc = this.xmlEventFactory.createEndDocument();
            this.xmlEventWriter.add(endDoc);
        }
        catch (Exception e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void endElement(XPathFragment pathFragment, NamespaceResolver namespaceResolver) {
        if (this.isStartElementOpen) {
            this.openAndCloseStartElement();
            this.isStartElementOpen = false;
        }
        String namespaceURI = pathFragment.getNamespaceURI();
        String prefix = pathFragment.getPrefix();
        if (prefix == null) {
            prefix = "";
        }
        try {
            EndElement endElement = this.xmlEventFactory.createEndElement(prefix, namespaceURI, pathFragment.getLocalName());
            this.xmlEventWriter.add(endElement);
        }
        catch (Exception e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void node(Node node, NamespaceResolver resolver) {
        if (this.isStartElementOpen) {
            this.openAndCloseStartElement();
            this.isStartElementOpen = false;
        }
        try {
            if (node.getNodeType() == 9) {
                node = ((Document)node).getDocumentElement();
            }
            this.domToXMLEventWriter.writeToEventWriter(node, this.xmlEventWriter);
        }
        catch (XMLStreamException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void startDocument(String encoding, String version) {
        try {
            StartDocument startDoc = this.xmlEventFactory.createStartDocument(encoding, version, false);
            this.xmlEventWriter.add(startDoc);
        }
        catch (Exception e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    private String getString(String string) {
        return string;
    }

    public void startPrefixMapping(String prefix, String namespaceUri) {
        this.prefixMapping.put(prefix, namespaceUri);
    }

    private void writePrefixMappings() {
        for (Map.Entry<String, String> entry : this.prefixMapping.entrySet()) {
            Namespace namespace = this.xmlEventFactory.createNamespace(entry.getKey(), entry.getValue());
            this.namespaceDeclarations.add(namespace);
        }
        this.prefixMapping = new HashMap<String, String>();
    }

    public void namespaceDeclarations(NamespaceResolver namespaceResolver) {
    }

    public void startPrefixMappings(NamespaceResolver namespaceResolver) {
        if (namespaceResolver != null) {
            if (namespaceResolver.getDefaultNamespaceURI() != null) {
                this.startPrefixMapping("", namespaceResolver.getDefaultNamespaceURI());
            }
            Enumeration prefixes = namespaceResolver.getPrefixes();
            while (prefixes.hasMoreElements()) {
                String prefix = (String)prefixes.nextElement();
                String uri = namespaceResolver.resolveNamespacePrefix(prefix);
                this.startPrefixMapping(prefix, uri);
            }
        }
    }
}

