/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryableArgument;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QueryableEditDialog;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;

final class FirstArgumentPanel
extends AbstractPanel {
    private PropertyValueModel argumentHolder;
    private JTextField queryKeyTextField;
    private JButton editQueryKeyButton;

    FirstArgumentPanel(PropertyValueModel argumentHolder, ValueModel basicExpressionEnablerModel, WorkbenchContextHolder contextHolder) {
        super(contextHolder);
        this.argumentHolder = argumentHolder;
        this.initializeLayout(basicExpressionEnablerModel);
    }

    private void initializeLayout(ValueModel basicExpressionEnablerModel) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        ArrayList<JComponent> enablingComponents = new ArrayList<JComponent>();
        JLabel queryKeyLabel = new JLabel(this.resourceRepository().getString("QUERY_KEY_LABEL_ON_FIRST_ARGUMENT_PANEL"));
        enablingComponents.add(queryKeyLabel);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 18;
        constraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)queryKeyLabel, constraints);
        this.queryKeyTextField = this.buildQueryableTextField();
        enablingComponents.add(this.queryKeyTextField);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 18;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.queryKeyTextField, constraints);
        this.editQueryKeyButton = new JButton(this.resourceRepository().getString("QUERY_KEY_EDIT_BUTTON_ON_FIRST_ARGUMENT_PANEL"));
        this.editQueryKeyButton.setMnemonic(this.resourceRepository().getMnemonic("QUERY_KEY_EDIT_BUTTON_ON_FIRST_ARGUMENT_PANEL"));
        this.editQueryKeyButton.addActionListener(this.buildEditQueryKeyAction());
        enablingComponents.add(this.editQueryKeyButton);
        new ComponentEnabler(basicExpressionEnablerModel, enablingComponents);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.fill = 0;
        constraints.anchor = 18;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.editQueryKeyButton, constraints);
    }

    private JTextField buildQueryableTextField() {
        JTextField textField = new JTextField();
        textField.setDocument(new DocumentAdapter(this.buildQueryableHolder()));
        textField.setEditable(false);
        return textField;
    }

    private PropertyValueModel buildQueryableHolder() {
        return new PropertyAspectAdapter(this.argumentHolder, "queryableArgumentElement"){

            protected Object getValueFromSubject() {
                return ((MWQueryableArgument)this.subject).displayString();
            }
        };
    }

    private ActionListener buildEditQueryKeyAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                FirstArgumentPanel.this.editQueryKey();
            }
        };
    }

    private void editQueryKey() {
        QueryableEditDialog queryKeyDialog = new QueryableEditDialog((MWQueryableArgument)this.argumentHolder.getValue(), this.getWorkbenchContext());
        queryKeyDialog.show();
    }
}

