/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.exceptions;

import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicClassWriter;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.internal.dynamic.DynamicEntityImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;

public class DynamicException
extends EclipseLinkException {
    protected DynamicException(String message) {
        super(message);
    }

    protected DynamicException(String message, Throwable throwable) {
        super(message, throwable);
    }

    public static DynamicException invalidPropertyName(DynamicType type, String propertyName) {
        return new DynamicException("Invalid DynamicEntity[" + type + "] property name: " + propertyName);
    }

    public static DynamicException invalidGetPropertyType(DatabaseMapping mapping, ClassCastException cce) {
        return new DynamicException("DynamicEntity:: Cannot return: " + mapping + ": " + cce.getMessage(), cce);
    }

    public static DynamicException invalidSetPropertyType(DatabaseMapping mapping, Object value) {
        return new DynamicException("DynamicEntity:: Cannot set: " + mapping + " with: " + value);
    }

    public static DynamicException invalidPropertyIndex(DynamicType type, int propertyIndex) {
        return new DynamicException("Invalid DynamicEntity[" + type + "] property index: " + propertyIndex);
    }

    public static DynamicException illegalDynamicClassWriter(DynamicClassLoader loader, String parentClassName) {
        return new DynamicException("Illegal DynamicClassWriter(" + loader + ", " + parentClassName + ")");
    }

    public static DynamicException entityNotFoundException(String message) {
        return new DynamicException("DynamicEntity not found: " + message);
    }

    public static DynamicException entityHasNullType(DynamicEntityImpl entity) {
        return new DynamicException("DynamicEntity has null type: " + entity);
    }

    public static DynamicException illegalParentClassName(String parentClassName) {
        return new DynamicException("Illegal parent class name for dynamic type: " + parentClassName);
    }

    public static DynamicException incompatibleDuplicateWriters(String className, DynamicClassWriter existingWriter, DynamicClassWriter writer) {
        return new DynamicException("Duplicate addClass request with incompatible writer: " + className + " - existing: " + existingWriter + " - new: " + writer);
    }
}

