/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;
import org.eclipse.persistence.tools.schemaframework.ForeignKeyConstraint;
import org.eclipse.persistence.tools.schemaframework.UniqueKeyConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableDefinition
extends DatabaseObjectDefinition {
    protected Vector fields = new Vector();
    protected HashMap<String, ForeignKeyConstraint> foreignKeyMap = new HashMap();
    protected Vector<UniqueKeyConstraint> uniqueKeys = new Vector();
    protected String creationPrefix = "CREATE TABLE ";
    protected String creationSuffix = "";
    private boolean createSQLFiles;

    public void addField(String fieldName, Class type) {
        this.addField(new FieldDefinition(fieldName, type));
    }

    public void addField(String fieldName, Class type, int fieldSize) {
        this.addField(new FieldDefinition(fieldName, type, fieldSize));
    }

    public void addField(String fieldName, Class type, int fieldSize, int fieldSubSize) {
        this.addField(new FieldDefinition(fieldName, type, fieldSize, fieldSubSize));
    }

    public void addField(String fieldName, String typeName) {
        this.addField(new FieldDefinition(fieldName, typeName));
    }

    public void addField(FieldDefinition field) {
        this.getFields().addElement(field);
    }

    public void addForeignKeyConstraint(String name, String sourceField, String targetField, String targetTable) {
        ForeignKeyConstraint foreignKey = new ForeignKeyConstraint(name, sourceField, targetField, targetTable);
        this.addForeignKeyConstraint(foreignKey);
    }

    public void addUniqueKeyConstraint(String name, String sourceField) {
        UniqueKeyConstraint uniqueKey = new UniqueKeyConstraint(name, sourceField);
        this.addUniqueKeyConstraint(uniqueKey);
    }

    public void addUniqueKeyConstraint(String name, String[] sourceFields) {
        UniqueKeyConstraint uniqueKey = new UniqueKeyConstraint(name, sourceFields);
        this.addUniqueKeyConstraint(uniqueKey);
    }

    public void addForeignKeyConstraint(ForeignKeyConstraint foreignKey) {
        if (!this.foreignKeyMap.containsKey(foreignKey.getName())) {
            this.foreignKeyMap.put(foreignKey.getName(), foreignKey);
        }
    }

    public void addUniqueKeyConstraint(UniqueKeyConstraint uniqueKey) {
        this.getUniqueKeys().addElement(uniqueKey);
    }

    public void addIdentityField(String fieldName, Class type) {
        FieldDefinition fieldDef = new FieldDefinition(fieldName, type);
        fieldDef.setIsIdentity(true);
        fieldDef.setIsPrimaryKey(true);
        this.addField(fieldDef);
    }

    public void addIdentityField(String fieldName, Class type, int fieldSize) {
        FieldDefinition fieldDef = new FieldDefinition(fieldName, type, fieldSize);
        fieldDef.setIsIdentity(true);
        fieldDef.setIsPrimaryKey(true);
        this.addField(fieldDef);
    }

    public void addPrimaryKeyField(String fieldName, Class type) {
        FieldDefinition fieldDef = new FieldDefinition(fieldName, type);
        fieldDef.setIsPrimaryKey(true);
        this.addField(fieldDef);
    }

    public void addPrimaryKeyField(String fieldName, Class type, int fieldSize) {
        FieldDefinition fieldDef = new FieldDefinition(fieldName, type, fieldSize);
        fieldDef.setIsPrimaryKey(true);
        this.addField(fieldDef);
    }

    public Writer buildConstraintCreationWriter(AbstractSession session, ForeignKeyConstraint foreignKey, Writer writer) throws ValidationException {
        try {
            writer.write("ALTER TABLE " + this.getFullName());
            writer.write(" ADD CONSTRAINT ");
            if (!session.getPlatform().shouldPrintConstraintNameAfter()) {
                writer.write(foreignKey.getName() + " ");
            }
            foreignKey.appendDBString(writer, session);
            if (session.getPlatform().shouldPrintConstraintNameAfter()) {
                writer.write(" CONSTRAINT " + foreignKey.getName());
            }
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public Writer buildConstraintDeletionWriter(AbstractSession session, ForeignKeyConstraint foreignKey, Writer writer) throws ValidationException {
        try {
            writer.write("ALTER TABLE " + this.getFullName());
            writer.write(session.getPlatform().getConstraintDeletionString() + foreignKey.getName());
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public Writer buildUniqueConstraintCreationWriter(AbstractSession session, UniqueKeyConstraint uniqueKey, Writer writer) throws ValidationException {
        try {
            writer.write("ALTER TABLE " + this.getFullName());
            writer.write(" ADD CONSTRAINT ");
            if (!session.getPlatform().shouldPrintConstraintNameAfter()) {
                writer.write(uniqueKey.getName() + " ");
            }
            uniqueKey.appendDBString(writer, session);
            if (session.getPlatform().shouldPrintConstraintNameAfter()) {
                writer.write(" CONSTRAINT " + uniqueKey.getName());
            }
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public Writer buildUniqueConstraintDeletionWriter(AbstractSession session, UniqueKeyConstraint uniqueKey, Writer writer) throws ValidationException {
        try {
            writer.write("ALTER TABLE " + this.getFullName());
            writer.write(session.getPlatform().getConstraintDeletionString() + uniqueKey.getName());
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public String getCreationPrefix() {
        return this.creationPrefix;
    }

    public void setCreationPrefix(String creationPrefix) {
        this.creationPrefix = creationPrefix;
    }

    public String getCreationSuffix() {
        return this.creationSuffix;
    }

    public void setCreationSuffix(String creationSuffix) {
        this.creationSuffix = creationSuffix;
    }

    @Override
    public Writer buildCreationWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            writer.write(this.getCreationPrefix() + this.getFullName() + " (");
            Enumeration fieldsEnum = this.getFields().elements();
            while (fieldsEnum.hasMoreElements()) {
                FieldDefinition field = (FieldDefinition)fieldsEnum.nextElement();
                field.appendDBString(writer, session, this);
                if (!fieldsEnum.hasMoreElements()) continue;
                writer.write(", ");
            }
            Vector keyFields = this.getPrimaryKeyFieldNames();
            if (!keyFields.isEmpty() && session.getPlatform().supportsPrimaryKeyConstraint()) {
                writer.write(", ");
                if (session.getPlatform().requiresNamedPrimaryKeyConstraints()) {
                    writer.write("CONSTRAINT " + this.getFullName() + "_PK ");
                }
                writer.write("PRIMARY KEY (");
                Enumeration keyEnum = keyFields.elements();
                while (keyEnum.hasMoreElements()) {
                    writer.write((String)keyEnum.nextElement());
                    if (!keyEnum.hasMoreElements()) continue;
                    writer.write(", ");
                }
                writer.write(")");
            }
            writer.write(")");
            if (this.getCreationSuffix().length() > 0) {
                writer.write(this.getCreationSuffix());
            }
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    @Override
    public Writer buildDeletionWriter(AbstractSession session, Writer writer) throws ValidationException {
        try {
            writer.write("DROP TABLE " + this.getFullName());
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    protected void buildFieldTypes(AbstractSession session) {
        FieldDefinition field = null;
        Enumeration enumtr = this.getFields().elements();
        while (enumtr.hasMoreElements()) {
            field = (FieldDefinition)enumtr.nextElement();
            if (field.getForeignKeyFieldName() == null) continue;
            this.addForeignKeyConstraint(this.buildForeignKeyConstraint(field, session.getPlatform()));
        }
    }

    protected ForeignKeyConstraint buildForeignKeyConstraint(FieldDefinition field, DatabasePlatform platform) {
        Vector<String> sourceFields = new Vector<String>();
        Vector<String> targetFields = new Vector<String>();
        ForeignKeyConstraint fkConstraint = new ForeignKeyConstraint();
        DatabaseField tempTargetField = new DatabaseField(field.getForeignKeyFieldName());
        DatabaseField tempSourceField = new DatabaseField(field.getName());
        sourceFields.addElement(tempSourceField.getName());
        targetFields.addElement(tempTargetField.getName());
        fkConstraint.setSourceFields(sourceFields);
        fkConstraint.setTargetFields(targetFields);
        fkConstraint.setTargetTable(tempTargetField.getTable().getQualifiedNameDelimited(platform));
        String tempName = this.buildForeignKeyConstraintName(this.getName(), tempSourceField.getName(), platform.getMaxForeignKeyNameSize(), platform);
        fkConstraint.setName(tempName);
        return fkConstraint;
    }

    protected ForeignKeyConstraint buildForeignKeyConstraint(Vector fkFieldNames, Vector pkFieldNames, TableDefinition targetTable, DatabasePlatform platform) {
        assert (fkFieldNames.size() > 0 && fkFieldNames.size() == pkFieldNames.size());
        ForeignKeyConstraint fkConstraint = new ForeignKeyConstraint();
        for (int i = 0; i < fkFieldNames.size(); ++i) {
            fkConstraint.getSourceFields().add(fkFieldNames.get(i));
            fkConstraint.getTargetFields().add(pkFieldNames.get(i));
        }
        fkConstraint.setTargetTable(targetTable.getFullName());
        String fkFieldName = (String)fkFieldNames.get(0);
        String name = this.buildForeignKeyConstraintName(this.getName(), fkFieldName, platform.getMaxForeignKeyNameSize(), platform);
        fkConstraint.setName(name);
        return fkConstraint;
    }

    protected String buildForeignKeyConstraintName(String tableName, String fieldName, int maximumNameLength, DatabasePlatform platform) {
        char c;
        int i;
        StringBuffer buff;
        String adjustedTableName;
        boolean useDelimiters;
        String startDelimiter = "";
        String endDelimiter = "";
        boolean bl = useDelimiters = !platform.getStartDelimiter().equals("") && (tableName.startsWith(platform.getStartDelimiter()) || fieldName.startsWith(platform.getStartDelimiter()));
        if (useDelimiters) {
            startDelimiter = platform.getStartDelimiter();
            endDelimiter = platform.getEndDelimiter();
        }
        if ((adjustedTableName = tableName).indexOf(32) != -1 || adjustedTableName.indexOf(34) != -1 || adjustedTableName.indexOf(96) != -1) {
            buff = new StringBuffer();
            for (i = 0; i < tableName.length(); ++i) {
                c = tableName.charAt(i);
                if (c == ' ' || c == '\"' || c == '`') continue;
                buff.append(c);
            }
            adjustedTableName = buff.toString();
        }
        buff = new StringBuffer();
        for (i = 0; i < fieldName.length(); ++i) {
            c = fieldName.charAt(i);
            if (c == ' ' || c == '\"' || c == '`') continue;
            buff.append(c);
        }
        String adjustedFieldName = buff.toString();
        String foreignKeyName = startDelimiter + "FK_" + adjustedTableName + "_" + adjustedFieldName + endDelimiter;
        if (foreignKeyName.length() > maximumNameLength && (foreignKeyName = startDelimiter + adjustedTableName + "_" + adjustedFieldName + endDelimiter).length() > maximumNameLength && (foreignKeyName = startDelimiter + Helper.removeAllButAlphaNumericToFit(adjustedTableName + adjustedFieldName, maximumNameLength) + endDelimiter).length() > maximumNameLength) {
            String onlyAlphaNumericTableName = Helper.removeAllButAlphaNumericToFit(adjustedTableName, 0);
            String onlyAlphaNumericFieldName = Helper.removeAllButAlphaNumericToFit(adjustedFieldName, 0);
            foreignKeyName = startDelimiter + Helper.shortenStringsByRemovingVowelsToFit(onlyAlphaNumericTableName, onlyAlphaNumericFieldName, maximumNameLength) + endDelimiter;
            if (foreignKeyName.length() > maximumNameLength) {
                String shortenedFieldName = Helper.removeVowels(onlyAlphaNumericFieldName);
                String shortenedTableName = Helper.removeVowels(onlyAlphaNumericTableName);
                int delimiterLength = startDelimiter.length() + endDelimiter.length();
                foreignKeyName = shortenedFieldName.length() + delimiterLength >= maximumNameLength ? startDelimiter + Helper.truncate(shortenedFieldName, maximumNameLength - delimiterLength) + endDelimiter : startDelimiter + Helper.truncate(shortenedTableName, maximumNameLength - shortenedFieldName.length() - delimiterLength) + shortenedFieldName + endDelimiter;
            }
        }
        return foreignKeyName;
    }

    protected UniqueKeyConstraint buildUniqueKeyConstraint(List<String> fieldNames, int serialNumber, DatabasePlatform platform) {
        assert (fieldNames.size() > 0);
        UniqueKeyConstraint unqConstraint = new UniqueKeyConstraint();
        for (String fieldName : fieldNames) {
            unqConstraint.addSourceField(fieldName);
        }
        String name = this.buildUniqueKeyConstraintName(this.getName(), serialNumber, platform.getMaxUniqueKeyNameSize());
        unqConstraint.setName(name);
        return unqConstraint;
    }

    protected String buildUniqueKeyConstraintName(String tableName, int serialNumber, int maximumNameLength) {
        String serialName;
        String onlyAlphaNumericTableName;
        String uniqueKeyName = "UNQ_" + tableName + "_" + serialNumber;
        if (uniqueKeyName.length() > maximumNameLength && (uniqueKeyName = tableName + serialNumber).length() > maximumNameLength && (uniqueKeyName = Helper.removeAllButAlphaNumericToFit(tableName + serialNumber, maximumNameLength)).length() > maximumNameLength && (uniqueKeyName = Helper.shortenStringsByRemovingVowelsToFit(onlyAlphaNumericTableName = Helper.removeAllButAlphaNumericToFit(tableName, 0), serialName = String.valueOf(serialNumber), maximumNameLength)).length() > maximumNameLength) {
            String shortenedTableName = Helper.removeVowels(onlyAlphaNumericTableName);
            uniqueKeyName = Helper.truncate(shortenedTableName, maximumNameLength - serialName.length()) + serialName;
        }
        return uniqueKeyName;
    }

    @Override
    public Object clone() {
        TableDefinition clone = (TableDefinition)super.clone();
        if (this.fields != null) {
            clone.setFields(new Vector(this.fields.size()));
            Enumeration enumtr = this.getFields().elements();
            while (enumtr.hasMoreElements()) {
                FieldDefinition fieldDef = (FieldDefinition)enumtr.nextElement();
                clone.addField((FieldDefinition)fieldDef.clone());
            }
        }
        if (this.foreignKeyMap != null) {
            clone.setForeignKeyMap((HashMap)this.foreignKeyMap.clone());
        }
        if (this.uniqueKeys != null) {
            clone.setUniqueKeys((Vector)this.uniqueKeys.clone());
        }
        return clone;
    }

    public void createConstraints(AbstractSession session, Writer schemaWriter) throws EclipseLinkException {
        this.createUniqueConstraints(session, schemaWriter);
        this.createForeignConstraints(session, schemaWriter);
    }

    void createUniqueConstraints(AbstractSession session, Writer schemaWriter) throws ValidationException {
        if (schemaWriter == null) {
            this.createUniqueConstraintsOnDatabase(session);
            return;
        }
        Enumeration<UniqueKeyConstraint> uniqueKeysEnum = this.getUniqueKeys().elements();
        while (uniqueKeysEnum.hasMoreElements()) {
            UniqueKeyConstraint uniqueKey = uniqueKeysEnum.nextElement();
            this.buildUniqueConstraintCreationWriter(session, uniqueKey, schemaWriter).toString();
            try {
                if (this.createSQLFiles) {
                    schemaWriter.write(session.getPlatform().getStoredProcedureTerminationToken());
                }
                schemaWriter.write("\n");
            }
            catch (IOException exception) {
                throw ValidationException.fileError(exception);
            }
        }
    }

    void createForeignConstraints(AbstractSession session, Writer schemaWriter) throws ValidationException {
        if (schemaWriter == null) {
            this.createForeignConstraintsOnDatabase(session);
            return;
        }
        for (ForeignKeyConstraint foreignKey : this.getForeignKeyMap().values()) {
            this.buildConstraintCreationWriter(session, foreignKey, schemaWriter).toString();
            try {
                if (this.createSQLFiles) {
                    schemaWriter.write(session.getPlatform().getStoredProcedureTerminationToken());
                }
                schemaWriter.write("\n");
            }
            catch (IOException exception) {
                throw ValidationException.fileError(exception);
            }
        }
    }

    public void createConstraintsOnDatabase(AbstractSession session) throws EclipseLinkException {
        this.createUniqueConstraintsOnDatabase(session);
        this.createForeignConstraintsOnDatabase(session);
    }

    void createUniqueConstraintsOnDatabase(AbstractSession session) throws ValidationException, DatabaseException {
        if (!session.getPlatform().supportsUniqueKeyConstraints() || this.getUniqueKeys().isEmpty()) {
            return;
        }
        Enumeration<UniqueKeyConstraint> uniqueKeysEnum = this.getUniqueKeys().elements();
        while (uniqueKeysEnum.hasMoreElements()) {
            UniqueKeyConstraint uniqueKey = uniqueKeysEnum.nextElement();
            session.executeNonSelectingCall(new SQLCall(this.buildUniqueConstraintCreationWriter(session, uniqueKey, new StringWriter()).toString()));
        }
    }

    void createForeignConstraintsOnDatabase(AbstractSession session) throws ValidationException, DatabaseException {
        if (!session.getPlatform().supportsForeignKeyConstraints() || this.getForeignKeyMap().isEmpty()) {
            return;
        }
        for (ForeignKeyConstraint foreignKey : this.getForeignKeyMap().values()) {
            session.executeNonSelectingCall(new SQLCall(this.buildConstraintCreationWriter(session, foreignKey, new StringWriter()).toString()));
        }
    }

    public String deletionStringFor(DatabaseAccessor accessor) {
        return "DROP TABLE " + this.getName();
    }

    public void dropConstraints(AbstractSession session, Writer schemaWriter) throws EclipseLinkException {
        if (schemaWriter == null) {
            this.dropConstraintsOnDatabase(session);
        } else {
            if (session.getPlatform().supportsForeignKeyConstraints()) {
                for (ForeignKeyConstraint foreignKey : this.getForeignKeyMap().values()) {
                    this.buildConstraintDeletionWriter(session, foreignKey, schemaWriter).toString();
                    try {
                        if (this.createSQLFiles) {
                            schemaWriter.write(session.getPlatform().getStoredProcedureTerminationToken());
                        }
                        schemaWriter.write("\n");
                    }
                    catch (IOException exception) {
                        throw ValidationException.fileError(exception);
                    }
                }
            }
            if (session.getPlatform().supportsUniqueKeyConstraints()) {
                Enumeration<UniqueKeyConstraint> uniqueKeysEnum = this.getUniqueKeys().elements();
                while (uniqueKeysEnum.hasMoreElements()) {
                    UniqueKeyConstraint uniqueKey = uniqueKeysEnum.nextElement();
                    this.buildUniqueConstraintDeletionWriter(session, uniqueKey, schemaWriter).toString();
                    try {
                        if (this.createSQLFiles) {
                            schemaWriter.write(session.getPlatform().getStoredProcedureTerminationToken());
                        }
                        schemaWriter.write("\n");
                    }
                    catch (IOException exception) {
                        throw ValidationException.fileError(exception);
                    }
                }
            }
        }
    }

    public void dropConstraintsOnDatabase(AbstractSession session) throws EclipseLinkException {
        this.dropForeignConstraintsOnDatabase(session);
        this.dropUniqueConstraintsOnDatabase(session);
    }

    private void dropUniqueConstraintsOnDatabase(AbstractSession session) throws ValidationException {
        if (!session.getPlatform().supportsUniqueKeyConstraints() || this.getUniqueKeys().isEmpty()) {
            return;
        }
        Enumeration<UniqueKeyConstraint> uniqueKeysEnum = this.getUniqueKeys().elements();
        while (uniqueKeysEnum.hasMoreElements()) {
            UniqueKeyConstraint uniqueKey = uniqueKeysEnum.nextElement();
            try {
                session.executeNonSelectingCall(new SQLCall(this.buildUniqueConstraintDeletionWriter(session, uniqueKey, new StringWriter()).toString()));
            }
            catch (DatabaseException ex) {}
        }
    }

    private void dropForeignConstraintsOnDatabase(AbstractSession session) throws ValidationException {
        if (!session.getPlatform().supportsForeignKeyConstraints() || this.getForeignKeyMap().isEmpty()) {
            return;
        }
        for (ForeignKeyConstraint foreignKey : this.getForeignKeyMap().values()) {
            try {
                session.executeNonSelectingCall(new SQLCall(this.buildConstraintDeletionWriter(session, foreignKey, new StringWriter()).toString()));
            }
            catch (DatabaseException ex) {}
        }
    }

    HashMap<String, ForeignKeyConstraint> getForeignKeyMap() {
        return this.foreignKeyMap;
    }

    void setForeignKeyMap(HashMap<String, ForeignKeyConstraint> foreignKeyMap) {
        this.foreignKeyMap = foreignKeyMap;
    }

    public Vector getFields() {
        return this.fields;
    }

    public Vector<ForeignKeyConstraint> getForeignKeys() {
        return new Vector<ForeignKeyConstraint>(this.foreignKeyMap.values());
    }

    public Vector<UniqueKeyConstraint> getUniqueKeys() {
        return this.uniqueKeys;
    }

    public Vector getPrimaryKeyFieldNames() {
        Vector<String> keyNames = new Vector<String>();
        Enumeration fieldEnum = this.getFields().elements();
        while (fieldEnum.hasMoreElements()) {
            FieldDefinition field = (FieldDefinition)fieldEnum.nextElement();
            if (!field.isPrimaryKey()) continue;
            keyNames.addElement(field.getName());
        }
        return keyNames;
    }

    public void setFields(Vector fields) {
        this.fields = fields;
    }

    public void setForeignKeys(Vector<ForeignKeyConstraint> foreignKeys) {
        this.foreignKeyMap.clear();
        if (foreignKeys != null) {
            for (ForeignKeyConstraint foreignKey : foreignKeys) {
                this.foreignKeyMap.put(foreignKey.getName(), foreignKey);
            }
        }
    }

    public void setUniqueKeys(Vector<UniqueKeyConstraint> uniqueKeys) {
        this.uniqueKeys = uniqueKeys;
    }

    public void setCreateSQLFiles(boolean genFlag) {
        this.createSQLFiles = genFlag;
    }
}

