/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classfile;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classfile.CFExternalClassDescription;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.Classpath;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

final class CFExternalClassRepository
implements ExternalClassRepository {
    private final Classpath classpath;
    private ExternalClassDescription[] classDescriptions;
    private Map defaultClassDescriptions;
    private final Map stubClassDescriptions = new HashMap();
    private final Map arrayClassDescriptions = new HashMap();
    private static final int STARTING_SIZE = 20000;

    CFExternalClassRepository(File[] classpath) {
        this.classpath = new Classpath(this.fileNames(classpath)).compressed();
    }

    private String[] fileNames(File[] files) {
        int len = files.length;
        String[] fileNames = new String[len];
        for (int i = 0; i < len; ++i) {
            fileNames[i] = files[i].getAbsolutePath();
        }
        return fileNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalClassDescription getClassDescription(String typeName) {
        CFExternalClassRepository cFExternalClassRepository = this;
        synchronized (cFExternalClassRepository) {
            if (this.classDescriptions == null) {
                this.initializeClassDescriptions();
            }
        }
        return (ExternalClassDescription)this.defaultClassDescriptions.get(typeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalClassDescription[] getClassDescriptions() {
        CFExternalClassRepository cFExternalClassRepository = this;
        synchronized (cFExternalClassRepository) {
            if (this.classDescriptions == null) {
                this.initializeClassDescriptions();
            }
        }
        return this.classDescriptions;
    }

    private void initializeClassDescriptions() {
        ArrayList<ExternalClassDescription> list = new ArrayList<ExternalClassDescription>(20000);
        this.defaultClassDescriptions = new HashMap(20000);
        int i = PRIMITIVE_EXTERNAL_CLASS_DESCRIPTIONS.length;
        while (i-- > 0) {
            ExternalClassDescription classDescription = PRIMITIVE_EXTERNAL_CLASS_DESCRIPTIONS[i];
            list.add(classDescription);
            this.defaultClassDescriptions.put(classDescription.getName(), classDescription);
        }
        Classpath.Entry[] entries = this.classpath.getEntries();
        int len = entries.length;
        for (int i2 = 0; i2 < len; ++i2) {
            this.addClassDescriptionsFromClasspathEntryTo(entries[i2], list, this.defaultClassDescriptions);
        }
        this.classDescriptions = list.toArray(new ExternalClassDescription[list.size()]);
    }

    private void addClassDescriptionsFromClasspathEntryTo(Classpath.Entry entry, List list, Map map) {
        Iterator stream = entry.classNamesStream();
        while (stream.hasNext()) {
            String name = (String)stream.next();
            CFExternalClassDescription classDescription = new CFExternalClassDescription(name, entry.canonicalFileName(), this);
            list.add(classDescription);
            if (map.containsKey(name)) continue;
            map.put(name, classDescription);
        }
    }

    ExternalClassDescription getClassDescriptionNamed(String className) {
        if (ClassTools.classNamedIsArray(className)) {
            return this.getArrayClassDescriptionNamed(className);
        }
        ExternalClassDescription classDescription = (ExternalClassDescription)this.defaultClassDescriptions.get(className);
        if (classDescription == null) {
            classDescription = this.getStubClassDescriptionNamed(className);
        }
        return classDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExternalClassDescription getStubClassDescriptionNamed(String className) {
        Map map = this.stubClassDescriptions;
        synchronized (map) {
            ExternalClassDescription stubClassDescription = (ExternalClassDescription)this.stubClassDescriptions.get(className);
            if (stubClassDescription == null) {
                stubClassDescription = new CFExternalClassDescription(className, this);
                this.stubClassDescriptions.put(className, stubClassDescription);
            }
            return stubClassDescription;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExternalClassDescription getArrayClassDescriptionNamed(String className) {
        Map map = this.arrayClassDescriptions;
        synchronized (map) {
            ExternalClassDescription arrayClassDescription = (ExternalClassDescription)this.arrayClassDescriptions.get(className);
            if (arrayClassDescription == null) {
                arrayClassDescription = new CFExternalClassDescription(className, this);
                this.arrayClassDescriptions.put(className, arrayClassDescription);
            }
            return arrayClassDescription;
        }
    }

    public String toString() {
        String moreInfo = this.classDescriptions == null ? "uninitialized" : String.valueOf(this.classDescriptions.length) + " types";
        return StringTools.buildToStringFor(this, moreInfo);
    }
}

