/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import java.lang.reflect.Field;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.indirection.BasicIndirectionPolicy;
import org.eclipse.persistence.internal.xr.Util;
import org.eclipse.persistence.internal.xr.XRDynamicClassLoader;
import org.eclipse.persistence.internal.xr.XRDynamicEntity;
import org.eclipse.persistence.internal.xr.XRDynamicEntityAccessor;
import org.eclipse.persistence.internal.xr.XRDynamicEntityVHAccessor;
import org.eclipse.persistence.internal.xr.XRFieldInfo;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;

public class ProjectHelper {
    public static void fixOROXAccessors(Project orProject, Project oxProject) {
        XRDynamicClassLoader xrdecl;
        ConversionManager conversionManager;
        Platform platform;
        for (ClassDescriptor desc : orProject.getDescriptors().values()) {
            Class clz = desc.getJavaClass();
            if (!XRDynamicEntity.class.isAssignableFrom(clz)) continue;
            ClassDescriptor xdesc = null;
            if (oxProject != null) {
                xdesc = oxProject.getDescriptorForAlias(desc.getAlias());
            }
            int idx = 0;
            XRFieldInfo xrfi = null;
            if (!clz.getName().endsWith("_CollectionWrapper")) {
                try {
                    Field xrfiField = Helper.getField((Class)clz, (String)"XRFI");
                    xrfi = (XRFieldInfo)xrfiField.get(null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (DatabaseMapping dm : desc.getMappings()) {
                String attributeName = dm.getAttributeName();
                DatabaseMapping xdm = null;
                if (xdesc != null) {
                    xdm = xdesc.getMappingForAttributeName(attributeName);
                }
                dm.setAttributeAccessor((AttributeAccessor)new XRDynamicEntityAccessor(attributeName, idx));
                if (xdm != null) {
                    if (dm.isForeignReferenceMapping()) {
                        ForeignReferenceMapping frm = (ForeignReferenceMapping)dm;
                        if (frm.usesIndirection() && frm.getIndirectionPolicy().getClass().isAssignableFrom(BasicIndirectionPolicy.class)) {
                            xdm.setAttributeAccessor((AttributeAccessor)new XRDynamicEntityVHAccessor(attributeName, idx));
                        } else {
                            xdm.setAttributeAccessor((AttributeAccessor)new XRDynamicEntityAccessor(attributeName, idx));
                        }
                    } else {
                        Class<?> schemaClass;
                        XMLField xmlField;
                        xdm.setAttributeAccessor((AttributeAccessor)new XRDynamicEntityAccessor(attributeName, idx));
                        if (xdm.isDirectToFieldMapping()) {
                            XMLDirectMapping xmlDM = (XMLDirectMapping)xdm;
                            xmlField = (XMLField)xmlDM.getField();
                            schemaClass = Util.SCHEMA_2_CLASS.get(xmlField.getSchemaType());
                            if (schemaClass != null) {
                                xmlField.setType(schemaClass);
                            } else {
                                xmlField.setType(ClassConstants.OBJECT);
                            }
                        } else if (xdm.isAbstractCompositeDirectCollectionMapping()) {
                            AbstractCompositeDirectCollectionMapping acdcm = (AbstractCompositeDirectCollectionMapping)xdm;
                            xmlField = (XMLField)acdcm.getField();
                            schemaClass = Util.SCHEMA_2_CLASS.get(xmlField.getSchemaType());
                            if (clz != null) {
                                xmlField.setType(schemaClass);
                            } else {
                                xmlField.setType(ClassConstants.OBJECT);
                            }
                        }
                    }
                }
                if (xrfi != null) {
                    xrfi.addFieldInfo(attributeName, idx);
                }
                ++idx;
            }
        }
        ClassLoader cl = null;
        Login login = orProject.getDatasourceLogin();
        if (login != null && (platform = login.getDatasourcePlatform()) != null && (conversionManager = platform.getConversionManager()) != null) {
            cl = conversionManager.getLoader();
        }
        if (cl != null && cl instanceof XRDynamicClassLoader) {
            xrdecl = (XRDynamicClassLoader)((Object)cl);
            xrdecl.dontGenerateSubclasses();
        }
        if (oxProject != null) {
            cl = null;
            login = oxProject.getDatasourceLogin();
            if (login != null && (platform = login.getDatasourcePlatform()) != null && (conversionManager = platform.getConversionManager()) != null) {
                cl = conversionManager.getLoader();
            }
            if (cl != null && cl instanceof XRDynamicClassLoader) {
                xrdecl = (XRDynamicClassLoader)((Object)cl);
                xrdecl.dontGenerateSubclasses();
            }
        }
    }
}

