/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import java.beans.PropertyChangeListener;
import java.util.Vector;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.exceptions.DynamicException;
import org.eclipse.persistence.indirection.IndirectContainer;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.xr.XRFieldInfo;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XRDynamicEntity
implements DynamicEntity,
PersistenceEntity,
ChangeTracker,
FetchGroupTracker {
    public static final String XR_FIELD_INFO_STATIC = "XRFI";
    protected XRField[] _fields;
    protected CacheKey __cacheKey;
    protected Vector __pk;
    protected PropertyChangeListener __changeListener = null;
    protected FetchGroup __fetchGroup;
    protected boolean __refreshFetchGroup = false;
    protected Session __session;

    public XRDynamicEntity() {
        int numFields = this.getFieldInfo().numFields();
        this._fields = new XRField[numFields];
        for (int i = 0; i < numFields; ++i) {
            this._fields[i] = new XRField();
        }
    }

    public abstract XRFieldInfo getFieldInfo();

    protected int getFieldIdx(String fieldName) {
        return this.getFieldInfo().getFieldIdx(fieldName);
    }

    public <T> T get(String fieldName) throws DynamicException {
        return (T)this.get(this.getFieldIdx(fieldName));
    }

    protected Object get(int fieldIdx) {
        XRField df = this._fields[fieldIdx];
        Object value = null;
        if (df.isSet) {
            value = df.fieldValue;
            if (value instanceof ValueHolderInterface) {
                value = ((ValueHolderInterface)value).getValue();
            } else if (value instanceof IndirectContainer) {
                value = ((IndirectContainer)value).getValueHolder().getValue();
            }
        }
        return value;
    }

    public boolean isSet(String fieldName) throws DynamicException {
        return this.isSet(this.getFieldIdx(fieldName));
    }

    protected boolean isSet(int fieldIdx) {
        return this._fields[fieldIdx].isSet;
    }

    public DynamicEntity set(String fieldName, Object value) throws DynamicException {
        this.set(this.getFieldIdx(fieldName), value);
        return this;
    }

    protected void set(int fieldIdx, Object value) {
        XRField df = this._fields[fieldIdx];
        Object currentValue = df.fieldValue;
        if (currentValue instanceof ValueHolderInterface) {
            ((ValueHolderInterface)currentValue).setValue(value);
        } else {
            df.fieldValue = value;
        }
        df.isSet = true;
    }

    public CacheKey _persistence_getCacheKey() {
        return this.__cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this.__cacheKey = cacheKey;
    }

    public Vector _persistence_getPKVector() {
        return this.__pk;
    }

    public void _persistence_setPKVector(Vector pk) {
        this.__pk = pk;
    }

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this.__changeListener;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener listener) {
        this.__changeListener = listener;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this.__fetchGroup;
    }

    public Session _persistence_getSession() {
        return this.__session;
    }

    public boolean _persistence_isAttributeFetched(String attribute) {
        return this.__fetchGroup == null || this.__fetchGroup.containsAttribute(attribute);
    }

    public void _persistence_resetFetchGroup() {
        throw new UnsupportedOperationException("XRDynamicEntity._persistence_resetFetchGroup:: NOT SUPPORTED");
    }

    public void _persistence_setFetchGroup(FetchGroup group) {
        this.__fetchGroup = group;
    }

    public void _persistence_setSession(Session session) {
        this.__session = session;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean shouldRefreshFetchGroup) {
        this.__refreshFetchGroup = shouldRefreshFetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this.__refreshFetchGroup;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(20);
        sb.append('{');
        sb.append(Helper.getShortClassName(this.getClass()));
        if (this.__pk != null) {
            for (int i = 0; i < this.__pk.size(); ++i) {
                sb.append(' ');
                sb.append(this.__pk.elementAt(i));
            }
        }
        sb.append('}');
        return sb.toString();
    }

    static class XRField {
        protected Object fieldValue = null;
        protected boolean isSet = false;

        XRField() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.isSet) {
                sb.append("[T]");
            } else {
                sb.append("[F]");
            }
            if (this.fieldValue == null) {
                sb.append("<null>");
            } else {
                sb.append(this.fieldValue.toString());
            }
            return sb.toString();
        }
    }
}

