/*******************************************************************************
 * Copyright (c) 1998, 2009 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the 
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0 
 * which accompanies this distribution. 
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at 
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation from Oracle TopLink
 ******************************************************************************/  
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.tools.schemaframework.*;

public class State {
    public String name;
    public org.eclipse.persistence.indirection.ValueHolderInterface country = new org.eclipse.persistence.indirection.ValueHolder();
    public static State alabama;
    public static State athens;
    public static State alberta;

    /**
     * This method was created in VisualAge.
     */
    public State() {
    }

    public static State alabama() {
        State state = new State();
        state.name = "Alabama";
        state.setCountry(Country.usa);
        alabama = state;
        return alabama;
    }

    public static State alberta() {
        State state = new State();
        state.name = "Alberta";
        state.setCountry(Country.canada);
        alberta = state;
        return alberta;
    }

    public static State athens() {
        State state = new State();
        state.name = "Athens";
        state.setCountry(Country.greece);
        athens = state;
        return athens;
    }

    /**
     * TopLink generated method.
     * <b>WARNING</b>: This code was generated by an automated tool.
     * Any changes will be lost when the code is re-generated
     */
    public static TableDefinition buildSTATETable() {
        org.eclipse.persistence.tools.schemaframework.TableDefinition tabledefinition = new org.eclipse.persistence.tools.schemaframework.TableDefinition();

        // SECTION: TABLE
        tabledefinition.setName("STATE");

        // SECTION: FIELD
        org.eclipse.persistence.tools.schemaframework.FieldDefinition field = new org.eclipse.persistence.tools.schemaframework.FieldDefinition();
        field.setName("NAME");
        field.setTypeName("VARCHAR");
        field.setShouldAllowNull(false);
        field.setIsPrimaryKey(true);
        field.setUnique(false);
        field.setIsIdentity(false);
        tabledefinition.addField(field);

        // SECTION: FIELD
        org.eclipse.persistence.tools.schemaframework.FieldDefinition field1 = new org.eclipse.persistence.tools.schemaframework.FieldDefinition();
        field1.setName("COUNTRY");
        field1.setTypeName("VARCHAR");
        field1.setShouldAllowNull(false);
        field1.setIsPrimaryKey(true);
        field1.setUnique(false);
        field1.setIsIdentity(false);
        tabledefinition.addField(field1);
        return tabledefinition;
    }

    public Country getCountry() {
        return (Country)country.getValue();
    }

    public void setCountry(Country value) {
        country.setValue(value);
    }

    public void setName(String theName) {
        name = theName;
    }
}
