/*******************************************************************************
 * Copyright (c) 1998, 2009 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the 
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0 
 * which accompanies this distribution. 
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at 
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation from Oracle TopLink
 ******************************************************************************/  
package org.eclipse.persistence.testing.tests.returning.model;

import org.eclipse.persistence.sessions.*;
import org.eclipse.persistence.mappings.*;
import org.eclipse.persistence.descriptors.RelationalDescriptor;

/**
 * This class was generated by the TopLink project class generator.
 * It stores the meta-data (descriptors) that define the TopLink mappings.
 * ## TopLink - 9.0.3 (Build 423) ##
 * @see org.eclipse.persistence.sessions.factories.ProjectClassGenerator
 */
public class ReturningProject extends org.eclipse.persistence.sessions.Project {

    public ReturningProject() {
        setName("ReturningTestProject");
        applyLogin();

        addDescriptor(buildClass1Descriptor());
        addDescriptor(buildClass2Descriptor());
    }

    public void applyLogin() {
        DatabaseLogin login = new DatabaseLogin();
        setLogin(login);
    }

    public RelationalDescriptor buildClass1Descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(org.eclipse.persistence.testing.tests.returning.model.Class1.class);
        descriptor.addTableName("RETURNING");
        descriptor.addPrimaryKeyFieldName("RETURNING.ID");

        // RelationalDescriptor properties.
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.useRemoteSoftCacheWeakIdentityMap();
        descriptor.setRemoteIdentityMapSize(100);
        descriptor.setAlias("Class1");

        // Query manager.
        descriptor.getQueryManager().checkCacheForDoesExist();
        //Named Queries

        // Event manager.

        // Mappings.
        DirectToFieldMapping a_IntegerMapping = new DirectToFieldMapping();
        a_IntegerMapping.setAttributeName("a_Integer");
        a_IntegerMapping.setFieldName("RETURNING.A1");
        a_IntegerMapping.readOnly();
        descriptor.addMapping(a_IntegerMapping);

        DirectToFieldMapping b_IntegerMapping = new DirectToFieldMapping();
        b_IntegerMapping.setAttributeName("b_Integer");
        b_IntegerMapping.setFieldName("RETURNING.B1");
        b_IntegerMapping.readOnly();
        descriptor.addMapping(b_IntegerMapping);

        DirectToFieldMapping c_BigDecimalMapping = new DirectToFieldMapping();
        c_BigDecimalMapping.setAttributeName("c_BigDecimal");
        c_BigDecimalMapping.setFieldName("RETURNING.C1");
        descriptor.addMapping(c_BigDecimalMapping);

        DirectToFieldMapping c_IntegerMapping = new DirectToFieldMapping();
        c_IntegerMapping.setAttributeName("c_Integer");
        c_IntegerMapping.setFieldName("RETURNING.C1");
        c_IntegerMapping.readOnly();
        descriptor.addMapping(c_IntegerMapping);

        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("RETURNING.ID");
        descriptor.addMapping(idMapping);

        TransformationMapping a_plus_minus_b_BigDecimalMapping = new TransformationMapping();
        a_plus_minus_b_BigDecimalMapping.setAttributeName("a_plus_minus_b_BigDecimal");
        a_plus_minus_b_BigDecimalMapping.setAttributeTransformation("build_a_plus_minus_b_BigDecimal");
        a_plus_minus_b_BigDecimalMapping.addFieldTransformation("RETURNING.B1", "getB");
        a_plus_minus_b_BigDecimalMapping.addFieldTransformation("RETURNING.A1", "getA");
        descriptor.addMapping(a_plus_minus_b_BigDecimalMapping);

        AggregateObjectMapping aggregateMapping = new AggregateObjectMapping();
        aggregateMapping.setAttributeName("aggregate");
        aggregateMapping.setReferenceClass(org.eclipse.persistence.testing.tests.returning.model.Class2.class);
        aggregateMapping.setIsNullAllowed(true);
        aggregateMapping.addFieldNameTranslation("RETURNING.C2", "C2");
        aggregateMapping.addFieldNameTranslation("RETURNING.B2", "B2");
        aggregateMapping.addFieldNameTranslation("RETURNING.A2", "A2");
        descriptor.addMapping(aggregateMapping);

        return descriptor;
    }

    public RelationalDescriptor buildClass2Descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.descriptorIsAggregate();
        descriptor.setJavaClass(org.eclipse.persistence.testing.tests.returning.model.Class2.class);

        // RelationalDescriptor properties.
        descriptor.setAlias("Class2");

        // Query manager.
        //Named Queries

        // Event manager.

        // Mappings.
        DirectToFieldMapping a_IntegerMapping = new DirectToFieldMapping();
        a_IntegerMapping.setAttributeName("a_Integer");
        a_IntegerMapping.setFieldName("A2");
        a_IntegerMapping.readOnly();
        descriptor.addMapping(a_IntegerMapping);

        DirectToFieldMapping b_IntegerMapping = new DirectToFieldMapping();
        b_IntegerMapping.setAttributeName("b_Integer");
        b_IntegerMapping.setFieldName("B2");
        b_IntegerMapping.readOnly();
        descriptor.addMapping(b_IntegerMapping);

        DirectToFieldMapping c_BigDecimalMapping = new DirectToFieldMapping();
        c_BigDecimalMapping.setAttributeName("c_BigDecimal");
        c_BigDecimalMapping.setFieldName("C2");
        descriptor.addMapping(c_BigDecimalMapping);

        DirectToFieldMapping c_IntegerMapping = new DirectToFieldMapping();
        c_IntegerMapping.setAttributeName("c_Integer");
        c_IntegerMapping.setFieldName("C2");
        c_IntegerMapping.readOnly();
        descriptor.addMapping(c_IntegerMapping);

        TransformationMapping a_plus_minus_b_BigDecimalMapping = new TransformationMapping();
        a_plus_minus_b_BigDecimalMapping.setAttributeName("a_plus_minus_b_BigDecimal");
        a_plus_minus_b_BigDecimalMapping.setAttributeTransformation("build_a_plus_minus_b_BigDecimal");
        a_plus_minus_b_BigDecimalMapping.addFieldTransformation("B2", "getB");
        a_plus_minus_b_BigDecimalMapping.addFieldTransformation("A2", "getA");
        descriptor.addMapping(a_plus_minus_b_BigDecimalMapping);

        return descriptor;
    }
}
