/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.eclipse.persistence.internal.dbws.ProviderHelper;
import org.eclipse.persistence.tools.dbws.DBWSBuilder;
import org.eclipse.persistence.tools.dbws.DBWSPackager;
import org.eclipse.persistence.tools.dbws.WeblogicPackager;
import org.eclipse.persistence.tools.dbws.XRPackager;

public class JDevPackager
extends WeblogicPackager {
    public static final String DBWS_PROVIDER_SOURCE_PREAMBLE = "package _dbws;\n\n//javase imports\nimport java.lang.reflect.Method;\n\n//Java extension libraries\nimport javax.annotation.PostConstruct;\nimport javax.annotation.PreDestroy;\nimport javax.annotation.Resource;\nimport javax.servlet.ServletContext;\nimport javax.xml.soap.SOAPMessage;\nimport javax.xml.ws.BindingType;\nimport javax.xml.ws.Provider;\nimport javax.xml.ws.ServiceMode;\nimport javax.xml.ws.WebServiceContext;\nimport javax.xml.ws.WebServiceProvider;\nimport javax.xml.ws.handler.MessageContext;\nimport javax.xml.ws.soap.SOAPBinding;\nimport static javax.xml.ws.Service.Mode.MESSAGE;\nimport static javax.xml.ws.soap.SOAPBinding.SOAP12HTTP_BINDING;\nimport static javax.xml.ws.soap.SOAPBinding.SOAP11HTTP_MTOM_BINDING;\nimport static javax.xml.ws.soap.SOAPBinding.SOAP12HTTP_MTOM_BINDING;\n\n//EclipseLink imports\nimport " + ProviderHelper.class.getName() + ";\n" + "\n" + "@WebServiceProvider(\n" + "    wsdlLocation = \"WEB-INF/wsdl/eclipselink-dbws.wsdl\",\n" + "    serviceName = \"";
    public static final String DBWS_PROVIDER_SOURCE_PORT_NAME = "\",\n    portName = \"";
    public static final String DBWS_PROVIDER_SOURCE_TARGET_NAMESPACE = "\",\n    targetNamespace = \"";
    public static final String DBWS_PROVIDER_SOURCE_SUFFIX = "\"\n)\n@ServiceMode(MESSAGE)\n";
    public static final String DBWS_PROVIDER_SOAP12_BINDING = "@BindingType(value=SOAP12HTTP_BINDING)\n";
    public static final String DBWS_PROVIDER_SOAP11_MTOM_BINDING = "@BindingType(value=SOAP11HTTP_MTOM_BINDING)\n";
    public static final String DBWS_PROVIDER_SOAP12_MTOM_BINDING = "@BindingType(value=SOAP12HTTP_MTOM_BINDING)\n";
    public static final String DBWS_PROVIDER_SOURCE_CLASSDEF = "public class DBWSProvider extends ProviderHelper implements Provider<SOAPMessage> {\n\n    // Container injects wsContext here\n    @Resource\n    protected WebServiceContext wsContext;\n    public  DBWSProvider() {\n        super();\n    }\n    private static final String CONTAINER_RESOLVER_CLASSNAME =\n        \"com.sun.xml.ws.api.server.ContainerResolver\";\n    @PostConstruct\n    public void init() {\n        ClassLoader parentClassLoader = Thread.currentThread().getContextClassLoader();\n        ServletContext sc = null;\n        //ServletContext sc = \n        //    ContainerResolver.getInstance().getContainer().getSPI(ServletContext.class);\n        try {\n            Class<?> containerResolverClass = parentClassLoader.loadClass(\n                CONTAINER_RESOLVER_CLASSNAME);\n            Method getInstanceMethod = containerResolverClass.getMethod(\"getInstance\");\n            Object containerResolver = getInstanceMethod.invoke(null);\n            Method getContainerMethod = containerResolver.getClass().getMethod(\"getContainer\");\n            getContainerMethod.setAccessible(true);\n            Object container = getContainerMethod.invoke(containerResolver);\n            Method getSPIMethod = container.getClass().getMethod(\"getSPI\", Class.class);\n            getSPIMethod.setAccessible(true);\n            sc = (ServletContext)getSPIMethod.invoke(container, ServletContext.class);\n        }\n        catch (Exception e) {\n            // if the above doesn't work, then maybe we are running in JavaSE 6 'containerless' mode\n            // we can live with a null ServletContext (just use the parentClassLoader to load resources \n        }\n        boolean mtomEnabled = false;\n        BindingType thisBindingType = this.getClass().getAnnotation(BindingType.class);\n        if (thisBindingType != null) {\n            if (thisBindingType.value().toLowerCase().contains(\"mtom=true\")) {\n                mtomEnabled = true;\n            }\n        }\n        super.init(parentClassLoader, sc, mtomEnabled);\n    }\n    @Override\n    public SOAPMessage invoke(SOAPMessage request) {\n        if (wsContext != null) {\n            setMessageContext(wsContext.getMessageContext());\n        }\n        return super.invoke(request);\n    }\n    @Override\n    @PreDestroy\n    public void destroy() {\n        super.destroy();\n    }\n};\n";
    public static final String SRC_DIR = "src";
    public static final String PUBLIC_HTML_DIR = "public_html";
    protected File srcDir;
    protected File publicHTMLDir;
    protected File webInfDir;
    protected File wsdlDir;
    protected File underDBWSDir;

    public JDevPackager() {
        this(null, "jdev", DBWSPackager.ArchiveUse.noArchive);
    }

    protected JDevPackager(DBWSPackager.Archiver archiver, String packagerLabel, DBWSPackager.ArchiveUse useJavaArchive) {
        super(archiver, packagerLabel, useJavaArchive);
    }

    @Override
    public String getArchiverLabel() {
        return "not supported";
    }

    @Override
    public String getAdditionalUsage() {
        return null;
    }

    @Override
    public DBWSPackager.Archiver buildDefaultArchiver() {
        return null;
    }

    @Override
    public OutputStream getSchemaStream() throws FileNotFoundException {
        this.buildWSDLDir();
        return new FileOutputStream(new File(this.wsdlDir, "eclipselink-dbws-schema.xsd"));
    }

    @Override
    public OutputStream getSessionsStream(String sessionsFileName) throws FileNotFoundException {
        this.buildSrcDir();
        return new FileOutputStream(new File(this.srcDir, sessionsFileName));
    }

    @Override
    public OutputStream getServiceStream() throws FileNotFoundException {
        this.buildSrcDir();
        return new FileOutputStream(new File(this.srcDir, "eclipselink-dbws.xml"));
    }

    @Override
    public OutputStream getOrStream() throws FileNotFoundException {
        this.buildSrcDir();
        return new FileOutputStream(new File(this.srcDir, "eclipselink-dbws-or.xml"));
    }

    @Override
    public OutputStream getOxStream() throws FileNotFoundException {
        this.buildSrcDir();
        return new FileOutputStream(new File(this.srcDir, "eclipselink-dbws-ox.xml"));
    }

    @Override
    public OutputStream getWSDLStream() throws FileNotFoundException {
        this.buildWSDLDir();
        return new FileOutputStream(new File(this.wsdlDir, "eclipselink-dbws.wsdl"));
    }

    @Override
    public OutputStream getSWARefStream() throws FileNotFoundException {
        if (this.hasAttachments) {
            this.buildWSDLDir();
            return new FileOutputStream(new File(this.wsdlDir, "swaref.xsd"));
        }
        return XRPackager.__nullStream;
    }

    @Override
    public OutputStream getWebXmlStream() throws FileNotFoundException {
        this.buildWebInfDir();
        return new FileOutputStream(new File(this.webInfDir, "web.xml"));
    }

    @Override
    public OutputStream getProviderClassStream() throws FileNotFoundException {
        return XRPackager.__nullStream;
    }

    @Override
    public void writeProviderClass(OutputStream codeGenProviderStream, DBWSBuilder builder) {
    }

    protected void buildSrcDir() throws FileNotFoundException {
        boolean worked;
        this.srcDir = new File(this.stageDir, SRC_DIR);
        if (!this.srcDir.exists() && !(worked = this.srcDir.mkdir())) {
            throw new FileNotFoundException("cannot create src under " + this.stageDir);
        }
    }

    protected void buildUnderDBWS() throws FileNotFoundException {
        boolean worked;
        this.buildSrcDir();
        this.underDBWSDir = new File(this.srcDir, "_dbws");
        if (!this.underDBWSDir.exists() && !(worked = this.underDBWSDir.mkdir())) {
            throw new FileNotFoundException("cannot create src/_dbws dir under " + this.stageDir);
        }
    }

    protected void buildPublicHTMLDir() throws FileNotFoundException {
        boolean worked;
        this.publicHTMLDir = new File(this.stageDir, PUBLIC_HTML_DIR);
        if (!this.publicHTMLDir.exists() && !(worked = this.publicHTMLDir.mkdir())) {
            throw new FileNotFoundException("cannot create public_html under " + this.stageDir);
        }
    }

    protected void buildWebInfDir() throws FileNotFoundException {
        boolean worked;
        this.buildPublicHTMLDir();
        this.webInfDir = new File(this.publicHTMLDir, "WEB-INF/");
        if (!this.webInfDir.exists() && !(worked = this.webInfDir.mkdir())) {
            throw new FileNotFoundException("cannot create WEB-INF/ under public_html");
        }
    }

    protected void buildWSDLDir() throws FileNotFoundException {
        boolean worked;
        this.buildWebInfDir();
        this.wsdlDir = new File(this.webInfDir, "wsdl/");
        if (!this.wsdlDir.exists() && !(worked = this.wsdlDir.mkdir())) {
            throw new FileNotFoundException("cannot create wsdl/ under WEB-INF/");
        }
    }

    @Override
    public OutputStream getProviderSourceStream() throws FileNotFoundException {
        this.buildUnderDBWS();
        return new FileOutputStream(new File(this.underDBWSDir, "DBWSProvider.java"));
    }

    @Override
    public void writeProviderSource(OutputStream sourceProviderStream, DBWSBuilder builder) {
        StringBuilder sb = new StringBuilder(DBWS_PROVIDER_SOURCE_PREAMBLE);
        String serviceName = builder.getWSDLGenerator().getServiceName();
        sb.append(serviceName);
        sb.append(DBWS_PROVIDER_SOURCE_PORT_NAME);
        sb.append(serviceName + "Port");
        sb.append(DBWS_PROVIDER_SOURCE_TARGET_NAMESPACE);
        sb.append(builder.getWSDLGenerator().getServiceNameSpace());
        sb.append(DBWS_PROVIDER_SOURCE_SUFFIX);
        if (builder.usesSOAP12()) {
            if (builder.mtomEnabled()) {
                sb.append(DBWS_PROVIDER_SOAP12_MTOM_BINDING);
            } else {
                sb.append(DBWS_PROVIDER_SOAP12_BINDING);
            }
        } else if (builder.mtomEnabled()) {
            sb.append(DBWS_PROVIDER_SOAP11_MTOM_BINDING);
        }
        sb.append(DBWS_PROVIDER_SOURCE_CLASSDEF);
        OutputStreamWriter osw = new OutputStreamWriter(new BufferedOutputStream(sourceProviderStream));
        try {
            osw.write(sb.toString());
            osw.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
    }
}

