/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.util.attrs;

import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ClassReader;
import org.eclipse.persistence.internal.libraries.asm.Label;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.libraries.asm.attrs.Annotation;
import org.eclipse.persistence.internal.libraries.asm.attrs.AnnotationDefaultAttribute;
import org.eclipse.persistence.internal.libraries.asm.util.attrs.ASMifiable;

public class ASMAnnotationDefaultAttribute
extends AnnotationDefaultAttribute
implements ASMifiable {
    protected Attribute read(ClassReader cr, int off, int len, char[] buf, int codeOff, Label[] labels) {
        AnnotationDefaultAttribute attr = (AnnotationDefaultAttribute)super.read(cr, off, len, buf, codeOff, labels);
        ASMAnnotationDefaultAttribute result = new ASMAnnotationDefaultAttribute();
        result.defaultValue = attr.defaultValue;
        return result;
    }

    public void asmify(StringBuffer buf, String varName, Map labelNames) {
        buf.append("AnnotationDefaultAttribute ").append(varName).append(" = new AnnotationDefaultAttribute();\n");
        String val = ASMAnnotationDefaultAttribute.asmify(this.defaultValue, buf, String.valueOf(varName) + "Val");
        buf.append(varName).append(".defaultValue = ").append(val).append(";\n");
    }

    static void asmifyAnnotations(StringBuffer buf, String varName, List annotations) {
        if (annotations.size() > 0) {
            buf.append("{\n");
            int i = 0;
            while (i < annotations.size()) {
                String val = String.valueOf(varName) + "ann" + i;
                ASMAnnotationDefaultAttribute.asmify((Annotation)annotations.get(i), buf, val);
                buf.append(varName).append(".annotations.add( ").append(val).append(");\n");
                ++i;
            }
            buf.append("}\n");
        }
    }

    static void asmifyParameterAnnotations(StringBuffer buf, String varName, List parameters) {
        if (parameters.size() > 0) {
            buf.append("{\n");
            int i = 0;
            while (i < parameters.size()) {
                String val = String.valueOf(varName) + "param" + i;
                buf.append("List ").append(val).append(" = new ArrayList();\n");
                List annotations = (List)parameters.get(i);
                if (annotations.size() > 0) {
                    buf.append("{\n");
                    int i1 = 0;
                    while (i1 < annotations.size()) {
                        String val1 = String.valueOf(val) + "ann" + i1;
                        ASMAnnotationDefaultAttribute.asmify((Annotation)annotations.get(i1), buf, val1);
                        buf.append(val).append(".add( ").append(val1).append(");\n");
                        ++i1;
                    }
                    buf.append("}\n");
                }
                buf.append(varName).append(".parameters.add( ").append(val).append(");\n\n");
                ++i;
            }
            buf.append("}\n");
        }
    }

    static String asmify(Annotation a, StringBuffer buf, String varName) {
        buf.append("Annotation ").append(varName).append(" = new Annotation(\"").append(a.type).append("\");\n");
        List elementValues = a.elementValues;
        if (elementValues.size() > 0) {
            int i = 0;
            while (i < elementValues.size()) {
                Object[] values = (Object[])elementValues.get(i);
                String val = ASMAnnotationDefaultAttribute.asmify(values[1], buf, String.valueOf(varName) + "val" + i);
                buf.append(varName).append(".add( \"").append(values[0]).append("\", ").append(val).append(");\n");
                ++i;
            }
        }
        return varName;
    }

    static String asmify(Object value, StringBuffer buf, String valName) {
        if (value instanceof String) {
            return "\"" + value + "\"";
        }
        if (value instanceof Integer) {
            return "new Integer(" + value + ")";
        }
        if (value instanceof Byte) {
            return "new Byte((byte)" + value + ")";
        }
        if (value instanceof Character) {
            return "new Character((char)" + ((Character)value).charValue() + ")";
        }
        if (value instanceof Double) {
            return "new Double(\"" + value + "\")";
        }
        if (value instanceof Float) {
            return "new Float(\"" + value + "\")";
        }
        if (value instanceof Long) {
            return "new Long(" + value + "L)";
        }
        if (value instanceof Short) {
            return "new Short((short)" + value + ")";
        }
        if (value instanceof Boolean) {
            return "new Boolean(" + value + ")";
        }
        if (value instanceof Annotation.EnumConstValue) {
            Annotation.EnumConstValue e = (Annotation.EnumConstValue)value;
            return "new Annotation.EnumConstValue(\"" + e.typeName + "\", \"" + e.constName + "\")";
        }
        if (value instanceof Type) {
            Type t = (Type)value;
            return "Type.getType(\"" + t.getDescriptor() + "\")";
        }
        if (value instanceof Annotation) {
            return ASMAnnotationDefaultAttribute.asmify((Annotation)value, buf, valName);
        }
        if (value instanceof Object[]) {
            Object[] v = (Object[])value;
            buf.append("Object[] ").append(valName).append(" = new Object[").append(v.length).append("];\n");
            int i = 0;
            while (i < v.length) {
                String val = ASMAnnotationDefaultAttribute.asmify(v[i], buf, String.valueOf(valName) + "Arr" + i);
                buf.append(String.valueOf(valName) + "[" + i + "] = ").append(val).append(";\n");
                ++i;
            }
            return valName;
        }
        if (value instanceof byte[]) {
            byte[] v = (byte[])value;
            StringBuffer sb = new StringBuffer("new byte[] {");
            String sep = "";
            int i = 0;
            while (i < v.length) {
                sb.append(sep).append(v[i]);
                sep = ", ";
                ++i;
            }
            sb.append("}");
            return sb.toString();
        }
        if (value instanceof char[]) {
            char[] v = (char[])value;
            StringBuffer sb = new StringBuffer("new char[] {");
            String sep = "";
            int i = 0;
            while (i < v.length) {
                sb.append(sep).append("(char)").append((int)v[i]);
                sep = ", ";
                ++i;
            }
            sb.append("}");
            return sb.toString();
        }
        if (value instanceof short[]) {
            short[] v = (short[])value;
            StringBuffer sb = new StringBuffer("new short[] {");
            String sep = "";
            int i = 0;
            while (i < v.length) {
                sb.append(sep).append("(short)").append(v[i]);
                sep = ", ";
                ++i;
            }
            sb.append("}");
            return sb.toString();
        }
        if (value instanceof long[]) {
            long[] v = (long[])value;
            StringBuffer sb = new StringBuffer("new long[] {");
            String sep = "";
            int i = 0;
            while (i < v.length) {
                sb.append(sep).append(v[i]).append("L");
                sep = ", ";
                ++i;
            }
            sb.append("}");
            return sb.toString();
        }
        if (value instanceof int[]) {
            int[] v = (int[])value;
            StringBuffer sb = new StringBuffer("new int[] {");
            String sep = "";
            int i = 0;
            while (i < v.length) {
                sb.append(sep).append(v[i]);
                sep = ", ";
                ++i;
            }
            sb.append("}");
            return sb.toString();
        }
        if (value instanceof boolean[]) {
            boolean[] v = (boolean[])value;
            StringBuffer sb = new StringBuffer("new boolean[] {");
            String sep = "";
            int i = 0;
            while (i < v.length) {
                sb.append(sep).append(v[i]);
                sep = ", ";
                ++i;
            }
            sb.append("}");
            return sb.toString();
        }
        if (value instanceof float[]) {
            float[] v = (float[])value;
            StringBuffer sb = new StringBuffer("new float[] {");
            String sep = "";
            int i = 0;
            while (i < v.length) {
                sb.append(sep).append(v[i]).append("f");
                sep = ", ";
                ++i;
            }
            sb.append("}");
            return sb.toString();
        }
        if (value instanceof double[]) {
            double[] v = (double[])value;
            StringBuffer sb = new StringBuffer("new double[] {");
            String sep = "";
            int i = 0;
            while (i < v.length) {
                sb.append(sep).append(v[i]).append("d");
                sep = ", ";
                ++i;
            }
            sb.append("}");
            return sb.toString();
        }
        throw new IllegalArgumentException("Invalid value: " + value.getClass().getName() + " : " + value);
    }
}

