/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MappedSuperclassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataFactory;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataFile;
import org.eclipse.persistence.internal.jpa.metadata.converters.ConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.ObjectTypeConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.StructConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.TypeConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.listeners.EntityListenerMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedNativeQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedStoredProcedureQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.SQLResultSetMappingMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.SequenceGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.TableGeneratorMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappingsReader;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappingsWriter;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLPersistenceUnitMetadata;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLEntityMappings
extends ORMetadata {
    private boolean m_isEclipseLinkORMFile = false;
    private ClassLoader m_loader;
    private List<EntityAccessor> m_entities;
    private List<ConverterMetadata> m_converters;
    private List<EmbeddableAccessor> m_embeddables;
    private List<MappedSuperclassAccessor> m_mappedSuperclasses;
    private List<NamedNativeQueryMetadata> m_namedNativeQueries;
    private List<NamedQueryMetadata> m_namedQueries;
    private List<NamedStoredProcedureQueryMetadata> m_namedStoredProcedureQueries;
    private List<ObjectTypeConverterMetadata> m_objectTypeConverters;
    private List<SequenceGeneratorMetadata> m_sequenceGenerators;
    private List<SQLResultSetMappingMetadata> m_sqlResultSetMappings;
    private List<StructConverterMetadata> m_structConverters;
    private List<TableGeneratorMetadata> m_tableGenerators;
    private List<TypeConverterMetadata> m_typeConverters;
    private MetadataFactory m_factory;
    private MetadataFile m_file;
    private MetadataProject m_project;
    private String m_access;
    private String m_catalog;
    private String m_description;
    private String m_package;
    private String m_schema;
    private String m_version;
    private String m_mappingFileNameOrURL;
    private XMLPersistenceUnitMetadata m_persistenceUnitMetadata;

    public XMLEntityMappings() {
        super("<entity-mappings>");
    }

    public String getAccess() {
        return this.m_access;
    }

    public String getCatalog() {
        return this.m_catalog;
    }

    protected Class getClassForName(String classname, ClassLoader loader) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return (Class)AccessController.doPrivileged(new PrivilegedClassForName(classname, true, loader));
                }
                catch (PrivilegedActionException exception) {
                    throw ValidationException.unableToLoadClass((String)classname, (Exception)exception.getException());
                }
            }
            return PrivilegedAccessHelper.getClassForName((String)classname, (boolean)true, (ClassLoader)loader);
        }
        catch (Exception exception) {
            throw ValidationException.unableToLoadClass((String)classname, (Exception)exception);
        }
    }

    public String getFullClassName(String className) {
        if (className == null || className.equals("")) {
            return "void";
        }
        if (className.equalsIgnoreCase("Boolean")) {
            return "java.lang.Boolean";
        }
        if (className.equalsIgnoreCase("Byte")) {
            return "java.lang.Byte";
        }
        if (className.equalsIgnoreCase("Character")) {
            return "java.lang.Character";
        }
        if (className.equalsIgnoreCase("Double")) {
            return "java.lang.Double";
        }
        if (className.equalsIgnoreCase("Float")) {
            return "java.lang.Float";
        }
        if (className.equalsIgnoreCase("Integer")) {
            return "java.lang.Integer";
        }
        if (className.equalsIgnoreCase("Long")) {
            return "java.lang.Long";
        }
        if (className.equalsIgnoreCase("Number")) {
            return "java.lang.Number";
        }
        if (className.equalsIgnoreCase("Short")) {
            return "java.lang.Short";
        }
        if (className.equalsIgnoreCase("String")) {
            return "java.lang.String";
        }
        return this.getFullyQualifiedClassName(className);
    }

    public Class getClassForName(String className) {
        return this.getClassForName(this.getFullyQualifiedClassName(className), this.m_loader);
    }

    public List<ConverterMetadata> getConverters() {
        return this.m_converters;
    }

    public String getDescription() {
        return this.m_description;
    }

    protected String getDefaultCatalog() {
        if (this.m_catalog == null) {
            if (this.m_project.getPersistenceUnitMetadata() == null) {
                return null;
            }
            return this.m_project.getPersistenceUnitMetadata().getCatalog();
        }
        return this.m_catalog;
    }

    protected String getDefaultSchema() {
        if (this.m_schema == null) {
            if (this.m_project.getPersistenceUnitMetadata() == null) {
                return null;
            }
            return this.m_project.getPersistenceUnitMetadata().getSchema();
        }
        return this.m_schema;
    }

    public List<EmbeddableAccessor> getEmbeddables() {
        return this.m_embeddables;
    }

    public List<EntityAccessor> getEntities() {
        return this.m_entities;
    }

    public String getFullyQualifiedClassName(String className) {
        if (this.m_package == null || this.m_package.equals("")) {
            return className;
        }
        if (className.indexOf(".") > -1) {
            return className;
        }
        if (this.m_package.endsWith(".")) {
            return this.m_package + className;
        }
        return this.m_package + "." + className;
    }

    public MetadataLogger getLogger() {
        return this.m_project.getLogger();
    }

    public List<MappedSuperclassAccessor> getMappedSuperclasses() {
        return this.m_mappedSuperclasses;
    }

    public String getMappingFileOrURL() {
        return this.m_mappingFileNameOrURL;
    }

    @Override
    public MetadataFactory getMetadataFactory() {
        return this.m_factory;
    }

    public List<NamedNativeQueryMetadata> getNamedNativeQueries() {
        return this.m_namedNativeQueries;
    }

    public List<NamedQueryMetadata> getNamedQueries() {
        return this.m_namedQueries;
    }

    public List<NamedStoredProcedureQueryMetadata> getNamedStoredProcedureQueries() {
        return this.m_namedStoredProcedureQueries;
    }

    public List<ObjectTypeConverterMetadata> getObjectTypeConverters() {
        return this.m_objectTypeConverters;
    }

    public String getPackage() {
        return this.m_package;
    }

    public XMLPersistenceUnitMetadata getPersistenceUnitMetadata() {
        return this.m_persistenceUnitMetadata;
    }

    public MetadataProject getProject() {
        return this.m_project;
    }

    public String getSchema() {
        return this.m_schema;
    }

    public List<SequenceGeneratorMetadata> getSequenceGenerators() {
        return this.m_sequenceGenerators;
    }

    public List<SQLResultSetMappingMetadata> getSqlResultSetMappings() {
        return this.m_sqlResultSetMappings;
    }

    public List<StructConverterMetadata> getStructConverters() {
        return this.m_structConverters;
    }

    public List<TableGeneratorMetadata> getTableGenerators() {
        return this.m_tableGenerators;
    }

    public List<TypeConverterMetadata> getTypeConverters() {
        return this.m_typeConverters;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void initPersistenceUnitClasses(HashMap<String, EntityAccessor> allEntities, HashMap<String, EmbeddableAccessor> allEmbeddables) {
        for (EntityAccessor entity : this.getEntities()) {
            MetadataClass entityClass = this.getMetadataClass(this.getFullClassName(entity.getClassName()));
            entity.initXMLClassAccessor(entityClass, new MetadataDescriptor(entityClass, entity), this.m_project, this);
            if (allEntities.containsKey(entityClass.getName())) {
                allEntities.get(entityClass.getName()).merge(entity);
                continue;
            }
            allEntities.put(entityClass.getName(), entity);
        }
        for (EmbeddableAccessor embeddable : this.getEmbeddables()) {
            MetadataClass embeddableClass = this.getMetadataClass(this.getFullClassName(embeddable.getClassName()));
            embeddable.initXMLClassAccessor(embeddableClass, new MetadataDescriptor(embeddableClass, embeddable), this.m_project, this);
            if (allEmbeddables.containsKey(embeddableClass.getName())) {
                allEmbeddables.get(embeddableClass.getName()).merge(embeddable);
                continue;
            }
            allEmbeddables.put(embeddableClass.getName(), embeddable);
        }
        for (MappedSuperclassAccessor mappedSuperclass : this.getMappedSuperclasses()) {
            MetadataClass mappedSuperclassClass = this.getMetadataClass(this.getFullClassName(mappedSuperclass.getClassName()));
            mappedSuperclass.setAccessibleObject(mappedSuperclassClass);
            mappedSuperclass.setEntityMappings(this);
            if (this.m_project.hasMappedSuperclass(mappedSuperclassClass)) {
                this.m_project.getMappedSuperclassAccessor(mappedSuperclassClass).merge(mappedSuperclass);
                continue;
            }
            this.m_project.addMappedSuperclass(mappedSuperclass);
        }
    }

    public boolean isEclipseLinkORMFile() {
        return this.m_isEclipseLinkORMFile;
    }

    protected XMLEntityMappings newXMLEntityMappingsObject() {
        XMLEntityMappings entityMappingsOut = new XMLEntityMappings();
        entityMappingsOut.setVersion(this.getVersion());
        return entityMappingsOut;
    }

    public void process() {
        for (ConverterMetadata converter : this.m_converters) {
            converter.initXMLObject(this.m_file, this);
            this.m_project.addConverter(converter);
        }
        for (TypeConverterMetadata typeConverter : this.m_typeConverters) {
            typeConverter.initXMLObject(this.m_file, this);
            this.m_project.addConverter(typeConverter);
        }
        for (ObjectTypeConverterMetadata objectTypeConverter : this.m_objectTypeConverters) {
            objectTypeConverter.initXMLObject(this.m_file, this);
            this.m_project.addConverter(objectTypeConverter);
        }
        for (StructConverterMetadata structConverter : this.m_structConverters) {
            structConverter.initXMLObject(this.m_file, this);
            this.m_project.addConverter(structConverter);
        }
        for (TableGeneratorMetadata tableGenerator : this.m_tableGenerators) {
            tableGenerator.initXMLObject(this.m_file, this);
            this.m_project.addTableGenerator(tableGenerator, this.getDefaultCatalog(), this.getDefaultSchema());
        }
        for (SequenceGeneratorMetadata sequenceGenerator : this.m_sequenceGenerators) {
            sequenceGenerator.initXMLObject(this.m_file, this);
            this.m_project.addSequenceGenerator(sequenceGenerator, this.getDefaultCatalog(), this.getDefaultSchema());
        }
        for (NamedQueryMetadata namedQuery : this.m_namedQueries) {
            namedQuery.initXMLObject(this.m_file, this);
            this.m_project.addQuery(namedQuery);
        }
        for (NamedNativeQueryMetadata namedNativeQuery : this.m_namedNativeQueries) {
            namedNativeQuery.initXMLObject(this.m_file, this);
            this.m_project.addQuery(namedNativeQuery);
        }
        for (NamedStoredProcedureQueryMetadata namedStoredProcedureQuery : this.m_namedStoredProcedureQueries) {
            namedStoredProcedureQuery.initXMLObject(this.m_file, this);
            this.m_project.addQuery(namedStoredProcedureQuery);
        }
        for (SQLResultSetMappingMetadata sqlResultSetMapping : this.m_sqlResultSetMappings) {
            sqlResultSetMapping.initXMLObject(this.m_file, this);
            this.m_project.addSQLResultSetMapping(sqlResultSetMapping);
        }
    }

    public void processEntityMappingsDefaults(ClassAccessor accessor) {
        MetadataDescriptor descriptor = accessor.getDescriptor();
        if (this.m_access != null) {
            descriptor.setDefaultAccess(this.m_access);
        }
        if (this.m_catalog != null) {
            descriptor.setDefaultCatalog(this.m_catalog);
        }
        if (this.m_schema != null) {
            descriptor.setDefaultSchema(this.m_schema);
        }
    }

    public void processPersistenceUnitMetadata() {
        this.m_file = new MetadataFile(this);
        if (this.m_persistenceUnitMetadata != null) {
            this.m_persistenceUnitMetadata.initXMLObject(this.m_file, this);
            this.m_project.setPersistenceUnitMetadata(this.m_persistenceUnitMetadata);
            for (EntityListenerMetadata defaultListener : this.m_persistenceUnitMetadata.getDefaultListeners()) {
                defaultListener.initXMLObject(this.m_file, this);
                this.m_project.addDefaultListener(defaultListener);
            }
        }
    }

    @Override
    public EntityAccessor reloadEntity(EntityAccessor accessor, MetadataDescriptor descriptor) {
        XMLEntityMappings xmlEntityMappings = this.newXMLEntityMappingsObject();
        ArrayList<EntityAccessor> list = new ArrayList<EntityAccessor>();
        list.add(accessor);
        xmlEntityMappings.setEntities(list);
        xmlEntityMappings = this.reloadXMLEntityMappingsObject(xmlEntityMappings);
        EntityAccessor entity = xmlEntityMappings.getEntities().get(0);
        MetadataClass metadataClass = this.getMetadataFactory().getMetadataClass(this.getFullClassName(entity.getClassName()));
        entity.initXMLClassAccessor(metadataClass, descriptor, this.m_project, this);
        return entity;
    }

    @Override
    public MappedSuperclassAccessor reloadMappedSuperclass(MappedSuperclassAccessor accessor, MetadataDescriptor descriptor) {
        XMLEntityMappings xmlEntityMappings = this.newXMLEntityMappingsObject();
        ArrayList<MappedSuperclassAccessor> list = new ArrayList<MappedSuperclassAccessor>();
        list.add(accessor);
        xmlEntityMappings.setMappedSuperclasses(list);
        xmlEntityMappings = this.reloadXMLEntityMappingsObject(xmlEntityMappings);
        MappedSuperclassAccessor mappedSuperclass = xmlEntityMappings.getMappedSuperclasses().get(0);
        MetadataClass metadataClass = this.getMetadataFactory().getMetadataClass(this.getFullClassName(mappedSuperclass.getClassName()));
        mappedSuperclass.initXMLClassAccessor(metadataClass, descriptor, this.m_project, this);
        return mappedSuperclass;
    }

    protected XMLEntityMappings reloadXMLEntityMappingsObject(XMLEntityMappings xmlEntityMappings) {
        ByteArrayOutputStream outputStream = null;
        StringReader reader1 = null;
        StringReader reader2 = null;
        StringReader reader3 = null;
        try {
            XMLEntityMappings newXMLEntityMappings;
            outputStream = new ByteArrayOutputStream();
            XMLEntityMappingsWriter.write(xmlEntityMappings, outputStream);
            reader1 = new StringReader(outputStream.toString());
            reader2 = new StringReader(outputStream.toString());
            reader3 = new StringReader(outputStream.toString());
            XMLEntityMappings xMLEntityMappings = newXMLEntityMappings = XMLEntityMappingsReader.read("tempStream", reader1, reader2, reader3, this.m_loader, null);
            return xMLEntityMappings;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException ex) {}
            }
            if (reader1 != null) {
                reader1.close();
            }
            if (reader2 != null) {
                reader2.close();
            }
            if (reader3 != null) {
                reader3.close();
            }
        }
    }

    public void setAccess(String access) {
        this.m_access = access;
    }

    public void setCatalog(String catalog) {
        this.m_catalog = catalog;
    }

    public void setConverters(List<ConverterMetadata> converters) {
        this.m_converters = converters;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setEmbeddables(List<EmbeddableAccessor> embeddables) {
        this.m_embeddables = embeddables;
    }

    public void setEntities(List<EntityAccessor> entities) {
        this.m_entities = entities;
    }

    public void setIsEclipseLinkORMFile(boolean isEclipseLinkORMFile) {
        this.m_isEclipseLinkORMFile = isEclipseLinkORMFile;
    }

    public void setLoader(ClassLoader loader) {
        this.m_loader = loader;
    }

    public void setMappedSuperclasses(List<MappedSuperclassAccessor> mappedSuperclasses) {
        this.m_mappedSuperclasses = mappedSuperclasses;
    }

    public void setMappingFile(String mappingFileNameOrURL) {
        this.m_mappingFileNameOrURL = mappingFileNameOrURL;
    }

    public void setMetadataFactory(MetadataFactory factory) {
        this.m_factory = factory;
    }

    public void setNamedNativeQueries(List<NamedNativeQueryMetadata> namedNativeQueries) {
        this.m_namedNativeQueries = namedNativeQueries;
    }

    public void setNamedQueries(List<NamedQueryMetadata> namedQueries) {
        this.m_namedQueries = namedQueries;
    }

    public void setNamedStoredProcedureQueries(List<NamedStoredProcedureQueryMetadata> namedStoredProcedureQueries) {
        this.m_namedStoredProcedureQueries = namedStoredProcedureQueries;
    }

    public void setObjectTypeConverters(List<ObjectTypeConverterMetadata> objectTypeConverters) {
        this.m_objectTypeConverters = objectTypeConverters;
    }

    public void setPackage(String pkg) {
        this.m_package = pkg;
    }

    public void setPersistenceUnitMetadata(XMLPersistenceUnitMetadata persistenceUnitMetadata) {
        this.m_persistenceUnitMetadata = persistenceUnitMetadata;
    }

    public void setProject(MetadataProject project) {
        this.m_project = project;
    }

    public void setSchema(String schema) {
        this.m_schema = schema;
    }

    public void setSequenceGenerators(List<SequenceGeneratorMetadata> sequenceGenerators) {
        this.m_sequenceGenerators = sequenceGenerators;
    }

    public void setSqlResultSetMappings(List<SQLResultSetMappingMetadata> sqlResultSetMappings) {
        this.m_sqlResultSetMappings = sqlResultSetMappings;
    }

    public void setStructConverters(List<StructConverterMetadata> structConverters) {
        this.m_structConverters = structConverters;
    }

    public void setTableGenerators(List<TableGeneratorMetadata> tableGenerators) {
        this.m_tableGenerators = tableGenerators;
    }

    public void setTypeConverters(List<TypeConverterMetadata> typeConverters) {
        this.m_typeConverters = typeConverters;
    }

    public void setVersion(String version) {
        this.m_version = version;
    }
}

