/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational;

import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWColumnHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWDirectMapContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWDirectMapMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWNullConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWObjectTypeConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWSerializedObjectConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTypeConversionConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWRelationalDirectContainerMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWXmlTypeConversionConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWRelationalDirectMapMapping
extends MWRelationalDirectContainerMapping
implements MWDirectMapMapping {
    private MWColumnHandle directKeyColumnHandle;
    public static final String DIRECT_KEY_COLUMN_PROPERTY = "directKeyColumn";
    private volatile MWConverter directKeyConverter;
    private MWDirectMapContainerPolicy containerPolicy;

    private MWRelationalDirectMapMapping() {
    }

    public MWRelationalDirectMapMapping(MWRelationalClassDescriptor parent, MWClassAttribute attribute, String name) {
        super(parent, attribute, name);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.directKeyColumnHandle = new MWColumnHandle(this, this.buildDirectKeyColumnScrubber());
        this.directKeyConverter = new MWNullConverter(this);
        this.containerPolicy = new MWDirectMapContainerPolicy(this);
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.directKeyColumnHandle);
        children.add(this.directKeyConverter);
        children.add(this.containerPolicy);
    }

    private MWHandle.NodeReferenceScrubber buildDirectKeyColumnScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWRelationalDirectMapMapping.this.setDirectKeyColumn(null);
            }

            public String toString() {
                return "MWRelationalDirectMapMapping.buildDirectKeyColumnScrubber()";
            }
        };
    }

    public MWDirectMapMapping asMWDirectMapMapping() {
        return this;
    }

    protected void initializeOn(MWMapping newMapping) {
        newMapping.initializeFromMWRelationalDirectMapMapping(this);
    }

    public String iconKey() {
        return "mapping.directMap";
    }

    public MWColumn getDirectKeyColumn() {
        return this.directKeyColumnHandle.getColumn();
    }

    public void setDirectKeyColumn(MWColumn directKeyColumn) {
        this.checkColumn(directKeyColumn);
        MWColumn old = this.directKeyColumnHandle.getColumn();
        this.directKeyColumnHandle.setColumn(directKeyColumn);
        this.firePropertyChanged(DIRECT_KEY_COLUMN_PROPERTY, old, directKeyColumn);
    }

    protected void setDirectFieldsNull() {
        super.setDirectFieldsNull();
        this.setDirectKeyColumn(null);
    }

    public MWConverter getDirectKeyConverter() {
        return this.directKeyConverter;
    }

    public MWNullConverter setNullDirectKeyConverter() {
        MWNullConverter nullConverter = new MWNullConverter(this);
        this.setDirectKeyConverter(nullConverter);
        return nullConverter;
    }

    public MWObjectTypeConverter setObjectTypeDirectKeyConverter() {
        MWObjectTypeConverter objectTypeConverter = new MWObjectTypeConverter(this);
        this.setDirectKeyConverter(objectTypeConverter);
        return objectTypeConverter;
    }

    public MWSerializedObjectConverter setSerializedObjectDirectKeyConverter() {
        MWSerializedObjectConverter serializedObjectConverter = new MWSerializedObjectConverter(this);
        this.setDirectKeyConverter(serializedObjectConverter);
        return serializedObjectConverter;
    }

    public MWTypeConversionConverter setTypeConversionDirectKeyConverter() {
        MWXmlTypeConversionConverter typeConversionConverter = new MWXmlTypeConversionConverter(this);
        this.setDirectKeyConverter(typeConversionConverter);
        return typeConversionConverter;
    }

    private void setDirectKeyConverter(MWConverter newConverter) {
        MWConverter oldConverter = this.directKeyConverter;
        this.directKeyConverter = newConverter;
        newConverter.setParent(this);
        this.firePropertyChanged("directKeyConverter", oldConverter, newConverter);
    }

    public MWDirectMapContainerPolicy getContainerPolicy() {
        return this.containerPolicy;
    }

    protected MWClass conatinerPolicyClass() {
        return this.getContainerPolicy().getDefaultingContainerClass().getContainerClass();
    }

    protected int automapNonPrimaryKeyColumnsSize() {
        return 2;
    }

    protected void addProblemsTo(List newProblems) {
        super.addProblemsTo(newProblems);
        this.checkDirectKeyColumn(newProblems);
    }

    private void checkDirectKeyColumn(List newProblems) {
        if (this.parentDescriptorIsAggregate()) {
            return;
        }
        if (this.getDirectKeyColumn() == null) {
            newProblems.add(this.buildProblem("0415"));
        }
    }

    protected DatabaseMapping buildRuntimeMapping() {
        return new DirectMapMapping();
    }

    public DatabaseMapping runtimeMapping() {
        DirectMapMapping runtimeMapping = (DirectMapMapping)super.runtimeMapping();
        runtimeMapping.setContainerPolicy(this.containerPolicy.runtimeContainerPolicy());
        runtimeMapping.setKeyConverter(this.getDirectKeyConverter().runtimeConverter((DatabaseMapping)runtimeMapping));
        if (this.getDirectKeyColumn() != null) {
            runtimeMapping.setDirectKeyFieldName(this.getDirectKeyColumn().qualifiedName());
        }
        return runtimeMapping;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWRelationalDirectMapMapping.class);
        descriptor.getInheritancePolicy().setParentClass(MWRelationalDirectContainerMapping.class);
        XMLCompositeObjectMapping directFieldMapping = new XMLCompositeObjectMapping();
        directFieldMapping.setAttributeName("directKeyColumnHandle");
        directFieldMapping.setGetMethodName("getDirectKeyColumnHandleForTopLink");
        directFieldMapping.setSetMethodName("setDirectKeyColumnHandleForTopLink");
        directFieldMapping.setReferenceClass(MWColumnHandle.class);
        directFieldMapping.setXPath("direct-key-column-handle");
        descriptor.addMapping((DatabaseMapping)directFieldMapping);
        XMLCompositeObjectMapping converterMapping = new XMLCompositeObjectMapping();
        converterMapping.setReferenceClass(MWConverter.class);
        converterMapping.setAttributeName("directKeyConverter");
        converterMapping.setGetMethodName("getDirectKeyConverterForTopLink");
        converterMapping.setSetMethodName("setDirectKeyConverterForTopLink");
        converterMapping.setXPath("direct-key-converter");
        descriptor.addMapping((DatabaseMapping)converterMapping);
        XMLCompositeObjectMapping containerPolicyMapping = new XMLCompositeObjectMapping();
        containerPolicyMapping.setAttributeName("containerPolicy");
        containerPolicyMapping.setReferenceClass(MWDirectMapContainerPolicy.class);
        containerPolicyMapping.setXPath("container-policy");
        descriptor.addMapping((DatabaseMapping)containerPolicyMapping);
        return descriptor;
    }

    private MWColumnHandle getDirectKeyColumnHandleForTopLink() {
        return this.directKeyColumnHandle.getColumn() == null ? null : this.directKeyColumnHandle;
    }

    private void setDirectKeyColumnHandleForTopLink(MWColumnHandle directKeyColumnHandle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildDirectKeyColumnScrubber();
        this.directKeyColumnHandle = directKeyColumnHandle == null ? new MWColumnHandle(this, scrubber) : directKeyColumnHandle.setScrubber(scrubber);
    }

    private MWConverter getDirectKeyConverterForTopLink() {
        return this.directKeyConverter == null ? null : this.directKeyConverter.getValueForTopLink();
    }

    private void setDirectKeyConverterForTopLink(MWConverter converter) {
        this.directKeyConverter = converter == null ? new MWNullConverter(this) : converter;
    }
}

