/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JTextField;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryableArgument;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ArgumentPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QueryableEditDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;

final class QueryableArgumentPanel
extends ArgumentPanel {
    private JTextField queryKeyTextField;
    private JButton editQueryKeyButton;

    QueryableArgumentPanel(PropertyValueModel argumentHolder, WorkbenchContextHolder contextHolder, Collection enablingComponents) {
        super(argumentHolder, contextHolder);
        this.initialize(enablingComponents);
    }

    protected MWQueryableArgument getQueryableArgument() {
        return (MWQueryableArgument)this.getArgument();
    }

    private void initialize(Collection enablingComponents) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        this.queryKeyTextField = this.buildQueryableTextField();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 15;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.queryKeyTextField, constraints);
        this.editQueryKeyButton = new JButton(this.resourceRepository().getString("QUERY_KEY_EDIT_BUTTON_ON_SECOND_ARGUMENT_PANEL"));
        this.editQueryKeyButton.setMnemonic(this.resourceRepository().getMnemonic("QUERY_KEY_EDIT_BUTTON_ON_SECOND_ARGUMENT_PANEL"));
        this.editQueryKeyButton.addActionListener(this.buildEditQueryKeyAction());
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.editQueryKeyButton, constraints);
        enablingComponents.add(this.editQueryKeyButton);
    }

    private JTextField buildQueryableTextField() {
        JTextField textField = new JTextField();
        textField.setDocument(new DocumentAdapter(this.buildQueryableHolder()));
        textField.setEditable(false);
        return textField;
    }

    private PropertyValueModel buildQueryableHolder() {
        return new PropertyAspectAdapter(this.getArgumentHolder(), "queryableArgumentElement"){

            protected Object getValueFromSubject() {
                return ((MWQueryableArgument)this.subject).displayString();
            }
        };
    }

    protected PropertyValueModel buildQueryArgumentHolder(PropertyValueModel argumentHolder) {
        return new FilteringPropertyValueModel(argumentHolder){

            protected boolean accept(Object value) {
                return value instanceof MWQueryableArgument;
            }
        };
    }

    private ActionListener buildEditQueryKeyAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                QueryableArgumentPanel.this.editQueryKey();
            }
        };
    }

    private void editQueryKey() {
        QueryableEditDialog queryKeyDialog = new QueryableEditDialog(this.getQueryableArgument(), this.getWorkbenchContext());
        queryKeyDialog.show();
    }
}

