/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.resources;

import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.eclipse.persistence.tools.workbench.framework.resources.AcceleratorRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.DefaultAcceleratorRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.DefaultIconRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.DefaultMnemonicRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.DefaultStringRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.IconRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.IconResourceFileNameMap;
import org.eclipse.persistence.tools.workbench.framework.resources.MnemonicRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.StringRepository;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class DefaultResourceRepository
implements ResourceRepository {
    private StringRepository stringRepository;
    private MnemonicRepository mnemonicRepository;
    private AcceleratorRepository acceleratorRepository;
    private IconRepository iconRepository;

    public DefaultResourceRepository(Class resourceBundleClass) {
        this(resourceBundleClass, null);
    }

    public DefaultResourceRepository(IconResourceFileNameMap iconResourceFileNameMap) {
        this(null, iconResourceFileNameMap);
    }

    public DefaultResourceRepository(Class resourceBundleClass, IconResourceFileNameMap iconResourceFileNameMap) {
        this.stringRepository = this.buildStringRepository(resourceBundleClass);
        this.mnemonicRepository = this.buildMnemonicRepository(resourceBundleClass);
        this.acceleratorRepository = this.buildAcceleratorRepository(resourceBundleClass);
        this.iconRepository = this.buildIconRepository(iconResourceFileNameMap);
    }

    protected StringRepository buildStringRepository(Class resourceBundleClass) {
        return resourceBundleClass == null ? StringRepository.NULL_INSTANCE : new DefaultStringRepository(resourceBundleClass);
    }

    protected MnemonicRepository buildMnemonicRepository(Class resourceBundleClass) {
        return resourceBundleClass == null ? MnemonicRepository.NULL_INSTANCE : new DefaultMnemonicRepository(resourceBundleClass);
    }

    protected AcceleratorRepository buildAcceleratorRepository(Class resourceBundleClass) {
        return resourceBundleClass == null ? AcceleratorRepository.NULL_INSTANCE : new DefaultAcceleratorRepository(resourceBundleClass);
    }

    protected IconRepository buildIconRepository(IconResourceFileNameMap iconResourceFileNameMap) {
        return iconResourceFileNameMap == null ? IconRepository.NULL_INSTANCE : new DefaultIconRepository(iconResourceFileNameMap);
    }

    public boolean hasString(String key) {
        return this.stringRepository.hasString(key);
    }

    public String getString(String key) {
        return this.stringRepository.getString(key);
    }

    public String getString(String key, Object argument) {
        return this.stringRepository.getString(key, argument);
    }

    public String getString(String key, Object argument1, Object argument2) {
        return this.stringRepository.getString(key, argument1, argument2);
    }

    public String getString(String key, Object argument1, Object argument2, Object argument3) {
        return this.stringRepository.getString(key, argument1, argument2, argument3);
    }

    public String getString(String key, Object[] arguments) {
        return this.stringRepository.getString(key, arguments);
    }

    public boolean hasMnemonic(String key) {
        return this.mnemonicRepository.hasMnemonic(key);
    }

    public int getMnemonic(String key) {
        return this.mnemonicRepository.getMnemonic(key);
    }

    public int getMnemonicIndex(String key) {
        return this.mnemonicRepository.getMnemonicIndex(key);
    }

    public boolean hasAccelerator(String key) {
        return this.acceleratorRepository.hasAccelerator(key);
    }

    public KeyStroke getAccelerator(String key) {
        return this.acceleratorRepository.getAccelerator(key);
    }

    public boolean hasIcon(String key) {
        return this.iconRepository.hasIcon(key);
    }

    public Icon getIcon(String key) {
        return this.iconRepository.getIcon(key);
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this);
    }
}

