/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JRadioButton;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWObjectTypeConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTypeConversionConverter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.ObjectTypeConverterPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.TypeConversionConverterPanel;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;

public final class ConverterPanel
extends AbstractPanel {
    private PropertyValueModel converterHolder;
    private PropertyValueModel converterTypeHolder;

    public ConverterPanel(PropertyValueModel converterHolder, ConverterSetter converterSetter, WorkbenchContextHolder contextHolder) {
        super(contextHolder);
        this.initialize(converterHolder, converterSetter);
        this.initializeLayout();
    }

    private void initialize(PropertyValueModel converterHolder, ConverterSetter converterSetter) {
        this.converterHolder = converterHolder;
        this.converterTypeHolder = this.buildConverterTypeHolder(converterHolder, converterSetter);
    }

    private PropertyValueModel buildConverterTypeHolder(PropertyValueModel converterHolder, final ConverterSetter converterSetter) {
        return new PropertyAspectAdapter(converterHolder, converterSetter.converterTypePropertyString()){

            protected Object getValueFromSubject() {
                return converterSetter.getType();
            }

            protected void setValueOnSubject(Object value) {
                String converterType = (String)value;
                if (converterType.equals("no-converter")) {
                    if (!converterSetter.getType().equals("no-converter")) {
                        converterSetter.setNullConverter();
                    }
                } else if (converterType.equals("object-type-converter")) {
                    if (!converterSetter.getType().equals("object-type-converter")) {
                        converterSetter.setObjectTypeConverter();
                    }
                } else if (converterType.equals("serialized-object-converter")) {
                    if (!converterSetter.getType().equals("serialized-object-converter")) {
                        converterSetter.setSerializedObjectConverter();
                    }
                } else if (converterType.equals("type-conversion-converter") && !converterSetter.getType().equals("type-conversion-converter")) {
                    converterSetter.setTypeConversionConverter();
                }
            }
        };
    }

    private void initializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        JRadioButton noConverterRadioButton = this.buildNoConverterRadioButton();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 10, 0, 5);
        this.add((Component)noConverterRadioButton, constraints);
        JRadioButton serializedObjectConverterRadioButton = this.buildSerializedObjectConverterRadioButton();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(3, 10, 0, 5);
        this.add((Component)serializedObjectConverterRadioButton, constraints);
        JRadioButton typeConversionConverterRadioButton = this.buildTypeConversionConverterRadioButton();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(3, 10, 0, 5);
        this.add((Component)typeConversionConverterRadioButton, constraints);
        AbstractPanel typeConversionConverterPanel = this.buildTypeConversionConverterPanel();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(3, 36, 0, 5);
        this.add((Component)typeConversionConverterPanel, constraints);
        this.addPaneForAlignment(typeConversionConverterPanel);
        JRadioButton objectTypeConverterRadioButton = this.buildObjectTypeConverterRadioButton();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(8, 10, 0, 5);
        this.add((Component)objectTypeConverterRadioButton, constraints);
        AbstractPanel objectTypeConverterPanel = this.buildObjectTypeConverterPanel();
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 21;
        constraints.insets = new Insets(3, 36, 5, 5);
        this.add((Component)objectTypeConverterPanel, constraints);
        this.addPaneForAlignment(objectTypeConverterPanel);
        this.addHelpTopicId(this, this.helpTopicId());
    }

    private JRadioButton buildNoConverterRadioButton() {
        return this.buildRadioButton("NO_CONVERTER_RADIO_BUTTON", this.buildConverterRadioButtonModelAdapter("no-converter", true));
    }

    private JRadioButton buildSerializedObjectConverterRadioButton() {
        JRadioButton button = this.buildRadioButton("SERIALIZED_OBJECT_CONVERTER_RADIO_BUTTON", this.buildConverterRadioButtonModelAdapter("serialized-object-converter", false));
        this.addHelpTopicId(button, this.helpTopicId() + ".serialized");
        return button;
    }

    private JRadioButton buildTypeConversionConverterRadioButton() {
        JRadioButton button = this.buildRadioButton("TYPE_CONVERSION_CONVERTER_RADIO_BUTTON", this.buildConverterRadioButtonModelAdapter("type-conversion-converter", false));
        this.addHelpTopicId(button, this.helpTopicId() + ".typeConverter");
        return button;
    }

    private AbstractPanel buildTypeConversionConverterPanel() {
        TypeConversionConverterPanel panel = new TypeConversionConverterPanel(this.buildTypeConversionConverterHolder(), this.getWorkbenchContextHolder());
        this.buildTypeConversionConverterPanelEnabler(panel);
        return panel;
    }

    private PropertyValueModel buildTypeConversionConverterHolder() {
        return new FilteringPropertyValueModel(this.converterHolder){

            protected boolean accept(Object value) {
                return value instanceof MWTypeConversionConverter;
            }
        };
    }

    private ComponentEnabler buildTypeConversionConverterPanelEnabler(AbstractPanel panel) {
        return new ComponentEnabler(this.buildIsTypeConversionConverterHolder(), panel);
    }

    private ValueModel buildIsTypeConversionConverterHolder() {
        return new PropertyAspectAdapter(this.converterHolder){

            protected Object getValueFromSubject() {
                return new Boolean(this.subject instanceof MWTypeConversionConverter);
            }
        };
    }

    private JRadioButton buildObjectTypeConverterRadioButton() {
        JRadioButton button = this.buildRadioButton("OBJECT_TYPE_CONVERTER_RADIO_BUTTON", this.buildConverterRadioButtonModelAdapter("object-type-converter", false));
        this.addHelpTopicId(button, this.helpTopicId() + ".objectType");
        return button;
    }

    private AbstractPanel buildObjectTypeConverterPanel() {
        ObjectTypeConverterPanel panel = new ObjectTypeConverterPanel(this.buildObjectTypeConverterHolder(), this.getWorkbenchContextHolder());
        this.buildObjectTypeConverterPanelEnabler(panel);
        return panel;
    }

    private PropertyValueModel buildObjectTypeConverterHolder() {
        return new FilteringPropertyValueModel(this.converterHolder){

            protected boolean accept(Object value) {
                return value instanceof MWObjectTypeConverter;
            }
        };
    }

    private ComponentEnabler buildObjectTypeConverterPanelEnabler(AbstractPanel panel) {
        return new ComponentEnabler(this.buildIsObjectTypeConverterHolder(), panel);
    }

    private ValueModel buildIsObjectTypeConverterHolder() {
        return new PropertyAspectAdapter(this.converterHolder){

            protected Object getValueFromSubject() {
                return new Boolean(this.subject instanceof MWObjectTypeConverter);
            }
        };
    }

    private RadioButtonModelAdapter buildConverterRadioButtonModelAdapter(String propertyName, boolean defaultValue) {
        return new RadioButtonModelAdapter(this.converterTypeHolder, propertyName, defaultValue);
    }

    protected String helpTopicId() {
        return "mapping.converter";
    }

    public static interface ConverterSetter {
        public String getType();

        public void setNullConverter();

        public void setObjectTypeConverter();

        public void setSerializedObjectConverter();

        public void setTypeConversionConverter();

        public String converterTypePropertyString();
    }
}

