/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational;

import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.GroupContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.NavigatorSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWQueryKey;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWAggregateDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWInterfaceDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.MappingsPlugin;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.DatabaseNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.TableNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.UiDbBundle;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorPackageNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.relational.AggregateDescriptorNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.relational.InterfaceDescriptorNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.relational.RelationalClassDescriptorNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.relational.RelationalDescriptorPackageNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.relational.TableDescriptorNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.relational.UiDescriptorRelationalBundle;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.UiMappingRelationalBundle;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.ProjectNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational.RelationalProjectTabbedPropertiesPage;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class RelationalProjectNode
extends ProjectNode {
    public RelationalProjectNode(MWRelationalProject project, ApplicationContext context, MappingsPlugin plugin) {
        super((MWProject)project, plugin, context);
    }

    protected ApplicationContext expandContext(ApplicationContext context) {
        return super.expandContext(context).buildExpandedResourceRepositoryContext(UiDescriptorRelationalBundle.class).buildExpandedResourceRepositoryContext(UiMappingRelationalBundle.class).buildExpandedResourceRepositoryContext(UiDbBundle.class);
    }

    public String getCannotAutomapDescriptorsStringKey() {
        return "RELATIONAL_PROJECT_UNAUTOMAPPABLE";
    }

    protected ProjectNode.Child buildMetaDataRepositoryNode() {
        return new DatabaseNode(this.getProject().getDatabase(), this, this.getMappingsPlugin(), this.getApplicationContext());
    }

    protected String accessibleNameKey() {
        return "ACCESSIBLE_RELATIONAL_PROJECT_NODE";
    }

    protected void addToMenuDescription(GroupContainerDescription menuDescription, WorkbenchContext context) {
        menuDescription.add(this.buildClassActionGroup(context));
        menuDescription.add(this.buildCloseDeleteActionGroup(context));
        menuDescription.add(this.buildSaveActionGroup(context));
        menuDescription.add(this.buildExportActionGroup(context));
        menuDescription.add(this.buildAutomapActionGroup(context));
        menuDescription.add(this.buildOracleHelpMenuGroup(context));
    }

    private MenuGroupDescription buildAutomapActionGroup(WorkbenchContext context) {
        MenuGroupDescription autoMapGroup = new MenuGroupDescription();
        autoMapGroup.add(this.getMappingsPlugin().getAutomapAction(context));
        return autoMapGroup;
    }

    protected String buildIconKey() {
        return "project.relational";
    }

    protected Class propertiesPageClass() {
        return RelationalProjectTabbedPropertiesPage.class;
    }

    protected DescriptorPackageNode buildDescriptorPackageNodeFor(MWDescriptor descriptor) {
        return new RelationalDescriptorPackageNode(descriptor.packageName(), this, this.getDescriptorNodeBuilder());
    }

    protected DescriptorPackageNode.DescriptorNodeBuilder buildDescriptorNodeBuilder() {
        return new DescriptorPackageNode.DescriptorNodeBuilder(){

            public DescriptorNode buildDescriptorNode(MWDescriptor descriptor, DescriptorPackageNode descriptorPackageNode) {
                if (descriptor instanceof MWTableDescriptor) {
                    return new TableDescriptorNode((MWTableDescriptor)descriptor, descriptorPackageNode);
                }
                if (descriptor instanceof MWInterfaceDescriptor) {
                    return new InterfaceDescriptorNode((MWInterfaceDescriptor)descriptor, descriptorPackageNode);
                }
                if (descriptor instanceof MWAggregateDescriptor) {
                    return new AggregateDescriptorNode((MWAggregateDescriptor)descriptor, descriptorPackageNode);
                }
                throw new IllegalArgumentException(descriptor.toString());
            }
        };
    }

    protected GroupContainerDescription buildExportMenuDescription(WorkbenchContext context) {
        MenuDescription exportMenu = new MenuDescription(this.resourceRepository().getString("EXPORT_MENU"), this.resourceRepository().getString("EXPORT_MENU"), this.resourceRepository().getMnemonic("EXPORT_MENU"), this.resourceRepository().getIcon("file.export"));
        MenuGroupDescription groupDesc = new MenuGroupDescription();
        groupDesc.add(this.getExportDeploymentXmlAction(context));
        if (this.getMappingsPlugin().isDevelopmentModeIn(context)) {
            groupDesc.add(this.getExportDeploymentXmlAndInitializeRuntimeDescriptorsAction(context));
        }
        groupDesc.add(this.getExportProjectJavaSourceAction(context));
        groupDesc.add(this.getModelJavaSourceAction(context));
        groupDesc.add(this.getExportTableCreatorJavaSourceAction(context));
        exportMenu.add(groupDesc);
        return exportMenu;
    }

    public boolean supportsExportProjectJavaSource() {
        return true;
    }

    public boolean supportsExportTableCreatorJavaSource() {
        return true;
    }

    protected FrameworkAction getExportProjectJavaSourceAction(WorkbenchContext context) {
        return this.getMappingsPlugin().getExportProjectJavaSourceAction(context);
    }

    protected FrameworkAction getExportTableCreatorJavaSourceAction(WorkbenchContext context) {
        return this.getMappingsPlugin().getExportTableCreatorJavaSourceAction(context);
    }

    public void selectTableNodeFor(MWTable table, NavigatorSelectionModel nsm) {
        this.selectTableNode(this.tableNodeFor(table), nsm);
    }

    public void selectTableNode(TableNode tableNode, NavigatorSelectionModel nsm) {
        nsm.setSelectedNode(tableNode);
    }

    public TableNode tableNodeFor(MWTable table) {
        DatabaseNode databaseNode = (DatabaseNode)this.descendantNodeForValue((Node)table.getDatabase());
        return databaseNode.tableNodeFor(table);
    }

    public void selectColumn(MWColumn column, WorkbenchContext context) {
        TableNode tableNode = this.tableNodeFor(column.getTable());
        this.selectTableNode(tableNode, context.getNavigatorSelectionModel());
        tableNode.selectColumn(column, context);
    }

    public void selectReference(MWReference reference, WorkbenchContext context) {
        TableNode tableNode = this.tableNodeFor(reference.getSourceTable());
        this.selectTableNode(tableNode, context.getNavigatorSelectionModel());
        tableNode.selectReference(reference, context);
    }

    public void selectQueryKey(MWQueryKey queryKey, WorkbenchContext context) {
        RelationalClassDescriptorNode descriptorNode = (RelationalClassDescriptorNode)this.descriptorNodeFor((MWDescriptor)queryKey.getDescriptor());
        this.selectDescriptorNode(descriptorNode, context.getNavigatorSelectionModel());
        descriptorNode.selectQueryKey(queryKey, context);
    }
}

