/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModelWrapper;
import org.eclipse.persistence.tools.workbench.uitools.app.ListCollectionValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.utility.Transformer;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

public class CompositeCollectionValueModel
extends CollectionValueModelWrapper {
    private Transformer transformer;
    private IdentityHashMap components;
    private IdentityHashMap collections;
    private CollectionChangeListener componentListener;
    private int size;
    private static final Transformer DISABLED_TRANSFORMER = new Transformer(){

        public Object transform(Object o) {
            throw new IllegalStateException("CompositeCollectionValueModel.transform(Object) was not implemented.");
        }

        public String toString() {
            return "Disabled Transformer";
        }
    };

    public CompositeCollectionValueModel(CollectionValueModel collectionHolder) {
        this(collectionHolder, DISABLED_TRANSFORMER);
    }

    public CompositeCollectionValueModel(CollectionValueModel collectionHolder, Transformer transformer) {
        super(collectionHolder);
        this.transformer = transformer;
    }

    public CompositeCollectionValueModel(ListValueModel listHolder) {
        this(new ListCollectionValueModelAdapter(listHolder));
    }

    public CompositeCollectionValueModel(ListValueModel listHolder, Transformer transformer) {
        this(new ListCollectionValueModelAdapter(listHolder), transformer);
    }

    protected void initialize() {
        super.initialize();
        this.components = new IdentityHashMap();
        this.collections = new IdentityHashMap();
        this.componentListener = this.buildComponentListener();
        this.size = 0;
    }

    protected CollectionChangeListener buildComponentListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent e) {
                CompositeCollectionValueModel.this.componentItemsAdded(e);
            }

            public void itemsRemoved(CollectionChangeEvent e) {
                CompositeCollectionValueModel.this.componentItemsRemoved(e);
            }

            public void collectionChanged(CollectionChangeEvent e) {
                CompositeCollectionValueModel.this.componentCollectionChanged(e);
            }

            public String toString() {
                return "component listener";
            }
        };
    }

    public Object getValue() {
        return new CompositeIterator(this.buildCollectionsIterators());
    }

    protected Iterator buildCollectionsIterators() {
        return new TransformationIterator(this.collections.values().iterator()){

            protected Object transform(Object next) {
                return ((ArrayList)next).iterator();
            }
        };
    }

    public int size() {
        return this.size;
    }

    protected void engageModel() {
        super.engageModel();
        this.addComponentSources((Iterator)this.collectionHolder.getValue());
    }

    protected void disengageModel() {
        super.disengageModel();
        Iterator stream = this.components.values().iterator();
        while (stream.hasNext()) {
            ((CollectionValueModel)stream.next()).removeCollectionChangeListener("value", this.componentListener);
        }
        this.components.clear();
        this.collections.clear();
        this.size = 0;
    }

    protected void itemsAdded(CollectionChangeEvent e) {
        this.addComponentSources(e.items());
    }

    protected void addComponentSources(Iterator sources) {
        while (sources.hasNext()) {
            this.addComponentSource(sources.next());
        }
    }

    protected void addComponentSource(Object source) {
        CollectionValueModel component = this.transform(source);
        if (this.components.put(source, component) != null) {
            throw new IllegalStateException("duplicate component: " + source);
        }
        component.addCollectionChangeListener("value", this.componentListener);
        ArrayList componentCollection = new ArrayList(component.size());
        if (this.collections.put(component, componentCollection) != null) {
            throw new IllegalStateException("duplicate collection: " + source);
        }
        this.addComponentItems(component, componentCollection);
    }

    protected void itemsRemoved(CollectionChangeEvent e) {
        this.removeComponentSources(e.items());
    }

    protected void removeComponentSources(Iterator sources) {
        while (sources.hasNext()) {
            this.removeComponentSource(sources.next());
        }
    }

    protected void removeComponentSource(Object source) {
        CollectionValueModel component = (CollectionValueModel)this.components.remove(source);
        if (component == null) {
            throw new IllegalStateException("missing component: " + source);
        }
        component.removeCollectionChangeListener("value", this.componentListener);
        ArrayList componentCollection = (ArrayList)this.collections.remove(component);
        if (componentCollection == null) {
            throw new IllegalStateException("missing collection: " + source);
        }
        this.clearComponentItems(componentCollection);
    }

    protected void collectionChanged(CollectionChangeEvent e) {
        this.removeComponentSources(new ArrayList(this.components.keySet()).iterator());
        this.addComponentSources((Iterator)this.collectionHolder.getValue());
    }

    protected ArrayList getComponentCollection(CollectionValueModel collectionValueModel) {
        return (ArrayList)this.collections.get(collectionValueModel);
    }

    protected CollectionValueModel transform(Object value) {
        return (CollectionValueModel)this.transformer.transform(value);
    }

    protected void componentItemsAdded(CollectionChangeEvent e) {
        this.addComponentItems(e.items(), e.size(), (CollectionValueModel)e.getSource());
    }

    protected void addComponentItems(Iterator items, int itemsSize, CollectionValueModel cvm) {
        this.addComponentItems(items, itemsSize, this.getComponentCollection(cvm));
    }

    protected void addComponentItems(CollectionValueModel itemsHolder, ArrayList componentCollection) {
        this.addComponentItems((Iterator)itemsHolder.getValue(), itemsHolder.size(), componentCollection);
    }

    protected void addComponentItems(Iterator items, int itemsSize, ArrayList componentCollection) {
        this.size += itemsSize;
        componentCollection.ensureCapacity(componentCollection.size() + itemsSize);
        this.addItemsToCollection(items, componentCollection, "value");
    }

    protected void componentItemsRemoved(CollectionChangeEvent e) {
        this.removeComponentItems(e.items(), e.size(), (CollectionValueModel)e.getSource());
    }

    protected void removeComponentItems(Iterator items, int itemsSize, CollectionValueModel cvm) {
        this.removeComponentItems(items, itemsSize, this.getComponentCollection(cvm));
    }

    protected void clearComponentItems(ArrayList items) {
        this.removeComponentItems(((ArrayList)items.clone()).iterator(), items.size(), items);
    }

    protected void removeComponentItems(Iterator items, int itemsSize, ArrayList componentCollection) {
        this.size -= itemsSize;
        this.removeItemsFromCollection(items, componentCollection, "value");
    }

    protected void componentCollectionChanged(CollectionChangeEvent e) {
        CollectionValueModel component = (CollectionValueModel)e.getSource();
        ArrayList items = this.getComponentCollection(component);
        this.clearComponentItems(items);
        this.addComponentItems(component, items);
    }
}

