/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.descriptors.changetracking.MapChangeEvent;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.queries.InterfaceContainerPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetValueFromField;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.CollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.Association;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.mappings.querykeys.QueryKey;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;

public class MapContainerPolicy
extends InterfaceContainerPolicy {
    protected String keyName;
    protected String elementClassName;
    protected Class elementClass;
    protected transient Field keyField;
    protected transient Method keyMethod;

    public MapContainerPolicy() {
    }

    public MapContainerPolicy(Class containerClass) {
        super(containerClass);
    }

    public MapContainerPolicy(String containerClassName) {
        super(containerClassName);
    }

    public void prepare(DatabaseQuery query, AbstractSession session) throws QueryException {
        if (this.getElementClass() == null && query.getDescriptor() != null) {
            this.setElementClass(query.getDescriptor().getJavaClass());
        }
        super.prepare(query, session);
    }

    public boolean addInto(Object element, Object container, AbstractSession session) {
        if (element instanceof Map.Entry) {
            return this.addInto(((Map.Entry)element).getKey(), ((Map.Entry)element).getValue(), container, session);
        }
        return super.addInto(element, container, session);
    }

    public boolean addInto(Object key, Object element, Object container, AbstractSession session) {
        Object wrapped = element;
        if (this.hasElementDescriptor()) {
            wrapped = this.getElementDescriptor().getObjectBuilder().wrapObject(element, session);
        }
        try {
            if (key != null) {
                return ((Map)container).put(key, wrapped) != null;
            }
            if (this.isKeyAvailableFromElement()) {
                Object keyFromElement = this.keyFrom(element, session);
                try {
                    Object result = ((Map)container).put(keyFromElement, wrapped);
                    return null != result;
                }
                catch (NullPointerException e) {
                    if (keyFromElement == null) {
                        throw QueryException.mapKeyIsNull(element, container);
                    }
                    throw e;
                }
            }
            throw QueryException.cannotAddElementWithoutKeyToMap(element);
        }
        catch (ClassCastException ex1) {
            throw QueryException.mapKeyNotComparable(key, container);
        }
    }

    public void addNextValueFromIteratorInto(Object valuesIterator, Object parent, Object toCollection, CollectionMapping mapping, UnitOfWorkImpl unitOfWork, boolean isExisting) {
        Map.Entry entry = ((MapContainerPolicyIterator)valuesIterator).next();
        Object clonedKey = this.buildCloneForKey(entry.getKey(), parent, unitOfWork, isExisting);
        Object clonedValue = this.buildCloneForValue(entry.getValue(), parent, mapping, unitOfWork, isExisting);
        if (mapping.isCandidateForPrivateOwnedRemoval() && unitOfWork.shouldDiscoverNewObjects() && clonedValue != null && unitOfWork.isObjectNew(clonedValue)) {
            unitOfWork.addPrivateOwnedObject(mapping, clonedValue);
        }
        this.addInto(clonedKey, clonedValue, toCollection, unitOfWork);
    }

    public Object buildCollectionEntry(Object objectAdded, ObjectChangeSet changeSet) {
        return new Association(changeSet.getNewKey(), objectAdded);
    }

    public Object[] buildReferencesPKList(Object container, AbstractSession session) {
        Object[] result = new Object[this.sizeFor(container) * 2];
        Iterator iterator = (Iterator)this.iteratorFor(container);
        int index = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            CMPPolicy policy = this.elementDescriptor.getCMPPolicy();
            result[index] = policy != null && policy.isCMP3Policy() ? policy.createPrimaryKeyInstance(entry.getValue(), session) : this.elementDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(entry.getValue(), session);
            ++index;
        }
        return result;
    }

    public void buildChangeSetForNewObjectInCollection(Object object, ClassDescriptor referenceDescriptor, UnitOfWorkChangeSet uowChangeSet, AbstractSession session) {
        ClassDescriptor tempValueDescriptor;
        Object value = ((Map.Entry)object).getValue();
        ClassDescriptor valueDescriptor = referenceDescriptor;
        if (value != null && (tempValueDescriptor = session.getDescriptor(value.getClass())) != null) {
            valueDescriptor = tempValueDescriptor;
        }
        ObjectChangeSet changeSet = valueDescriptor.getObjectBuilder().createObjectChangeSet(((Map.Entry)object).getValue(), uowChangeSet, session);
        Object key = ((Map.Entry)object).getKey();
        changeSet.setNewKey(key);
    }

    protected Object buildCloneForValue(Object value, Object parent, CollectionMapping mapping, UnitOfWorkImpl uow, boolean isExisting) {
        return mapping.buildElementClone(value, parent, uow, isExisting);
    }

    public void clear(Object container) {
        try {
            ((Map)container).clear();
        }
        catch (UnsupportedOperationException ex) {
            throw QueryException.methodNotValid(container, "clear()");
        }
    }

    public boolean compareKeys(Object sourceValue, AbstractSession session) {
        Object sourceValueKey;
        if (((UnitOfWorkImpl)session).isClassReadOnly(sourceValue.getClass())) {
            return true;
        }
        Object backUpVersion = ((UnitOfWorkImpl)session).getBackupClone(sourceValue, this.getElementDescriptor());
        Object backUpVersionKey = this.keyFrom(backUpVersion, session);
        if (backUpVersionKey == (sourceValueKey = this.keyFrom(sourceValue, session))) {
            return true;
        }
        if (backUpVersionKey == null && sourceValueKey != null) {
            return false;
        }
        return backUpVersionKey.equals(sourceValueKey);
    }

    protected boolean contains(Object element, Object container) {
        return ((Map)container).containsValue(element);
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        if (this.elementClassName == null) {
            return;
        }
        try {
            Class elementClass = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    elementClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.elementClassName, true, classLoader));
                }
                catch (PrivilegedActionException exception) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.containerClassName, exception.getException());
                }
            } else {
                elementClass = PrivilegedAccessHelper.getClassForName(this.elementClassName, true, classLoader);
            }
            this.setElementClass(elementClass);
        }
        catch (ClassNotFoundException exc) {
            throw ValidationException.classNotFoundWhileConvertingClassNames(this.containerClassName, exc);
        }
    }

    public CollectionChangeEvent createChangeEvent(Object collectionOwner, String propertyName, Object collectionChanged, Object elementChanged, int changeType, Integer index) {
        if (elementChanged instanceof Map.Entry) {
            return new MapChangeEvent(collectionOwner, propertyName, collectionChanged, ((Map.Entry)elementChanged).getKey(), ((Map.Entry)elementChanged).getValue(), changeType);
        }
        return super.createChangeEvent(collectionOwner, propertyName, collectionChanged, elementChanged, changeType, index);
    }

    public QueryKey createQueryKeyForMapKey() {
        return null;
    }

    public Object createWrappedObjectFromExistingWrappedObject(Object wrappedObject, Object parent, ClassDescriptor referenceDescriptor, MergeManager mergeManager) {
        Object key = ((Map.Entry)wrappedObject).getKey();
        Object value = referenceDescriptor.getObjectBuilder().wrapObject(mergeManager.getTargetVersionOfSourceObject(this.unwrapIteratorResult(wrappedObject)), mergeManager.getSession());
        return new Association(key, value);
    }

    public DatabaseField getDirectKeyField(CollectionMapping baseMapping) {
        if (baseMapping == null) {
            return null;
        }
        ClassDescriptor descriptor = baseMapping.getReferenceDescriptor();
        DatabaseMapping mapping = descriptor.getMappingForAttributeName(Helper.getAttributeNameFromMethodName(this.keyName));
        if (mapping.isAbstractDirectMapping()) {
            return ((AbstractDirectMapping)mapping).getField();
        }
        return null;
    }

    public Class getElementClass() {
        return this.elementClass;
    }

    public String getElementClassName() {
        return this.elementClassName;
    }

    public Class getInterfaceType() {
        return ClassConstants.Map_Class;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public Object getKeyType() {
        this.initializeKey();
        if (this.keyField != null) {
            return this.keyField.getType();
        }
        if (this.keyMethod != null) {
            return this.keyMethod.getReturnType();
        }
        if (this.elementDescriptor != null) {
            return this.elementDescriptor.getCMPPolicy().getPKClass();
        }
        return null;
    }

    public boolean isMapPolicy() {
        return true;
    }

    protected boolean isKeyAvailableFromElement() {
        return true;
    }

    public boolean isMapKeyAttribute() {
        DatabaseMapping mapping;
        if (this.elementDescriptor != null && this.keyName != null && (mapping = this.elementDescriptor.getMappingForAttributeName(Helper.getAttributeNameFromMethodName(this.keyName))) != null) {
            return mapping.isDirectToFieldMapping();
        }
        this.initializeKey();
        return this.keyField != null ? this.keyField.getClass().isPrimitive() : this.keyMethod != null && this.keyMethod.getClass().isPrimitive();
    }

    public boolean hasNext(Object iterator) {
        return ((MapContainerPolicyIterator)iterator).hasNext();
    }

    protected void initializeKey() {
        if (this.keyName != null && this.keyMethod == null && this.keyField == null) {
            try {
                this.keyMethod = Helper.getDeclaredMethod(this.elementClass, this.keyName, null);
            }
            catch (NoSuchMethodException ex) {
                try {
                    this.keyField = Helper.getField(this.elementClass, this.keyName);
                }
                catch (NoSuchFieldException e) {
                    throw ValidationException.mapKeyNotDeclaredInItemClass(this.keyName, this.elementClass);
                }
            }
        }
    }

    public Object iteratorFor(Object container) {
        return new MapContainerPolicyIterator((Map)container);
    }

    public Object keyFrom(Object element, AbstractSession session) {
        this.initializeKey();
        Object keyElement = element;
        if (this.hasElementDescriptor()) {
            keyElement = this.getElementDescriptor().getObjectBuilder().unwrapObject(element, session);
        }
        if (this.keyMethod != null) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedMethodInvoker(this.keyMethod, keyElement, null));
                    }
                    catch (PrivilegedActionException exception) {
                        Exception throwableException = exception.getException();
                        if (throwableException instanceof IllegalAccessException) {
                            throw QueryException.cannotAccessMethodOnObject(this.keyMethod, keyElement);
                        }
                        throw QueryException.calledMethodThrewException(this.keyMethod, keyElement, throwableException);
                    }
                }
                return PrivilegedAccessHelper.invokeMethod(this.keyMethod, keyElement, null);
            }
            catch (IllegalAccessException e) {
                throw QueryException.cannotAccessMethodOnObject(this.keyMethod, keyElement);
            }
            catch (InvocationTargetException exception) {
                throw QueryException.calledMethodThrewException(this.keyMethod, keyElement, exception);
            }
        }
        if (this.keyField != null) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedGetValueFromField(this.keyField, keyElement));
                    }
                    catch (PrivilegedActionException exception) {
                        throw QueryException.cannotAccessFieldOnObject(this.keyField, keyElement);
                    }
                }
                return PrivilegedAccessHelper.getValueFromField(this.keyField, keyElement);
            }
            catch (IllegalAccessException e) {
                throw QueryException.cannotAccessFieldOnObject(this.keyField, keyElement);
            }
        }
        return this.getElementDescriptor().getCMPPolicy().createPrimaryKeyInstance(keyElement, session);
    }

    public Object keyFromEntry(Object entry) {
        if (entry instanceof Map.Entry) {
            return ((Map.Entry)entry).getKey();
        }
        return null;
    }

    public Object keyFromIterator(Object iterator) {
        return ((MapContainerPolicyIterator)iterator).getCurrentKey();
    }

    protected Object next(Object iterator) {
        return ((MapContainerPolicyIterator)iterator).next().getValue();
    }

    public Object nextEntry(Object iterator) {
        return ((MapContainerPolicyIterator)iterator).next();
    }

    public Object nextEntry(Object iterator, AbstractSession session) {
        Map.Entry next = (Map.Entry)this.nextEntry(iterator);
        Object object = next.getValue();
        if (this.hasElementDescriptor()) {
            object = this.getElementDescriptor().getObjectBuilder().unwrapObject(object, session);
        }
        Object key = next.getKey();
        key = this.unwrapKey(key, session);
        next = new Association(key, object);
        return next;
    }

    public Object unwrapElement(Object object) {
        if (object instanceof Association) {
            return ((Association)object).getValue();
        }
        return object;
    }

    public Object unwrapIteratorResult(Object object) {
        if (object instanceof Map.Entry) {
            return ((Map.Entry)object).getValue();
        }
        return object;
    }

    public Object unwrapKey(Object key, AbstractSession session) {
        return key;
    }

    public void recordUpdateToCollectionInChangeRecord(CollectionChangeEvent event, ObjectChangeSet changeSet, CollectionChangeRecord collectionChangeRecord) {
        Object key = null;
        if (event.getClass().equals(ClassConstants.MapChangeEvent_Class)) {
            key = ((MapChangeEvent)event).getKey();
        }
        if (event.getChangeType() == CollectionChangeEvent.ADD) {
            this.recordAddToCollectionInChangeRecord(changeSet, collectionChangeRecord);
            changeSet.setNewKey(key);
        } else if (event.getChangeType() == CollectionChangeEvent.REMOVE) {
            this.recordRemoveFromCollectionInChangeRecord(changeSet, collectionChangeRecord);
            changeSet.setOldKey(key);
        } else {
            throw ValidationException.wrongCollectionChangeEventType(event.getChangeType());
        }
    }

    public boolean removeFrom(Object key, Object element, Object container, AbstractSession session) {
        try {
            Object returnValue = null;
            if (key != null) {
                returnValue = ((Map)container).remove(key);
            } else if (element != null) {
                returnValue = ((Map)container).remove(this.keyFrom(element, session));
            }
            return returnValue != null;
        }
        catch (UnsupportedOperationException ex) {
            throw QueryException.methodNotValid(container, "remove(Object element)");
        }
    }

    public void setElementClass(Class elementClass) {
        if (elementClass != null) {
            this.elementClassName = elementClass.getName();
        }
        this.elementClass = elementClass;
    }

    public boolean isValidContainer(Object container) {
        return container instanceof Map;
    }

    public void setKeyName(String keyName, String elementClassName) {
        this.keyName = keyName;
        this.elementClassName = elementClassName;
    }

    public void setKeyName(String keyName, Class elementClass) {
        this.keyName = keyName;
        this.elementClass = elementClass;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public void setKeyMethod(String keyMethodName, Class elementClass) {
        this.setKeyName(keyMethodName, elementClass);
    }

    public void setKeyMethod(String keyMethodName, String elementClassName) {
        this.setKeyName(keyMethodName, elementClassName);
    }

    public void setKeyMethodName(String keyMethodName) {
        this.setKeyName(keyMethodName);
    }

    public int sizeFor(Object container) {
        return ((Map)container).size();
    }

    public Object valueFromIterator(Object iterator) {
        return ((MapContainerPolicyIterator)iterator).getCurrentValue();
    }

    public Object valueFromPKList(Object[] pks, AbstractSession session) {
        Object result = this.containerInstance(pks.length);
        for (int index = 0; index < pks.length; ++index) {
            Object pk = null;
            pk = this.elementDescriptor.hasCMPPolicy() ? this.elementDescriptor.getCMPPolicy().createPrimaryKeyFromId(pks[index], session) : pks[index];
            ReadObjectQuery query = new ReadObjectQuery();
            query.setReferenceClass(this.elementDescriptor.getJavaClass());
            query.setSelectionId(pk);
            query.setIsExecutionClone(true);
            Object element = session.executeQuery(query);
            this.addInto(this.keyFrom(element, session), element, result, session);
        }
        return result;
    }

    public static class MapContainerPolicyIterator
    implements Iterator {
        private Iterator iterator;
        private Map.Entry currentEntry;

        public MapContainerPolicyIterator(Map container) {
            this.iterator = container.entrySet().iterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Map.Entry next() {
            this.currentEntry = (Map.Entry)this.iterator.next();
            return this.currentEntry;
        }

        public Object getCurrentKey() {
            if (this.currentEntry != null) {
                return this.currentEntry.getKey();
            }
            return null;
        }

        public Object getCurrentValue() {
            if (this.currentEntry != null) {
                return this.currentEntry.getValue();
            }
            return null;
        }

        public void remove() {
            this.iterator.remove();
        }
    }
}

